//==========================================================================
//
//	title		: define
//	company		: YAMAHA
//	author		: Taichi Sugiyama
//	create Data : 28/Sep/99
//
//==========================================================================
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>


typedef unsigned char	BYTE;
typedef unsigned short	WORD;
typedef unsigned long	DWORD;
typedef unsigned char far*	LPBYTE;
typedef unsigned short far*	LPWORD;
typedef unsigned long far*	LPDWORD;


//----- YAMAHA DS-XG Devices -----------------------------------------------
#define	YAMAHA		0x1073
#define	YMF724		0x0004
#define	YMF724F		0x000d
#define	YMF734		0x0005
#define	YMF737		0x0008
#define	YMF738		0x0020
#define	YMF740		0x000a
#define	YMF740C		0x000c
#define	YMF744		0x0010
#define	YMF754		0x0012
#define	YMF738_TEG	0x0006
#define DEVICE4CH	((phwi->wDeviceID == YMF738) ||	\
					 (phwi->wDeviceID == YMF744) ||	\
					 (phwi->wDeviceID == YMF754))


//----- interrupt flag -----------------------------------------------------
#define	YDSXG_DEFINT				0x01
#define	YDSXG_TIMERINT				0x02


//----- AC97 ---------------------------------------------------------------
#define	YDSXG_AC97TIMEOUT			1000
#define	YDSXG_AC97READCMD			0x8000
#define	YDSXG_AC97WRITECMD			0x0000
#define	YDSXG_AC97READFALSE			0xFFFF


//----- AC97 register map _-------------------------------------------------
#define	AC97R_RESET					0x00
#define	AC97R_MASTER				0x02
#define	AC97R_LNLVL					0x04
#define	AC97R_MASTERMONO			0x06
#define	AC97R_PCBEEP				0x0A
#define	AC97R_PHONE					0x0C
#define	AC97R_MIC					0x0E
#define	AC97R_LINE					0x10
#define	AC97R_CD					0x12
#define	AC97R_VIDEO					0x14
#define	AC97R_AUX					0x16
#define	AC97R_PCMOUT				0x18
#define	AC97R_RECSELECT				0x1A
#define	AC97R_RECGAIN				0x1C
#define	AC97R_GENPURPOSE			0x20
#define	AC97R_3DCTRL				0x22
#define	AC97R_PWMANAGE				0x26
#define	AC97R_EXTENDCTRL			0x2A
#define	AC97R_PCMDACRATE			0x2C
#define	AC97R_PCMADCRATE			0x32
#define	AC97R_GPIOSTATUS			0x54
#define	AC97R_VENDORID0				0x7C
#define	AC97R_VENDORID1				0x7E


//----- work buffer --------------------------------------------------------
#define	DEF_WORKBUFFLENGTH			0x0400


//----- register size ------------------------------------------------------
#define	YDSXG_MAPLENGTH				0x8000
#define	YDSXG_DSPLENGTH				0x0080
#define	YDSXG_CTRLLENGTH			0x3000


//----- register map -------------------------------------------------------
#define	YDSXGR_INTFLAG				0x0004
#define	YDSXGR_ACTIVITY				0x0006
#define	YDSXGR_GLOBALCTRL			0x0008
#define	YDSXGR_ZVCTRL				0x000A
#define	YDSXGR_TIMERCTRL			0x0010
#define	YDSXGR_TIMERCOUNT			0x0012
#define	YDSXGR_SPDIFOUTCTRL			0x0018
#define	YDSXGR_SPDIFOUTSTATUS		0x001C
#define	YDSXGR_EEPROMCTRL			0x0020
#define	YDSXGR_SPDIFINCTRL			0x0034
#define	YDSXGR_SPDIFINSTATUS		0x0038
#define	YDSXGR_DSPPROGRAMDL			0x0048
#define	YDSXGR_DLCNTRL				0x004C
#define	YDSXGR_GPIOININTFLAG		0x0050
#define	YDSXGR_GPIOININTENABLE		0x0052
#define	YDSXGR_GPIOINSTATUS			0x0054
#define	YDSXGR_GPIOOUTCTRL			0x0056
#define	YDSXGR_GPIOFUNCENABLE		0x0058
#define	YDSXGR_GPIOTYPECONFIG		0x005A
#define	YDSXGR_AC97CMDDATA			0x0060
#define	YDSXGR_AC97CMDADR			0x0062
#define	YDSXGR_PRISTATUSDATA		0x0064
#define	YDSXGR_PRISTATUSADR			0x0066
#define	YDSXGR_SECSTATUSDATA		0x0068
#define	YDSXGR_SECSTATUSADR			0x006A
#define	YDSXGR_SECCONFIG			0x0070
#define	YDSXGR_LEGACYOUTVOL			0x0080
#define	YDSXGR_LEGACYOUTVOLL		0x0080
#define	YDSXGR_LEGACYOUTVOLR		0x0082
#define	YDSXGR_NATIVEDACOUTVOL		0x0084
#define	YDSXGR_NATIVEDACOUTVOLL		0x0084
#define	YDSXGR_NATIVEDACOUTVOLR		0x0086
#define	YDSXGR_SPDIFOUTVOL			0x0088
#define	YDSXGR_SPDIFOUTVOLL			0x0088
#define	YDSXGR_SPDIFOUTVOLR			0x008A
#define	YDSXGR_AC3OUTVOL			0x008C
#define	YDSXGR_AC3OUTVOLL			0x008C
#define	YDSXGR_AC3OUTVOLR			0x008E
#define	YDSXGR_PRIADCOUTVOL			0x0090
#define	YDSXGR_PRIADCOUTVOLL		0x0090
#define	YDSXGR_PRIADCOUTVOLR		0x0092
#define	YDSXGR_LEGACYLOOPVOL		0x0094
#define	YDSXGR_LEGACYLOOPVOLL		0x0094
#define	YDSXGR_LEGACYLOOPVOLR		0x0096
#define	YDSXGR_NATIVEDACLOOPVOL		0x0098
#define	YDSXGR_NATIVEDACLOOPVOLL	0x0098
#define	YDSXGR_NATIVEDACLOOPVOLR	0x009A
#define	YDSXGR_SPDIFLOOPVOL			0x009C
#define	YDSXGR_SPDIFLOOPVOLL		0x009E
#define	YDSXGR_SPDIFLOOPVOLR		0x009E
#define	YDSXGR_AC3LOOPVOL			0x00A0
#define	YDSXGR_AC3LOOPVOLL			0x00A0
#define	YDSXGR_AC3LOOPVOLR			0x00A2
#define	YDSXGR_PRIADCLOOPVOL		0x00A4
#define	YDSXGR_PRIADCLOOPVOLL		0x00A4
#define	YDSXGR_PRIADCLOOPVOLR		0x00A6
#define	YDSXGR_NATIVEADCINVOL		0x00A8
#define	YDSXGR_NATIVEADCINVOLL		0x00A8
#define	YDSXGR_NATIVEADCINVOLR		0x00AA
#define	YDSXGR_NATIVEDACINVOL		0x00AC
#define	YDSXGR_NATIVEDACINVOLL		0x00AC
#define	YDSXGR_NATIVEDACINVOLR		0x00AE
#define	YDSXGR_BUF441OUTVOL			0x00B0
#define	YDSXGR_BUF441OUTVOLL		0x00B0
#define	YDSXGR_BUF441OUTVOLR		0x00B2
#define	YDSXGR_BUF441LOOPVOL		0x00B4
#define	YDSXGR_BUF441LOOPVOLL		0x00B4
#define	YDSXGR_BUF441LOOPVOLR		0x00B6
#define	YDSXGR_SPDIFOUTVOL2			0x00B8
#define	YDSXGR_SPDIFOUTVOL2L		0x00B8
#define	YDSXGR_SPDIFOUTVOL2R		0x00BA
#define	YDSXGR_SPDIFLOOPVOL2		0x00BC
#define	YDSXGR_SPDIFLOOPVOL2L		0x00BC
#define	YDSXGR_SPDIFLOOPVOL2R		0x00BE
#define	YDSXGR_ADCSLOTSR			0x00C0
#define	YDSXGR_RECSLOTSR			0x00C4
#define	YDSXGR_ADCFORMAT			0x00C8
#define	YDSXGR_RECFORMAT			0x00CC
#define	YDSXGR_P44SLOTSR			0x00D0
#define	YDSXGR_STATUS				0x0100
#define	YDSXGR_CTRLSELECT			0x0104
#define	YDSXGR_MODE					0x0108
#define	YDSXGR_SAMPLECOUNT			0x010C
#define	YDSXGR_NUMOFSAMPLES			0x0110
#define	YDSXGR_CONFIG				0x0114
#define	YDSXGR_PLAYCTRLSIZE			0x0140
#define	YDSXGR_RECCTRLSIZE			0x0144
#define	YDSXGR_EFFCTRLSIZE			0x0148
#define	YDSXGR_WORKSIZE				0x014C
#define	YDSXGR_MAPOFREC				0x0150
#define	YDSXGR_MAPOFEFFECT			0x0154
#define	YDSXGR_PLAYCTRLBASE			0x0158
#define	YDSXGR_RECCTRLBASE			0x015C
#define	YDSXGR_EFFCTRLBASE			0x0160
#define	YDSXGR_WORKBASE				0x0164
#define	YDSXGR_DSPINSTRAM			0x1000
#define	YDSXGR_CTRLINSTRAM			0x4000


//----- time out -----------------------------------------------------------
#define	YDSXG_WORKBITTIMEOUT		250000

#include "woddef.h"
#include "widdef.h"
#include "effdef.h"
#include "pcicfg.h"

typedef struct _tagHwinfo {
	//----- device informaiton ------------------------
	WORD	wVendorID;
	WORD	wDeviceID;
	BYTE	bRevisionID;
	DWORD	dwBaseAdr;
	BYTE	bIrq;

	//----- pointer to native register ----------------
	WORD	wNatSeg;
	DWORD	dwLinearAdr;
	LPBYTE	lpbNativeReg;
	LPWORD	lpwNativeReg;
	LPDWORD	lpdNativeReg;

	//----- configuration access key ------------------
	PCIKEY	pcikey;

	//----- interrupt ---------------------------------
	BYTE	bIntFlag;
	BYTE	bOldMask;
	BYTE	bNewFunc20[4];
	WORD	wIntSel;
	WORD	wIntRMSeg;
	WORD	wIntRMOff;
	void	(interrupt far*	lpOldFunc)();
	void	(interrupt far* lpOldFunc20)();
	LPWORD	lpwPassFlag;

	//----- external memory ---------------------------
	WORD	wExtSeg;
	WORD	wExtSel;
	DWORD	dwBuffSize;
	DWORD	dwWodCtrlBase;
	DWORD	dwWidCtrlBase;
	DWORD	dwEffCtrlBase;
	DWORD	dwWodBuffBase;
	DWORD	dwWidBuffBase;
	DWORD	dwEffBuffBase;
	DWORD	dwWorkBuffBase;
	DWORD	dwWodBankByteSize;
	DWORD	dwWidBankByteSize;
	DWORD	dwEffBankByteSize;
	DWORD	dwWodBuffByteSize;
	DWORD	dwWidBuffByteSize;
	DWORD	dwEffBuffByteSize;
	DWORD	dwWorkBuffByteSize;
	DWORD	dwBankSelect;
	LPBYTE	lpbWodBuffer;
	LPBYTE	lpbWidBuffer;
	LPBYTE	lpbEffBuffer;
	LPBYTE	lpbWorkBuffer;
	LPDWORD	lpdWodCtrlTable;
	WODINFO	wodinfo[DEF_MAXWOD];
	WIDINFO	widinfo[DEF_MAXWID];
	EFFINFO	effinfo[DEF_MAXEFF];

	//----- hardware control  --------------------------------------
	DWORD	dwHwStatus;

	//----- secondary Codec ID -------------------------------------
	BYTE	bCodecID;

} HWINFO, *PHWINFO;


typedef struct _tagDataInfo {
	FILE*	fp;
	BYTE	bChannel;
	BYTE	bBit;
	DWORD	dwSampling;
	DWORD	dwDataSize;
	DWORD	dwRemain;
	long	lDataHead;
} DATAINFO, *PDATAINFO;


#include "hw.h"
