//==========================================================================
//
//	title		: define functions to call DPMI host
//	company		: YAMAHA
//	author		: Taichi Sugiyama
//	create Data : 25/May/99
//
//==========================================================================
#include <dos.h>
#include <i86.h>
#include "dpmi.h"


//==========================================================================
//	allocate local discript table
//
//	param
//
//	return
//		selectot
//
//==========================================================================
WORD	DPMIAllocLDT(void)
{
	union REGS	reg;


	reg.w.ax = 0x0000;
	reg.w.cx = 0x0001;
	int386(DPMI_SERVICE, &reg, &reg);		// call DPMI service

	if(reg.w.cflag & 0x0001)
		return 0;
	else
		return reg.w.ax;
}


//==========================================================================
//	free local discript table
//
//	param
//		wSel : selector
//
//	return
//		FALSE if error
//
//==========================================================================
BYTE	DPMIFreeLDT(WORD wSel)
{
	union REGS	reg;


	reg.w.ax = 0x0001;
	reg.w.bx = wSel;
	int386(DPMI_SERVICE, &reg, &reg);		// call DPMI service

	if(reg.w.cflag & 0x0001)
		return FALSE;
	else
		return TRUE;
}


//==========================================================================
//	set base address to local discript table
//
//	param
//		wSel		: selector
//		dwBaseAdr	: base address
//
//	return
//		FALSE if error
//
//==========================================================================
BYTE	DPMISetBaseAddr(WORD wSel, DWORD dwBaseAdr)
{
	union REGS	reg;


	reg.w.ax = 0x0007;
	reg.w.bx = wSel;
	reg.w.cx = HiW(dwBaseAdr);
	reg.w.dx = LoW(dwBaseAdr);
	int386(DPMI_SERVICE, &reg, &reg);		// call DPMI service

	if(reg.w.cflag & 0x0001)
		return FALSE;
	else
		return TRUE;
}


//==========================================================================
//	set limit to local discript table
//
//	param
//		wSel	: selector
//		dwLimit	: limit
//
//	return
//		FALSE if error
//
//==========================================================================
BYTE	DPMISetLimit(WORD wSel, DWORD dwLimit)
{
	union REGS	reg;


	reg.w.ax = 0x0008;
	reg.w.bx = wSel;
	reg.w.cx = HiW(dwLimit);
	reg.w.dx = LoW(dwLimit);
	int386(DPMI_SERVICE, &reg, &reg);		// call DPMI service

	if(reg.w.cflag & 0x0001)
		return FALSE;
	else
		return TRUE;
}


//==========================================================================
//	set rights to local discript table
//
//	param
//		wSel	: selector
//
//	return
//		FALSE if error
//
//==========================================================================
BYTE	DPMISetRights(WORD wSel)
{
	union REGS	reg;


	reg.w.ax = 0x0009;
	reg.w.bx = wSel;
	reg.h.cl = 0xF2;
	reg.h.ch = 0x80;
	int386( DPMI_SERVICE, &reg, &reg);		// call DPMI service

	if(reg.w.cflag & 0x0001)
		return FALSE;
	else
		return TRUE;
}


//==========================================================================
//	allocate real memory
//
//	param
//		wPage	: page size
//		wpSeg	: pointer to segment
//		wpSel	: pointer to selector
//
//	return
//		TRUE if success
//
//==========================================================================
BYTE	DPMIAllocRMMemory(WORD wPage, WORD* wpSeg, WORD* wpSel)
{
	union REGS	reg;


	reg.w.ax = 0x0100;
	reg.w.bx = wPage;
	int386(DPMI_SERVICE, &reg, &reg);		// call DPMI service

	if (reg.w.cflag & 0x0001) {
		return reg.w.ax;
	}
	else {
		*wpSeg = reg.w.ax;
		*wpSel = reg.w.dx;
		return TRUE;
	}
}



//==========================================================================
//	free real memory
//
//	param
//		wSel	: selector
//
//	return
//		TRUE if success
//
//==========================================================================
BYTE	DPMIFreeRMMemory(WORD wSel)
{
	union REGS	reg;


	reg.w.ax = 0x0101;
	reg.w.dx = wSel;
	int386(DPMI_SERVICE, &reg, &reg);		// call DPMI service

	if (reg.w.cflag & 0x0001)
		return reg.w.ax;
	else
		return TRUE;
}


//==========================================================================
//	get real interrup vector
//
//	param
//		bVect	: number of vector
//		wpSeg	: pointer to segment
//		wpSel	: pointer to selector
//
//	return
//
//==========================================================================
void	DPMIGetRMVector(BYTE bVect, WORD* wpSeg, WORD* wpSel)
{
	union REGS	reg;


	reg.w.ax = 0x0200;
	reg.h.bl = bVect;
	int386(DPMI_SERVICE, &reg, &reg);		// call DPMI service

	*wpSeg = reg.w.cx;
	*wpSel = reg.w.dx;
}


//==========================================================================
//	set real interrup vector
//
//	param
//		bVect	: number of vector
//		wSeg	: segment
//		wSel	: selector
//
//	return
//
//==========================================================================
BYTE	DPMISetRMVector(BYTE bIrq, WORD wSeg, WORD  wSel)
{
	union REGS	reg;


	reg.w.ax = 0x0201;
	reg.h.bl = bIrq;
	reg.w.cx = wSeg;
	reg.w.dx = wSel;
	int386(DPMI_SERVICE, &reg, &reg);		// call DPMI service

	if(reg.w.cflag & 0x0001)
		return FALSE;
	else
		return TRUE;
}


//==========================================================================
//	get page option
//
//	param
//
//	return
//		0 : not support paging
//		1 : support paging
//
//==========================================================================
BYTE	DPMIPageOption(void)
{
	union REGS	reg;


	reg.w.ax = 0x400;
	int386(DPMI_SERVICE, &reg, &reg);		// call DPMI service

	return (BYTE)((reg.w.bx >> 2) & 0x0001);
}


//==========================================================================
//	map physical memory to linear memory
//
//	param
//		dwPhyAdr	: physical address
//		dwLenght	: length of memory
//
//	return
//		linear memory
//
//==========================================================================
DWORD   DPMIPhysicalToLinear(DWORD  dwPhyAdr, DWORD  dwLength)
{
	union REGS	reg;
	DWORD		dwLinAdr;


	reg.w.ax = 0x0800;
	reg.w.bx = HiW(dwPhyAdr);
	reg.w.cx = LoW(dwPhyAdr);
	reg.w.si = HiW(dwLength);
	reg.w.di = LoW(dwLength);

	int386(DPMI_SERVICE, &reg, &reg);		// call DPMI service

	if (reg.w.cflag & 0x0001) {
		return 0L;
	}
	else {
		dwLinAdr =(((DWORD)reg.w.bx << 16) | (DWORD)reg.w.cx);
		return  dwLinAdr;
	}
}


//==========================================================================
//	free physical memory
//
//	param
//		wSel		: selector
//		dwLinAdr	: linear address
//
//	return
//		FALSE if error
//
//==========================================================================
BYTE	DPMIFreePhysical(WORD wSel, DWORD dwLinAdr)
{
	union REGS	reg;


	reg.w.ax = 0x0801;
	reg.w.bx = HiW(dwLinAdr);
	reg.w.cx = LoW(dwLinAdr);

	int386(DPMI_SERVICE, &reg, &reg);            // call DPMI service

	if(reg.w.cflag & 0x0001)
		return FALSE;
	else
		return TRUE;
 }
