//==========================================================================
//
//	title		: define functions to WID
//	company		: YAMAHA
//	author		: Taichi Sugiyama
//	create Data : 30/Sep/99
//
//==========================================================================
#include "define.h"


//#define	TRACE_WIDPROC
#ifdef TRACE_WIDPROC
#define	DPF(X)		cprintf("TRACE_WIDPROC:");cprintf X
#define	dprintf(X)	cprintf X
#else
#define	DPF(X)
#define	dprintf(X)
#endif


//==========================================================================
//	calculate Format
//
//	argument
//		bChannel	: channel
//		bBit		: bit
//
//	return
//		Format
//
//==========================================================================
static BYTE	CalcFormat(BYTE bChannel, BYTE bBit)
{
	BYTE	bFormat;

	bFormat = 0x00;
	if(bChannel > 1)
		bFormat |= 0x02;
	if(bBit < 16)
		bFormat |= 0x01;

	return bFormat;
}


//==========================================================================
//	calculate Sampling Rate
//
//	argument
//		dwSR	: sampling rate
//
//	return
//		Sampling Rate
//
//==========================================================================
static WORD	CalcSR(DWORD dwSR)
{
	WORD	wSR;

	wSR = (WORD)((DEF_SAMPLINGRATE * 4096 / dwSR) - 1);

	return wSR;
}


//==========================================================================
//	setup WID bank register
//
//	argument
//		pWid	: pointer to WOD information
//
//	return
//
//==========================================================================
void	SetupWidBankRegister(PWIDINFO pWid)
{
	DWORD	i;


	DPF(("SetupWidBankRegister")); 

	//	set bank1 & bank2
	for(i=0; i<2; i++) {
		pWid->lpWidBank[i]->dwPgBase = pWid->dwBuffBaseAdr;
		pWid->lpWidBank[i]->dwPgLoopEndAdr = pWid->dwBuffLength;
		pWid->lpWidBank[i]->dwPgStartAdr = 0x00000000;
		pWid->lpWidBank[i]->dwNumOfLoops = 0x00000000;
	}

	dprintf(("/End\n\r"));
}


//==========================================================================
//	get WID buffer
//
//	argument
//		lpbBuffer	: pointer to WID buffer
//		dwLength	: get size
//		pdinfo		: get data information.
//
//	return
//		1, if no data
//
//==========================================================================
BYTE	GetWidBuffer(LPBYTE lpbBuffer, DWORD dwLength, PDATAINFO pdinf)
{
	BYTE	bTmp;
	DWORD	i;


	DPF(("\n\rGetWidBuff(%08lX/%08lX)", dwLength, pdinf->dwDataSize));

	//---- get data --------------------------------------------------------
	for(i=0; i<dwLength; i++) {
		bTmp = *(lpbBuffer + i);
		fwrite(&bTmp, sizeof(BYTE), 1, pdinf->fp);
		pdinf->dwDataSize++;
	}

	dprintf(("/End\n\r"));
	return 0;
}


//==========================================================================
//	WID procedure
//
//	argument
//		phwi	: pointer to hardware information
//		pdinf	: pointer to data information
//
//	return
//
//==========================================================================
void	WidProc(PHWINFO phwi, PDATAINFO pdinf)
{
	BYTE			bQuit = 1;
	BYTE			bBankFlag = 0;
	DWORD			dwHalfSize;
	PWIDINFO		pWidInf;
	WIDBANK far*	pWid;


	//---- setup WID bank ---------------------------------------------------
	if(phwi->dwHwStatus & HWDEF_REC) {
		pWidInf = &phwi->widinfo[0];
		Hw_WriteRegByte(phwi, YDSXGR_RECFORMAT, CalcFormat(pdinf->bChannel, pdinf->bBit));
		Hw_WriteRegWord(phwi, YDSXGR_RECSLOTSR, CalcSR(pdinf->dwSampling));
	}
	else if(phwi->dwHwStatus & HWDEF_ADC) {
		pWidInf = &phwi->widinfo[1];
		Hw_WriteRegByte(phwi, YDSXGR_ADCFORMAT, CalcFormat(pdinf->bChannel, pdinf->bBit));
		Hw_WriteRegWord(phwi, YDSXGR_ADCSLOTSR, CalcSR(pdinf->dwSampling));
	}
	else
		return;

	pWidInf->bChannel = pdinf->bChannel;
	pWidInf->bBit = pdinf->bBit;
	pWidInf->dwSampling = pdinf->dwSampling;
	pWidInf->dwBuffBaseAdr = phwi->dwWidBuffBase;
	pWidInf->dwBuffLength = phwi->dwWidBuffByteSize;
	SetupWidBankRegister(pWidInf);

	//---- start recording -------------------------------------------------
	phwi->bIntFlag = 0x00;
	dwHalfSize = phwi->dwWidBuffByteSize >> 1;
	Hw_WriteRegDword(phwi, YDSXGR_NATIVEADCINVOL, 0x3FFF3FFF);
	Hw_WriteRegDword(phwi, YDSXGR_NATIVEDACINVOL, 0x3FFF3FFF);
	Hw_Start(phwi);
	while(bQuit) {
		if(phwi->bIntFlag) {
			pWid = ((phwi->dwBankSelect)? pWidInf->lpWidBank[1]: pWidInf->lpWidBank[0]);
			if(bBankFlag) {
				if(pWid->dwPgStartAdr < (pWid->dwPgLoopEndAdr >> 1)) {
					GetWidBuffer(phwi->lpbWidBuffer + dwHalfSize, dwHalfSize, pdinf);
					bBankFlag = 0;
				}
			}
			else {
				if(pWid->dwPgStartAdr >= (pWid->dwPgLoopEndAdr >> 1)) {
					GetWidBuffer(phwi->lpbWidBuffer, dwHalfSize, pdinf);
					bBankFlag = 1;
				}
			}
			cprintf(" data size : %08lx\r", pdinf->dwDataSize);
			phwi->bIntFlag = 0x00;
		}
		if(kbhit() && (getch() == 0x1B)) {
			bQuit = 0;
		}
	}
	Hw_WriteRegDword(phwi, YDSXGR_NATIVEADCINVOL, 0x00000000);
	Hw_WriteRegDword(phwi, YDSXGR_NATIVEDACINVOL, 0x00000000);
	Hw_Stop(phwi);
}
