//==========================================================================
//
//	title		: define functions to WAV file.
//	company		: YAMAHA
//	author		: Taichi Sugiyama
//	create Data : 25/May/99
//
//==========================================================================
#include <stdio.h>
#include <stdlib.h>
#include "wavfile.h"


//==========================================================================
//	create chank ID
//
//
//==========================================================================
DWORD	chankID(DWORD a, DWORD b, DWORD c, DWORD d)
{
	return ((d << 24) | (c << 16) | (b << 8) | a);
}


//==========================================================================
//	set data size
//
//	argument
//		fp			: pointer to file
//		dwLength	: data size
//
//	return
//
//==========================================================================
void	Wav_SetLength(FILE* fp, DWORD dwLength)
{
	DWORD	dwSize;


	dwSize = 44 + dwLength;
	fseek(fp, 4, SEEK_SET);
	fwrite(&dwSize, sizeof(DWORD), 1, fp);
	fseek(fp, 40, SEEK_SET);
	fwrite(&dwLength, sizeof(DWORD), 1, fp);
}


//==========================================================================
//	create header
//
//	arument
//		fp			: pointer to file
//		bChannel	: channel
//		bBit		: bit
//		dwSR		: sampling rate
//
//	return
//
//==========================================================================
void	Wav_CreateHeader(FILE* fp, BYTE bChannel, BYTE bBit, DWORD dwSR)
{
	DWORD		wHead[3];
	WAVFMTINFO	finf;
	WAVCHANK	chank;


	//---- create RIFFXXXXWAVE head ----------------------------------------
	wHead[0] = chankID('R', 'I', 'F', 'F');
	wHead[1] = 0L;
	wHead[2] = chankID('W', 'A', 'V', 'E');
	fwrite(wHead, sizeof(DWORD), 3, fp);

	//---- create FMT chank header -----------------------------------------
	chank.dwID = chankID('f', 'm', 't', ' ');
	chank.dwLength = sizeof(WAVFMTINFO);
	fwrite(&chank, sizeof(WAVCHANK), 1, fp);

	//---- create FMT chank data -------------------------------------------
	finf.wFormat = WAV_PCMFORMAT;
	finf.wChannel = (WORD)bChannel;
	finf.wBit = (WORD)bBit;
	finf.dwSampling = dwSR;
	finf.wBlockSize = finf.wChannel * (finf.wBit >> 3);
	finf.dwTransSize = (DWORD)finf.wBlockSize * finf.dwSampling;
	fwrite(&finf, sizeof(WAVFMTINFO), 1, fp);

	//---- create DATA chank header ----------------------------------------
	chank.dwID = chankID('d', 'a', 't', 'a');
	chank.dwLength = 0L;
	fwrite(&chank, sizeof(WAVCHANK), 1, fp);
}


//==========================================================================
//	open WAV
//
//	argument
//		fp			: pointer to file
//		pbChannel	: pointer to channel
//		pbBit		: pointer to bit
//		pdwSR		: pointer to sampling rate
//
//	return
//		size of 'data' chank
//
//==========================================================================
DWORD	Wav_GetInfo(FILE* fp, BYTE* pbChannel, BYTE* pbBit, DWORD* pdwSR)
{
	DWORD		dwHead[3];
	DWORD		dwLength = 0L;
	WAVFMTINFO	finf;
	WAVCHANK	chank;


	//---- compare RIFFXXXXWAVE head ----------------------------------------
	fread(dwHead, sizeof(DWORD), 3, fp);
	if((dwHead[0] != chankID('R', 'I', 'F', 'F')) || (dwHead[2] != chankID('W', 'A', 'V', 'E'))) {
		return 0L;
	}

	//---- open 'fmt ' chank ------------------------------------------------
	while(1) {
		fread(&chank, sizeof(WAVCHANK), 1, fp );
		if(chank.dwID == chankID('f', 'm', 't', ' ')) {
			fread( &finf, sizeof(WAVFMTINFO), 1, fp);
			*pbChannel = (BYTE)finf.wChannel;
			*pbBit = (BYTE)finf.wBit;
			*pdwSR = finf.dwSampling;
			fseek(fp, (chank.dwLength - sizeof(WAVFMTINFO)), SEEK_CUR );
			break;
		}
		else {
			if(fseek(fp, chank.dwLength, SEEK_CUR) != 0)
				return 0L;
		}
	}

	//---- open 'data' chank ------------------------------------------------
	while(1) {
		fread(&chank, sizeof(WAVCHANK), 1, fp );
		if(chank.dwID == chankID('d', 'a', 't', 'a')) {
			dwLength = chank.dwLength;
			break;
		}
		else {
			if(fseek(fp, chank.dwLength, SEEK_CUR) != 0)
				return 0L;
		}
	}

	return dwLength;
}
