// This Code is for hardware function demonstration purposes only
// Leipzig 02-19-98 (c) 1998 marian GbR Leipzig


const
  adReg  = 0;
  adData = 4;
  selAd12  = $00E0;
  selAd34  = $00D0;
  selAd56  = $00B0;
  selAd78  = $0070;
  selAdAll = selAD12 And selAD34 And selAD56 And selAD78;

type
  a4b = packed array[1..4] of Byte;

{ Adda = Memory Address of Codecs }

function GetParam (Reg : Byte) : DWORD;
var
  RegL : a4b;
  ValL : LongInt;
  i    : byte;
begin
 { prepare Register Numbers }
  for i := 1 to 4 do
    RegL[i] := Reg;

 { Output Register Numbers }
  PDWORD (Addas+adReg+selAdAll)^ := DWORD (RegL);
 { Getting Register Values }
  Result := PDWORD (Addas+adData+selAdAll)^;
end;

function SetParam (Reg, Val : Byte; Chips : Word) : Boolean;
var
  RegL,
  ValL    : a4b;
  i       : Byte;
begin
 { prepare Register Numbers }
  for i := 1 to 4 do
    RegL[i] := Reg;
 { prepare Register Values }
  for i := 1 to 4 do
    ValL[i] := Val;
 { Output Register Numbers and Values }
  PDWORD (Addas+adReg+Chips)^  := DWORD (RegL);
  PDWORD (Addas+adData+Chips)^ := DWORD (ValL);
end;

function InitADDA : TInitError;
// Important: use THIS call order for initialization !
begin
  Ok := True;
  SetParam ($40 + 29, 0, selAdAll);    { Input Freq. 24,576 MHz }

  SetParam ($40 + 12, $ca, selAdAll);  { $ca = Mode 2 }

 {$IFDEF Test}
  SetParam ($40 +  8, $5a, selAdAll);  { Stereo/Format and Sample Rate, $5a = 64 kHz }
 {$ELSE}
  SetParam ($40 +  8, $5c, selAdAll);  { Stereo/Format and Sample Rate, $5b = 48 kHz }
 {$ENDIF}
  SetParam ($40 + 28, $50, selAdAll);  { $50 = Capture Data Format: Stereo 16 bit }

  SetParam (13, $00, selAdAll);        { $01 = Dig. Mix MCE End }

 { wait for 500 (1000) ms (use your own OS dependent wait function }
  timerCount := 25;
  repeat
  until timerCount = 0;
  SetParam (27, 8, selAdAll);          { use Mode2 Frequ. Reg.}
end;

