//*****************************************************************************
//* Name:
//*      1212stat.h
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file contains the declaration of the card states.
//*
//* Modification Log:
//*
//*      1.2   12/27/96 Bill
//*      Non-existent state added for the support of multiple cards.  
//*
//*      1.1   12/05/96 Bill
//*      Initial version created.  
//*
//*
//* Copyright (c) 1996 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#ifndef K1212STAT_H
#define K1212STAT_H


// ----------------------------------------------------------------------------
// the following enum defines the valid states of the Korg 1212 I/O card.
// ----------------------------------------------------------------------------
typedef enum {
   K1212_STATE_NONEXISTENT,         // there is no card here
   K1212_STATE_UNINITIALIZED,       // the card is awaiting DSP download
   K1212_STATE_DSP_IN_PROCESS,      // the card is currently downloading its DSP code
   K1212_STATE_DSP_COMPLETE,        // the card has finished the DSP download
   K1212_STATE_READY,               // the card can be opened by an application.  Any application
                                    //    requests prior to this state should fail.  Only an open
                                    //    request can be made at this state.
   K1212_STATE_OPEN,                // an application has opened the card
   K1212_STATE_SETUP,               // the card has been setup for play
   K1212_STATE_PLAYING,             // the card is playing
   K1212_STATE_MONITOR,             // the card is in the monitor mode
   K1212_STATE_CALIBRATING,         // the card is currently calibrating
   K1212_STATE_MAX_STATE            // state values of this and beyond are invalid
} CardState;


typedef enum {
   K1212_WAVEOUTSTATE_DISABLED = 0,    // default state - must first be enabled to be used
   K1212_WAVEOUTSTATE_ENABLED,         // once in this state, can be opened, closed, etc.
                                       //    an open device which is closed returns to this state
   K1212_WAVEOUTSTATE_OPEN,            // an enabled device has been opened by the wave driver
   K1212_WAVEOUTSTATE_PLAYING,         // the device is playing back PCM data
   K1212_WAVEOUTSTATE_PAUSED           // the card is playing, but silence is being fed to the
                                       //    card's buffers for this device.  Wave buffer ptrs
                                       //    are not updated in this state.
} WaveOutDeviceState;


typedef enum {
   K1212_WAVEINSTATE_DISABLED = 0,     // default state - must first be enabled to be used
   K1212_WAVEINSTATE_ENABLED,          // once in this state, can be opened, closed, etc.
                                       //    an open device which is closed returns to this state
   K1212_WAVEINSTATE_OPEN,             // an enabled device has been opened by the wave driver
   K1212_WAVEINSTATE_RECORDING         // the device is recording PCM data
} WaveInDeviceState;



#endif // K1212STAT_H
