//*****************************************************************************
//* Name:
//*      taskbar.cpp
//*
//* Project:
//*      1212 I/O Driver
//*
//* Author:
//*      Bill Jenkins
//*
//* Description: 
//*      Module for adding and controlling a status icon on the system
//*      taskbar.  This icon is used to launch the wave device volume
//*      control program.
//*
//* Modification Log:
//*
//*      1.1   4/18/97 Bill
//*      Initial version.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*
//* Note: This file was originally adapted from the Microsoft Windows
//*       95 DDK.  Copyright (c) 1991 - 1995  Microsoft Corporation.
//*****************************************************************************

#include <windows.h>

LONG APIENTRY VolWndProc
(
   HWND hWnd,
   UINT message,
   UINT wParam,
   LONG lParam
);

//--------------------------------------------------------------------------
// Globals
//--------------------------------------------------------------------------


BOOL InitVolWndClass (void)
{
   WNDCLASS  wcVolCtrl;
   
   // --------------------------------------------------------------------
   // Fill in window class structure with parameters that describe the
   // main window.                                                      
   // --------------------------------------------------------------------

   wcVolCtrl.style           = 0;                     
   wcVolCtrl.lpfnWndProc     = (WNDPROC)VolWndProc; 
   wcVolCtrl.cbClsExtra      = 0;              
   wcVolCtrl.cbWndExtra      = 0;              
   wcVolCtrl.hInstance       = 0;        // hInstance;       
   wcVolCtrl.hIcon           = LoadIcon(NULL, IDI_WINLOGO);
   wcVolCtrl.hCursor         = LoadCursor(NULL, IDC_ARROW);
   wcVolCtrl.hbrBackground   = GetStockObject(WHITE_BRUSH); 
   wcVolCtrl.lpszMenuName    = "1212VolCtrlMenu";  
   wcVolCtrl.lpszClassName   = "1212VolCtrlWClass";

   return RegisterClass(&wcVolCtrl);
}


BOOL InitInstance(void) 
{
   HWND hWnd;

   hWnd = CreateWindow(
                        "1212VolCtrlWClass",           
                        "1212 I/O Wave Volume", 
                        WS_OVERLAPPEDWINDOW,
                        CW_USEDEFAULT, 
                        CW_USEDEFAULT, 
                        CW_USEDEFAULT, 
                        CW_USEDEFAULT,
                        NULL,               
                        NULL,               
                        NULL,          // hInstance,          
                        NULL
          );

   // --------------------------------------------------------
   // If window could not be created, return "failure" 
   // --------------------------------------------------------
   if (!hWnd) {
      return FALSE;
   }
   
   return TRUE;
}



LONG APIENTRY VolWndProc
(
   HWND hWnd,  
   UINT message,
   UINT wParam,
   LONG lParam
)
{         

   switch (message) 
   {

      case WM_CREATE:
         break;

      case WM_SIZE:
         break;

      case TRAY_CALLBACK:      
         TrayCallback(wParam, lParam);
         break;

      case WM_COMMAND:

         switch( LOWORD( wParam ))
         {
                case IDM_FILEINFO:  
                    break;

                case IDM_ADD:
                   break;

                case IDM_REMOVE:
                    break;

                case IDM_TASKBAR:
                    break;

                case IDM_ADDICON:
                    TrayMessage(hWnd, NIM_ADD);
                    break;

                case IDM_STATECHANGE:
                    TrayMessage(hWnd, NIM_MODIFY);
                    break;

                case IDM_REMOVEICON:
                    TrayMessage(hWnd, NIM_DELETE);
                    break;

            case IDM_EXIT:
               SendMessage(hWnd, WM_DESTROY, 0L, 0L);;
               break;

            case IDM_ABOUT:
               break;

            default:
               return (DefWindowProc(hWnd, message, wParam, lParam));

         }
         break;

        case WM_DROPFILES:
            break;

      case WM_DESTROY: 
         PostQuitMessage(0);
         break;

      default:
         return (DefWindowProc(hWnd, message, wParam, lParam));
   }
   return (0);
}


/****************************************************************************
*
*    FUNCTION: TrayCallback(WPARAM, LPARAM)
*
*    PURPOSE:  Window procedure for the appbar window.
*
****************************************************************************/
void TrayCallback( WPARAM wParam, LPARAM lParam)
{
    UINT uID;
    UINT uMouseMsg;

    uID       = (UINT)wParam;
    uMouseMsg = (UINT) lParam;

    if (uMouseMsg == WM_LBUTTONDOWN)
    {
        if (uID == (UINT)IDI_WINLOGO)
            MessageBox(NULL, "Click!", "This sure is fun!", MB_OK);
    }

}

/****************************************************************************
*
*    FUNCTION: TrayMessage(HWND, UINT)
*
*    PURPOSE:  Sends messages to the tray about the tray icon we added.
*
****************************************************************************/
void TrayMessage( HWND hWnd, UINT message)
{
    NOTIFYICONDATA tnd;
    
    switch (message)
    {
        case NIM_ADD:
            tnd.uFlags = NIF_MESSAGE|NIF_ICON|NIF_TIP;
            break;

        case NIM_MODIFY:
            tnd.uFlags = NIF_TIP;
            break;

        case NIM_DELETE:
            tnd.uFlags = 0;
            g_State1 = FALSE;
            break;
    }

    tnd.uID              = (UINT)IDI_WINLOGO;
    tnd.cbSize           = sizeof(NOTIFYICONDATA);
    tnd.hWnd             = hWnd;
    tnd.uCallbackMessage = TRAY_CALLBACK;
    tnd.hIcon            = LoadIcon(NULL, MAKEINTRESOURCE(IDI_WINLOGO));;
    Shell_NotifyIcon(message, &tnd);
}
