//*****************************************************************************
//* Name:
//*      drvproc.cpp
//*
//* Project:
//*      1212 I/O Driver
//*
//* Author:
//*      Bill Jenkins
//*
//* Description: 
//*      Main installable driver entry point.
//*
//* Modification Log:
//*
//*      1.1   1/15/97 Bill
//*      Initial version.  
//*
//*
//* Copyright (c) 1997 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*
//* Note: This file was originally adapted from the Microsoft Windows
//*       95 DDK.  Copyright (c) 1991 - 1995  Microsoft Corporation.
//*****************************************************************************

#include <windows.h>
#include "gsound.h"
#include <string.h>
#include "12pmapic.h"
#include "driver.h"

//--------------------------------------------------------------------------
// Globals and externs
//--------------------------------------------------------------------------
CKorg1212Api*     pK1212Driver;           // VxD interface API object pointer

//--------------------------------------------------------------------------
//  
//  DWORD DriverProc
//  
//  Description:
//      The entry point for an installable driver.
//  
//  Parameters:
//      DWORD dwDriverID
//
//      For most messages, dwDriverId is the DWORD
//      value that the driver returns in response to a DRV_OPEN message.
//      Each time that the driver is opened, through the DrvOpen API,
//      the driver receives a DRV_OPEN message and can return an
//      arbitrary, non-zero value. The installable driver interface
//      saves this value and returns a unique driver handle to the
//      application. Whenever the application sends a message to the
//      driver using the driver handle, the interface routes the message
//      to this entry point and passes the corresponding dwDriverId.
//      This mechanism allows the driver to use the same or different
//      identifiers for multiple opens but ensures that driver handles
//      are unique at the application interface layer.
//
//      The following messages are not related to a particular open
//      instance of the driver. For these messages, the dwDriverId
//      will always be zero.
//
//         DRV_LOAD, DRV_FREE, DRV_ENABLE, DRV_DISABLE, DRV_OPEN
//  
//      HANDLE hDriver
//
//      This is the handle returned to the application by the driver
//      interface.
//
//      WORD wMessage
//
//      The requested action to be performed. Message
//      values below DRV_RESERVED are used for globally defined messages.
//      Message values from DRV_RESERVED to DRV_USER are used for
//      defined driver protocols. Messages above DRV_USER are used
//      for driver specific messages.
//  
//      DWORD dwParam1
//
//      Data for this message.  Defined separately for each message
//
//      DWORD dwParam2
//
//      Data for this message.  Defined separately for each message
//  
//  Return (DWORD):
//      Defined separately for each message.
//
//  
//--------------------------------------------------------------------------

DWORD FAR PASCAL _loadds DriverProc
(
    DWORD   dwDriverID,
    HANDLE  hDriver,
    WORD    wMessage,
    DWORD   dwParam1,
    DWORD   dwParam2
)
{
   switch (wMessage)
   {
      case DRV_LOAD:

         // -----------------------------------------------------------
         // We need to open our connection with the driver here.
         // -----------------------------------------------------------
         // DebugMsg((char __far *)"Got the DRV_LOAD message");
         return 1L ;


      case DRV_FREE:

         // -----------------------------------------------------------
         // We need to close our connection with the driver here.
         // -----------------------------------------------------------
         // DebugMsg((char __far *)"Got the DRV_FREE message");
         return 1L ;


      case DRV_OPEN:

         // ------------------------------------------------------------
         // Sent to the driver when it is opened.
         // 
         // dwDriverID is 0L.
         // 
         // lParam1 is a far pointer to a zero-terminated string
         // containing the name used to open the driver.
         // 
         // lParam2 is passed through from the drvOpen call.
         // 
         // Return 0L to fail the open.
         // 
         // DefDriverProc will return ZERO so we do have to
         // handle the DRV_OPEN message.
         // ------------------------------------------------------------
         // DebugMsg((char __far *)"Got the DRV_OPEN message");
         return 1L ;


      case DRV_CLOSE:

         // ------------------------------------------------------------
         // Sent to the driver when it is closed. Drivers are unloaded
         // when the close count reaches zero.
         // 
         // dwDriverID is the driver identifier returned from the
         // corresponding DRV_OPEN.
         // 
         // lParam1 is passed through from the drvOpen call.
         // 
         // lParam2 is passed through from the drvOpen call.
         // 
         // Return 0L to fail the close.
         // 
         // DefDriverProc will return ZERO so we do have to
         // handle the DRV_CLOSE message.
         // ------------------------------------------------------------
         // DebugMsg((char __far *)"Got the DRV_CLOSE message");
         return 1L ;


      case DRV_ENABLE:

         // ------------------------------------------------------------
         // Sent to the driver when the driver is loaded or reloaded
         // and whenever Windows is enabled. Drivers should only
         // hook interrupts or expect ANY part of the driver to be in
         // memory between enable and disable messages
         // 
         // We will open a connection with the VxD and create and
         // initialize our local heap.
         // 
         // dwDriverID is 0L.
         // lParam1 is 0L.
         // lParam2 is 0L.
         // 
         // Return value is ignored.
         // ------------------------------------------------------------
         // DebugMsg((char __far *)"Got the DRV_ENABLE message");
         if (DrvInit() != MMSYSERR_NOERROR) {
            return 0L ; // error
         }
         return 1L ;


      case DRV_DISABLE:

         // ------------------------------------------------
         // Sent to the driver before the driver is freed.
         // and whenever Windows is disabled
         //
         // We will close our connection to the VxD at this
         // point.
         // 
         // dwDriverID is 0L.
         // lParam1 is 0L.
         // lParam2 is 0L.
         // 
         // Return value is ignored.
         // ------------------------------------------------
         // DebugMsg((char __far *)"Got the DRV_DISABLE message");
         DrvEnd() ;
         return 1L ;


      case DRV_QUERYCONFIGURE:

         // -----------------------------------------------------
         // Sent to the driver so that applications can
         // determine whether the driver supports custom
         // configuration. The driver should return a
         // non-zero value to indicate that configuration
         // is supported.
         // 
         // dwDriverID is the value returned from the DRV_OPEN
         // call that must have succeeded before this message
         // was sent.
         // 
         // lParam1 is passed from the app and is undefined.
         // lParam2 is passed from the app and is undefined.
         // 
         // Return 0L to indicate configuration NOT supported.
         // ------------------------------------------------------ 
         // DebugMsg((char __far *)"Got the DRV_QUERYCONFIGURE message");
         return TRUE;


      case DRV_CONFIGURE:
      
         // ----------------------------------------------------
         // Sent to the driver so that it can display a custom
         // configuration dialog box.
         //
         // lParam1 is passed from the app. and should contain
         // the parent window handle in the loword.
         // lParam2 is passed from the app and is undefined.
         // 
         // Return value is REBOOT, OK, RESTART.
         // ----------------------------------------------------
         // DebugMsg((char __far *)"Got the DRV_CONFIGURE message");
         WinExec("k1212wav.exe", SW_SHOWNORMAL);
         return DRV_OK;


      case DRV_INSTALL:
         // DebugMsg((char __far *)"Got the DRV_INSTALL message");
         return DRV_OK ;


      case DRV_REMOVE:
         // DebugMsg((char __far *)"Got the DRV_REMOVE message");
         return 0 ;

               
      // --------------------------------------------------------------
      // This notification is from the Windows power driver.  For more
      // information about APM and how it works under Windows, please
      // see:  The DDK Advanced Power Management Notes
      // --------------------------------------------------------------
      case DRV_POWER:
         // DebugMsg((char __far *)"Got the DRV_POWER message");

         switch (dwParam1)
         {
            case PWR_SUSPENDREQUEST:
               return PWR_OK ;

            case PWR_SUSPENDRESUME:
            case PWR_CRITICALRESUME:
               return PWR_OK ;

            default:
               return PWR_OK ;
         }
   }

   return DefDriverProc( dwDriverID, hDriver, wMessage, 
                         dwParam1, dwParam2 ) ;

} // DriverProc()

//------------------------------------------------------------------------
//  LRESULT FAR PASCAL DrvInit( VOID )
//
//  Description:
//     Verifies that the VxD loaded successfully and opens a connection
//     to it.  Also, creates and initializes a local heap.
//
//  Parameters:
//     Nothing.
//
//  Return Value (LRESULT):
//     MMSYSERR_NOERROR if no problem.
//
//------------------------------------------------------------------------
int DrvInit()
{   
   pK1212Driver = CKorg1212Api::OpenDriver();
   return MMSYSERR_NOERROR;
} // end of DrvInit()


//------------------------------------------------------------------------
//  VOID DrvEnd
//
//  Description:
//     Closes up the connection to the VxD.
//
//  Parameters:
//     None.
//
//  Return Value:
//     None.
//
//
//------------------------------------------------------------------------
void DrvEnd()
{
   if (pK1212Driver) {
      pK1212Driver->CloseDriver();
   }
   pK1212Driver = 0;
} // end of DrvEnd()
