//*****************************************************************************
//* Name:
//*      1212ifpr.h
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file contains private declarations required for implementing the
//*      interface to the card.  The mailboxes, doorbells, playback and record 
//*      buffers, as well as other miscellaneous items are declared here.
//*
//* Modification Log:
//*
//*      1.2   08/08/97 Bill
//*      (v1.0B5) Added cardCommand to the shared buffer.  
//*
//*      1.1   11/22/96 Bill
//*      Initial version created.  
//*
//*
//* Copyright (c) 1996 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#ifndef K1212IFPR_H
#define K1212IFPR_H

#ifndef K1212API_H
#include "1212api.h"
#endif
#ifndef K1212APIP_H
#include "1212apip.h"
#endif

// --------------------------------------------------------------------------
// constants used for setting up and using the card interface registers
// --------------------------------------------------------------------------
#define  MAILBOX0_OFFSET      0x40        // location of mailbox 0 relative to base address
#define  MAILBOX1_OFFSET      0x44        // location of mailbox 1 relative to base address
#define  MAILBOX2_OFFSET      0x48        // location of mailbox 2 relative to base address
#define  MAILBOX3_OFFSET      0x4c        // location of mailbox 3 relative to base address
#define  OUT_DOORBELL_OFFSET  0x60        // location of PCI to local doorbell "
#define  IN_DOORBELL_OFFSET   0x64        // location of local to PCI doorbell "
#define  STATUS_REG_OFFSET    0x68        // location of interrupt control/status register "
#define  PCI_CONTROL_OFFSET   0x6c        // location of the EEPROM, PCI, User I/O, init control
                                          //    register
#define  SENS_CONTROL_OFFSET  0x6e        // location of the input sensitivity setting register.
                                          //    this is the upper word of the PCI control reg.
#define  DEV_VEND_ID_OFFSET   0x70        // location of the device and vendor ID register

   // command acknowledgment constants
#define  COMMAND_ACK_DELAY    13          // number of RTC ticks to wait for an acknowledgement
                                          //    from the card after sending a command.
#define  MAX_COMMAND_RETRIES  5           // maximum number of times the driver will attempt
                                          //    to send a command before giving up.
#define  COMMAND_ACK_MASK     0x8000      // the MSB is set in the command acknowledgment from
                                          //    the card.
#define  DOORBELL_VAL_MASK    0x00FF      // the doorbell value is one byte

   // card DMA setup notification constants
#define  DMA_SETUP_IN_PROGRESS_BIT  0x8000   // the MSB is set when the card is setting up a DMA

   // command timeout constants
#define  K1212_WAITFORSENS_DELAY  10         // wait 10 ms before retrying if held off by a sensitivity
                                             //    update.

   // -----------------------------------------------------------------
   // the following bits are used for controlling interrupts in the 
   // interrupt control/status reg
   // -----------------------------------------------------------------
#define  PCI_INT_ENABLE_BIT               0x00000100     
#define  PCI_DOORBELL_INT_ENABLE_BIT      0x00000200
#define  LOCAL_INT_ENABLE_BIT             0x00010000
#define  LOCAL_DOORBELL_INT_ENABLE_BIT    0x00020000
#define  LOCAL_DMA1_INT_ENABLE_BIT        0x00080000

   // -----------------------------------------------------------------
   // the following bits are defined for the PCI command register
   // -----------------------------------------------------------------
#define  PCI_CMD_MEM_SPACE_ENABLE_BIT     0x0002     
#define  PCI_CMD_IO_SPACE_ENABLE_BIT      0x0001     
#define  PCI_CMD_BUS_MASTER_ENABLE_BIT    0x0004

   // -----------------------------------------------------------------
   // the following bits are defined for the PCI status register
   // -----------------------------------------------------------------
#define  PCI_STAT_PARITY_ERROR_BIT        0x8000     
#define  PCI_STAT_SYSTEM_ERROR_BIT        0x4000     
#define  PCI_STAT_MASTER_ABORT_RCVD_BIT   0x2000     
#define  PCI_STAT_TARGET_ABORT_RCVD_BIT   0x1000     
#define  PCI_STAT_TARGET_ABORT_SENT_BIT   0x0800     

// --------------------------------------------------------------------------
// Structure to store the addresses of the doorbell and mailboxes for use in
// communicating with the card.
// --------------------------------------------------------------------------
typedef struct cardInterfaceRegisters {
   DWORD*   statusRegPtr;     // address of the interrupt status/control register
   DWORD*   outDoorbellPtr;   // address of the host->card doorbell register
   DWORD*   inDoorbellPtr;    // address of the card->host doorbell register
   DWORD*   mailbox0Ptr;      // address of mailbox 0 on the card
   DWORD*   mailbox1Ptr;      // address of mailbox 1 on the card
   DWORD*   mailbox2Ptr;      // address of mailbox 2 on the card
   DWORD*   mailbox3Ptr;      // address of mailbox 3 on the card
   DWORD*   controlRegPtr;    // address of the EEPROM, PCI, I/O, Init ctrl reg
   WORD*    sensRegPtr;       // address of the sensitivity setting register
   DWORD*   idRegPtr;         // address of the device and vendor ID registers
} cardIntfRegs;

// --------------------------------------------------------------------------
// private functions for setting and reading the card interface register
// addresses.
// --------------------------------------------------------------------------
void     initCardInterfaceRegs(DWORD cardIndex);                 // inits all members to 0

DWORD*   statusRegAddress  (DWORD cardIndex);                    // returns statusRegPtr
DWORD*   outDoorbellAddress(DWORD cardIndex);                    // returns inDoorbellPtr
DWORD*   inDoorbellAddress (DWORD cardIndex);                    // returns outDoorbellPtr
DWORD*   mailbox0Address   (DWORD cardIndex);                    // returns mailbox0Ptr
DWORD*   mailbox1Address   (DWORD cardIndex);                    // returns mailbox1Ptr
DWORD*   mailbox2Address   (DWORD cardIndex);                    // returns mailbox2Ptr
DWORD*   mailbox3Address   (DWORD cardIndex);                    // returns mailbox3Ptr
DWORD*   controlRegAddress (DWORD cardIndex);                    // returns controlRegPtr
WORD*    sensRegAddress    (DWORD cardIndex);                    // returns sensRegPtr
DWORD*   idRegAddress      (DWORD cardIndex);                    // returns idRegPtr

void     setStatusRegAddress  (DWORD cardIndex, DWORD* address); // sets statusRegPtr 
void     setOutDoorbellAddress(DWORD cardIndex, DWORD* address); // sets outDoorbellPtr 
void     setInDoorbellAddress (DWORD cardIndex, DWORD* address); // sets inDoorbellPtr
void     setMailbox0Address   (DWORD cardIndex, DWORD* address); // sets mailbox0Ptr to address
void     setMailbox1Address   (DWORD cardIndex, DWORD* address); // sets mailbox1Ptr to address
void     setMailbox2Address   (DWORD cardIndex, DWORD* address); // sets mailbox2Ptr to address
void     setMailbox3Address   (DWORD cardIndex, DWORD* address); // sets mailbox3Ptr to address
void     setControlRegAddress (DWORD cardIndex, DWORD* address); // sets controlRegPtr to address
void     setSensRegAddress    (DWORD cardIndex, WORD* address);  // sets sensRegPtr to address
void     setIdRegAddress      (DWORD cardIndex, DWORD* address); // sets idRegPtr to address

BOOL     regPtrsAssigned      (DWORD cardIndex);         // indicates whether the
                                                         //    pointers have been assigned

// --------------------------------------------------------------------------
// private functions for reading/writing the card interface registers
// --------------------------------------------------------------------------
void     writeStatusReg    (DWORD cardIndex, DWORD value);
DWORD    readStatusReg     (DWORD cardIndex);
void     writeOutDoorbell  (DWORD cardIndex, DWORD value);
DWORD    readOutDoorbell   (DWORD cardIndex);
void     writeInDoorbell   (DWORD cardIndex, DWORD value);
DWORD    readInDoorbell    (DWORD cardIndex);
void     writeMailbox0     (DWORD cardIndex, DWORD value);
DWORD    readMailbox0      (DWORD cardIndex);
void     writeMailbox1     (DWORD cardIndex, DWORD value);
DWORD    readMailbox1      (DWORD cardIndex);
void     writeMailbox2     (DWORD cardIndex, DWORD value);
DWORD    readMailbox2      (DWORD cardIndex);
void     writeMailbox3     (DWORD cardIndex, DWORD value);
DWORD    readMailbox3      (DWORD cardIndex);
DWORD    readControlReg    (DWORD cardIndex);
void     writeSensReg      (DWORD cardIndex, WORD value);
DWORD    readIdReg         (DWORD cardIndex);


// -------------------------------------------------------------------------------------
// This function gets called when the card has requested more data.  The registered
// fill routine is ultimately called via the following process.  ScheduleFillRoutine
// is scheduled by the ISR so that it can make all the necessary calls that the ISR
// is restricted from making.
// -------------------------------------------------------------------------------------
void OnRequestForData(DWORD cardIndex, DWORD doorbellValue);
void __stdcall ScheduleFillRoutine   (VMHANDLE hVM, PVOID Refdata, PCLIENT_STRUCT pRegs);
void __stdcall StopCardOnErrorRoutine(VMHANDLE hVM, PVOID Refdata, PCLIENT_STRUCT pRegs);
void __stdcall StopCardAckRoutine    (VMHANDLE hVM, PVOID Refdata, PCLIENT_STRUCT pRegs);

// -------------------------------------------------------------------------------------
// This function gets called when the DSP download has completed.  It instructs the
// card to boot from page 4.
// -------------------------------------------------------------------------------------
void OnDSPDownloadComplete(DWORD cardIndex);

// -------------------------------------------------------------------------------------
// This function gets called when the card has successfully booted from the DSP 
// microcode.  It lets the card know where all of its buffers are.
// -------------------------------------------------------------------------------------
void __stdcall OnDSPBootComplete(PVOID refdata, DWORD Extra);

// --------------------------------------------------------------------------
// SetupCardInterface
//
//    This function is called after the card configuration has been read in
//    from the configuration manager.  It sets up the interface structure
//    based on the configuration data so that the card interface function
//    can correctly communicate with the card.  A flag is used to indicate
//    whether this setup has been performed, so that the interface functions
//    can fail and return before trying to write based on uninitializes
//    pointers.
//
// --------------------------------------------------------------------------
void  SetupCardInterface(DWORD cardIndex);


// --------------------------------------------------------------------------
// CreateCardBuffers
//
//    This function creates the shared and miscellaneous buffers that are
//    used for passing data between a ring 3 application and the card itself.
// --------------------------------------------------------------------------
BOOL  CreateCardBuffers(DWORD cardIndex);


typedef struct KorgSharedBuffer {
   KorgAudioBuffer   playDataBufs[kNumBuffers];
   KorgAudioBuffer   recordDataBufs[kNumBuffers];
   WORD              volumeData[kAudioChannels];
   DWORD             cardCommand;                  // 1.0B5 added for sending commands to the
                                                   //    card while it is playing or in monitor mode
   WORD              routeData [kAudioChannels];
   DWORD             AdatTimeCode;                 // ADAT timecode value
} KorgSharedBuffer;

#endif // K1212IFPR_H
