//*****************************************************************************
//* Name:
//*      1212card.h
//*
//* Project:
//*      1212 I/O VxD
//*
//* Author:
//*      Bill Jenkins
//*
//* Description:
//*      This file contains the declaration of the card configuration access
//*      functions.
//*
//* Modification Log:
//*
//*      1.7   08/20/97 Bill
//*      (v1.0B6) Added auto sync rec/play access functions.
//*
//*      1.6   08/04/97 Bill
//*      (v1.0B5) Added k1212_DMA_ERROR code, setCardCommand, stopQueued, plus 
//*      idleMonitorOn functions.
//*
//*      1.5   06/18/97 Bill
//*      (v1.11) Added functions for record buffer number and buffer return
//*      linked list data members.
//*
//*      1.4   06/16/97 Bill
//*      (v1.09) Added accessor for numMsPerInt data member.  
//*
//*      1.3   06/03/97 Bill
//*      (v1.05) Added accessor for fileHandle data member.  
//*
//*      1.2   12/27/96 Bill
//*      Modified to support multiple cards.  
//*
//*      1.1   11/14/96 Bill
//*      Initial version created.  
//*
//*
//* Copyright (c) 1996 Korg, Inc.
//* All rights reserved.
//*
//* This program is protected as an unpublished work under the U.S.
//* copyright laws.  The above copyright notice is not intended to
//* effect a publication of this work.
//*
//* This program is the confidential and proprietary information of
//* Korg and all its subsidiaries.
//*****************************************************************************

#ifndef K1212CARD_H
#define K1212CARD_H

#ifndef _CONFIGMG_H
#include <configmg.h>
#endif
#ifndef K1212STAT_H
#include "1212stat.h"
#endif
#ifndef K1212IFPR_H
#include "1212ifpr.h"
#endif
#ifndef K1212WAVESTRUCT_H
#include "1212wavestruct.h"
#endif


// ------------------------------------------------------------------------
// critical section macros - we need to have the must complete statements
// to avoid deadlocks
// ------------------------------------------------------------------------
#define START_CRITICAL     EnterMustComplete(); \
                           Begin_Critical_Section(0);

#define END_CRITICAL       End_Critical_Section(); \
                           LeaveMustComplete();
                           


// ----------------------------------------------------------
// Card constants:
// the record/play latency is a fixed value of 16 samples.
// we allow 200 ms for the card to boot the DSP microcode.
// ----------------------------------------------------------
#define k1212RecPlayLatency         16
#define K1212DSP_BOOT_DELAY_IN_MS   200
#define K1212CARD_BOOT_DELAY_IN_MS  10

// -------------------------------------------------------------------------
// cardData utility functions
// -------------------------------------------------------------------------
BOOL              VerifyCardIndex  (DWORD cardIndex);   // verifies the index is valid
BOOL              VerifyDeviceIndex(DWORD deviceId);    // verifies the index is valid

// -------------------------------------------------------------------------
// public cardData functions
// -------------------------------------------------------------------------
DEVNODE           getDevNode  (DWORD cardIndex);   // gets the card's device node identifier
DWORD             getBusNum   (DWORD cardIndex);   // gets the number of the bus the card is on
DWORD             getDeviceNum(DWORD cardIndex);   // gets the bus device number of the card 
void              setCardState(DWORD cardIndex,    // sets the card's state
                               CardState csState
                  ); 
CardState         getCardState(DWORD cardIndex);   // gets the card's state
DWORD             getOpenCount(DWORD cardIndex);   // gets the # of times the card was opened
void              incOpenCount(DWORD cardIndex);   // increments the open count by one
int               getIrqNum   (DWORD cardIndex);   // gets the IRQ number assigned to the card
ULONG             getIrqCount (DWORD cardIndex);   // gets number of IRQs from the card
char*             getMemBase  (DWORD cardIndex);   // gets the base memory address assigned
WORD              getIoBase   (DWORD cardIndex);   // gets the base I/O space address "
DWORD             getMemLength(DWORD cardIndex);   // gets the amount of memory space assigned

BOOL              getIdleMonitorState(DWORD cardIndex);  // TRUE if card is in idle monitor mode
void              setIdleMonitorState(DWORD cardIndex,   // sets the idle monitor state of the card
                                      BOOL  newState);
DWORD             getCurFillBufNum  (DWORD cardIndex);   // gets buffer number to be filled
void              setCurFillBufNum  (DWORD cardIndex,    // sets buffer number to be filled
                                     DWORD bufNum);
DWORD             getCurRecBufNum   (DWORD cardIndex);   // gets buffer number recorded (v1.11)
void              setCurRecBufNum   (DWORD cardIndex,    // sets buffer number recorded (v1.11)
                                     DWORD bufNum);
void              incCurFillBufNum  (DWORD cardIndex);   // increments the buffer number to be filled
void              incCurRecBufNum   (DWORD cardIndex);   // increments the buffer number last recorded (v1.11)

DWORD             getCmdRetryCount  (DWORD cardIndex);   // gets the # of times a command was resent
                                                         //    to the card because of ack failure.
void              addToCmdRetryCount(DWORD cardIndex,    // increments the retry count by the passed
                                     DWORD numRetries    //    in value.
                  );
KorgSharedBuffer* getSharedBufferPtr(DWORD cardIndex);   // gets ptr to the card's shared buffer
KorgSharedBuffer* getSharedPhyBufPtr(DWORD cardIndex);   // gets physical address of the shared buffer
WORD*             getVolumeTable    (DWORD cardIndex);   // gets the address of the volume table
WORD*             getRoutingTable   (DWORD cardIndex);   // gets the address of the routing table
WORD*             getVolumeTablePhy (DWORD cardIndex);   // gets the volume table's phys address
WORD*             getRoutingTablePhy(DWORD cardIndex);   // gets the routing table's phys address
KorgAudioBuffer*  getPlayBuf0Address(DWORD cardIndex);   // gets 1st play buffer's linear address
KorgAudioBuffer*  getRecBuf0Address (DWORD cardIndex);   // gets 1st record buffer's linear address
KorgAudioBuffer*  getPlayBufXAddress(DWORD cardIndex,    // gets nth play buffer's linear address
                                     DWORD bufferIndex
                  );
KorgAudioBuffer*  getRecBufXAddress (DWORD cardIndex,    // gets nth record buffer's linear address
                                     DWORD bufferIndex
                  );
KorgAudioBuffer*  getPlayDataPhy    (DWORD cardIndex);   // gets 1st play buffer's physical address
KorgAudioBuffer*  getRecDataPhy     (DWORD cardIndex);   // gets 1st record buffer's physical address

DWORD             getAdatTimeCode   (DWORD cardIndex);   // gets the ADAT timecode value (from struct)
DWORD*            getAdatTimeCodePtr(DWORD cardIndex);   // gets the ADAT timecode address
DWORD*            getAdatTimeCodePhy(DWORD cardIndex);   // gets the ADAT timecode physical address
DWORD             getNumMsPerInt    (DWORD cardIndex);   // gets the # of ms between card interrupts
ClockSourceIndex  getClkSrcRate     (DWORD cardIndex);   // gets current clock rate and source value
short             getChannelVolume  (DWORD cardIndex,    // gets current channel volume
                                     WORD  channel
                  );
DWORD             getCardCommand    (DWORD cardIndex);   // gets value of command register
WORD              getChannelRoute   (DWORD cardIndex,    // gets current channel routing
                                     WORD  channel
                  );
WORD              getRightADCInSens (DWORD cardIndex);   // gets current right ADC input sensitivity
WORD              getLeftADCInSens  (DWORD cardIndex);   // gets current left ADC input sensitivity
WORD              getRightADCInSens (DWORD cardIndex);   // gets current right ADC input sensitivity
WORD              getMasterVolume   (DWORD cardIndex);   // Returns the current master volume setting

HANDLE            getFileHandle     (DWORD cardIndex);   // returns the handle to the debug file

void              setAdatTimeCode   (DWORD cardIndex,    // sets the ADAT timecode
                                     DWORD timeCodeVal   //    value (in card struct)
                  );           
BOOL              setClkSrcRate     (DWORD cardIndex,    // sets clock rate/source
                                     ClockSourceIndex clkSrcSel
                  );   
void              setChannelVolume  (DWORD cardIndex,     // sets channel volume in the shared buffer
                                     WORD  channel,
                                     short volume
                  );                
void              setCardCommand    (DWORD cardIndex,     // writes a value into the card command register
                                     DWORD command        //   in the shared buffer
                  );
void              setChannelRoute   (DWORD cardIndex,     // sets channel volume in the shared buffer
                                     WORD  channel,
                                     WORD  route
                  );                
void              setLeftADCInSens  (DWORD cardIndex,     // sets left input sens.
                                     WORD lSens
                  );                
void              setRightADCInSens (DWORD cardIndex,     // sets right input sens.
                                     WORD rSens
                  );               

void              setMasterVolume   (DWORD cardIndex,     // sets the master volume for the card
                                     WORD  volume
                  );    

   // -------------------------------------------------------------------------
   // other functions
   // -------------------------------------------------------------------------
void  K1212TurnOffIdleMonitor(DWORD cardIndex);
void  K1212TurnOnIdleMonitor(DWORD cardIndex);
void  WaitForCardStopAck(DWORD cardIndex);


   // -------------------------------------------------------------------------
   // wave device related functions
   // -------------------------------------------------------------------------
k1212WaveInDevice*   getWaveInDevPtr  (DWORD cardIndex,   // returns a pointer to the wave input
                                       DWORD deviceId     //   device structure
                     );
k1212WaveOutDevice*  getWaveOutDevPtr (DWORD cardIndex,   // returns a pointer to the wave output
                                       DWORD deviceId     //   device structure
                     );

BOOL                 getAutoWaveSyncMode (DWORD cardIndex);  // are the wave devices in auto sync record mode?
void                 setAutoWaveSyncMode (DWORD cardindex,   // sets the auto sync record mode of the card
                                          BOOL  setting
                     );

   // -------------------------------------------------------------------------
   // error codes
   // -------------------------------------------------------------------------
#define k1212_DMA_ERROR 1

#endif // K1212CARD_H
