//--------------------------------------------------------------------------;
//
//  File: PROPSET.C
//
//  Description:
//      The C implemtation of the PropertySet object.
//      
//
//---------------------------------------------------------------------------
//
//  Copyright (c) 1996 - 1997 Atmel Dream.  All Rights Reserved.
//
//---------------------------------------------------------------------------
#define  WANTVXDWRAPS

#include <windows.h>
#include "vmm.h"
#include <vmmreg.h>
#include <vxdldr.h>
#include <vxdwraps.h>

#include <configmg.h>
#include <dsound.h>
#include "dsdriver.h"
#include <debug.h>

#include <stdio.h>
#include "dsnd.h"
#include "Dos_xfer.h"
#include "Dream3D.h"

#undef CURSEG
#define CURSEG() PCODE

#pragma VxD_PAGEABLE_CODE_SEG
#pragma VxD_PAGEABLE_DATA_SEG

BYTE _fltused;

extern WORD gwBaseMPU401;		// Base Address 9407
extern BOOL NoMidiFlag;

#define Pi	3.141592657

//Buffer3D List
PDS3DLIST List3DTail=NULL;
PDS3DLIST Buffer3DList=NULL;

BOOL BatchFlag;

//--------------------------------------------------------------------------
//
//  IDsPropertySet_QueryInterface
//  Description:
//      We want to be COM, but we're not. This interface would be used
//      to extend functionality to the buffer object interface.
//  Parameters:
//  Return:
//      vtable
//  
//  
//--------------------------------------------------------------------------
HRESULT __stdcall IDsPropertySet_QueryInterface(
		PIDSDRIVERPROPERTYSET pIDsPropSet, REFIID riid, LPVOID *ppv)
{

    DP(("IDsPropertySet_QueryInterface\n"));

    *ppv = NULL;

    if(( !IsEqualGUID(riid,&IID_IDsDriverPropertySet)) &&
	    (!IsEqualGUID(riid,&IID_IUnknown)  ))
    {
        return DSERR_NOINTERFACE;
    }

    *ppv = pIDsPropSet;
    ((LPUNKNOWN)*ppv)->lpVtbl->AddRef(*ppv);

    return DS_OK;
}


//--------------------------------------------------------------------------
//
//  IDsPropertySet_AddRef
//  Description:
//      Add anohter reference count to the buffer object interface
//  Parameters:
//      pIDsDriverBuffer: Buffer object context.
//  Return:
//      Current reference count;
//  
//  
//--------------------------------------------------------------------------
ULONG __stdcall
IDsPropertySet_AddRef(
    IN PIDSDRIVERPROPERTYSET pIDsPropertySet
)
{
	PDSPROPERTYSET pPropSetContext = (PDSPROPERTYSET)pIDsPropertySet;
   

    DP(("IDsPropertySet_AddRef\n"));

    // add one.
    pPropSetContext->ReferenceCounter++;
    // return the CURRENT count.
    return pPropSetContext->ReferenceCounter;
}

//--------------------------------------------------------------------------
//
//  IDsPropertySet_Release
//  Description:
//      This functions is the destructor of our buffer object.
//  Parameters:
//      pIDsDriverBuffer: Our buffer object context
//  Return:
//      Obect ref count.
//  
//  
//--------------------------------------------------------------------------
ULONG __stdcall
IDsPropertySet_Release(
    IN PIDSDRIVERPROPERTYSET pIDsPropertySet
    )
{
	PDSPROPERTYSET pPropSetContext = (PDSPROPERTYSET)pIDsPropertySet;
    ULONG ReturnCount;


    DP(("IDsPropertySet_Release\n"));

    // this instance is going away, check our ref count
    pPropSetContext->ReferenceCounter--;

    ReturnCount = pPropSetContext->ReferenceCounter;

	  if( !pPropSetContext->ReferenceCounter )
	  {
		  	//Remove3DBufferFromList(pPropSetContext->pIBuffer);
            _HeapFree( pPropSetContext, 0 );
		}
	  return ReturnCount;
}

//--------------------------------------------------------------------------
//
//  IDsPropertySet_QuerySupport
//  Description:
//      
//  Parameters:
//      
//  Return:
//      
//  
//  
//--------------------------------------------------------------------------
HRESULT __stdcall IDsPropertySet_QuerySupport(PIDSDRIVERPROPERTYSET pIDsPropertySet,
			REFGUID PropertySetId, ULONG PropertyId, PULONG pSupport)
{
	PDSPROPERTYSET pPropSetContext = (PDSPROPERTYSET)pIDsPropertySet;
		
	    DP(("IDsPropertySet_QuerySupport\n"));


	*pSupport=0;

	if ((pPropSetContext->pIBuffer->Primary) &&		// DREAM Property (propertyset associated with the primary)
		( IsEqualGUID(PropertySetId,&DSPROPERTY_Dream3D)) )
	{
		if (PropertyId>DSPROPERTY_DREAM3D_EQUALIZER)
			return E_NOTIMPL;
		*pSupport=KSPROPERTY_SUPPORT_SET;

		return DS_OK;
	}


	// Is it a Dream buffer property set
	if ( (!(pPropSetContext->pIBuffer->Primary)) &&
	    (IsEqualGUID(PropertySetId,&DSPROPERTY_DreamBuffer)))
	{
		if (PropertyId>0)
			return E_NOTIMPL;
		*pSupport=KSPROPERTY_SUPPORT_SET; 
		return DS_OK;
	}


	if ((pPropSetContext->pIBuffer->Primary) && ( IsEqualGUID(PropertySetId,&DSPROPSETID_DirectSound3DListener)))
	{
		 if (pPropSetContext->pIBuffer->p3DProperty==NULL)		// 3D structure not allocated
			pPropSetContext->pIBuffer->p3DProperty = _HeapAllocate(sizeof(DS3DLISTENER), HEAPZEROINIT | HEAPSWAP);
	
		 *pSupport=KSPROPERTY_SUPPORT_GET | KSPROPERTY_SUPPORT_SET; // Listenner supported by Primary
		return DS_OK;
	}

	if ( (!(pPropSetContext->pIBuffer->Primary)) &&
	    (IsEqualGUID(PropertySetId,&DSPROPSETID_DirectSound3DBuffer)))
	{
		if (pPropSetContext->pIBuffer->p3DProperty==NULL)		// 3D structure not allocated
		{
			//first, check if not stereo
			if (pPropSetContext->pIBuffer->nChannels==2)
				return E_NOTIMPL;		// 3D not suported (pSupport=0)
			pPropSetContext->pIBuffer->p3DProperty = _HeapAllocate(sizeof(DS3DBUFFER), HEAPZEROINIT | HEAPSWAP);
			//add this 3D buffer in the Buffer3DList
			//Add3DBufferInList(pPropSetContext->pIBuffer);
		}

		*pSupport=KSPROPERTY_SUPPORT_GET | KSPROPERTY_SUPPORT_SET; // Buffer supported by secondary
		return DS_OK;
	}
	
	if ((pPropSetContext->pIBuffer->Primary) && (IsEqualGUID(PropertySetId,&DSPROPSETID_DirectSoundSpeakerConfig)))
	{
		if (pPropSetContext->pIBuffer->p3DProperty==NULL)		// 3D structure not allocated
			 pPropSetContext->pIBuffer->p3DProperty = _HeapAllocate(sizeof(DS3DLISTENER), HEAPZEROINIT | HEAPSWAP);
	
		*pSupport=KSPROPERTY_SUPPORT_GET; //speaker config supported by primary
		return DS_OK;
	}

	return E_NOTIMPL;
}

//--------------------------------------------------------------------------
//
//  IDsPropertySet_Get
//  Description:
//      
//  Parameters:
//      
//  Return:
//      
//  
//  
//--------------------------------------------------------------------------
HRESULT __stdcall IDsPropertySet_Get(PIDSDRIVERPROPERTYSET pIDsPropertySet,
			PDSPROPERTY pDsProperty, LPVOID pPropertyParam, ULONG cbPropertyParam,
			LPVOID pPropertyData, ULONG cbPropertyData, PULONG pcbReturnedData)
{
	PDSPROPERTYSET pPropSetContext = (PDSPROPERTYSET)pIDsPropertySet;

    DP(("IDsPropertySet_Get\n"));


	//let's test InstanceID
	if (pDsProperty->InstanceId!=pPropSetContext->pIBuffer->Instance3DId)
	{
		Trace_Out("set InstanceId");
		pPropSetContext->pIBuffer->Instance3DId=pDsProperty->InstanceId;
	}

		//Listener interface if primary buffer
	if (IsEqualGUID(&pDsProperty->Set,&DSPROPSETID_DirectSound3DListener))
	{
		if (!(pPropSetContext->pIBuffer->Primary))
			return DSERR_INVALIDPARAM;		//Listener must be a Primary buffer
		switch (pDsProperty->Id)
		{
		case DSPROPERTY_DIRECTSOUND3DLISTENER_ALL:
			{
				LPDS3DLISTENER pDs3dListener = pPropertyData;
				if (cbPropertyData<sizeof(DS3DLISTENER))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the structure (*(PDS3DLISTENER) p3DProperty) in pPropertyData
				*(pDs3dListener)=*((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty));
			
				*pcbReturnedData=sizeof(DS3DLISTENER);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_POSITION:
			{
				if (cbPropertyData<sizeof(D3DVECTOR))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the position
				*((LPD3DVECTOR)pPropertyData)=((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))->vPosition;
				*pcbReturnedData=sizeof(D3DVECTOR);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY:
			{
				if (cbPropertyData<sizeof(D3DVECTOR))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// velocity
				*((LPD3DVECTOR)pPropertyData)=((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))->vVelocity;
				*pcbReturnedData=sizeof(D3DVECTOR);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION:
			{
				if (cbPropertyData<2*sizeof(D3DVECTOR))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the orientation
				*((LPD3DVECTOR)pPropertyData)=((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))->vOrientFront;
				*( ((LPD3DVECTOR)pPropertyData)+1)=((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))->vOrientTop;
			
				*pcbReturnedData=2*sizeof(D3DVECTOR);
			}
			break;

		case DSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR:
			{
				if (cbPropertyData<sizeof(D3DVALUE))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the distance factor
				*((LPD3DVALUE)pPropertyData)=((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))->flDistanceFactor;
				*pcbReturnedData=sizeof(D3DVALUE);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR:
			{
				if (cbPropertyData<sizeof(D3DVALUE))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the distance factor
				*((LPD3DVALUE)pPropertyData)=((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))->flRolloffFactor;
				*pcbReturnedData=sizeof(D3DVALUE);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR:
			{
				if (cbPropertyData<sizeof(D3DVALUE))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the distance factor
				*((LPD3DVALUE)pPropertyData)=((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))->flDopplerFactor;
				*pcbReturnedData=sizeof(D3DVALUE);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_BATCH:
			{
				if (cbPropertyData<sizeof(BOOL))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the distance factor
				*((LPBOOL)pPropertyData)=BatchFlag;
				*pcbReturnedData=sizeof(BOOL);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION:
			return DSERR_INVALIDPARAM;
			break;

		}
	}

		//3D buffer if not primary buffer
	else if (IsEqualGUID(&pDsProperty->Set,&DSPROPSETID_DirectSound3DBuffer))
	{
		if (pPropSetContext->pIBuffer->Primary)
			return DSERR_INVALIDPARAM;		//3D buffer must be a secondary buffer
		switch (pDsProperty->Id)
		{
		case DSPROPERTY_DIRECTSOUND3DBUFFER_ALL:
			{
				LPDS3DBUFFER pDs3dBuffer = pPropertyData;
				if (cbPropertyData<sizeof(DS3DBUFFER))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the structure (*(PDS3DLISTENER) p3DProperty) in pPropertyData
				*(pDs3dBuffer)=*((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty));
			
				*pcbReturnedData=sizeof(DS3DBUFFER);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_POSITION:
			{
				if (cbPropertyData<sizeof(D3DVECTOR))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the position
				*((LPD3DVECTOR)pPropertyData)=((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->vPosition;
				*pcbReturnedData=sizeof(D3DVECTOR);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY:
			{
				if (cbPropertyData<sizeof(D3DVECTOR))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// velocity
				*((LPD3DVECTOR)pPropertyData)=((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->vVelocity;
				*pcbReturnedData=sizeof(D3DVECTOR);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES:
			{
				if (cbPropertyData<2*sizeof(DWORD))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// cone angles
				*((LPDWORD)pPropertyData)=((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->dwInsideConeAngle;
				*( ((LPDWORD)pPropertyData)+1 )=((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->dwOutsideConeAngle;
				*pcbReturnedData=2*sizeof(DWORD);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION:
			{
				if (cbPropertyData<sizeof(D3DVECTOR))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// cone angles
				*((LPD3DVECTOR)pPropertyData)=((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->vConeOrientation;
				*pcbReturnedData=sizeof(D3DVECTOR);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME:
			{
				if (cbPropertyData<sizeof(LONG))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// cone angles
				*((LPLONG)pPropertyData)=((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->lConeOutsideVolume;
				*pcbReturnedData=sizeof(LONG);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE:
			{
				if (cbPropertyData<sizeof(D3DVALUE))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the distance factor
				*((LPD3DVALUE)pPropertyData)=((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->flMinDistance;
				*pcbReturnedData=sizeof(D3DVALUE);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE:
			{
				if (cbPropertyData<sizeof(D3DVALUE))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the distance factor
				*((LPD3DVALUE)pPropertyData)=((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->flMaxDistance;
				*pcbReturnedData=sizeof(D3DVALUE);
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_MODE:
			{
				if (cbPropertyData<sizeof(DWORD))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// cone angles
				*((LPDWORD)pPropertyData)=((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->dwMode;
				*pcbReturnedData=sizeof(DWORD);
			}
			break;

		}
	}


	//speaker config supported for primary buffer
	else if (IsEqualGUID(&pDsProperty->Set,&DSPROPSETID_DirectSoundSpeakerConfig))
	{
		if (!pPropSetContext->pIBuffer->Primary)
			return DSERR_INVALIDPARAM;		//must be a Primary buffer
		if ( pDsProperty->Id!=DSPROPERTY_DIRECTSOUNDSPEAKERCONFIG_SPEAKERCONFIG)
			return DSERR_INVALIDPARAM;


		*((LPDWORD)pPropertyData)=DSSPEAKER_QUAD;
		*pcbReturnedData=sizeof(DWORD);
	}

	else return DSERR_INVALIDPARAM;

	return DS_OK;

}

		
//--------------------------------------------------------------------------
//
//  IDsPropertySet_Set
//  Description:
//      
//  Parameters:
//      
//  Return:
//      
//  
//  
//--------------------------------------------------------------------------
HRESULT __stdcall IDsPropertySet_Set(PIDSDRIVERPROPERTYSET pIDsPropertySet,
			PDSPROPERTY pDsProperty, LPVOID pPropertyParam, ULONG cbPropertyParam,
			LPVOID pPropertyData, ULONG cbPropertyData)
{
	PDSPROPERTYSET pPropSetContext = (PDSPROPERTYSET)pIDsPropertySet;
	PDS3DLIST Cur3DBuffer;
	DP(("IDsPropertySet_Set\n"));

	// First, match the case of Dream Property Set
	if (IsEqualGUID(&pDsProperty->Set,&DSPROPERTY_Dream3D))
	{
	if (!(pPropSetContext->pIBuffer->Primary))
			return DSERR_INVALIDCALL;		//Property interface not valid for secondary buffers
		switch (pDsProperty->Id)
		{
		case DSPROPERTY_DREAM3D_NOMIDI:
			{
				// no datas

				if (NoMidiFlag)
					return DS_OK;
				// Remove all sound Banks
				ResetMemory();

				// Remove slots
				if (!SetConfig(gwBaseMPU401, C_REVERB,C_OFF))
					return DSERR_GENERIC;
				if (!SetConfig(gwBaseMPU401, C_CHORUS,C_OFF))
					return DSERR_GENERIC;
				if (!SetConfig(gwBaseMPU401, C_EQUA,2))
					return DSERR_GENERIC;
				if (!SetConfig(gwBaseMPU401, C_ECHO,C_OFF))		// go in uart
					return DSERR_GENERIC;
				if (!SetConfig(gwBaseMPU401, C_SURROUND,C_OFF))		// go in uart
					return DSERR_GENERIC;
				
				NoMidiFlag=TRUE;

			if (!CheckFreeSize(gwBaseMPU401))
				return DSERR_GENERIC;

				// restart the wave 0
				RestartDSWave();

				// restart all voices
			Cur3DBuffer=Buffer3DList;
			while (Cur3DBuffer)
			{
				if (Cur3DBuffer->pBuffer3D->DacState != DS_DAC_STATE_STOPPED)
				{
					StartPlay(Cur3DBuffer->pBuffer3D, FALSE);
				}
				Cur3DBuffer=Cur3DBuffer->pNext;
			}
				return DS_OK;
			
			}
			break;
		case DSPROPERTY_DREAM3D_REMOVEALLBANKS:
			{
				if (NoMidiFlag)
					return DS_OK;
				// Remove all sound Banks
				ResetMemory();
			if (!CheckFreeSize(gwBaseMPU401))
				return DSERR_GENERIC;

				return DS_OK;
			}
			break;
		case DSPROPERTY_DREAM3D_REMOVEBANK:
			{
			if (cbPropertyData==0)
				return DSERR_INVALIDPARAM;			// parameters size not match!

			if (DeleteSoundBank((char *)pPropertyData))
			{
				if (!CheckFreeSize(gwBaseMPU401))
					return DSERR_GENERIC;

				return DS_OK;
			}
			else
				return DSERR_INVALIDPARAM;

			}
			break;

		case DSPROPERTY_DREAM3D_ADDBANK:
			{
			if (cbPropertyData==0)
				return DSERR_INVALIDPARAM;			// parameters size not match!

			if (vxdLoadSB((DWORD) pPropertyData,0)<=0x10)
			{
				if (!CheckFreeSize(gwBaseMPU401))
					return DSERR_GENERIC;
				return DS_OK;
			}
			else
				return DSERR_INVALIDPARAM;

			}
			break;
		case DSPROPERTY_DREAM3D_REVERB:
			{
			DWORD Config;

			if ((*(BOOL*) pPropertyData)==FALSE)
				Config=C_OFF;
			else
				Config=C_ON;
			
			if (!SetConfig(gwBaseMPU401, C_REVERB,Config))
				return DSERR_INVALIDCALL;

			if (!CheckFreeSize(gwBaseMPU401))
				return DSERR_GENERIC;

			// restart the wave 0
				RestartDSWave();
			// restart all voices
			Cur3DBuffer=Buffer3DList;
			while (Cur3DBuffer)
			{
				if (Cur3DBuffer->pBuffer3D->DacState != DS_DAC_STATE_STOPPED)
				{
					StartPlay(Cur3DBuffer->pBuffer3D, FALSE);
				}
				Cur3DBuffer=Cur3DBuffer->pNext;
			}

			return DS_OK;

			}
			break;


		case DSPROPERTY_DREAM3D_CHORUS:
			{
			DWORD Config;

			if ((*(BOOL*)pPropertyData)==FALSE)
				Config=C_OFF;
			else
				Config=C_ON;
			
			if (!SetConfig(gwBaseMPU401, C_CHORUS,Config))
				return DSERR_INVALIDCALL;

			if (!CheckFreeSize(gwBaseMPU401))
				return DSERR_GENERIC;

			// restart the wave 0
				RestartDSWave();
			// restart all voices
			Cur3DBuffer=Buffer3DList;
			while (Cur3DBuffer)
			{
				if (Cur3DBuffer->pBuffer3D->DacState != DS_DAC_STATE_STOPPED)
				{
					StartPlay(Cur3DBuffer->pBuffer3D, FALSE);
				}
				Cur3DBuffer=Cur3DBuffer->pNext;
			}

			return DS_OK;

			}
			break;


		case DSPROPERTY_DREAM3D_ECHO:
			{
			DWORD Config;

			if ((*(BOOL*) pPropertyData)==FALSE)
				Config=C_OFF;
			else
				Config=C_ON;
			
			if (!SetConfig(gwBaseMPU401, C_ECHO,Config))
				return DSERR_INVALIDCALL;

			if (!CheckFreeSize(gwBaseMPU401))
				return DSERR_GENERIC;

			// restart the wave 0
				RestartDSWave();

			// restart all voices
			Cur3DBuffer=Buffer3DList;
			while (Cur3DBuffer)
			{
				if (Cur3DBuffer->pBuffer3D->DacState != DS_DAC_STATE_STOPPED)
				{
					StartPlay(Cur3DBuffer->pBuffer3D, FALSE);
				}
				Cur3DBuffer=Cur3DBuffer->pNext;
			}

			return DS_OK;

			}
			break;


		case DSPROPERTY_DREAM3D_AUDIOIN:
			{
			DWORD Config;

			if ((*(BOOL*)pPropertyData)==FALSE)
				Config=C_OFF;
			else
				Config=C_ON;
			
			if (!SetConfig(gwBaseMPU401, C_AUDIO,Config))
				return DSERR_INVALIDCALL;

			if (!CheckFreeSize(gwBaseMPU401))
				return DSERR_GENERIC;

			// restart the wave 0
				RestartDSWave();

			// restart all voices
			Cur3DBuffer=Buffer3DList;
			while (Cur3DBuffer)
			{
				if (Cur3DBuffer->pBuffer3D->DacState != DS_DAC_STATE_STOPPED)
				{
					StartPlay(Cur3DBuffer->pBuffer3D, FALSE);
				}
				Cur3DBuffer=Cur3DBuffer->pNext;
			}

			return DS_OK;

			}
			break;


		case DSPROPERTY_DREAM3D_SURROUND:
			{
			DWORD Config;

			if ((*(BOOL*) pPropertyData)==FALSE)
				Config=C_OFF;
			else
				Config=C_ON;
			
			if (!SetConfig(gwBaseMPU401, C_SURROUND,Config))
				return DSERR_INVALIDCALL;

			if (!CheckFreeSize(gwBaseMPU401))
				return DSERR_GENERIC;

			// restart the wave 0
				RestartDSWave();
			// restart all voices
			Cur3DBuffer=Buffer3DList;
			while (Cur3DBuffer)
			{
				if (Cur3DBuffer->pBuffer3D->DacState != DS_DAC_STATE_STOPPED)
				{
					StartPlay(Cur3DBuffer->pBuffer3D, FALSE);
				}
				Cur3DBuffer=Cur3DBuffer->pNext;
			}

			return DS_OK;

			}
			break;


		case DSPROPERTY_DREAM3D_EQUALIZER:
			{
			DWORD Config;

			if ((*(BOOL*) pPropertyData)==FALSE)
				Config=2;
			else
				Config=0;
			
			if (!SetConfig(gwBaseMPU401, C_EQUA,Config))
				return DSERR_INVALIDCALL;

			if (!CheckFreeSize(gwBaseMPU401))
				return DSERR_GENERIC;

			// restart the wave 0
				RestartDSWave();

			// restart all voices
			Cur3DBuffer=Buffer3DList;
			while (Cur3DBuffer)
			{
				if (Cur3DBuffer->pBuffer3D->DacState != DS_DAC_STATE_STOPPED)
				{
					StartPlay(Cur3DBuffer->pBuffer3D, FALSE);
				}
				Cur3DBuffer=Cur3DBuffer->pNext;
			}

			return DS_OK;

			}
			break;

		default:
			return DSERR_INVALIDPARAM;
		}
	}


	if (IsEqualGUID(&pDsProperty->Set,&DSPROPERTY_DreamBuffer))
	{
		if (pPropSetContext->pIBuffer->Primary)
			return DSERR_INVALIDCALL;		//Listener must be a Primary buffer
		switch (pDsProperty->Id)
		{
		case DSPROPERTY_DREAMBUFFER_LOOPPOINT:
			{
				if (cbPropertyData<sizeof(DWORD))
					return DSERR_INVALIDPARAM;			// parameters size not match!
				if (pPropSetContext->pIBuffer->LoopPoint>pPropSetContext->pIBuffer->PCBufferSize)
					return DSERR_INVALIDPARAM;
				pPropSetContext->pIBuffer->LoopPoint= *((DWORD*) pPropertyData);
				return DS_OK;
			
			}
			break;
		default:
			return DSERR_INVALIDPARAM;
		}

	}


	//let's test InstanceID
	if ((pDsProperty->InstanceId!=pPropSetContext->pIBuffer->Instance3DId) &&
		(pDsProperty->Id!=DSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION))
	{
		Trace_Out("set InstanceId");
		pPropSetContext->pIBuffer->Instance3DId=pDsProperty->InstanceId;
	}

		//Listener interface if primary buffer
	if (IsEqualGUID(&pDsProperty->Set,&DSPROPSETID_DirectSound3DListener))
	{
		if (!(pPropSetContext->pIBuffer->Primary))
			return DSERR_INVALIDPARAM;		//Listener must be a Primary buffer
		switch (pDsProperty->Id)
		{
		case DSPROPERTY_DIRECTSOUND3DLISTENER_ALL:
			{
				LPDS3DLISTENER pDs3dListener = pPropertyData;
				if (cbPropertyData<sizeof(DS3DLISTENER))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy *pPropertyData in *p3DProperty
				*((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))=*(pDs3dListener);
			
			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_POSITION:
			{
				if (cbPropertyData<sizeof(D3DVECTOR))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the new position
				((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))->vPosition=*((LPD3DVECTOR)pPropertyData);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY:
			{
				if (cbPropertyData<sizeof(D3DVECTOR))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the new velocity
				((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))->vVelocity=*((LPD3DVECTOR)pPropertyData);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION:
			{
				if (cbPropertyData<2*sizeof(D3DVECTOR))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the new orientation
				((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))->vOrientFront=*((LPD3DVECTOR)pPropertyData);
				((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))->vOrientTop=*(( (LPD3DVECTOR)pPropertyData )+1);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR:
			{
				if (cbPropertyData<sizeof(D3DVALUE))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the new distance factor
				((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))->flDistanceFactor=*((LPD3DVALUE)pPropertyData);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR:
			{
				if (cbPropertyData<sizeof(D3DVALUE))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the new roll of factor
				((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))->flRolloffFactor=*((LPD3DVALUE)pPropertyData);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR:
			{
				if (cbPropertyData<sizeof(D3DVALUE))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the new doppler factor
				((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty))->flDopplerFactor=*((LPD3DVALUE)pPropertyData);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_BATCH:
			{
				if (cbPropertyData<sizeof(BOOL))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy the new Batch flag
				BatchFlag=*((LPBOOL)pPropertyData);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION:
			{
				if (cbPropertyData<sizeof(BOOL))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				
				// new listenner or release listenner
						//(nothing to do if I have well understood!)

			}
			break;

		}	// end switch
		if (!BatchFlag)
		{
			// let's modify the position for all 3D buffers associated with the listener
			PDS3DLIST Cur3DBuffer=Buffer3DList;
			while (Cur3DBuffer)
			{
				if (Cur3DBuffer->pBuffer3D->Instance3DId==pDsProperty->InstanceId)
				{
					if (Cur3DBuffer->pBuffer3D->Enabled3D==1)
						PosSound((LPDS3DLISTENER) (pPropSetContext->pIBuffer->p3DProperty),Cur3DBuffer->pBuffer3D);
				}
				Cur3DBuffer=Cur3DBuffer->pNext;
			}
		}
	}	// end if listener

		//3D buffer if not primary buffer
	else if (IsEqualGUID(&pDsProperty->Set,&DSPROPSETID_DirectSound3DBuffer))
	{
		if (pPropSetContext->pIBuffer->Primary)
			return DSERR_INVALIDPARAM;		//3D buffer must be a secondary buffer
		switch (pDsProperty->Id)
		{
		case DSPROPERTY_DIRECTSOUND3DBUFFER_ALL:
			{
				LPDS3DBUFFER pDs3dBuffer = pPropertyData;
				if (cbPropertyData<sizeof(DS3DBUFFER))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy *pPropertyData in *p3DProperty
				*((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))=*(pDs3dBuffer);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_POSITION:
			{
				if (cbPropertyData<sizeof(D3DVECTOR))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy new position
				((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->vPosition=*((LPD3DVECTOR)pPropertyData);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY:
			{
				if (cbPropertyData<sizeof(D3DVECTOR))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy new velocity
				((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->vVelocity=*((LPD3DVECTOR)pPropertyData);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES:
			{
				if (cbPropertyData<2*sizeof(DWORD))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy new cone angles
				((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->dwInsideConeAngle=*((LPDWORD)pPropertyData);
				((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->dwOutsideConeAngle=*( ((LPDWORD)pPropertyData)+1);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION:
			{
				if (cbPropertyData<sizeof(D3DVECTOR))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy new cone orientation
				((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->vConeOrientation=*((LPD3DVECTOR)pPropertyData);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME:
			{
				if (cbPropertyData<sizeof(LONG))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy new outside volume
				((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->lConeOutsideVolume=*((LPLONG)pPropertyData);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE:
			{
				if (cbPropertyData<sizeof(D3DVALUE))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy new min distance
				((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->flMinDistance=*((LPD3DVALUE)pPropertyData);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE:
			{
				if (cbPropertyData<sizeof(D3DVALUE))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy new min distance
				((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->flMaxDistance=*((LPD3DVALUE)pPropertyData);

			}
			break;
		case DSPROPERTY_DIRECTSOUND3DBUFFER_MODE:
			{
				if (cbPropertyData<sizeof(DWORD))
					return DSERR_INVALIDPARAM;			// parameters size not match!
					
				// copy new min distance
				((LPDS3DBUFFER) (pPropSetContext->pIBuffer->p3DProperty))->dwMode=*((LPDWORD)pPropertyData);

			}
			break;

		}	// end switch

		if ((!BatchFlag) && (pPropSetContext->pIBuffer->DacState!=DS_DAC_STATE_STOPPED))
			PosSound( (DS3DLISTENER*) (((PDSDRIVERBUFFER)(pPropSetContext->pIBuffer->pDriverContext->pPrimaryBuffer))->p3DProperty),
				(PDSDRIVERBUFFER) (pPropSetContext->pIBuffer) );

	}	// end if buffer

	else return DSERR_INVALIDPARAM;

	
	return DS_OK;


}


//
//
//	Procedure that realize the 3D positionning
//
//
BOOL PosSound(LPDS3DLISTENER pListener, PDSDRIVERBUFFER pBufferSource)
{
	D3DVECTOR BPos;
	D3DVECTOR NewOx; //, NewOy, NewOz;
	float FrontMod, TopMod;
	D3DVECTOR BDir;
	float Distance, Distxz, ZTrans;
	float Alpha;
	float Rolloff;
	float BPosConeOrient, ConeOrientMod;
	float Teta;
	float OutVol;
	float Cone;
	float Volume;
	D3DVECTOR RelVelocity;
	float RadialVelocity;
	float Phi[4];
	float V[4];
	int n;
	WORD VolSource;
	WORD Vol[4];
	//const long mind=1;
	const long SoundSpeed=340;
	DWORD Pitch=pBufferSource->nSamplesPerSec;
	LPDS3DBUFFER pBuffer=(LPDS3DBUFFER) (pBufferSource->p3DProperty);
	DWORD VolMaster;
	DWORD VolFront, VolBack, SamPitch;

	DWORD pbs= (DWORD) pBufferSource;
	__asm mov eax,pbs
	Trace_Out("PosSound #eax");

	//FIRST PART : PARAMETERS COMPUTATION
	if (pBuffer->dwMode==DS3DMODE_NORMAL)
	{
		BPos.x=(pBuffer->vPosition.x - pListener->vPosition.x);
		BPos.y=(pBuffer->vPosition.y - pListener->vPosition.y);
		BPos.z=(pBuffer->vPosition.z - pListener->vPosition.z);
	}
	else if (pBuffer->dwMode==DS3DMODE_HEADRELATIVE)
	{
		BDir.x=BPos.x=pBuffer->vPosition.x ;
		BDir.y=BPos.y=pBuffer->vPosition.y ;
		BDir.z=BPos.z=pBuffer->vPosition.z ;
	}

/*

  Instead of this, we don't create NewOy & NexOz, that couldn't 
  be stored as integers. NewOx modulus is then ||TopMod||*||FrontMod||.
  We divide the result by base vectors magnitudes in BDir formulas.
	
*/
	if (pBuffer->dwMode==DS3DMODE_NORMAL)
	{
		//OrientFront and OrientTop vectors magnitude
		fInX=pListener->vOrientFront.x*pListener->vOrientFront.x + pListener->vOrientFront.y*pListener->vOrientFront.y + pListener->vOrientFront.z*pListener->vOrientFront.z;
		dsSqrt();
		FrontMod= fOut;
		fInX=pListener->vOrientTop.x*pListener->vOrientTop.x + pListener->vOrientTop.y*pListener->vOrientTop.y + pListener->vOrientTop.z*pListener->vOrientTop.z;
		dsSqrt();
		TopMod= fOut;

		//New Ox vector = NewOy /\ NewOz
		NewOx.x=pListener->vOrientTop.z*pListener->vOrientFront.y-pListener->vOrientTop.y*pListener->vOrientFront.z;
		NewOx.y=pListener->vOrientTop.x*pListener->vOrientFront.z-pListener->vOrientTop.z*pListener->vOrientFront.x;
		NewOx.z=pListener->vOrientTop.y*pListener->vOrientFront.x-pListener->vOrientTop.x*pListener->vOrientFront.y;

		//Compute new coordinates (do normalize base vectors here)
		BDir.x=(NewOx.x*BPos.x+NewOx.y*BPos.y+NewOx.z*BPos.z)/(FrontMod*TopMod);
		BDir.y=(pListener->vOrientTop.x*BPos.x+pListener->vOrientTop.y*BPos.y+pListener->vOrientTop.z*BPos.z)/TopMod;
		BDir.z=(pListener->vOrientFront.x*BPos.x+pListener->vOrientFront.y*BPos.y+pListener->vOrientFront.z*BPos.z)/FrontMod;
	}

	if (pBuffer->dwMode!=DS3DMODE_DISABLE)
	{
		//Compute Buffer distance to listener
		fInX=BPos.x*BPos.x + BPos.y*BPos.y + BPos.z*BPos.z;
		dsSqrt();
		Distance=fOut; 
	}
	else
	{	//DS3DMODE_DISABLE
		Distance=0;
		pBufferSource->Doppler=1.0;
	}

	if (Distance==0)
		Volume=1.0;
	else
	{
		Alpha=0;
		fInX=BDir.x*BDir.x +  BDir.z*BDir.z;
		dsSqrt();
		Distxz=fOut; 

		//Compute source direction (Alpha range is -180/180)
		if (BDir.x>0)
		{
			fInX=BDir.z/Distxz;
			dsACos();
			Alpha= (float) (180/Pi*fOut);
		}
		if (BDir.x<0)
		{
			fInX=BDir.z/Distxz;
			dsACos();
			Alpha= (float) (-180/Pi*fOut);
		}
		if ((BDir.x==0)&&(BDir.z<0))
			Alpha=180.0;

		//Compute attenuation
		if (Distance<=pBuffer->flMinDistance)
			Rolloff=1;
		else
		{
			if (Distance>=pBuffer->flMaxDistance)
			{
				fInX=pBuffer->flMinDistance/pBuffer->flMaxDistance;
				fInY=pListener->flRolloffFactor;
				dsPow();
				Rolloff=fOut;
			}
			else
			{
				fInX=pBuffer->flMinDistance/Distance;
				fInY=pListener->flRolloffFactor;
				dsPow();
				Rolloff=fOut;
			}
		}

		//Compute angle between source cone axis and listener (Teta range is 0/180)
		BPosConeOrient=(BPos.x*pBuffer->vConeOrientation.x+BPos.y*pBuffer->vConeOrientation.y+BPos.z*pBuffer->vConeOrientation.z);
		fInX=pBuffer->vConeOrientation.x*pBuffer->vConeOrientation.x + pBuffer->vConeOrientation.y*pBuffer->vConeOrientation.y + pBuffer->vConeOrientation.z*pBuffer->vConeOrientation.z;
		dsSqrt();
		ConeOrientMod= fOut;
		if (Distance)
		{
			fInX=-BPosConeOrient/(ConeOrientMod*Distance);
			dsACos();
			Teta= (float) (180/Pi*fOut);
		}
		else
			Teta=0;
		
		if ((2*Teta)<=(float) pBuffer->dwInsideConeAngle)
			Cone=1;
		else
		{
				//Convert Cone outside volume into linear scale
			fInX=10.0;
			fInY=(float) (pBuffer->lConeOutsideVolume/2000);
			dsPow();
			OutVol=fOut;

			if ((2*Teta)>=(float) pBuffer->dwOutsideConeAngle)
				Cone=OutVol;
			else
				Cone=((2*Teta-pBuffer->dwInsideConeAngle)*OutVol+(pBuffer->dwOutsideConeAngle-2*Teta))/(pBuffer->dwOutsideConeAngle-pBuffer->dwInsideConeAngle);
		}
		
		Volume=Rolloff*Cone;
	}

	//Doppler effect
	RelVelocity.x=pListener->flDistanceFactor*(pBuffer->vVelocity.x-pListener->vVelocity.x);
	RelVelocity.y=pListener->flDistanceFactor*(pBuffer->vVelocity.y-pListener->vVelocity.y);
	RelVelocity.z=pListener->flDistanceFactor*(pBuffer->vVelocity.z-pListener->vVelocity.z);

	// compute the radial velocity
	if (Distance)
		// if distance >0, RadialVelocity=projection of V on List->Buff 
		RadialVelocity= ((RelVelocity.x*BPos.x + RelVelocity.y*BPos.y + RelVelocity.z*BPos.z)/Distance);
	else
	{
		//RadialVelocity=||v||
		fInX=RelVelocity.x*RelVelocity.x + RelVelocity.y*RelVelocity.y + RelVelocity.z*RelVelocity.z;
		dsSqrt();
		RadialVelocity=fOut; 
	}

	pBufferSource->Doppler=SoundSpeed/(SoundSpeed+RadialVelocity*pListener->flDopplerFactor);

//SECOND PART : 4 SPEAKERS VOLUMES COMPUTATION
	
	VolMaster=((PDSDRIVERBUFFER)(pBufferSource->pDriverContext->pPrimaryBuffer))->MainVol;
	VolSource=(WORD) (pBufferSource->MainVol); //(WORD) (pBufferSource->RVol + pBufferSource->LVol)/2;

	if (Distance>pBuffer->flMinDistance)
	{
		for (n=0; n<4; n++)
		{
			Phi[n]=Alpha+45-n*90;
			if (Phi[n]<-180)	//Phi must be within a -180/+180 range
				Phi[n]=Phi[n]+360;
		}
	
		for (n=0; n<4; n++)
			if ((Phi[n]<90) && (Phi[n]>-90))
			{
				if (Phi[n]>=0)
					fInX=(float) (1-Phi[n]/90.0);
				else
					fInX=(float) (1+Phi[n]/90.0);
				dsSqrt();
				V[n]=fOut;
			}
			else
				V[n]=0;

		ZTrans=(Distance-pBuffer->flMinDistance)/(4*pBuffer->flMinDistance);
		ZTrans=ZTrans*ZTrans;
		//Convert Cone outside volume into linear scale
		fInX=2.7182818;
		fInY=-ZTrans;
		dsPow();
		ZTrans=fOut;

		for (n=0; n<4; n++)
			Vol[n]=min(0xff,(WORD) FloatToLong(4*VolSource*Volume*(V[n]*(1-ZTrans)+ZTrans/4)));
	}
	else
	{
		for (n=0; n<4; n++)
			Vol[n]=VolSource*Volume;
	}

//SEND PARAMETER INTO SOUND BOARD
	
	VolFront=(DWORD) ((Vol[1]<<8)+Vol[0]);
	VolBack=(DWORD) ((Vol[2]<<8)+Vol[3]);
	SamPitch=(DWORD) FloatToLong(pBufferSource->Doppler*Pitch);
	
	if (SamPitch!=pBufferSource->SamPitch)
	{
		pBufferSource->SamPitch=SamPitch;
		modChangeParam(pBufferSource, 0x58, SamPitch);
	}
	
	if (VolMaster!=pBufferSource->VolMaster)
	{
		pBufferSource->VolMaster=VolMaster;
		modChangeParam(pBufferSource, 0x56, VolMaster);
	}

	if (VolFront!=pBufferSource->VFront)
	{
		pBufferSource->VFront=VolFront;
		modChangeParam(pBufferSource, 0x57, VolFront );
	}

	if (VolBack!=pBufferSource->VBack)
	{
		pBufferSource->VBack=VolBack;
		modChangeParam(pBufferSource, 0x59, VolBack);
	}

	return TRUE;
}

void AddBufferInList(PDSDRIVERBUFFER pBufferCtx)
{
	if (Buffer3DList)
	{	// the list isn't empty
		List3DTail->pNext=_HeapAllocate(sizeof(DS3DLIST), HEAPZEROINIT | HEAPSWAP); //new link
		List3DTail=List3DTail->pNext;
		List3DTail->pBuffer3D=pBufferCtx;			// pointer on 3D buffer
	}
	else
	{
		// the list is empty, create it
		Buffer3DList=_HeapAllocate(sizeof(DS3DLIST), HEAPZEROINIT | HEAPSWAP); //new link
		List3DTail=Buffer3DList;
		Buffer3DList->pBuffer3D=pBufferCtx;			// pointer on 3D buffer
	}

}

void RemoveBufferFromList(PDSDRIVERBUFFER pBufferCtx)
{
	PDS3DLIST Cur3DBuffer=Buffer3DList;
	PDS3DLIST Prev3DBuff=NULL;

	while (Cur3DBuffer) 
	{
		if (Cur3DBuffer->pBuffer3D==pBufferCtx)
		{		//remove this link
			if (List3DTail==Cur3DBuffer)
				List3DTail=Prev3DBuff;
			if (Prev3DBuff)
				Prev3DBuff->pNext=Cur3DBuffer->pNext;
			else
				Buffer3DList=Cur3DBuffer->pNext;
			_HeapFree(Cur3DBuffer,0);
			break;
		}
		Prev3DBuff=Cur3DBuffer;
		Cur3DBuffer=Cur3DBuffer->pNext;
	}
			


}


long FloatToLong(float fl)
{
	long ll;

	__asm
	{
		mov		edx, fl
		mov		ebx, edx
		shr		edx, 31			; sign
		and		ebx, 0x7fffffff
		shr		ebx, 23			; exposant + 7f
		mov		eax, fl
		and		eax, 0x007fffff	; significand
		or		eax, 0x00800000 ; real significand
		mov		ecx, 0x96		;  0x7f + 23
		sub		ecx, ebx		; 23 - exposant
		jge		ftlShift		; exposant<=23
		
		; exp>23
		imul	ecx, -1			; set ecx positive
		cmp		ecx, 7
		jl		ftlShiftl
		mov		ecx, 7			; clip at 2^31
	ftlShiftl:
		shl		eax, cl
		jmp		ftlSign

	ftlShift:
		cmp		cx, 32
		jb		ftlShiftr
		mov		eax, 0
		jmp		ftlExit
	ftlShiftr:
		shr		eax, cl
	ftlSign:
		test	edx, 1
		jz		ftlExit			; positive number
		imul	eax, -1
	ftlExit:
		mov		ll, eax
	}
	return ll;


}

const IDSDRIVERPROPERTYSETVTBL vtDsPropertySet = {
    IDsPropertySet_QueryInterface,
    IDsPropertySet_AddRef,
    IDsPropertySet_Release,
	IDsPropertySet_Get,
	IDsPropertySet_Set,
    IDsPropertySet_QuerySupport
};