/*==========================================================================;
 *
 *  Copyright (C) 1995,1996 Microsoft Corporation.  All Rights Reserved.
 *
 *  File:       dsdriver.h
 *  Content:    DirectSound driver include file
 *
 ***************************************************************************/

#ifndef __DSDRIVER_INCLUDED__
#define __DSDRIVER_INCLUDED__

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus


	/*
 * The requested COM interface is not available.  This value is the same
 *  as E_NOINTERFACE as defined in winerror.h in the Win32 SDK.
 */
//#define DSERR_NOINTERFACE               0x80004002L


//
// Structures
//

// Driver description
typedef struct _DSDRIVERDESC 
{
    DWORD       dwFlags;
    CHAR        szDesc[256];
    CHAR        szDrvname[256];
    DWORD       dnDevNode;
    WORD        wVxdId;
    WORD        wReserved;
    ULONG       ulDeviceNum;
    DWORD       dwHeapType;
    LPVOID      pvDirectDrawHeap;
    DWORD       dwMemStartAddress;
    DWORD       dwMemEndAddress;
    DWORD       dwMemAllocExtra;
    LPVOID      pvReserved1;
    LPVOID      pvReserved2;
} DSDRIVERDESC, *PDSDRIVERDESC;

#define DSDDESC_DOMMSYSTEMOPEN          0x00000001
#define DSDDESC_DOMMSYSTEMSETFORMAT     0x00000002
#define DSDDESC_USESYSTEMMEMORY         0x00000004
#define DSDDESC_DONTNEEDPRIMARYLOCK     0x00000008
#define DSDDESC_DONTNEEDSECONDARYLOCK   0x00000010

#define DSDHEAP_NOHEAP                  0x00000000
#define DSDHEAP_CREATEHEAP              0x00000001
#define DSDHEAP_USEDIRECTDRAWHEAP       0x00000002
#define DSDHEAP_PRIVATEHEAP             0x00000003

// Driver caps
typedef struct _DSDRIVERCAPS 
{
    DWORD       dwFlags;
    DWORD       dwMinSecondarySampleRate;
    DWORD       dwMaxSecondarySampleRate;
    DWORD       dwPrimaryBuffers;
    DWORD       dwMaxHwMixingAllBuffers;
    DWORD       dwMaxHwMixingStaticBuffers;
    DWORD       dwMaxHwMixingStreamingBuffers;
    DWORD       dwFreeHwMixingAllBuffers;
    DWORD       dwFreeHwMixingStaticBuffers;
    DWORD       dwFreeHwMixingStreamingBuffers;
    DWORD       dwMaxHw3DAllBuffers;
    DWORD       dwMaxHw3DStaticBuffers;
    DWORD       dwMaxHw3DStreamingBuffers;
    DWORD       dwFreeHw3DAllBuffers;
    DWORD       dwFreeHw3DStaticBuffers;
    DWORD       dwFreeHw3DStreamingBuffers;
    DWORD       dwTotalHwMemBytes;
    DWORD       dwFreeHwMemBytes;
    DWORD       dwMaxContigFreeHwMemBytes;
} DSDRIVERCAPS, *PDSDRIVERCAPS;

// Buffer volume and pan
typedef struct _DSVOLUMEPAN 
{
    DWORD       dwTotalLeftAmpFactor;
    DWORD       dwTotalRightAmpFactor;
    LONG        lVolume;
    DWORD       dwVolAmpFactor;
    LONG        lPan;
    DWORD       dwPanLeftAmpFactor;
    DWORD       dwPanRightAmpFactor;
} DSVOLUMEPAN, *PDSVOLUMEPAN;

// Property set identifier
typedef union _DSPROPERTY
{
    struct
    {
        GUID    Set;
        ULONG   Id;
        ULONG   Flags;
        ULONG   InstanceId;
    };
#if defined(_NTDDK_)
    ULONGLONG   Alignment;
#else // !_NTDDK_
    DWORDLONG   Alignment;
#endif // !_NTDDK_
} DSPROPERTY, *PDSPROPERTY;

//
// DirectSound driver interfaces
//

DEFINE_GUID(IID_IDsDriver, 0x8c4233c0l, 0xb4cc, 0x11ce, 0x92, 0x94, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(IID_IDsDriverBuffer, 0x8c4233c1l, 0xb4cc, 0x11ce, 0x92, 0x94, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00);
DEFINE_GUID(IID_IDsDriverPropertySet, 0xf6f2e8e0, 0xd842, 0x11d0, 0x8f, 0x75, 0x0, 0xc0, 0x4f, 0xc2, 0x8a, 0xca);

//  IDsDriverBuffer
typedef struct _IDSDRIVERBUFFER 
{
    struct _IDSDRIVERBUFFERVTBL *lpVtbl;
} IDSDRIVERBUFFER, *PIDSDRIVERBUFFER;

typedef struct _IDSDRIVERBUFFERVTBL 
{
    // IUnknown
    HRESULT (__stdcall *QueryInterface) (PIDSDRIVERBUFFER, REFIID, LPVOID *);
    ULONG   (__stdcall *AddRef)         (PIDSDRIVERBUFFER);
    ULONG   (__stdcall *Release)        (PIDSDRIVERBUFFER);

    // IDsDriverBuffer
    HRESULT (__stdcall *Lock)           (PIDSDRIVERBUFFER, LPVOID *, LPDWORD, LPVOID *, LPDWORD, DWORD, DWORD, DWORD);
    HRESULT (__stdcall *Unlock)         (PIDSDRIVERBUFFER, LPVOID, DWORD, LPVOID, DWORD);
    HRESULT (__stdcall *SetFormat)      (PIDSDRIVERBUFFER, LPWAVEFORMATEX);
    HRESULT (__stdcall *SetFrequency)   (PIDSDRIVERBUFFER, DWORD);
    HRESULT (__stdcall *SetVolumePan)   (PIDSDRIVERBUFFER, PDSVOLUMEPAN);
    HRESULT (__stdcall *SetPosition)    (PIDSDRIVERBUFFER, DWORD);
    HRESULT (__stdcall *GetPosition)    (PIDSDRIVERBUFFER, LPDWORD, LPDWORD);
    HRESULT (__stdcall *Play)           (PIDSDRIVERBUFFER, DWORD, DWORD, DWORD);
    HRESULT (__stdcall *Stop)           (PIDSDRIVERBUFFER);
} IDSDRIVERBUFFERVTBL, PIDSDRIVERBUFFERVTBL;

//  IDsDriver
typedef struct _IDSDRIVER 
{
    struct _IDSDRIVERVTBL *lpVtbl;
} IDSDRIVER, *PIDSDRIVER;

typedef struct _IDSDRIVERVTBL 
{
    // IUnknown
    HRESULT (__stdcall *QueryInterface)         (PIDSDRIVER, REFIID, LPVOID *);
    ULONG   (__stdcall *AddRef)                 (PIDSDRIVER);
    ULONG   (__stdcall *Release)                (PIDSDRIVER);

    // IDsDriver
    HRESULT (__stdcall *GetDriverDesc)          (PIDSDRIVER, PDSDRIVERDESC);
    HRESULT (__stdcall *Open)                   (PIDSDRIVER);
    HRESULT (__stdcall *Close)                  (PIDSDRIVER);
    HRESULT (__stdcall *GetCaps)                (PIDSDRIVER, PDSDRIVERCAPS);
    HRESULT (__stdcall *CreateSoundBuffer)      (PIDSDRIVER, LPWAVEFORMATEX, DWORD, DWORD, LPDWORD, LPBYTE *, LPVOID *);
    HRESULT (__stdcall *DuplicateSoundBuffer)   (PIDSDRIVER, PIDSDRIVERBUFFER, LPVOID *);
} IDSDRIVERVTBL, *PIDSDRIVERVTBL;

//  IDsDriverPropertySet
typedef struct _IDSDRIVERPROPERTYSET 
{
    struct _IDSDRIVERPROPERTYSETVTBL *lpVtbl;
} IDSDRIVERPROPERTYSET, *PIDSDRIVERPROPERTYSET;

typedef struct _IDSDRIVERPROPERTYSETVTBL 
{
    // IUnknown
    HRESULT (__stdcall *QueryInterface)         (PIDSDRIVERPROPERTYSET, REFIID, LPVOID *);
    ULONG   (__stdcall *AddRef)                 (PIDSDRIVERPROPERTYSET);
    ULONG   (__stdcall *Release)                (PIDSDRIVERPROPERTYSET);

    // IDsDriverPropertySet
    HRESULT (__stdcall *Get)                    (PIDSDRIVERPROPERTYSET, PDSPROPERTY, LPVOID, ULONG, LPVOID, ULONG, PULONG);
    HRESULT (__stdcall *Set)                    (PIDSDRIVERPROPERTYSET, PDSPROPERTY, LPVOID, ULONG, LPVOID, ULONG);
    HRESULT (__stdcall *QuerySupport)           (PIDSDRIVERPROPERTYSET, REFGUID, ULONG, PULONG);
} IDSDRIVERPROPERTYSETVTBL, *PIDSDRIVERPROPERTYSETVTBL;

//
// Property sets
//

// 3D Listener property set {6D047B40-7AF9-11d0-9294-444553540000}
DEFINE_GUID(DSPROPSETID_DirectSound3DListener, 0x6d047b40, 0x7af9, 0x11d0, 0x92, 0x94, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0);

typedef enum 
{
    DSPROPERTY_DIRECTSOUND3DLISTENER_ALL,
    DSPROPERTY_DIRECTSOUND3DLISTENER_POSITION,
    DSPROPERTY_DIRECTSOUND3DLISTENER_VELOCITY,
    DSPROPERTY_DIRECTSOUND3DLISTENER_ORIENTATION,
    DSPROPERTY_DIRECTSOUND3DLISTENER_DISTANCEFACTOR,
    DSPROPERTY_DIRECTSOUND3DLISTENER_ROLLOFFFACTOR,
    DSPROPERTY_DIRECTSOUND3DLISTENER_DOPPLERFACTOR,
    DSPROPERTY_DIRECTSOUND3DLISTENER_BATCH,
    DSPROPERTY_DIRECTSOUND3DLISTENER_ALLOCATION
} DSPROPERTY_DIRECTSOUND3DLISTENER;

// 3D Buffer property set {6D047B41-7AF9-11d0-9294-444553540000}
DEFINE_GUID(DSPROPSETID_DirectSound3DBuffer, 0x6d047b41, 0x7af9, 0x11d0, 0x92, 0x94, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0);

typedef enum 
{
    DSPROPERTY_DIRECTSOUND3DBUFFER_ALL,
    DSPROPERTY_DIRECTSOUND3DBUFFER_POSITION,
    DSPROPERTY_DIRECTSOUND3DBUFFER_VELOCITY,
    DSPROPERTY_DIRECTSOUND3DBUFFER_CONEANGLES,
    DSPROPERTY_DIRECTSOUND3DBUFFER_CONEORIENTATION,
    DSPROPERTY_DIRECTSOUND3DBUFFER_CONEOUTSIDEVOLUME,
    DSPROPERTY_DIRECTSOUND3DBUFFER_MINDISTANCE,
    DSPROPERTY_DIRECTSOUND3DBUFFER_MAXDISTANCE,
    DSPROPERTY_DIRECTSOUND3DBUFFER_MODE
} DSPROPERTY_DIRECTSOUND3DBUFFER;

// Speaker configuration property set {6D047B42-7AF9-11d0-9294-444553540000}
DEFINE_GUID(DSPROPSETID_DirectSoundSpeakerConfig, 0x6d047b42, 0x7af9, 0x11d0, 0x92, 0x94, 0x44, 0x45, 0x53, 0x54, 0x0, 0x0);

typedef enum 
{
    DSPROPERTY_DIRECTSOUNDSPEAKERCONFIG_SPEAKERCONFIG
} DSPROPERTY_DIRECTSOUNDSPEAKERCONFIG;

//
//  Driver registration
//

// Device id registered to DSOUND.VXD
#define DSOUND_DEVICE_ID    0x357E

#if !defined(Not_VxD) && !defined(NODSOUNDSERVICETABLE)

Begin_Service_Table (DSOUND, VxD)
 Declare_Service (_DSOUND_GetVersion, LOCAL)
 Declare_Service (_DSOUND_RegisterDeviceDriver, VxD_CODE)
 Declare_Service (_DSOUND_DeregisterDeviceDriver, VxD_CODE)
 Declare_Service (_DSOUND_DD_IOCTL, VxD_LOCKED_CODE)
End_Service_Table (DSOUND, VxD)

#ifndef NODSOUNDWRAPS

DWORD __inline DSOUND_GetVersion(void)
{
    DWORD dwVersion;
    Touch_Register(eax)
    VxDCall(_DSOUND_GetVersion);
    _asm mov dwVersion, eax
    return dwVersion;
}

HRESULT __inline DSOUND_RegisterDeviceDriver(PIDSDRIVER pIDsDriver, DWORD dwFlags)
{
    HRESULT dsv;
    Touch_Register(eax)
    Touch_Register(ecx)
    Touch_Register(edx)
    _asm push dwFlags;
    _asm push pIDsDriver;
    VxDCall(_DSOUND_RegisterDeviceDriver);
    _asm add esp, 8;
    _asm mov dsv, eax;
    return dsv;
}

HRESULT __inline DSOUND_DeregisterDeviceDriver(PIDSDRIVER pIDsDriver, DWORD dwFlags)
{
    HRESULT dsv;
    Touch_Register(eax)
    Touch_Register(ecx)
    Touch_Register(edx)
    _asm push dwFlags;
    _asm push pIDsDriver;
    VxDCall(_DSOUND_DeregisterDeviceDriver);
    _asm add esp, 8;
    _asm mov dsv, eax;
    return dsv;
}

#endif // NODSOUNDWRAPS

#endif // !defined(Not_VxD) && !defined(NODSOUNDSERVICETABLE)

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __DSDRIVER_INCLUDED__
