//---------------------------------------------------------------------------
//
//  Module:   cnfgmgr.c
//
//  Description:
//     Config manager notification handler
//
//---------------------------------------------------------------------------
//
//  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
//  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
//  PURPOSE.
//
//  Copyright (c) 1994 - 1995 Microsoft Corporation.	All Rights Reserved.
//
//---------------------------------------------------------------------------

#define  WANTVXDWRAPS

//#define  DEBUG

#include <basedef.h>
#include <vmm.h>
#include <vmmreg.h>
#include <vxdwraps.h>
#include <configmg.h>
#include <vmmreg.h>
#include <debug.h>
#include <vmm.h>

#include "cnfgmgr.h"
#include "dos_xfer.h"
               
#undef CURSEG               
#define  CURSEG()                   PCODE

#define  CM_Get_Alloc_Log_Conf      PREPEND(_CONFIGMG_Get_Alloc_Log_Conf)
#define  CM_Run_Detection           PREPEND(_CONFIGMG_Run_Detection)

#ifdef  DEBUG
#define DPF(x) Out_Debug_String(x)
#else
#define DPF(x)
#endif

#pragma VxD_PAGEABLE_CODE_SEG
#pragma VxD_PAGEABLE_DATA_SEG

WORD DrvOwn=0;


int BlockNb=64;                // number of block in MMT


WORD buffer[0x1000]; 		// allocate a 4K WORD buffer
int NBlocks,NInTable;
int NInBlTable=0;
WORD gwBaseMPU401=0;

BANKCAPS BkCaps;		// structure for bankGetCaps

// Variables for registryRead
char FirmName[256], SoundName[256];

DWORD InitTime;

//  PnP Crystal
BYTE pnpCrystal[]={	0x96,0x35,0x9a,0xcd,0xe6,0xf3,0x79,0xbc,
					0x5e,0xaf,0x57,0x2b,0x15,0x8a,0xc5,0xe2,
					0xf1,0xf8,0x7c,0x3e,0x9f,0x4f,0x27,0x13,
					0x09,0x84,0x42,0xa1,0xd0,0x68,0x34,0x1A,
					0x06,0x01,0x15,0x04,0x47};
// Debugger program
WORD BOOT[]={
	0xD0CE, 0x0111, 0xD0CE, 0x01D5, 0x0001, 0x0003, 0x0004, 0x0006, 
	0x0001, 0x0003, 0x0002, 0x0002, 0x0006, 0x0002, 0x0001, 0x0006, 
	0x0006, 0x7A0C, 0xE628, 0x0001, 0xD448, 0x1010, 0xC4CB, 0xD1CB, 
	0xE2FE, 0x4F01, 0xE3FC, 0x4E0D, 0xE0FA, 0x4700, 0x8407, 0xD148, 
	0x0104, 0x9107, 0x7A08, 0x7A09, 0xC590, 0xD1CB, 0xE2FE, 0x4F01, 
	0xE3EE, 0xC74D, 0x6DFA, 0xD44A, 0x012E, 0xC449, 0x7816, 0x7819, 
	0x7821, 0x781D, 0x782E, 0x7830, 0x7835, 0x783A, 0x783F, 0x7849, 
	0x784C, 0x786E, 0x786D, 0x7914, 0x01F8, 0x7A10, 0x7A11, 0x7915, 
	0x0000, 0x7913, 0x0007, 0x7A12, 0xD1CA, 0xC44F, 0xC4C4, 0xD0CE, 
	0x01CB, 0xC64F, 0xC54F, 0xC44F, 0xCB4C, 0xD5C4, 0x78C4, 0xC64F, 
	0xC74F, 0xCF4C, 0xC64F, 0xC54F, 0xCB4C, 0x3D09, 0xC64F, 0xC54F, 
	0xCB4C, 0x3D08, 0xD449, 0x0130, 0xE302, 0xC480, 0x786C, 0xCF80, 
	0x78B2, 0xC04F, 0xC4C9, 0x7867, 0xC64F, 0xC54F, 0xCB4C, 0xC04F, 
	0xC5CB, 0x78A9, 0xC54F, 0xC44F, 0xC94A, 0xD1CE, 0x8405, 0x785B, 
	0xC54F, 0xC44F, 0xC94A, 0xD1CE, 0x8406, 0x7855, 0xC74F, 0xC64F, 
	0xCD4E, 0xC74F, 0xC54F, 0xCB4E, 0xC74F, 0xC44F, 0xC94E, 0xD1CF, 
	0x7892, 0xC64F, 0xC54F, 0xCB4C, 0xC549, 0xC04F, 0x0001, 0x0400, 
	0xC4CB, 0x0115, 0x0406, 0xC04F, 0xD0C1, 0x7D01, 0x6CFC, 0xD0CA, 
	0x8418, 0x0001, 0xC4CB, 0xD1C9, 0x0001, 0x840C, 0xE901, 0x0000, 
	0x7803, 0xE911, 0xD048, 0xFFFF, 0x7B00, 0xE920, 0xD1C8, 0xC04F, 
	0xC14F, 0xC24F, 0xC34F, 0xC44F, 0xC54F, 0xC64F, 0xC74F, 0xD1CA, 
	0x8704, 0x0001, 0x0410, 0xC4CB, 0xC54F, 0xC44F, 0xC94A, 0x3C0D, 
	0xC54F, 0xC44F, 0xC94A, 0x3C0F, 0xC54F, 0xC44F, 0xC94A, 0x3C0E, 
	0x0001, 0xD448, 0x2010, 0xD548, 0x3010, 0xD749, 0x013A, 0xE304, 
	0xD448, 0x1010, 0xD548, 0x1010, 0xC4CB, 0xC5CB, 0x0006, 0xC4CB, 
	0x7B0D, 0xE3FE, 0x78B5, 0x0006, 0xC4CB, 0x0001, 0xC5C9, 0x3510, 
	0xE2FD, 0xCA49, 0x0006, 0xC5CB, 0x78AB, 0xC74D, 0xC64D, 0xC54D, 
	0xC44D, 0xC34D, 0xC24D, 0xC14D, 0xC04D, 0x7A05, 0x840C, 0x4100, 
	0xE101, 0x4104, 0xE301, 0x4201, 0xE501, 0x4302, 0xD94A, 0xD94B, 
	0x3C0C, 0x0001, 0x0400, 0xC4CB, 0xD0C8, 0x0110, 0x0406, 0xC0C1, 
	0xC04D, 0x7C01, 0x6CFC, 0xD0CF, 0x013B, 0xD448, 0x55AA, 0x78D3,
	0,0,0,0,0,0,0,0};


extern void dsInitializeDriver( DEVNODE dn );

DWORD RMID_Offset=0;

//--------------------------------------------------------------------------
//  
//  CONFIGRET DREAM_Config_Handler
//  
//  Description:
//  
//  
//  Parameters:
//      CONFIGFUNC cfFuncName
//  
//      SUBCONFIGFUNC scfSubFuncName
//  
//      DEVNODE dn
//  
//      DWORD dwRefData
//  
//      ULONG ulFlags
//  
//  Return (CONFIGRET):
//--------------------------------------------------------------------------

CONFIGRET DREAM_Config_Handler
(
    CONFIGFUNC      cfFuncName,
    SUBCONFIGFUNC   scfSubFuncName,
    DEVNODE         dn,
    DWORD           dwRefData,
    ULONG           ulFlags
)
{

	WORD DreamCard;
	DWORD hFirm,hSound;
    CONFIGRET   cr ;
    WORD        wBaseMPU401 ;
    WORD        wIRQ ;
	int n;

   //
   // Switch the function (aka command)
   //

   DPF( "DREAM: Config_Handler\r\n" ) ;

   switch (cfFuncName)
   {

      case CONFIG_FILTER:
         //
         // This command is sent to the devnode and all it's parents
         // to give them a chance to delete logical configurations
         // from the filtered configuration list.  A parent would
         // remove a configuration from the filtered list if it cannot
         // provide that configuration.
         //
		   DPF( "CONFIG_FILTER\r\n" ) ;
         return CR_SUCCESS ;
    
      case CONFIG_START:
      {
         //
         // This command is sent to instruct the driver that
         // it can start using the resources that have been
         // allocated to it.   This is the meat of this
         // DriverConfigMan.
         //
         // We get our resource allocation by calling the
         // configuration manager (CM) using the devnode that
         // was passed to us.
         //
         // If all has gone well, we should not have been given
         // a resource allocation that we can't use.   Ideally
         // this command should always succeed.  However, every
         // now and then life throws you a curve ball, so we
         // should still verify that we are happy with the
         // resources we have been given.
         //
         // If we receive multiple _STARTs for multiple devodes,
         // then there are multiple taget devices for us to drive.
         // How we handle this is highly dependent upon the driver.
         // This particular driver can only drive one target device.
         //


         //
         // Get our resource allocation from CM.  if
         // this fails, we have no choice but to fail
         // the CONFIG_START.  We'll return the same
         // error that the CM_Get_Alloc_Config returned.
         //
	
	char SubKey[]="System\\CurrentControlSet\\Control\\MediaResources\\Dream\\Debug";
	DWORD hdKey, dwSize=0;
	long	ll;

	ll=_RegDeleteKey(HKEY_LOCAL_MACHINE,SubKey);

	ll=_RegCreateKey(HKEY_LOCAL_MACHINE,SubKey,&hdKey);
	ll=_RegCloseKey(hdKey);

	Trace_Out("---- PnP config handler,  Time initialization------");
	InitTime=GetTime();
	Trace_Out("-- get ressources");

         if (!ressource(dn,&wBaseMPU401,&wIRQ))
		 {
			 registryDebug("VxDerr","no ressource");
			 return CR_FAILURE;
		 }

			
         //
         // OK, now do whatever else is necessary to put this
         // configuration into effect.
         //
	Trace_Out("-- read registry");
			
		registryRead();		//FirmName,SoundName);

		//registryRead(&hFirm,&hSound);
		

		DreamCard=TRUE;

		WriteP16(wBaseMPU401,0xff,1);	//reset
		Trace_Out(" Reset");
		n=0;  
		while ((MPU401_Command_Read(wBaseMPU401)>0x1000) && (n<3)) 
		{				// wait acknowledge
			n++;
		}


		Trace_Out("-- UART?");
		if (switchUART(wBaseMPU401))
		{
			Trace_Out("-- GenINT?");
			if (!genINT(wBaseMPU401))
			{
			 registryDebug("VxDtype","MPU401");		//MPU401
			 Trace_Out("-- MPU401");
			 DreamCard=FALSE;
			 goto CardInitialized;
			}
			else  
			{
			 registryDebug("VxDtype","PC1M");			//PC1M no boot ROM firmware
			 Trace_Out("-- 94PC1M"); 
			 }
		}
		else
		{
			
			Trace_Out("-- load BOOT");
			loadBoot(wBaseMPU401);
			Trace_Out("-- UART?");
			if (switchUART(wBaseMPU401))
			{
				registryDebug("VxDtype","PC2M");			//PC2M boot ROM firmware
				Trace_Out("-- 94PC2M");
			}
			else
			{
				Trace_Out("-- load Firmware");
				hFirm=cOpen((DWORD) FirmName,0);
				if (!hFirm)
				{
					Trace_Out("error in loading firmware");
					registryDebug("VxDerr","no FW File");	//Dream no GenINT
					return CR_FAILURE;
				}
				if (!LoadFirmware(hFirm,wBaseMPU401)) 
				{
					Trace_Out("error in loading firmware");
					 DreamCard=FALSE;   
				}
				cClose(hFirm);

				Trace_Out("-- UART?");
				if (switchUART(wBaseMPU401))
				{
					registryDebug("VxDtype","PnP");	//PnP/SIMM RAM firmware
					Trace_Out("-- 94PnP");
				}
				else
				{
					registryDebug("VxDerr","no UART");	//Dream no UART
					Trace_Out("no UART");
					return CR_FAILURE;
				}
			}
		}
		Trace_Out("-- GenINT?");
		if (!genINT(wBaseMPU401))
		{
			Trace_Out("Gen INT");
			registryDebug("VxDerr","no GenINT");	//Dream no GenINT
			return CR_FAILURE;
		}
		if (!soundbankMMT(wBaseMPU401))
		{
			Trace_Out("load SoundBANK");
			hSound=cOpen((DWORD) SoundName,0); 
			if (!hSound)
			{
				Trace_Out("error in loading sb");
				registryDebug("VxDerr","no SB File");	//Dream no GenINT
				return CR_FAILURE;
			}
			if (SendNewSoundBank(hSound,wBaseMPU401)>8)  // send sound bank 
			{
					Trace_Out("error in loading sb");
					 DreamCard=FALSE;   
			}  		
			cClose(hSound);
		}

//		return TRUE;
          
         if (DreamCard)
		{
			if (gwBaseMPU401!=0)
				Trace_Out("Pb : DreamCard detected twice !!!!");
			gwBaseMPU401=wBaseMPU401;
		}
CardInitialized:
         cr = DREAM_Set_Config( dn, wBaseMPU401, wIRQ ,DreamCard);
		
		 if(CR_SUCCESS == cr) 
		 {
			 dsInitializeDriver( dn );
			 registryDebug("VxDerr","No error");
		 }
		 else
			 registryDebug("VxDerr","Hw Configuration doesn't match");			//PC2M boot ROM firmware

		 TimeDebug();
		 return cr ;
      }

      case CONFIG_TEST:
       
         //
         // This command is sent to query the driver whether it can
         // change configuration, stop using the resources, or
         // handle a remove.  The query is specified by the sub func.
         //
		   DPF( "CONFIG_TEST\r\n" ) ;

         switch (scfSubFuncName)
         {
            case CONFIG_TEST_CAN_STOP:

               //
               // This command asks: Can we stop
               // using our resources?  If we're making noise,
               // we'd rather not stop.
               //

               return (DREAM_IsOwned( dn ) ? CR_FAILURE : CR_SUCCESS) ;

            case CONFIG_TEST_CAN_REMOVE:

               //
               // This command asks: Is it OK for CM to remove
               // the devnode?  This implies that the associated
               // device is also going to disappear (or has
               // already disappeared).
               //
          
               return (DREAM_IsOwned( dn ) ? CR_FAILURE : CR_SUCCESS) ;

            default:
               return CR_DEFAULT ;
         }

      case CONFIG_REMOVE:

         //
         // This command is sent to a devnode and all it's parents when
         // when the devnode is being removed from the hardware tree.
         // Deallocate any per devnode instance data and take whatever
         // other measures are necessary to stop using that devnode and
         // the associated hardware.   The command is essentially saying
         // that the hardware no longer exists in the system.
         //
		   DPF( "CONFIG_REMOVE\r\n" ) ;

         // ... fall-through ...

      case CONFIG_STOP:

         //
         // This command indicates that we should stop
         // using the resources that were allocated to us.
         //
		   DPF( "CONFIG_STOP\r\n" ) ;

         DREAM_Remove_Config( dn ) ;
         return CR_SUCCESS ;

      default:
         return CR_DEFAULT ;
   }

} // DREAM_Config_Handler()
 


//*********************************************************************
//
//	switchUART
//
//	switch in stand alone then in uart mode
//
//*********************************************************************
BOOL switchUART(WORD wBaseMPU401)
{
	long	n;
	DWORD read;
    
    __asm
    {  
    	mov	dx, wBaseMPU401
    	mov	ecx, 1000 
    aread:
    	inc	dx
    	in al, dx
    	test al, 0x80
    	jnz	aexit
    	dec	dx
    	in	al, dx
    	loop aread
    aexit:
    	nop
    }
    
	WriteP16(wBaseMPU401,UART_MOD,1); // Uart mode
	n=0;  
	while (((read=MPU401_Command_Read(wBaseMPU401))!=0xfe) && (n<3)) 
	{
		if (MPU401_Command_Read(wBaseMPU401)>0x1000)
			n++;				// wait acknowledge
	}
	if (read==0xfe)
		return TRUE;
	else
		return FALSE;
}
//*********************************************************************
//
//	genINT
//
//	gen INT dream card ?
//
//*********************************************************************
BOOL genINT(WORD wBaseMPU401)
{
	long	n;
	DWORD read;
	
	WriteP16(wBaseMPU401,GEN_INT,1); // GenINT
	WriteP16(wBaseMPU401,0,0);		// data 0
	n=0;  
	while (((read=MPU401_Command_Read(wBaseMPU401))>0x1000) && (n<3)) 
		n++;				// wait acknowledge
	if (read==0x88)
		return TRUE;
	else
		return FALSE;
}


//*********************************************************************
//
//	ressource
//
//	get ressource from Config Manager
//
//*********************************************************************
BOOL ressource(DEVNODE dn,WORD *pBaseMPU401,WORD *pIRQ)
{
         CMCONFIG    ccb ;
         CONFIGRET   cr ;
	
	if (CR_SUCCESS != 
		(cr = CM_Get_Alloc_Log_Conf( &ccb, dn, 0 )))
		return FALSE ;

         //
         // Extract the information of interest from the config buffer
         // that we got from CM_Get_Alloc_Config.
         //

         *pBaseMPU401 = (WORD) -1 ;

         if (ccb.wNumIOPorts != 1)
         {
            DPF( "DREAM: Invalid config.\r\n" ) ;
            return FALSE ;
         }
                                 
         *pBaseMPU401 = ccb.wIOPortBase[ 0 ] ;

         if (ccb.wNumIRQs)
            *pIRQ = ccb.bIRQRegisters[ 0 ] ;
         else
            *pIRQ = (WORD) -1 ;

         if (-1 == *pBaseMPU401)
            return FALSE ;
	return TRUE;

}
 
//*********************************************************************
//
//	registryRead
//
//	read firmware & sound bank names in registry
//
//*********************************************************************
void registryRead()
{
	DWORD hkey;
	int n;
	long ll; 
	char tbuffer[100];
	DWORD BuffSize=100;
	VALENT ValEnt[2];
	char SubKey[]="System\\CurrentControlSet\\Control\\MediaResources\\Dream";
	char Fname[]="Firmware",Sname[]="Sound";

	// open the Dream key
	ll=_RegOpenKey(HKEY_LOCAL_MACHINE,SubKey,&hkey);
	Trace_Out("Open Key");
	// read config in registry
	ValEnt[0].ve_valuename=Fname;
	ValEnt[1].ve_valuename=Sname;
	
	ll=_RegQueryMultipleValues(hkey,ValEnt,2,tbuffer,&BuffSize);
	
	//copy the strings to return
	n=0;
	do
	{
		SoundName[n]=((char *) ValEnt[1].ve_valueptr)[n];
		n++;
	}
	while ((SoundName[n-1]!=0) && (n<256));

	n=0;
	do
	{
		FirmName[n]=((char *) ValEnt[0].ve_valueptr)[n];
		n++;
	}
	while ((FirmName[n-1]!=0) && (n<256));
	
	ll=_RegCloseKey(hkey);
	
}

//*********************************************************************
//
//	registryDebug
//
//	put debug message in registry
//
//*********************************************************************
void registryDebug(CHAR cType[], CHAR cMes[])
{
	char SubKey[]="System\\CurrentControlSet\\Control\\MediaResources\\Dream\\Debug";
	long ll; 
	DWORD hdKey, dwSize=0;

	Trace_Out("registry debug");

/*	ll=_RegDeleteKey(HKEY_LOCAL_MACHINE,SubKey);

	ll=_RegCreateKey(HKEY_LOCAL_MACHINE,SubKey,&hdKey);*/
	ll=_RegOpenKey(HKEY_LOCAL_MACHINE,SubKey,&hdKey);
	
	for (dwSize=0; cMes[dwSize];dwSize++);  //compute the size of cMes

	ll=_RegSetValueEx(hdKey,cType,NULL,REG_SZ,cMes,(DWORD) (dwSize));

	ll=_RegCloseKey(hdKey);

}

//*********************************************************************
//
//	TimeDebug
//
//	put debug message in registry
//
//*********************************************************************
void TimeDebug()
{
	char SubKeyDbg[]="System\\CurrentControlSet\\Control\\MediaResources\\Dream\\Debug";
	DWORD ll, t; 
	DWORD hdKey, size=16;

	Trace_Out("Time");

	t=GetTime()-InitTime;

	ll=_RegOpenKey(HKEY_LOCAL_MACHINE,SubKeyDbg,&hdKey);
	if (!ll)
	{
		_RegSetValueEx(hdKey,"Time",NULL,REG_BINARY,&t,4);
		_RegCloseKey(hdKey);
	}

}


//*********************************************************************
//
//	loadBoot
//
//	load bootstrap 256word
//
//*********************************************************************
void loadBoot(WORD wBaseMPU401)
{
	long	n;
	WORD	byteCod;
	
	for (n=0; n<256;n++)
	{
		byteCod=BOOT[n];
		__asm
		{
			mov dx, wBaseMPU401
			add dx, 2
			mov	ax, byteCod
			out	dx, ax
		}
	}

// Wait for 94PC2M to be ready
TempoInit(wBaseMPU401);	// wait 200 ms  

}


void TempoInit(WORD wBaseMPU401)
{
	// WAIT 200 ms
	_asm
	{  
	mov		ecx,20000h
	mov		dx, wBaseMPU401
	add		dx, 1
	delay:
		in		al,dx  
	loop delay 
	}  
}

//*********************************************************************
//
//	soundbankMMT
//
//	check if there is already a sound bank in MMT (TRUE if sb found)
//
//*********************************************************************
BOOL soundbankMMT(WORD wBaseMPU401)
{       
int n;
MemBlDefTyp MemoryBlock[64];
SndBkDefTyp SndBkDef[8]; 

if (!GetMemoryMapping(wBaseMPU401,MemoryBlock,SndBkDef))
{
	Trace_Out("error in get MMT");	
	return FALSE;
}
n=1;
while (((MemoryBlock[n].Type & 0x7f)!=0x10) && (n<BlockNb))
	n++;
if ( (MemoryBlock[n].Type & 0x7f)==0x10)   // Sound Parameter
{
	Trace_Out("sound bank detected");
	return TRUE;                    
}
Trace_Out("no sb detected");
return FALSE;
}           


//*********************************************************************
//
//	BOOL LoadFirmware(DWORD hFirm,WORD wBaseMPU401)
//
//	Initialize the board. 
//	Load the firware program,and run it (UART mode when function exiting)
//
//*********************************************************************
BOOL LoadFirmware(DWORD hFirm, WORD wBaseMPU401)
{       
DWORD read, dwBuffer;
long n, dwLength, lRemain;

dwBuffer=(DWORD) buffer;
	
	if ((dwLength=(long) cSeek(hFirm, 0, 2))==0xffffffff)
	{
		Trace_Out("error in cseek");
	}
	dwLength=dwLength/2-0x200;     // file size in words
	
	cSeek(hFirm, 0x400, 0);    // skip first 0x200 word
	// init dma xfer    
	WriteP16(wBaseMPU401,0xb,1);        // command xfer pc->sam
	WriteP16(wBaseMPU401,00,1);        // address=0x200
	WriteP16(wBaseMPU401,02,1); 
	WriteP16(wBaseMPU401,00,1);        // page=0
	WriteP16(wBaseMPU401,00,1);
	WriteP16(wBaseMPU401,(BYTE) (dwLength & 0xff),1);	// count=length
	WriteP16(wBaseMPU401,(BYTE) ((dwLength>>8) & 0xff),1);  
	// wait acknowledge
	n=0;
	while ((n<4) && ((read=MPU401_Command_Read(wBaseMPU401))>0x1000)) 
		n++; 
	if (read>0x1000) 
		{
		Trace_Out("no card?");
		return FALSE;
		}
	// load gm94 by 16K pack;
	for (n=0; n<(int) (dwLength/0x1000); n++)
		{
		if (!cRead(hFirm,(DWORD) buffer,0x2000))
			{
				//error
				Trace_Out("error in cRead->0");
				return FALSE;
			}
		__asm 
			{
				mov dx, wBaseMPU401
				add	dx, 2
				mov	esi, dwBuffer
				mov	ecx, 0x1000
			rep outsw
			}
		}  
	lRemain=(dwLength%0x1000);
	if (!cRead(hFirm,(DWORD) buffer,lRemain*2))
		{
			//error
			Trace_Out("error in cRead->0");
			return FALSE;
		}
	__asm 
		{
			mov dx, wBaseMPU401
			add	dx, 2
			mov	esi, dwBuffer
			mov	ecx, lRemain
		rep outsw
		}
	// The gm94 is now loaded, let's run it  
	WriteP16(wBaseMPU401,9,1);   // command go
	WriteP16(wBaseMPU401,0x00,1);    
	WriteP16(wBaseMPU401,0x02,1);  
	
	// The gm is now running. Wait a little to be sure
	
	for (n=0; n<8; n++)
		TempoInit(wBaseMPU401);	// wait 200 ms  

	              
return TRUE;
} 

/****************************************************************************

     GetMemMapAddress 
    Return 32 bit Address of the Memory Mapping Table
    (FFFFFFFF if failed)

****************************************************************************/  
DWORD  GetMemMapAddress(WORD wBaseMPU401)
{
DWORD gadd=0;
int n; 
BYTE err=0;
DWORD read;

__asm cli
WriteP16(wBaseMPU401,GET_MMT,1);
WriteP16(wBaseMPU401,0,0);

// Now, wait for the answer 
for (n=0; n<4; n++)
	{  
	Trace_Out(" mpu com read");
	if ((read=MPU401_Command_Read(wBaseMPU401))>0x1000)  
	{
		__asm sti;
		return 0xffffffff; 
	}
	gadd+=((read & 0xff) << (8*n));
	}
__asm sti	
return gadd;
}

/****************************************************************************

    API dream - DownLoad 
    Transfert a memory bloc from Pc memory to dream card
    lpSrc	:	Pointer to memory bloc to transfer
    wDestOffset 	: offset of destination
    wDestPage	: destination page
    wCount	 	: nb of word to copy
    
    Return : 0 if successfull
    		 1 if fail wCount>32kWords  or page number too high
    		 2	other errors
****************************************************************************/
WORD DownLoad(WORD wBaseMpu,void *lpSrc,WORD wDestPage,WORD wDestOffset,WORD wCount) 
{              
WORD *point,ww;

if (wCount>0x8000)  						// wCount>32Kwords  error
	{
	return 1;             
	}
//if ((wDestOffset!=0) && (wDestOffset+(wCount-1) < wCount))      // last address in the next page
if ((wDestOffset!=0) && (wDestOffset+(wCount-1) >0xffff))      // last address in the next page

	{	
	if (!MemCopySrc(wBaseMpu,wDestPage,wDestOffset,lpSrc,(WORD) (0x10000-wDestOffset)))
	{
	return 2;
	}
	
	point=(WORD*)lpSrc;
	point+=(0x10000-wDestOffset);
	MemCopySrc(wBaseMpu,wDestPage+1,0,point,ww=(wCount+wDestOffset));
	}
else
	{								// no page change
	if (!MemCopySrc(wBaseMpu,wDestPage,wDestOffset,lpSrc,wCount))
		{
		return 2;
		}
	}
return 0;
}  

/****************************************************************************

    API dream - UpLoad 
    Transfert a memory bloc from dream card memory to PC.
    lpDst	:	Pointer to memory bloc to receive bytes.
    wSrcOffset 	: offset of source
    wSrcPage	: source page
    wCount	 	: nb of word to copy
    
    Return : 0 if successfull
    		 1 if fail wCount>32kWords
    		 2	not in page
****************************************************************************/
WORD UpLoad(WORD wBaseMpu,void *lpDst,WORD wSrcPage,WORD wSrcOffset,WORD wCount) 
{

if (wCount==0) 
	return 0;
if (wCount>0x8000)  						// wCount>32Kwords  error
	{
	return 1;             
	}
if ((wSrcOffset!=0) && (wSrcOffset+(wCount-1) < wCount))
	{								// Page change  
	return 2;
	}
else
	{								// no page change
	MemCopyDst(wBaseMpu,wSrcPage,wSrcOffset,lpDst,wCount);
	}
return 0;
}


/***************************************************************************************
*
*  BOOL memWrFmt
*	
*	Copy an 'in page' buffer in card through dma
*
*
*****************************************************************************************/     
BOOL MemWrFmt(WORD wBaseMpu,DWORD BoardAddress, void * lpSrc,WORD SizeBuff, 
			  BOOL Stereo, BOOL s8Bits, DWORD BoardAddress2)
{
	WORD count=0;
	DWORD read;  
	BYTE *StereoBuffer;

	__asm cli
	// init dma
	WriteP16(wBaseMpu,WRT_MEM,1);
	WriteP16(wBaseMpu,(BYTE) (BoardAddress & 0xff),0);
	WriteP16(wBaseMpu,(BYTE) ((BoardAddress>>8) & 0xff),0);     
	WriteP16(wBaseMpu,(BYTE) ((BoardAddress>>16) & 0xff),0);
	WriteP16(wBaseMpu,(BYTE) ((BoardAddress>>24) & 0xff),0);
	WriteP16(wBaseMpu,(BYTE) (SizeBuff & 0xff),0);
	WriteP16(wBaseMpu,(BYTE) ((SizeBuff>>8) & 0xff),0);
	// Wait acknowledge
	do
		{
		read=MPU401_Command_Read(wBaseMpu);
		count++;
		}
	while ((count<10)	&& (read != ACQ_DMA));
	__asm sti
	if (read != ACQ_DMA)
		return FALSE; 

	//common initializations
	__asm
	{
		cld
	}

	if (!Stereo && !s8Bits)
	{		//16b mono
		__asm
		{ 
			mov		esi, lpSrc  
			mov		dx, wBaseMpu
			add		dx, 2
			movzx		ecx, SizeBuff 
			rep	outsw
		}
	}
	else if (Stereo && !s8Bits)
	{			// 16b stereo
		StereoBuffer=(BYTE *) _PageAllocate(2*SizeBuff/0x1000 + 1,PG_SYS,0,0,0,0xfff,0,PAGEFIXED | PAGECONTIG |  PAGEUSEALIGN);
		if (StereoBuffer==0)
		{
			Trace_Out("Can't allocate tempo buffer for stereo");
			return FALSE;
		}
		__asm
		{
			mov		edi, StereoBuffer
			mov		esi, lpSrc  
			mov		dx, wBaseMpu
			add		dx, 2
			movzx		ecx, SizeBuff 
		Fl16s:
			outsw
			movsw
			loop	Fl16s
		}
	}
	else if (!Stereo && s8Bits)
	{	//8b mono
		__asm
		{ 
			mov		esi, lpSrc  
			mov		dx, wBaseMpu
			add		dx, 2
			movzx		ecx, SizeBuff 
		Fl8m:
			mov		al, [esi]
			add		al, 80h
			shl		eax, 8
			out		dx, ax
			inc		esi
			loop	Fl8m
		}
	}
	else if (Stereo && s8Bits)
	{	//8b stereo
		__asm
		{ 
			mov		esi, lpSrc  
			mov		dx, wBaseMpu
			add		dx, 2
			movzx		ecx, SizeBuff 
		Fl8s:
			mov		ax, [esi]
			add		al, 80h
			add		ah, 80h
			out		dx, ax
			add		esi, 2
			loop	Fl8s
		}
	}

	if (Stereo && !s8Bits)		//16 bits stereo
	{
		//Fill 2nd channel (right)
		__asm cli
		// init dma
		WriteP16(wBaseMpu,WRT_MEM,1);
		WriteP16(wBaseMpu,(BYTE) (BoardAddress2 & 0xff),0);
		WriteP16(wBaseMpu,(BYTE) ((BoardAddress2>>8) & 0xff),0);     
		WriteP16(wBaseMpu,(BYTE) ((BoardAddress2>>16) & 0xff),0);
		WriteP16(wBaseMpu,(BYTE) ((BoardAddress2>>24) & 0xff),0);
		WriteP16(wBaseMpu,(BYTE) (SizeBuff & 0xff),0);
		WriteP16(wBaseMpu,(BYTE) ((SizeBuff>>8) & 0xff),0);
		// Wait acknowledge
		do
			{
			read=MPU401_Command_Read(wBaseMpu);
			count++;
			}
		while ((count<10)	&& (read != ACQ_DMA));
		__asm sti
		if (read != ACQ_DMA)
			return FALSE; 
		__asm
		{
			mov		esi, StereoBuffer 
			mov		dx, wBaseMpu
			add		dx, 2
			movzx		ecx, SizeBuff 
			rep	outsw
		}
		if (!(_PageFree(StereoBuffer,0)))
		{
			__asm int 3
			Trace_Out("Can't free tempo buffer");
		}

	}


	return TRUE;
}    


/***************************************************************************************
*
*  BOOL MemCopySrc
*	
*	Copy an 'in page' buffer in card through dma
*
*
*****************************************************************************************/     
BOOL MemCopySrc(WORD wBaseMpu,WORD PageDst, WORD OffDst, void * lpSrc,WORD wCount)
{
	WORD count=0;
	DWORD read;  

	__asm cli
	// init dma
	WriteP16(wBaseMpu,WRT_MEM,1);
	WriteP16(wBaseMpu,(BYTE) (OffDst & 0xff),0);
	WriteP16(wBaseMpu,(BYTE) ((OffDst>>8) & 0xff),0);     
	WriteP16(wBaseMpu,(BYTE) (PageDst & 0xff),0);
	WriteP16(wBaseMpu,(BYTE) ((PageDst>>8) & 0xff),0);
	WriteP16(wBaseMpu,(BYTE) (wCount & 0xff),0);
	WriteP16(wBaseMpu,(BYTE) ((wCount>>8) & 0xff),0);
	// Wait acknowledge
	do
		{
		read=MPU401_Command_Read(wBaseMpu);
		count++;
		}
	while ((count<10)	&& (read != ACQ_DMA));
	__asm sti
	if (read != ACQ_DMA)
		return FALSE;  
	__asm
		{ 
		push esi
		pushad
		cld
		mov		esi, lpSrc  
		mov		dx, wBaseMpu
		add		dx, 2
		xor		ecx, ecx
		mov		cx, wCount 
	rep	outsw

		popad
		pop		esi     
		}
	return TRUE;
}    

/***************************************************************************************
*
*  BOOL MemCopyDst(WORD PageSrc, WORD OffSrc, WORD *lpDst,WORD wCount)
*	
*	Copy from memory card to an 'in page' buffer
*
*
*****************************************************************************************/     
BOOL MemCopyDst(WORD wBaseMpu,WORD PageSrc, WORD OffSrc, void * lpDst,WORD wCount)
{
	int count=0;
	DWORD read;   

	__asm cli
	// init dma
	WriteP16(wBaseMpu,READ_MEM,1);
	WriteP16(wBaseMpu,(BYTE) (OffSrc & 0xff),0);
	WriteP16(wBaseMpu,(BYTE) ((OffSrc>>8) & 0xff),0);     
	WriteP16(wBaseMpu,(BYTE) (PageSrc & 0xff),0);
	WriteP16(wBaseMpu,(BYTE) ((PageSrc>>8) & 0xff),0);
	WriteP16(wBaseMpu,(BYTE) (wCount & 0xff),0);
	WriteP16(wBaseMpu,(BYTE) ((wCount>>8) & 0xff),0);
	// Wait acknowledge
	do
		{
		read=MPU401_Command_Read(wBaseMpu);
		count++;
		}
	while ((count<10)	&& (read != ACQ_DMA));
	__asm sti
	if (read != ACQ_DMA)
		return FALSE;

	__asm
		{
		push edi
		pushad
		cld
		mov		edi, lpDst   // model medium lpDst=offset only
		mov		dx, wBaseMpu
		add		dx, 2
		xor		ecx, ecx
		mov		cx, wCount 
	rep	insw
		popad
		pop		edi	
		}
	return TRUE;
}

/**********************************************************************
*
*   BOOL GetMemoryMapping(MemBlDefTyp MemoryBlock[],SndBkDefTyp SndBkDef[])
*	
*	Ask the card for the memory mapping address, and upload the memory
*	Mapping Table in MemoryBlock[BlockNb] and SndBkDef[8]                                                                
*   
*	Return TRUE if succeed, FALSE if failed  
*
*		Call :	GetMemMapAddress     API Dream
*				UpLoad               API Dream
*
**********************************************************************/          
BOOL GetMemoryMapping(WORD wBaseMpu,MemBlDefTyp MemoryBlock[],SndBkDefTyp SndBkDef[])
{ 
DWORD MemMapAdd; 
void *a;
a=&(MemMapAdd);

Trace_Out(" go in get mmt add");
if ((MemMapAdd=GetMemMapAddress(wBaseMpu))==0xffffffff)				//API Dream called to Get Memory Mapping Table address
	{
	Trace_Out("Error in API GetMemMapAddress"); 
	return FALSE;
	}
if (UpLoad(wBaseMpu,(void*)MemoryBlock,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),MemBlockSize))	//API Dream called to Get Memory block definition
	{
	Trace_Out("Can't UpLoad Memory Block Definition");     
	return FALSE;
	}
if (UpLoad(wBaseMpu,SndBkDef,(WORD) ((MemMapAdd+MemBlockSize)>>16),(WORD) ((MemMapAdd+MemBlockSize) & 0xffff),MemSBSize)) 
				//API Dream called to Get Sound bank definition             
    {
	Trace_Out("Can't UpLoad Sound Bank Definition");    
	return FALSE;
	}   
return TRUE;
}

/***************************************************************************************
*
*  int SendNewSoundBank(DWORD BinFile, WORD wBaseMPU)
*	
*	Realize the transfert of a new sound bank binary file (94b) in 9407 card .
*	Allocate the best place for memory optimization
*	and update memory mapping and instrument mapping. 
*   If the transfert is directed to card offset and memory size are ignored. If transfert is
*	directed to file, the Memory mapping is placed at address offset. The first Word of the 
*	file is the one at address offset.
*	              
*   
*	Return FALSE if failed 
*  
*	Call    GetMemoryMapping
*			PutSoundBank
*			DownLoad						API Dream
*			GetChunkPos					BankDoc
*           SplitInsMap  
*			AddAssign
*           CreateInsMap
*
*****************************************************************************************/
int SendNewSoundBank(DWORD BinFile, WORD wBaseMPU)
{
DWORD PcmAlloc[128],ParAlloc[2]; 
DWORD MMOldAdd;     
long MidiMapExt,MidiMapAdd=0,MidiMapSize,MemMapAdd,MidiExtSize,NewMemTableAdd=-1;
long pos,length,ParamDid=0,lenpar,Imaplength;
NewBloc *BlockList;
MemBlDefTyp MemoryBlock[64];
SndBkDefTyp SndBkDef[8];
int SndBkNb,n,nMMT,nCur;
BOOL Card=TRUE,First=FALSE;
WORD *NewAssign;
int nInsInBin=0,nDrmInBin=0;
BOOL RellocMemMap=FALSE;
WORD *MidiMapping; 
DWORD MidSize;
assigne *InstTab,*InstBkUpTab,DrumTab[80],DrumBkUpTab[80];
int nInst,nInstBk,nDrm,nDrmBk; 
SndBkDefTyp priority;
WORD OldMidMapSize;
int nNA,res; 
WORD MidiPr,Pointer; 
BYTE var,pg;
DWORD MBAdd;   
long FreeSize, MidiAvSize;

//seek chunk copyright dream
if ((pos=GetChunkPos(BinFile,"DRCP",FALSE))!=-1)
{
	RMID_Offset=pos; 		// !=0 if .rmi file
} 
else
{
	// Get chunk "PRIO" 
	Trace_Out("seek for prio");
	if ((pos=GetChunkPos(BinFile,"PRIO",TRUE))==-1)
	{
		Trace_Out("error in seeking for prio chunk");
		return 0xff;  
	} 
	Trace_Out("ret seek for prio");

	RMID_Offset=pos; 		// !=0 if .rmi file
}

// Get chunk "IMAP" 
if ((pos=GetChunkPos(BinFile,"IMAP",TRUE))==-1)
{
	Trace_Out("getchunk : error in seeking imap ");
	return 0xff;
}     

           
// let's get chunk's size  
if ((cSeek(BinFile,pos+4,0)==NULL))
{
	Trace_Out("error in seeking imap ");
	return 0xff;
} 
if (!cRead(BinFile,(DWORD) (&Imaplength),4))
{
	Trace_Out("error in reading imap length");
	return 0xff;
}  


if ((NewAssign =(WORD *) _PageAllocate(1,PG_SYS,0,0,1,1,0,0))==NULL)
{
	Trace_Out("Can't allocate NewAssign");
	return 0xff;
}
Trace_Out("Allocate NewAssign");
if (!cRead(BinFile,(DWORD) NewAssign,Imaplength)) 
  	{
	Trace_Out("Error in reading chunk IMAP");  
	return 0xff;
	}  
//Compute instrument number in BinFile    
n=0;
while ((NewAssign[n])!=0xffff)
	{	// not end of instrum table
	n+=3; 
	nInsInBin++;
	}
n++;  
//compute drumset number in BinFile
while ((NewAssign[n])!=0xffff)
	{	// not end of instrum table
	n+=3; 
	nDrmInBin++;
	}  

if (Card)
	{         	
	//Get Memory Mapping from card 
	if (!GetMemoryMapping(wBaseMPU,MemoryBlock,SndBkDef))
		return 0xff;
		
	if ((MemMapAdd=GetMemMapAddress(wBaseMPU))==0xffffffff)				//API Dream called to Get Memory Mapping Table address
		{
		Trace_Out("Error in API GetMemMapAddress\n");
		return 0xff;
		}
	nMMT=0;
	while ((MemMapAdd!=MemoryBlock[nMMT].Address) && (nMMT<BlockNb))  // research Mem Map Table in Memory Map
		nMMT++;   
	if (nMMT==BlockNb) 
		{
		Trace_Out("Error in searching MemMapAdd in Memory Mapping");
		return 0xff;
		} 

// if no midi mapping in card,or if there is a too short one, find a space for new memory mapping table 
	n=nMMT;
	MMOldAdd=MemoryBlock[n].Address;	// Address of Memory Mapping. Use if it is reallocate to update pointers 
	MidiMapSize=17+128*5+(nInsInBin-128)*2+nDrmInBin*3+3; //required size
	if (MemoryBlock[n+1].Type!=4)			// no midi mapping table     
		{  
		First=TRUE;
		if (MemoryBlock[n+1].Type!=1)	// not a free bloc		
			RellocMemMap=TRUE;
		else                                    //free block 
			{  //compute free block size
			if ((MemoryBlock[n+2].Address >> 16) == (MemoryBlock[n+1].Address >> 16))
				FreeSize=MemoryBlock[n+2].Address-MemoryBlock[n+1].Address; // free size is in page
		    else
		    	FreeSize=0x10000 - (MemoryBlock[n+1].Address & 0x0ffff);  // let's considere in page free size only
		    
		    if (FreeSize>=MidiMapSize+MidiMapExtSize) 
		    	{
		    	NewBloc ToAdd;  
		    	Trace_Out("free size large enough");
		    	ToAdd.Type=4; 
		    	if (MemoryBlock[n].Address+(MemBlockSize+MemSBSize) != MemoryBlock[n+1].Address)
		    	 	{
					Trace_Out("Bad Memory Mapping size (!=136)");
					return 0xff;
					} 
		    	ToAdd.Address=MemoryBlock[n].Address+MemBlockSize+MemSBSize;	// After memory mapping table
		  		if (FreeSize==MidiMapSize+MidiMapExtSize)
		  			DeleteMBlock(n+1,MemoryBlock); 	// no free space more
		  		else
		  			MemoryBlock[n+1].Address+=MidiMapSize+MidiMapExtSize;
		    	if (!InsertMBlock(n+1,ToAdd,MemoryBlock))  // reserve midi mapping  space
		        	{
					Trace_Out("Can't insert midi map block");
					return 0xff;
					} 
				Trace_Out("Block 4, ok");
				ToAdd.Type=5;
		    	ToAdd.Address=MemoryBlock[n].Address+MemBlockSize+MemSBSize+MidiMapSize;
		    						// After midi mapping table    
				if (!InsertMBlock(n+2,ToAdd,MemoryBlock))   // reserve midi mapping ext space
		        	{
					Trace_Out("Can't insert midi map block");  
					return 0xff;
					}
				Trace_Out("Block 5, ok");  
				} 
			else        // free space too short after Memory mapping table 
				{
				Trace_Out("free size isn't large enough. Need relloc");
				RellocMemMap=TRUE;  
				}
			}
		}
	else      // Midi mapping table present
		{ 
		// Is there enough place in Midi Mapping + Midi Map Ext tables
		if (MemoryBlock[n+2].Type!=5) 
			{
			n--;
			MidiAvSize=0;
			}
		else
			{                                      
			// Compute available size
			MidiAvSize=MemoryBlock[n+3].Address-MemoryBlock[n+2].Address;
			}
		
	    if (MidiAvSize<MidiMapSize-0x194)
	    	{
	    	if (MemoryBlock[n+3].Type==1)
	    		{                  // free block after so we can enlarge midi mapping extension 
				// check free size (only in page free size is usefull)
				if ((MemoryBlock[n+4].Address >> 16) == (MemoryBlock[n+3].Address >> 16))
					FreeSize=MemoryBlock[n+4].Address-MemoryBlock[n+3].Address; // free size is in page
			    else
			    	FreeSize=0x10000 - (MemoryBlock[n+3].Address & 0x0ffff);  // let's considere in page free size only
				// Is free size large enough?
				if (FreeSize+MidiAvSize<MidiMapSize-0x194)
					RellocMemMap=TRUE;              // no, realloc it
				else 
					{
					if (FreeSize+MidiAvSize==MidiMapSize-0x194) 
						DeleteMBlock(n+3,MemoryBlock);  // no free block remaining
					else 
						{
						if (MidiAvSize)
							{
							MemoryBlock[n+3].Address=MidiMapSize-0x194+MemoryBlock[n+2].Address; // remaining free block
		    		    	DeleteMBlock(n+2,MemoryBlock);   // no more MidiMapExt
	    		            }
	    		        else
	    		        	MemoryBlock[n+3].Address+=MidiMapSize-0x194; // remaining free block
	    		     	}
	    		    }
	    		}  
	    	else   // no free block after midi mapping ext
	    	    RellocMemMap=TRUE;              // no, realloc it	    		
	    	}
	    else
	    	{// MidiMapExt large enough   
	    	if (MidiAvSize!=MidiMapSize-0x194)  
	    		MemoryBlock[n+2].Address+=MidiMapSize-0x194;  
	    	else
	    		DeleteMBlock(n+2,MemoryBlock);   // no more MidiMapExt	
	    	} 		
	    }
	if (MidiAvSize==0)
			n++;
			
			
	if (RellocMemMap)
	{     
		long NMidiMapSize;      
		Trace_Out("rellocation");  
		if (MemoryBlock[n+1].Type==4)		// MidiMap    
			{
			NMidiMapSize=MidiMapSize+MemoryBlock[n+2].Address-MemoryBlock[n+1].Address;
			} 
		else
			NMidiMapSize=MidiMapSize;
		if ((NewMemTableAdd=ReallocMemoryMap(MemoryBlock,NMidiMapSize))==-1)
			return 0xff;
	}
	
	// Get free SoundBank number, and Affect it to the new one 
	SndBkNb=0;
	while((SndBkDef[SndBkNb].Nam[0]!=0) && (SndBkNb<8)) SndBkNb++;
	if (SndBkNb==8) 
		{
		Trace_Out("8 Sound Bank already in card!");
		return 0xff;
		}  
	}
else
	{			// donig file, No sound bank in memory   
	return 0xff;
	}

// Construct the list of new bloc to send to card
if ((BlockList= (NewBloc *) _PageAllocate(1,PG_SYS,0,0,1,1,0,0))==NULL)	//allocate 4K for block table
{
	Trace_Out("Can't allocate BlockList");
	return 0xff;
}
Trace_Out("Allocate BlockList");
NInBlTable=0;
if (!PutSoundBank(BlockList,BinFile,PcmAlloc,ParAlloc,MemoryBlock,SndBkDef,SndBkNb))
	return 0xff;


//For parameters, we have first to Update parameters pointer.
// 	...with info given in RLOC and  PcmAlloc		
  
/*if ((WORD) (buffer+0x1000)<0x1000)  
	{
	Trace_Out("Buffer in cross page");
	return 0xff;
	}*/

// First MiniBloc;	
nCur=0;

while (nCur<NInBlTable)
	{               // loop until the end of mini blocks list
	Trace_Out("xfer block nb");
	if (((BlockList[nCur].Type) & 0xff)==0x10)	
		{		// 	sound parameters  
				//Load the param bloc in buffer  
		long totpar=0;
		WORD st_address=(WORD) (BlockList[nCur].Address & 0xffff); 

		if (BlockList[nCur].Size-totpar<0x1000)
			lenpar=BlockList[nCur].Size-totpar;
		else
			lenpar=0x1000;
		do
			{ 
			if (cSeek(BinFile,BlockList[nCur].PosInSndBk,0)==0xffffffff)
				{
					Trace_Out("error in seeking param");
					return 0xff;
				}	
			if (!cRead(BinFile,(DWORD) buffer,2*lenpar))
				{
					Trace_Out("error in reading par");
					return 0xff;
				}
			Trace_Out("Do rellocation");
			if (res=DoRellocation(BlockList[nCur],buffer,lenpar,PcmAlloc,BinFile,st_address))
			{
				if (res==2)
				{
					Trace_Out("error in  rellocation");
					return 0xff; 
				}
				lenpar--;
			}
			Trace_Out("ret from Do rellocation");

		    if (DownLoad(wBaseMPU,buffer,(WORD) (BlockList[nCur].Address >> 16),(WORD) (BlockList[nCur].Address & 0xffff),(WORD) lenpar))
				{                        
				Trace_Out("Error in loading bloc in card at address ");  
				return 0xff;
				}
	
			totpar+=lenpar;  
			BlockList[nCur].Address+=lenpar;
			BlockList[nCur].PosInSndBk+=2*lenpar;
			if (BlockList[nCur].Size-totpar<0x1000)
				lenpar=BlockList[nCur].Size-totpar;
			else
				lenpar=0x1000;
			}
		while (lenpar!=0);  
		} // end if parameter bloc
  	else
  		{				// pcm bloc, just download it
  		for (n=0; n<(int) (BlockList[nCur].Size/0x1000);n++)			// send it by 16k word pack
	  	    {
	  	    if (cSeek(BinFile,BlockList[nCur].PosInSndBk,0)==0xffffffff)
				{
					Trace_Out("error in seeking pcm");
					return 0xff;
				}	
			if (!cRead(BinFile,(DWORD) buffer,0x2000))
				{
					Trace_Out("error in reading pcm");
					return 0xff;
				}
			if (Card)
				{
		  	    if (res=DownLoad(wBaseMPU,buffer,(WORD) (BlockList[nCur].Address >> 16),(WORD) (BlockList[nCur].Address & 0xffff), 0x1000))
				  	{                     
					Trace_Out("Error in loading bloc in card at address ");
					return 0xff;
					}
				}    
			else  
				{
				Trace_Out("ERROR   Card=FALSE");
				return 0xff;
				}
			
			BlockList[nCur].PosInSndBk+=0x2000;
			BlockList[nCur].Address+=0x1000;
			}   
		if (cSeek(BinFile,BlockList[nCur].PosInSndBk,0)==0xffffffff)
			{
				Trace_Out("error in seeking pcm");
				return 0xff;
			}	
		if (!cRead(BinFile,(DWORD) buffer, (DWORD) (2*(BlockList[nCur].Size%0x1000)) ))
			{
				Trace_Out("error in reading pcm");
				return 0xff;
			}

	  	if (DownLoad(wBaseMPU,buffer,(WORD) (BlockList[nCur].Address >> 16),(WORD) (BlockList[nCur].Address & 0xffff),(WORD) (BlockList[nCur].Size%0x1000)))
			{                        
			Trace_Out("Error in loading bloc in card at address");  
			return 0xff;
			} 
		}   
	nCur++; 
	}	// end while cur!=null 

if (!(_PageFree(BlockList,0)))
{
	Trace_Out("free blocklist fail");
}

//Now, we have to create new Instrument mapping 
//Get Midi Mapping Table address


if ((MemMapAdd=GetMemMapAddress(wBaseMPU))==0xffffffff)			//API Dream called to Get Memory Mapping Table address
	{
	Trace_Out("Error in API GetMemMapAddress");
	return 0xff;
	} 

	
nMMT=0;
while ((MemMapAdd!=MemoryBlock[nMMT].Address) && (nMMT<BlockNb))  // research Mem Map Table in Memory Map
	nMMT++;   
if (nMMT==BlockNb) 
	{
	Trace_Out("Error in searching MemMapAdd in Memory Mapping\n");
	return 0xff;
	} 
		
MidiExtSize=MidSize=0;   
n=nMMT;
if (MemoryBlock[n+1].Type==4)           //Midi Mapping Table    
	{
	MidiMapAdd=MemoryBlock[n+1].Address;  
	MidSize=MemoryBlock[n+2].Address-MidiMapAdd;
	}
if (MemoryBlock[n+2].Type==5)           //Midi Mapping Table Extension  
	{
	MidiMapExt=MemoryBlock[n+2].Address;
	MidiExtSize=MemoryBlock[n+3].Address-MidiMapExt;
	}   
if (!First)
	{   
		long MidiMapSizeInCard;
		long OMidiMapSizeInCard=MidSize+MidiExtSize;	//size Midi mapping+Midi mapping extension in word 
		Trace_Out("already a midimap");
		if (!MidiMapAdd)
			{
			Trace_Out("No Midi Mapping"); 
			return 0xff;
			}
		if (NewMemTableAdd>=0)			// table reallocated
			{    
			Trace_Out("rellocation ");
			nMMT=0;
			while ((NewMemTableAdd!=MemoryBlock[nMMT].Address) && (nMMT<BlockNb))  // research Mem Map Table in Memory Map
				nMMT++;   
			if (nMMT==BlockNb) 
				{
				Trace_Out("Error in searching MemMapAdd in Memory Mapping");  
				return 0xff;
				} 
			if (MemoryBlock[nMMT+1].Type==4)           //Midi Mapping Table    
				{
				MidiMapSizeInCard=MemoryBlock[nMMT+2].Address-MemoryBlock[nMMT+1].Address;
				}
			if (MemoryBlock[nMMT+2].Type==5)           //Midi Mapping Table Extension  
				{
				MidiMapSizeInCard+=MemoryBlock[nMMT+3].Address-MemoryBlock[nMMT+2].Address;
				} 
			}
		else
			MidiMapSizeInCard=OMidiMapSizeInCard; 
	    Trace_Out("go to Allocate MidiMap");

		if ((MidiMapping=_PageAllocate(1+(ULONG) (MidiMapSizeInCard/2048),PG_SYS,0,0,1,1,0,0))==NULL)
		{             
			Trace_Out("Can't allocate MidiMap");
			return 0xff;
		} 
		Trace_Out("Allocate MidiMap"); 
 
		if (UpLoad(wBaseMPU,MidiMapping,(WORD) (MidiMapAdd>>16),(WORD) (MidiMapAdd & 0xffff),(WORD) OMidiMapSizeInCard))	//API Dream called to Get Midi mapping
			{
			Trace_Out("Can't UpLoad Midi Mapping");                       
			return 0xff;
			}     
		}

// Read the priority of the new sound bank

// Get chunk "PRIO" 
Trace_Out("seek for prio");
if ((pos=GetChunkPos(BinFile,"PRIO",TRUE))==-1)
{
	Trace_Out("error in seeking for prio chunk");
	return 0xff;  
} 
// let's get chunk's size  
if (cSeek(BinFile,pos+4,0)==0xffffffff)
{
	Trace_Out("error in seeking for prio chunk");
	return 0xff;
} 
if (!cRead(BinFile,(DWORD) (&length),4))
{
	Trace_Out("error in reading prio length");
	return 0xff;
} 

if (length!=10)
	{ 
	Trace_Out("Bad size for 'PRIO' Chunk");   
	return 0xff;
	}
 
if (!cRead(BinFile,(DWORD) &(priority.Nam),8))
{
	Trace_Out("error in reading sb name ");
	return 0xff;
} 
if (!cRead(BinFile,(DWORD) &(priority.Prio),2))
{
	Trace_Out("error in reading sb name ");
	return 0xff;
}
	
// Create new midi mapping  
if (!First)
	{   
		int AssignSize; 
		OldMidMapSize=MidiMapping[0]-0x194;
		AssignSize=(MidiMapping[0]-0x194)/2;		// Evaluation of assignement number in old midi mapping table
		if ((InstTab=_PageAllocate(1+(ULONG) ((AssignSize+nInsInBin)/850),PG_SYS,0,0,1,1,0,0))==NULL)
		{
			Trace_Out("Can't allocate InstTab");
			return 0xff;
		}  
		if ((InstBkUpTab=_PageAllocate(1+(ULONG) ((AssignSize+nInsInBin)/850),PG_SYS,0,0,1,1,0,0))==NULL)
		{
			Trace_Out("Can't allocate InstBkUpTab");
			return 0xff;
		} 
		Trace_Out("Allocate InsTab & InstBkUpTab");         
		if (!SplitInsMap(MidiMapping,(WORD) MidiMapAdd,InstTab,InstBkUpTab,DrumTab,DrumBkUpTab,
					&nInst,&nInstBk,&nDrm,&nDrmBk))
		{
			Trace_Out("Error in splitting Midi mapping");                
			return 0xff;
		}
		Trace_Out("ret from split ins map"); 
	}
else
	{  // no sound bank yet, so no Midi Mapping.
	OldMidMapSize=0;
    if ((MidiMapping=_PageAllocate(1,PG_SYS,0,0,1,1,0,0))==NULL)
	{
		Trace_Out("Can't allocate MidiMap");
		return 0xff;
	} 
	Trace_Out("Allocate MidiMap");
	if ((InstTab=_PageAllocate(2,PG_SYS,0,0,1,1,0,0))==NULL)
	{
		Trace_Out("Can't allocate InstTab");
		return 0xff;
	} 
	Trace_Out("Allocate InsTab");
	if ((InstBkUpTab=_PageAllocate(1,PG_SYS,0,0,1,1,0,0))==NULL)
	{
		Trace_Out("Can't allocate InstBkUpTab");
		return 0xff;
	} 
	Trace_Out("Allocate InsBkUpTab");
    nDrm=nDrmBk=nInstBk=nInst=0;   
    }
nNA=0; 

//Read new instrument assignement 
while ((MidiPr=NewAssign[nNA++])!=0xffff)
	{	// not end of instrum table
	var=(BYTE) (NewAssign[nNA] & 0xff);
	pg=(BYTE) ((NewAssign[nNA++]>>8) & 0xff);  
	Pointer=NewAssign[nNA++];  
	// add this instrument assignement 
	AddAssign(InstTab,InstBkUpTab,(BYTE) MidiPr,var,Pointer,(WORD) (ParAlloc[pg] & 0xffff),(BYTE) (SndBkNb*2+pg),SndBkDef,
			priority.Prio,&nInst,&nInstBk);
	}  
//Read new Drumset assignement 
while ((MidiPr=NewAssign[nNA++])!=0xffff)
	{	// not end of drumset table
	var=(BYTE) (NewAssign[nNA] & 0xff);
	pg=(BYTE) ((NewAssign[nNA++]>>8) & 0xff);  
	Pointer=NewAssign[nNA++]; 
	// add this drumset assignement 
	AddAssign(DrumTab,DrumBkUpTab,(BYTE) MidiPr,var,Pointer,(WORD) (ParAlloc[pg] & 0xffff),(BYTE) (SndBkNb*2+pg),
			SndBkDef,priority.Prio,&nDrm,&nDrmBk);
	} 

if (!(_PageFree(NewAssign,0)))
{
	Trace_Out("error in freeing NewAssign");
	return 0xff;
}
// Now, we have to redo midi mapping table  
MidiMapping[2*SndBkNb+1]=(WORD) (ParAlloc[0]>>16); 
MidiMapping[2*SndBkNb+2]=(WORD) (ParAlloc[1]>>16); 

// Let's sort Tables according to increasing midi prog
saSort(InstTab,nInst); 
saSort(InstBkUpTab,nInstBk); 
saSort(DrumTab,nDrm); 
saSort(DrumBkUpTab,nDrmBk);

if (!CreateInsMap(MidiMapping,InstTab,InstBkUpTab,DrumTab,DrumBkUpTab,nInst,
		nInstBk,nDrm,nDrmBk,(WORD) (MidiMapAdd & 0xffff)))
  	{
	Trace_Out("Error in re-doing Midi mapping");
	return 0xff;
	}   
if (MidiMapping[0]!=(WORD) MidiMapSize+OldMidMapSize)
	{
	Trace_Out("Midi mapping size not fit"); 
	}   

if (!(_PageFree(InstTab,0)))
{
	Trace_Out("error in freeing InstTab");
	return 0xff;
}
if (!(_PageFree(InstBkUpTab,0)))
{
	Trace_Out("error in freeing InstBkUpTab");
	return 0xff;
}  
// Send midi mapping in card 
if (Card)
	{ 
	DWORD MMTAdd;
	
	if (NewMemTableAdd>=0)   // Table reallocated
		{ 
		// delete Old MMT 
		int nn;
		for (nn=0; nn<BlockNb; nn++)
			{
			if ((MemoryBlock[nn].Type==3) && (MemoryBlock[nn].Address!=NewMemTableAdd)) // old MMT
				{
				if (MemoryBlock[nn-1].Type==1)
					DeleteMBlock(nn, MemoryBlock);  
				else   
					MemoryBlock[nn++].Type=1;
				if (MemoryBlock[nn].Type==4)  // old Midi MT
					DeleteMBlock(nn, MemoryBlock); 
				if (MemoryBlock[nn].Type==5)  // old Middi map ext 
					DeleteMBlock(nn, MemoryBlock); 
				if (MemoryBlock[nn].Type==1) 
					DeleteMBlock(nn, MemoryBlock);  
				break;
				}
			}
		MMTAdd=NewMemTableAdd+MemBlockSize+MemSBSize; 
		for (n=17; n<145; n++)			//	Update pointers      
			MidiMapping[n]+=(WORD) ((MMTAdd & 0xffff)-(MidiMapAdd & 0xffff));  
			//MidiMapping[n]+=(WORD) ((NewMemTableAdd-MMOldAdd) & 0xffff);  
		}
	else   
		MMTAdd=MidiMapAdd;

	if (DownLoad(wBaseMPU,MidiMapping,(WORD) (MMTAdd >> 16),(WORD) (MMTAdd & 0xffff),(WORD) MidiMapping[0]))
	  	{                        
		Trace_Out("Error in loading MidiMapping in card at address",);  
		return 0xff;
		} 
	}
if (!(_PageFree(MidiMapping,0)))
{
	Trace_Out("error in freeing MidiMapping");
	return 0xff;
}  

// Now, we have to send memory mapping table
//	a) Memory bloc definition


if (NewMemTableAdd>=0)
	MBAdd=NewMemTableAdd;
else   
	MBAdd=MemMapAdd;

if (DownLoad(wBaseMPU,MemoryBlock,(WORD) (MBAdd >> 16),(WORD) (MBAdd & 0xffff),(WORD) MemBlockSize))
	{                        
	Trace_Out("Error in loading MemoryMapping in card at address");
	return 0xff;
	}

if (!Card)
{
	Trace_Out("error card=0");
	return 0xff;
}

//	b) Sound Bank definition 
SndBkDef[SndBkNb]=priority;
MemMapAdd+=MemBlockSize;

if (NewMemTableAdd>=0)
	MBAdd=NewMemTableAdd+MemBlockSize;
else   
	MBAdd=MemMapAdd;


if (DownLoad(wBaseMPU,SndBkDef,(WORD) (MBAdd >> 16),(WORD) (MBAdd & 0xffff),MemSBSize))
	{                        
	Trace_Out("Error in loading sound bank def in card at address ");
	return 0xff;
	}  

if (NewMemTableAdd>=0)
	{
	// memory mapping address has change
	if (SetMemMapAddress((DWORD) NewMemTableAdd, wBaseMPU))  
		{                        
		Trace_Out("Error in notifying the card about a Memory Map Address change");
		return 0xff;
		}  
	}
// let's send program change 0 on all channels 
WriteP16(wBaseMPU,0xb0,1);
for(n=0; n<16;n++)                   // channel 0-15
	{
	WriteP16(wBaseMPU,(BYTE) (0xc0+n),0);    
	WriteP16(wBaseMPU,0,0); 
	}   
WriteP16(wBaseMPU,0xb1,1);
for(n=0; n<16;n++)                   // channel 16-31
	{
	WriteP16(wBaseMPU,(BYTE) (0xc0+n),0);    
	WriteP16(wBaseMPU,0,0); 
	}  
Trace_Out("exit SendNewSoundBank");     
return SndBkNb;
}


/****************************************************************************

    API dream - SetMemMapAddress 
    Called to inform card that client have modify the Memory Mapping Table
    address.
    
    return 	0 if succeed
    		1 if failed

****************************************************************************/  
WORD SetMemMapAddress(DWORD address, WORD wBaseMPU401)
{
WriteP16(wBaseMPU401,SET_MMT,1);
WriteP16(wBaseMPU401,(BYTE) (address & 0xff),0);
WriteP16(wBaseMPU401,(BYTE) ((address>>8) & 0xff),0);
WriteP16(wBaseMPU401,(BYTE) ((address>>16) & 0xff),0);
WriteP16(wBaseMPU401,(BYTE) ((address>>24) & 0xff),0);
return 0;
}    

/****************************************************************************
*
*	long ReallocMemoryMap(MemBlDefTyp MemoryBlock[],long MidiMapSize)
*
*	Find a free space large enough to accept Memory mapping table and
*	Midi mapping table and midi map ext. Update MemoryBloc with reserving
*	space for midi mapping and deplace memory mapping block
*	
*	return new memory mapping address or -1 if Failed or not found memory space large enough
*
****************************************************************************/
long ReallocMemoryMap(MemBlDefTyp MemoryBlock[],long MidiMapSize)
{
int n;
NewBloc ToAdd;
BOOL Split;
long FreeSize=0,Required=MidiMapSize+MidiMapExtSize+MemBlockSize+MemSBSize;

n=-1;
do
	{
	n++;
	Split=FALSE;
	while ((MemoryBlock[n].Type!=1) && (n<BlockNb)) n++;
	if (n==BlockNb)
		{
		Trace_Out("Can't find a new space large enough for memory mapping Table");
		return -1;
		} 
	if ((MemoryBlock[n+1].Address >> 16)==(MemoryBlock[n].Address>>16))
		FreeSize=MemoryBlock[n+1].Address-MemoryBlock[n].Address; 
	else
		{
		FreeSize=((MemoryBlock[n].Address & 0xffff0000) + 0x10000)-MemoryBlock[n].Address;
		if (FreeSize<Required) 
			{     
			Split=TRUE;       // The free block is split. The free size is in the second part
			FreeSize=MemoryBlock[n+1].Address-((MemoryBlock[n].Address & 0xffff0000) + 0x10000); 
			}
		}
	}
while (FreeSize<Required);
// find a space to accept mapping tables

if (Split)
	{
	ToAdd.Type=1;	//Free block   
	ToAdd.Address=MemoryBlock[n].Address;
    if (!InsertMBlock(n,ToAdd,MemoryBlock))  // reserve midi mapping  space
		{
		Trace_Out("Can't insert midi map block\n");                  
		return -1;
		}  
	n++;
	MemoryBlock[n].Address=((MemoryBlock[n-1].Address & 0xffff0000) + 0x10000) ;
	}
ToAdd.Type=3;
ToAdd.Address=MemoryBlock[n].Address;	// After memory mapping table
if (FreeSize==Required)
	DeleteMBlock(n,MemoryBlock); 	// no free space more
else
	MemoryBlock[n].Address+=Required;
if (!InsertMBlock(n,ToAdd,MemoryBlock))  // reserve midi mapping  space
	{
	Trace_Out("Can't insert midi map block");                
	return -1;
	} 
ToAdd.Type=4;
ToAdd.Address=MemoryBlock[n].Address+MemBlockSize+MemSBSize;	// After memory mapping table
if (!InsertMBlock(n+1,ToAdd,MemoryBlock))  // reserve midi mapping  space
	{
	Trace_Out("Can't insert midi map block\n");                
	return -1;
	}  
Trace_Out("Block 4");
ToAdd.Type=5;
ToAdd.Address=MemoryBlock[n].Address+Required-MidiMapExtSize;
					// After midi mapping table    
if (!InsertMBlock(n+2,ToAdd,MemoryBlock))   // reserve midi mapping ext space
	{
	//printf(MsgStr,"Can't insert midi map block\n");                    
	//return FALSE;
	}
else
	Trace_Out("Block 5");
return MemoryBlock[n].Address;
}


/***************************************************************************************
*
*   BOOL SplitInsMap(WORD MidiMapping[],WORD MidiMapAdd,assigne InstTab,assigne InstBkUpTab,
*			assigne DrumTab,assigne DrumBkUpTab,int *nInst,int *nInstBk, int *nDrm, int *nDrmBk)
*	
*	Split Instrument mapping Table in 4 assignement table. One for instrument, one for 
*	backup instrument, one for drumset and one for backup drumset.          
*   
*	Return FALSE if failed 
*
*
*****************************************************************************************/    
BOOL SplitInsMap(WORD MidiMapping[],WORD MidiMapAdd,assigne InsTab[],assigne InstBkUpTab[],
			assigne DrumTab[],assigne DrumBkUpTab[],int *nInst,int *nInstBk, int *nDrm, 
			int *nDrmBk)
{
int n,nInsTab;
WORD varpg,mpr;  

Trace_Out("Split ins map");
*nInst=*nInstBk=*nDrm=*nDrmBk=0;
for (n=0;n<128;n++)
	{                     //walk along pointers to instrument program table
	nInsTab=MidiMapping[17+n]-MidiMapAdd;   
	// read instrument program table
	while ((varpg=MidiMapping[nInsTab++])!=0xffff)
		{ 
		InsTab[*nInst].mprog=n;
		InsTab[*nInst].mbank=(BYTE) (varpg & 0xff);
		InsTab[*nInst].page=(BYTE) (varpg>>8);
		InsTab[(*nInst)++].pointer=MidiMapping[nInsTab++];
		}     
	// read instrument backup program table
	while ((varpg=MidiMapping[nInsTab++])!=0xffff)
		{ 
		InstBkUpTab[*nInstBk].mprog=n;
		InstBkUpTab[*nInstBk].mbank=(BYTE) (varpg & 0xff);
		InstBkUpTab[*nInstBk].page=(BYTE) (varpg>>8);
		InstBkUpTab[(*nInstBk)++].pointer=MidiMapping[nInsTab++];
		}
	} 
Trace_Out("Split ins map 2");
n=145;
// read drumset table
while ((mpr=MidiMapping[n++])!=0xffff) 
	{
	DrumTab[*nDrm].mprog=(BYTE) mpr;
	DrumTab[*nDrm].mbank=(BYTE) (MidiMapping[n] & 0xff);
	DrumTab[*nDrm].page=(BYTE) (MidiMapping[n++] >>8);
	DrumTab[(*nDrm)++].pointer=MidiMapping[n++]; 
	}
// read drumset backup table    
while ((mpr=MidiMapping[n++])!=0xffff) 
	{
	DrumBkUpTab[*nDrmBk].mprog=(BYTE) mpr;
	DrumBkUpTab[*nDrmBk].mbank=(BYTE) (MidiMapping[n] & 0xff);
	DrumBkUpTab[*nDrmBk].page=(BYTE) (MidiMapping[n++] >>8);
	DrumBkUpTab[(*nDrmBk)++].pointer=MidiMapping[n++]; 
	} 
Trace_Out("Split ins map end");
return TRUE;
}  

/***************************************************************************************
*
*   int DoRellocation(NewBloc Cur,WORD *buffer,long lenpar,DWORD PcmAlloc[],
*		DWORD ParAlloc[],FILE *BinFile)
*	
*	Update all pointers to be rellocate in the piece of parameter the bloc Cur, of size
*	lenpar from address totpar relative Cur block start.PcmAlloc and ParAlloc contains 
*	address of pcm and parameters page.                
*   
*	Return 	0 if succeed
*		    1 if buffer boundary in the middle of a Ma2 or Mb object
*			2 if failed
*  
*	Call    GetChunkPos					BankDoc
*			LoadRelloc
*
*****************************************************************************************/
int DoRellocation(NewBloc Cur,WORD *buffer,long lenpar,DWORD PcmAlloc[],
		DWORD BinFile,WORD st_address)
{  
long LocPos,LocLength; 
RellocTyp RLocBuf[300];   
DWORD lPointer;
WORD BinPointer;
int SndBkNb=(Cur.Type >> 8) & 0xf,n,nb; 
WORD nword, tempo; 
int LObj1=0, LObj2=0, LObj3=0; 
static int PgUpdate=0;
static int PageNb;			// expected type of rellocation
WORD *bufferw;
long aStart, aEnd, aLoop;
int PgEnd;
long PhiEnd;
long InRelloc;
if (SndBkNb>7)
    { 
	Trace_Out("Free Block in ROM or snd bk nb too large.");
	return 2;
	} 


if ((LocPos=GetChunkPos(BinFile,"RLOC",TRUE))==-1)
	return 2; 
  
// let's get chunk's size  
LocLength=0;
if (cSeek(BinFile,LocPos+4,0)==0xffffffff)       //     point on chunk length
{
	Trace_Out("error in seeking param rloc");
	return 2;
}
if (!cRead(BinFile,(DWORD) &LocLength,4))
{
	Trace_Out("error in reading param rloc");
	return 2;
} 

if (LocLength%6 != 0)
	{
	Trace_Out("RLOC chunk size % 6 != 0");   
	return 2;
	} 
         
LocLength=LocLength/6;
LocPos+=8; 
InRelloc=LocPos;
do
	{
	nb=LoadRelloc(RLocBuf,&InRelloc,&LocLength,BinFile);  
	for (n=0; n<nb;n++)
		{      
		RLocBuf[n].pointer+=RMID_Offset;
		// Is this relloc for the current bloc 
		if ((RLocBuf[n].pointer>=Cur.PosInSndBk) && (RLocBuf[n].pointer<Cur.PosInSndBk+lenpar*2))
			{   

			switch (RLocBuf[n].type)	
				{
				case 0:
							// param pointer
					BinPointer=buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2];
					BinPointer+=st_address;
					buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2]=BinPointer;
					break;
				case 1:				//MA2 Page  
					if (PgUpdate!=0) 
						{ 
						Trace_Out("Ma2 Page change, whereas loop, phi, end not updated for last one.");
						PgUpdate=0;
						return 2;
						} 
					PgUpdate=1;   // wait for Ma2 Loop for the next relloc
					BinPointer=buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2+2];    
                    PageNb=(BinPointer>>6) & 0x7f; 
                    BinPointer&=0xe03f;				// erase page info 
                    BinPointer+=((WORD) ((PcmAlloc[PageNb]>>18))) << 6;  //...and update it
					buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2+2]=BinPointer;
					break; 
				case 2:				//MA2 LOOP  
					if (PgUpdate!=1) 
						{                        
						Trace_Out("Ma2 Loop change, whereas page wasn't the last relloc.");
						PgUpdate=0;
						return 2;
						}   
					if ((RLocBuf[n].pointer-Cur.PosInSndBk)/2+1 >= lenpar)    
						return 1;
						
					if ((buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2+1] & 1) != 1)
					    { 
						Trace_Out("assume Ma2 Loop and not Ma2 xfer object!");
						PgUpdate=0;
						return 2;
						} 

					PgUpdate=2;   // wait for Mp phi for the next relloc
					lPointer=(((DWORD) buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2]) << 12) +
								(buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2+1] >> 4); 
                    lPointer+=(PcmAlloc[PageNb] & 0x3ffff) << 10;  //...and update it
					buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2]=(WORD) (lPointer>>12);  
					buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2+1]=(WORD) (((lPointer<<4) +1) & 0xffff);
					break;        
				case 3:	
					if ((buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2] & 4) == 1)
						    { 
							Trace_Out("assume Mb phi or end and dummy object!");
							PgUpdate=0;
							return 2;
							} 	
					if ((RLocBuf[n].pointer-Cur.PosInSndBk)/2+1 >= lenpar)    
						return 1;    
						                         	
					if (PgUpdate==2)     //Mb Phi
						{
						PgUpdate=3;   // wait for Mb end for the next relloc
						lPointer=(buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2] ) +
									((DWORD) (buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2+1]) << 16); 
                        lPointer+=(PcmAlloc[PageNb] & 0x3ffff) << 14 ;  //...and update it
						buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2]=(WORD) (lPointer & 0xffff);  
						buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2+1]=(WORD) ((lPointer>>16)  & 0xffff);
						}
              		else if (PgUpdate==3)     //Mb end
						{
						PgUpdate=0;   // wait for Ma2 pg before other loop, phi, end relloc
						lPointer=(buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2] ) +
									((DWORD) (buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2+1]) << 16); 
                        lPointer+=(PcmAlloc[PageNb] & 0x3ffff) << 14 ;  //...and update it
						buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2]=(WORD) (lPointer & 0xffff);  

						buffer[(RLocBuf[n].pointer-Cur.PosInSndBk)/2+1]=(WORD) ((lPointer>>16)  & 0xffff);  
						}
					else
                   		{                        
						Trace_Out("Mb end or phi unexpected relloc");
						PgUpdate=0;
						return 2;
						}   
                     break;


			// MODIF NO LIMITS (08-98)
				case 4:
					// ALGO XL   
					LObj1=0;
					LObj2=0;
					LObj3=0;
					if ((RLocBuf[n].pointer-Cur.PosInSndBk)/2+50 >= lenpar)    
						return 5;  

		// 1 ) First, we search for the length of all variable size objects

		// Length of MA1[1]  VOL

		nword=(WORD) (RLocBuf[n].pointer-Cur.PosInSndBk)/2;
		tempo=buffer[nword+2];
		if (((tempo & 1)==1) || (((tempo>>6) & 1)==1)) LObj1=1;  //long MA1?

		// Length of MA1[2]  FC
		tempo=buffer[nword+4+LObj1];
		if (((tempo & 1)==1) || (((tempo>>6) & 1)==1)) LObj2=1;  //long MA1?

		// Length of MA2[4]  Freq
		tempo=buffer[nword+14+LObj1+LObj2];
		if ((((tempo>>4) & 1)==1) || (((tempo>>7) & 1)==1)) LObj3=1;  //long MA2?
			
		bufferw=(WORD *) buffer+nword;

		// 2 ) Let's compute Start, Loop, End address
		aStart=((long) (bufferw[6+LObj1+LObj2] & 0xffc0) << 12)  + // Phi Start[18,27] : PG Start >>6  <<18 --> <<12
			(bufferw[30+LObj1+LObj2+LObj3] >> 14 )  +		//Phi Start[0,1]
			(((long)bufferw[31+LObj1+LObj2+LObj3]) << 2); //Phi Start[2,17]

		aEnd=((long) (PgEnd=(0x400-(bufferw[29+LObj1+LObj2+LObj3] >> 6))) << 18)  + // Phi End[18,27] : PG End >>6  <<18 --> <<12
			(
			 PhiEnd=(0x40000 - 
			(bufferw[20+LObj1+LObj2+LObj3] >> 14 )  -		//Phi End[0,1]
			(((long)bufferw[21+LObj1+LObj2+LObj3]) << 2) ) //Phi End[2,17]
			);

		aLoop=((((long) (bufferw[25+LObj1+LObj2+LObj3] >> 6)+ PgEnd) & 0x3ff) << 18) + // Phi Loop[18,27] : PG Loop >>6  <<18 --> <<12
			((
			PhiEnd +
			(bufferw[22+LObj1+LObj2+LObj3] >> 14 )  +		//Phi Loop-Phi End[0,1]
			(((long)bufferw[23+LObj1+LObj2+LObj3]) << 2) //Phi Loop-Phi End[2,17]
			) & 0x3ffff);


		// 3 ) Add the in page Offset of the sample to compute new address
		aStart+=PcmAlloc[0];
		aEnd+=PcmAlloc[0];
		aLoop+=PcmAlloc[0];  
		
		PhiEnd=aEnd & 0x3ffff;
		PgEnd=(int) (aEnd>>18);

		// 4 ) Modify buffer with new address 
				// Pg Start
		bufferw[6+LObj1+LObj2]=(WORD) ((aStart & 0x3fc0000)>>12);
				// 10000000-PhiEnd
		bufferw[20+LObj1+LObj2+LObj3]=(bufferw[20+LObj1+LObj2+LObj3]  & 0x3fff) +
			(WORD) (( (0x40000-PhiEnd) & 3) << 14);
		bufferw[21+LObj1+LObj2+LObj3]=(WORD) ((0x40000-PhiEnd)>>2);
				// PhiLoop-PhiEnd
		bufferw[22+LObj1+LObj2+LObj3]=(bufferw[22+LObj1+LObj2+LObj3]  & 0x3fff) + 
			(WORD) (( ((aLoop & 0x3ffff)-PhiEnd) & 3) << 14);
		bufferw[23+LObj1+LObj2+LObj3]=(WORD) (((aLoop & 0x3ffff)-PhiEnd)>>2);
				// PgLoop - PgEnd
		bufferw[25+LObj1+LObj2+LObj3]=(WORD) (((aLoop >> 18)-PgEnd)<<6);

				// 0x400-PgEnd
		bufferw[29+LObj1+LObj2+LObj3]=(WORD) ((0x400-PgEnd)<<6);
				// PhiStart
		bufferw[30+LObj1+LObj2+LObj3]=(bufferw[30+LObj1+LObj2+LObj3]  & 0x3fff) + 
			(WORD) (( aStart & 3) << 14);
		bufferw[31+LObj1+LObj2+LObj3]=(WORD) (aStart >> 2); 
			// 0x400-PgEnd
		bufferw[32+LObj1+LObj2+LObj3]=(WORD) ((0x400-PgEnd)<<6);   
		
		break;

             	};	//end switch  
        	} //end if relloc for the current bloc
    	}   //end loop for every relloc 
	}		// end while inrelloc =0 
while (nb!=0);                  
//Rellocation finished on this bloc    
return 0;
}  


/****************************************************************************
*
*	void smbSort(MemBlockTyp *Tab, int Nb)
*
*	Compare Mini blocks to sort Mini blocks 
*		according to order mentionned in PutNewBlockInMemory header :
*		-Size in Increasing order
*		-If 2 block have the same size, put first 
*			-FillBefStart=TRUE  &   FillAftStop=TRUE
*			- then  FillBefStart=TRUE 
*			- then  FillAftStop=TRUE
*			- then others           
*
****************************************************************************/
void smbSort(MemBlockTyp *Tab, int Nb)
{   
	BOOL Change;
	MemBlockTyp Inter;
	int n;             
	do
	{
		Change=FALSE;
		for (n=0; n<Nb-1; n++)
		{ 
			if (Tab[n].Size==Tab[n+1].Size) 
			{
				if ((Tab[n].FillBefStart==Tab[n+1].FillBefStart) && 
					(Tab[n].FillAftStop==Tab[n+1].FillAftStop)) 
					goto nothing;
				if ((Tab[n].FillBefStart==TRUE) && (Tab[n].FillAftStop==TRUE)) 
					goto nothing;
				if ((Tab[n+1].FillBefStart==TRUE) && (Tab[n+1].FillAftStop==TRUE)) 
					{
						Inter=Tab[n];
						Tab[n]=Tab[n+1];
						Tab[n+1]=Inter;
						Change=TRUE; 
						goto nothing;
					}    
				if (Tab[n].FillBefStart==TRUE)
					goto nothing;
				if (Tab[n+1].FillBefStart==TRUE) 
					{
						Inter=Tab[n];
						Tab[n]=Tab[n+1];
						Tab[n+1]=Inter;
						Change=TRUE; 
						goto nothing;
					}  
				if (Tab[n].FillAftStop==TRUE)
					goto nothing;
				if (Tab[n+1].FillAftStop==TRUE) 
					{
						Inter=Tab[n];
						Tab[n]=Tab[n+1];
						Tab[n+1]=Inter;
						Change=TRUE; 
						goto nothing;
					}  
			nothing:
					Change=Change;		//nop
			}
			else if (Tab[n].Size>Tab[n+1].Size) 
			{
				Inter=Tab[n];
				Tab[n]=Tab[n+1];
				Tab[n+1]=Inter;
				Change=TRUE;
			}  
		}
	}
	while (Change);   
}  

/****************************************************************************
*
*	void saSort(assigne *Tab, int Nb)

*	Compare assignement to sort instrument assignement 
*		according to increasing program change number
*
****************************************************************************/
void saSort(assigne *Tab, int Nb)
{   
	BOOL Change;
	assigne Inter;
	int n;

	do
	{
		Change=FALSE;
		for (n=0; n<Nb-1; n++)
		{
			if (Tab[n].mprog==Tab[n+1].mprog) 
			{
				if (Tab[n].mbank>Tab[n+1].mbank)
				{
					Inter=Tab[n];
					Tab[n]=Tab[n+1];
					Tab[n+1]=Inter;
					Change=TRUE;
				}
			}
			else if (Tab[n].mprog>Tab[n+1].mprog) 
			{
				Inter=Tab[n];
				Tab[n]=Tab[n+1];
				Tab[n+1]=Inter;
				Change=TRUE;
			}
		}
	}
	while (Change);

}  


/*********************************************************************************
*
*  BOOL PutSoundBank(NewBloc *BinToAdd,FILE *BinFile,DWORD PcmAlloc[],DWORD ParAlloc[],
*		MemBlDefTyp MemoryBlock[],SndBkDefTyp SndBkDef[],int SndBkNb) 
*	
*	For each pcm page and each parameters page of Binary file (94b) BinFile
*	this function find the best memory place.  
*	update MemoryBlock[BlockNb] and SndBkDef[8]
*	It create a list of structure NewBloc and fill table PcmAlloc and ParAlloc 
*	for future pointer's Rellocation.	                       
*   
*	Return pointer on NewBloc list if succeed, NULL if failed  
*  
*	Call    GetChunkPos					BankDoc
*			CreateMiniBlockMapping
*           
*
***********************************************************************************/
BOOL PutSoundBank(NewBloc *BinToAdd, DWORD BinFile,DWORD PcmAlloc[],DWORD ParAlloc[],
		MemBlDefTyp MemoryBlock[],SndBkDefTyp SndBkDef[],int SndBkNb) 
{
long pos,length, SampleSize; 
int n,nPgPar;
BOOL Samples; 
 

Samples=TRUE;
for (n=0;n<128;n++) PcmAlloc[n]=0;     // Initialise allocation tables
ParAlloc[0]=ParAlloc[1]=0;

// MODIF NO LIMIT (08-98)
if ((pos=GetChunkPos(BinFile,"SIZE",FALSE))==-1)
{
	SampleSize=IN_PAGE_SAMPLE; 
}
else
{
	SampleSize=0;
	if (cSeek(BinFile,pos+8,0)==0xffffffff)
	{
		Trace_Out("error in seeking for samples chunk");
		return FALSE;
	}
	if (!cRead(BinFile, (DWORD) &SampleSize,4))
	{
		Trace_Out("error in reading param length");
		return FALSE;
	} 
}
	
//find position of chunk SAMP 
if ((pos=GetChunkPos(BinFile,"SAMP",FALSE))==-1)
	{
	Samples=FALSE;      
	}  
else
	{       
	// let's get chunk's size  
	if (cSeek(BinFile,pos+4,0)==0xffffffff)
	{
		Trace_Out("error in seeking for samples chunk");
		return FALSE;
	}
	if (!cRead(BinFile, (DWORD) &length,4))
	{
		Trace_Out("error in reading param length");
		return FALSE;
	} 

	pos=pos+8;

		// MODIF NO LIMIT (08-98)
	if (SampleSize == IN_PAGE_SAMPLE)
	{
		for(n=0; n<(int) (length/0x80000);n++)		//full 256kw pages
		{
			BinToAdd[NInBlTable].Size=0x40000; 
			BinToAdd[NInBlTable].PosInSndBk=pos;
			BinToAdd[NInBlTable].Type=0x11+(((n<<4) + SndBkNb)<<8);  
			if (memorAlloc(MemoryBlock,BinToAdd[NInBlTable].Size, BinToAdd[NInBlTable].Type,&(BinToAdd[NInBlTable].Address)))
			{
				Trace_Out("error in memorAlloc");
				return FALSE;
			}
			pos+=0x80000;
			PcmAlloc[n]=BinToAdd[NInBlTable++].Address;	 
		}
		// remaining pcm block (<256k).  
		BinToAdd[NInBlTable].Size=(length%0x80000)/2;         // remaining size in word
		BinToAdd[NInBlTable].PosInSndBk=pos;
		BinToAdd[NInBlTable].Type=0x0011+(((n<<4) + SndBkNb)<<8);    
		if (memorAlloc(MemoryBlock,BinToAdd[NInBlTable].Size, BinToAdd[NInBlTable].Type,&(BinToAdd[NInBlTable].Address)))
			{
				Trace_Out("error in memorAlloc");
				return FALSE;
			}

		PcmAlloc[n]=BinToAdd[NInBlTable++].Address; 
	}

		else
	{
		// MODIF NO LIMIT (08-98)
		// Only one Big Block
		BOOL Found=FALSE;
        DWORD    AllignedAddress;

		BinToAdd[NInBlTable].Size=length/2;         // remaining size in word
		BinToAdd[NInBlTable].PosInSndBk=pos;
		BinToAdd[NInBlTable].Type=0x0011+(((n<<4) + SndBkNb)<<8);    

		// Find a memory block large enough
		n=0;
		do
		{
			while ((MemoryBlock[n+1].Address - MemoryBlock[n].Address < BinToAdd[NInBlTable].Size)
				|| (MemoryBlock[n].Type !=1))  
			{      
				n++; 
				if (MemoryBlock[n].Type ==0xffff)
				{
					Trace_Out("Not enough memory for Large Block");   
					return FALSE;
				}
			}
			Found=TRUE;
            AllignedAddress=MemoryBlock[n].Address;
			if ((MemoryBlock[n].Type !=0xffff) && (SampleSize == MIXTYPE_SAMPLE))
			{		// we need a block alignement of 256 kW
				AllignedAddress=((MemoryBlock[n].Address-1) & 0xfffc0000)+0x40000;
				if (MemoryBlock[n+1].Address - AllignedAddress < BinToAdd[NInBlTable].Size)
				{
					Found=FALSE;		// the block is too small, try another
					n++;
				}
			}
		}
		while (!Found);


		BinToAdd[NInBlTable].Address=AllignedAddress;
		// Construct new memory block
		if (!UpdateMemBlock(MemoryBlock,BinToAdd[NInBlTable]))
			return NULL;
		for(n=0; n<(int) (length/0x80000);n++)		//full 256kw pages
		{
			PcmAlloc[n]=BinToAdd[NInBlTable].Address + n*0x40000;
		}
		if (length%0x80000)
			PcmAlloc[n]=BinToAdd[NInBlTable++].Address + n*0x40000;
	}

	}
//find position of chunk PARA 
if ((pos=GetChunkPos(BinFile,"PARA",TRUE))==-1)
	return FALSE;               
// let's get chunk's size  
if (cSeek(BinFile,pos+4,0)==0xffffffff)
{
	Trace_Out("error in seeking for param chunk");
	return FALSE;
} 
if (!cRead(BinFile,(DWORD) &length,4))
{
	Trace_Out("error in reading param length");
	return FALSE;
} 

pos+=8;
nPgPar=0;
if (length>0x20000)    //More than a 64kw page,
	{                  // first send the first full 64k page   
	BinToAdd[NInBlTable].Size=0x10000; 
	BinToAdd[NInBlTable].PosInSndBk=pos;
	BinToAdd[NInBlTable].Type=0x10+ (SndBkNb<<8);   
	//Insert it in list BinToAdd
	if (memorAlloc(MemoryBlock,BinToAdd[NInBlTable].Size, BinToAdd[NInBlTable].Type,&(BinToAdd[NInBlTable].Address)))
		{
			Trace_Out("error in memorAlloc");
			return FALSE;
		}
	// Construct new memory block	 
	pos+=0x20000; 
	length-=0x20000;
	ParAlloc[nPgPar++]=BinToAdd[NInBlTable++].Address;
	}            
// remaining parameters page (<64k).
if (length>0x20000)    //More than 2 64k page,
	{
	Trace_Out("More than 2 parameters page");   
	return FALSE;
	} 

BinToAdd[NInBlTable].Size=length/2;                // size in word
BinToAdd[NInBlTable].PosInSndBk=pos;
BinToAdd[NInBlTable].Type=0x10+ (SndBkNb<<8) + (nPgPar<<12);   
//Insert it in list BinToAdd
if (memorAlloc(MemoryBlock,BinToAdd[NInBlTable].Size, BinToAdd[NInBlTable].Type,&(BinToAdd[NInBlTable].Address)))
	{
		Trace_Out("error in memorAlloc");
		return FALSE;
	}

ParAlloc[nPgPar++]=BinToAdd[NInBlTable++].Address;
	
return TRUE;
}


/**********************************************************************
*
*   BOOL PutNewBlockInMemory(NewBlock BlockToAdd,CMemoryMap* MemMap)
*	
*	Find the best place to put BlockToAdd in memory.
*		Update th Adress field of BlockToAdd.
* 
*	The Block Table of MemMap is first ordered according to the folowing low.
*		-Size in Increasing order
*		-If 2 block have the same size, put first 
*			-FillBefStart=TRUE  &   FillAftStop=TRUE
*			- then  FillBefStart=TRUE 
*			- then  FillAftStop=TRUE
*			- then others                                                      
*   
*	Return TRUE if succeed, FALSE if failed  
*
*
**********************************************************************/
BOOL PutNewBlockInMemory(NewBloc *BlockToAdd,MemBlockTyp* MemMap)
{
int n=0;

// sort MemoryBlock according to order mentionned in header
smbSort(MemMap,NBlocks);
 
 Trace_Out("loop on mini block");
// First let's see if some not empty 256K page can accept it  
 while ((MemMap[n].Size<BlockToAdd->Size) && (n<NBlocks)) 
	n++;  

Trace_Out("end looping on mini block");
 
if (n>=NBlocks) 
	{
	Trace_Out("Not enough free space on card");  
	return FALSE;
	}  

// if we have find a not empty 256 k page to accept new block or not the treatement is the same.
	// Remark : if it is Parameter block, it must be inside a 64k page.
	// The Mini block selected can't be > 64k, because the corresponding 64 k block
	// would be selected before. So, treatement is the same for parameters or pcm block.
if (MemMap[n].FillBefStart)
	{		//Put NewBlock at the top of mini block 
	BlockToAdd->Address=MemMap[n].Address;
	return TRUE;
	}  
else
	{		// Put it at the end oh the mini block
	BlockToAdd->Address=(MemMap[n].Address+MemMap[n].Size-BlockToAdd->Size);
	return TRUE;
	}	 
}

/*********************************************************************************
*
*  void DeleteMBlock(int pos,MemBlDefTyp MemoryBlock[])  
*	
*	Delete a block in MemoryBlock at position pos
*				
*
***********************************************************************************/  
void DeleteMBlock(int pos,MemBlDefTyp MemoryBlock[])  
{
int n;   

for (n=pos; n<BlockNb-1;n++)
	MemoryBlock[n]=MemoryBlock[n+1];  		// shift every blocks after pos
}  

/*********************************************************************************
*
*  BOOL InsertMBlock(int pos,NewBloc ToAdd,MemBlDefTyp MemoryBlock[])
*	
*	Insert new block ToAdd in MemoryBlock at position pos     
*   
*	Return FALSE if failed  
*				
*
***********************************************************************************/  
BOOL InsertMBlock(int pos,NewBloc ToAdd,MemBlDefTyp MemoryBlock[])  
{
int n,NbBlock=0;   

while ((MemoryBlock[NbBlock].Type!=0xFFFF) && (NbBlock<BlockNb)) NbBlock++; 
if (NbBlock>=BlockNb-1) 
	{
	Trace_Out("No more available bloc in memory blck table. Can't add new bloc."); 
	return FALSE;
	} 
for (n=NbBlock; n>=pos;n--)
	MemoryBlock[n+1]=MemoryBlock[n];  		// shift every blocks after pos
MemoryBlock[pos].Address=ToAdd.Address;
MemoryBlock[pos].Type=ToAdd.Type;  
return TRUE;
}


/*********************************************************************************
*
*  BOOL UpdateMemBlock(MemBlDefTyp MemoryBlock[],NewBloc ToAdd)
*	
*	Update memory mapping information contained in MemoryBloc, with new block ToAdd.     
*   
*	Return FALSE if failed  
*  
*	Call    DeleteMBlock
*			InsertMBlock				
*
***********************************************************************************/  
BOOL UpdateMemBlock(MemBlDefTyp MemoryBlock[],NewBloc ToAdd)
{
long NextAdd;
int n=1;
BOOL InTheBegin=FALSE,InTheEnd=FALSE;

// go up to the next bloc.
while ((MemoryBlock[n].Address<=ToAdd.Address) && (n<BlockNb) && (MemoryBlock[n].Type!=0xffff)) n++;
if (n==BlockNb) 
	{
	Trace_Out("End of memory mapping Table (0xFFFF) not found"); 
	return FALSE;
	}     
n-=1;		//  MemoryBlock[n] is the bloc in which we have added new bloc

NextAdd=MemoryBlock[n+1].Address;       // there is a bloc after
		
// Do some easy verification
if ((MemoryBlock[n].Type!=1) || (ToAdd.Address+ToAdd.Size > NextAdd))
	{		// It was not a free block or block too small for Block to Add!

	Trace_Out("BUG! The block chosen doesn't match!");     
	return FALSE;
	}
// See If new block is added at the begin of a free bloc
if (MemoryBlock[n].Address==ToAdd.Address)
	 InTheBegin=TRUE;
// See If new block is added at the end of a free bloc
if (ToAdd.Address+ToAdd.Size == NextAdd)
	 InTheEnd=TRUE;                
// If the new block fill the whole old block, just change type
if ((InTheBegin) && (InTheEnd))
	{	    
	MemoryBlock[n].Type=ToAdd.Type;
	return TRUE;
	}
// If the block is added in the begin
if (InTheBegin)	
	{
	MemoryBlock[n].Address=ToAdd.Address+ToAdd.Size;	// new begin of free block
	if (MemoryBlock[n-1].Type != ToAdd.Type)  // if not the same type than the previous block
		if (!InsertMBlock(n,ToAdd,MemoryBlock))      // add a new block
			return FALSE; 
    return TRUE;
	}    
// If the block is added in the end
if (InTheEnd)	
	{            
	if (MemoryBlock[n+1].Type == ToAdd.Type)  // ifthe same type than the next block  
		MemoryBlock[n+1].Address=ToAdd.Address;		//   just enlarge it
	else
		if (!InsertMBlock(n+1,ToAdd,MemoryBlock))      // add a new block
			return FALSE; 
    return TRUE;
	}   
// In the middle of the block
if (!InsertMBlock(n+1,ToAdd,MemoryBlock))      // add the new block
	return FALSE; 
// add a new block for remaining free space behind  new block 
ToAdd.Address=ToAdd.Address+ToAdd.Size;
ToAdd.Type=1;	//Free block
if (!InsertMBlock(n+2,ToAdd,MemoryBlock))      
	return FALSE;	
return TRUE;
} 


/***************************************************************************************
*
*  BOOL AddAssign(assigne Tab,assigne BkUpTab,BYTE MidiPr,BYTE var,WORD Pointer,WORD offset,
*					BYTE SndBknb,SndBkDefTyp SndBkDef[],WORD prio,int *nTab,int *nTabBk)
*	
*	Update Tab and BkUpTab with a new assignement. If MidiProg and variation is already 
*		affected, keep the one with higher priority in Tab and put the other in BkUpTab     
*   
*	Return FALSE if failed 
*
*
*****************************************************************************************/    
BOOL AddAssign(assigne Tab[],assigne BkUpTab[],BYTE MidiPr,BYTE var,WORD Pointer,WORD offset,
					BYTE SndBknb,SndBkDefTyp SndBkDef[],WORD prio,int *nTab,int *nTabBk)
{ 
int n;
BOOL found=FALSE;
// Is prog change and variation already allocated in Tab
for(n=0;n<*nTab;n++)
	{
	if ((Tab[n].mprog==MidiPr) && (Tab[n].mbank==var))
		{ 
		found=TRUE;
		if (SndBkDef[Tab[n].page >> 1].Prio>prio)
			{        // the midi prog and variation is already allocated with a higher priority
			// so put it in back up table
			BkUpTab[*nTabBk].mprog=MidiPr;
			BkUpTab[*nTabBk].mbank=var;
			BkUpTab[*nTabBk].page=SndBknb;
			BkUpTab[(*nTabBk)++].pointer=Pointer+offset;  
			}
		else
			{	// the midi prog and variation is already allocated with a lower priority
			// so put old in back up table and replace it with the new in table
			BkUpTab[*nTabBk].mprog=Tab[n].mprog;
			BkUpTab[*nTabBk].mbank=Tab[n].mbank;
			BkUpTab[*nTabBk].page=Tab[n].page;
			BkUpTab[(*nTabBk)++].pointer=Tab[n].pointer; 
			
			Tab[n].mprog=MidiPr;
			Tab[n].mbank=var;
			Tab[n].page=SndBknb;
			Tab[n].pointer=Pointer+offset;  
			}
		}
	}
if (!found)	
	{
	// the midi prog and variation isn't already allocated
	// add it to table 
	Tab[*nTab].mprog=MidiPr;
	Tab[*nTab].mbank=var;
	Tab[*nTab].page=SndBknb;
	Tab[(*nTab)++].pointer=Pointer+offset;  
	}
return TRUE;
}


/***************************************************************************************
*
*  BOOL CreateInsMap(WORD *MidiMapping,assigne InstTab[],assigne InstBkUpTab[],assigne DrumTab[],
*			int SndBkNb,assigne DrumBkUpTab[],int nInst,int nInstBk,
*			int nDrm,int nDrmBk))  
*	
*	Invert SplitInsMap. Update Midi Mapping Table with information in tables.  
*   
*	Return FALSE if failed 
*
*
*****************************************************************************************/    
BOOL CreateInsMap(WORD *MidiMapping,assigne InstTab[],assigne InstBkUpTab[],assigne DrumTab[],
			assigne DrumBkUpTab[],int nInst,int nInstBk,int nDrm,int nDrmBk,WORD MMoffset)  
{
int n;
int MidiProg=0,nI=0,nB=0;

// let's put drumset table
int p=145;		// drumset table position

Trace_Out("Create ins map");
for (n=0;n<nDrm;n++)
	{
	MidiMapping[p++]=(WORD) DrumTab[n].mprog;     
	MidiMapping[p++]=(WORD) ((DrumTab[n].page)<<8)+DrumTab[n].mbank;
	MidiMapping[p++]=DrumTab[n].pointer;  
	}  
MidiMapping[p++]=0xffff;     //end of drumset
for (n=0;n<nDrmBk;n++)
	{
	MidiMapping[p++]=(WORD) DrumBkUpTab[n].mprog;     
	MidiMapping[p++]=(WORD) ((DrumBkUpTab[n].page)<<8)+DrumBkUpTab[n].mbank;
	MidiMapping[p++]=DrumBkUpTab[n].pointer;  
	}  
MidiMapping[p++]=0xffff;	// end of back up drumset     
MidiMapping[p++]=0xffff;    // end of bloc

//Let's put instrument table
		

for (n=17; n<145;n++)		// for every instrument table pointer place
	{
	MidiMapping[n]=p+MMoffset;
	while ((InstTab[nI].mprog==MidiProg) && (nI<nInst))  
		{			
		MidiMapping[p++]=(WORD) ((InstTab[nI].page)<<8)+InstTab[nI].mbank;		
		MidiMapping[p++]=InstTab[nI++].pointer;  
		}   
	MidiMapping[p++]=0xffff;	// end of instrum def   
	while ((InstBkUpTab[nB].mprog==MidiProg) && (nB<nInstBk))   
		{ 
		MidiMapping[p++]=(WORD) ((InstBkUpTab[nB].page)<<8)+InstBkUpTab[nB].mbank;
		MidiMapping[p++]=InstBkUpTab[nB++].pointer;  
		}      
	MidiMapping[p++]=0xffff;	// end of backup instrum def 
	MidiProg++;  
	}
MidiMapping[0]=p;			// total table length
return TRUE;                                     
} 


/**********************************************************************************
*
*   BOOL ChunkCmp(char buffer[], const char Name[])
*
*	Find position in the file stream, of the chunk name. Skip all previous chunk.
* 
*	Return the position or -1 if an error occurs.
*
*
*******************************************************************************/ 
BOOL ChunkCmp(char buffer[], const char Name[])
{ 
if ((buffer[0]!=Name[0]) || (buffer[1]!=Name[1]) || (buffer[2]!=Name[2]) ||
	   (buffer[3]!=Name[3]))
	return FALSE;
return TRUE;
}

/**********************************************************************************
*
*   long GetChunkPos(DWORD stream,const char ChunkName[]BOOL ErrMsg))
*
*	Find position in the file stream, of the chunk name. Skip all previous chunk.
* 
*	Return the position or -1 if an error occurs.
*
*
*******************************************************************************/ 
long GetChunkPos(DWORD stream,const char ChunkName[],BOOL ErrMsg)
{ 
long pos=0,length; 
char buffer[5];


if (cSeek(stream,0,0)==0xffffffff)				//rewind
	{
		Trace_Out("error in rewind");
		return -1;
	}	
if (!cRead(stream,(DWORD) buffer,4))
	{
		if (ErrMsg) 
		{
			Trace_Out("error in reading chunk name");
		}
		return -1;
	}

pos+=4;  	
while (!ChunkCmp(buffer,ChunkName))
	{
    if (!ChunkCmp(buffer,"RMID"))
	{                          
		// chunk length?
		if (!cRead(stream,(DWORD) &length,4))
		{
			Trace_Out("error in reading chunk length");
			return -1;
		}

		pos+=4;

		if ( (!ChunkCmp(buffer,"RIFF")) && (!ChunkCmp(buffer,"drsb")) )
		{      
		//Trace_Out("not RIFF nor drsb");
			// Skip chunk
			if (cSeek(stream,length,1)==0xffffffff)				//rewind
			{
				Trace_Out("error in skipping chunk");
				return -1;
			}	
			pos+=length;
		}
	}
	if (!cRead(stream,(DWORD) buffer,4))
	{
		if (ErrMsg) 
		{
			Trace_Out("error in reading chunk name");
		}
		return -1;
	}

	pos+=4;
	}  
//pindex point on "chunk
pos-=4;
return pos;
} 



/**********************************************************************
*
*   MemBlockTyp *AddBlock(MemBlockTyp *MemMaplong Address, long Size,long StartBigBlock,long StopBigBlock)
*	
*	Add a Mini Block in BlockTable                                                        
*	if Address==StartBigBlock (beginning of free block) FillBefStart is set to TRUE
*   if Address+Size-1==StopBigBlock (end of free block) FillAftStop  is set to TRUE
*
**********************************************************************/    
MemBlockTyp *AddBlock(MemBlockTyp *MemMap,long Address, long Size,long StartBigBlock,long StopBigBlock)
{

if (NBlocks==NInTable)
	{   // BlockTable is full, realloc it  
	/*NInTable+=256;
	MemMap=(MemBlockTyp*) _PageReAllocate((ULONG) MemMap,(ULONG) (NInTable/256),0);
	if (MemMap==NULL)
		return NULL;*/
	Trace_Out("Too much memory : MemMap too small. Increase it in source code");
	__asm int 3		//###
	return NULL;
	}
MemMap[NBlocks].Address=Address; 
MemMap[NBlocks].Size=Size;  
if (Address==StartBigBlock)			// beginning of the free block
	MemMap[NBlocks].FillBefStart=TRUE;
else
    MemMap[NBlocks].FillBefStart=FALSE;       

if (Address+Size-1==StopBigBlock)			// end of the free block
	MemMap[NBlocks].FillAftStop=TRUE;
else
    MemMap[NBlocks].FillAftStop=FALSE;
NBlocks++;
return MemMap;
}


/****************************************************************************
*
*	int LoadRelloc(RellocTyp RLocBuf[],int *InRelloc,long *LocLength,FILE *stream)
*
*	load RLocBuf with up to 300 relloc structure from file stream at position
*	InRelloc. Update InRelloc, LocLength (number of relloc structure remaining in stream)
*	
*	return nb of relloc structure copied
*
****************************************************************************/
int LoadRelloc(RellocTyp RLocBuf[],long *InRelloc,long *LocLength,DWORD stream)
{  
long ll;

if (cSeek(stream,*InRelloc,0)==NULL)
{
	Trace_Out("can't seek relloc");
	return 0;
}
//load up to 300 Relloc structure
if (*LocLength>300)
{
	if (!cRead(stream,(DWORD) RLocBuf,1800))
	{
		Trace_Out("error in cRead->0");
		return 0;
	}
ll=300;
}
else 
{
	if (!cRead(stream,(DWORD) RLocBuf,(*LocLength)*6))
		{
			Trace_Out("error in cRead->0");
			return 0;
		}
	ll=*LocLength;
}  
*LocLength-=ll; 
*InRelloc+=ll*6;		//new position in stream
return (int) ll;
}

/***********************************************************************
*	
*	int mstrcmp(char *str1,char *str2)
*
* return 0 if strings are equal
*
**************************************************************************/
int mstrcmp(char *str1,char *str2)
{
int n=0;

while ((str1[n]!=0) && (str1[n]==str2[n]))
	n++;
if ((str1[n]==0) && (str2[n]==0))
	return 0;
else
	return 1;
}


/**********************************************************************
*
*   BOOL CreateMiniBlockMapping(MemBlDefTyp MemoryBlock[], MemBlockTyp *  MemMap)
*	
*	Convert the memory block definition in a usuable memory mapping in Mini 
*		Block. Mini blocks take account of page boundaries. For example, a free
*		block from 000000a8 to 00080050 will be split in   mini block.
*			- a8		->		ffff           (64k boundary)
*			- 10000		->		1ffff            "
*			- a8		->		1ffff            "    
*			- 20000     ->		2ffff            "
*			- a8		->		2ffff            "
*			- 30000		->		3ffff            "
*			- a8		->		3ffff          (256k boundary)
*			- 40000		->		7ffff			 "
*			- 80000		->		80050                                                         
*   
*	Return TRUE if succeed, FALSE if failed  
*
*		Call :	AddBlock     -CMemoryMap function
*
**********************************************************************/          
MemBlockTyp* CreateMiniBlockMapping(MemBlDefTyp MemoryBlock[], MemBlockTyp *MemMap)
{
DWORD Start,Stop,Page64,Page256,StartMiniBlock; 
WORD Type;
int n, nn;
long MemorySize=MemoryBlock[0].Address;

if (MemoryBlock[0].Type!=0)  
	{
	Trace_Out("Error in Memory Block Definition, memory size type not found");   
	return NULL;
	}

n=1;
while ((n<BlockNb) && ((Type=MemoryBlock[n].Type)!=0xffff))		// see each block of memory mapping
	{
	if (Type==1)				// It is a Free block
		{
		Start=MemoryBlock[n].Address;             // start of the block
		Stop=MemoryBlock[n+1].Address-1;      // end of the block
		StartMiniBlock=Start;
		Page64=(StartMiniBlock & 0xffff0000);    //Page of start address
		if ((Stop & 0xffff0000)==Page64)
		{					// No 64k page change
			if ((MemMap=AddBlock(MemMap,StartMiniBlock,Stop-StartMiniBlock+1,Start,Stop))==NULL) //just 1 Mini block
				return NULL;
		}
		else  
		    { 
			int n64KPg;

		    Page64+=0x00010000;		// increment 64k page number
		    if ((MemMap=AddBlock(MemMap,StartMiniBlock,Page64-StartMiniBlock,Start,Stop))==NULL) //  first Mini block, up to 64k page limit
				return NULL;
				//How many 64K Pages (up to 256K Page change)?
		    n64KPg=0;
		    while ((((Stop+1) & 0xffff0000)!=Page64) &&  		// Loop till not end of block in the same 64 K Page...
		    		((Page64 % 0x40000)!=0))            //	... and not a 256k page change
		    	 {       
		    	 if ((MemMap=AddBlock(MemMap,Page64,0x10000,FALSE,FALSE))==NULL) // free 64k page
		    		return NULL;
				 Page64+=0x00010000;		// increment 64k page number
		         if ((MemMap=AddBlock(MemMap,StartMiniBlock,Page64-StartMiniBlock,Start,Stop))==NULL) // first free space + every free 64k pages
					return NULL;
					 n64KPg++;
		         } 
		     // Add block containig one or several 64k free page

		    for (nn=2; nn<=n64KPg;nn++)
		        if ((MemMap=AddBlock(MemMap,Page64-nn*0x10000,nn*0x10000,Start,Stop))==NULL)
					return NULL;
		    if ((Page64 & 0x0003FFFF)==0) 
		    	{                     		// 256k page change
		    	//How many 256K Pages (up to 256K Page change)?
		    	Page256=Page64;
			    while (((Stop+1) & 0xfffc0000)!=Page256) 		// Loop till not end of block in the same 256k page...
			    	 {       
			    	 if ((MemMap=AddBlock(MemMap,Page256,0x40000,Start,Stop))==NULL) // free 256k page
			    		return NULL;
					Page256+=0x00040000;		// increment 256k page number
			         }  
			    //How many free 64K Pages (till the end)? 
			    Page64=Page256;
			    n64KPg=0;
			    while (((Stop+1) & 0xffff0000)!=Page64)  		// Loop till not end of block in the same 64 K Page...
			    	 {                                  
			    	 if ((MemMap=AddBlock(MemMap,Page64,0x10000,Start,Stop))==NULL) // free 64k page
			    		return NULL;
					Page64+=0x00010000;		// increment 64k page number
			         if ((MemMap=AddBlock(MemMap,Page256,Page64-Page256,Start,Stop))==NULL) // free space from end of 256k page
						return NULL;
					n64KPg++;
			         }     
			   // Add block containig one or several 64k free page
			    for (nn=2; nn<=n64KPg;nn++)
			        if ((MemMap=AddBlock(MemMap,Page64-nn*0x10000,nn*0x10000,Start,Stop))==NULL)
						return NULL;
		    	} // end 256k page change
		    //Last Bloc, from last 64k page boundary to the end
		    if (Stop>Page64)
		    	if ((MemMap=AddBlock(MemMap,Page64,Stop-Page64+1,Start,Stop))==NULL) // last mini block
					return NULL;
		    }  //end else 64k page change
		 }	//End free bloc
		 // if not a free bloc, we do nothing 
	n++;
	};		// end while   
return MemMap;                                  
}

/***************************************************************************************
*
*  void RemoveAssign(int pos,assigne Tab[],int *nTab)
*	
*	Remove an element of the array Tab.
*
*****************************************************************************************/    
void RemoveAssign(int pos,assigne Tab[],int *nTab)
{
int n;

for (n=pos;n<*nTab;n++)
	Tab[n]=Tab[n+1];
(*nTab)--;
}

/***************************************************************************************
*
*  int IsInBkUp(BYTE mprog,BYTE mbank,assigne BkUpTab[],int *nTabBk,SndBkDefTyp SndBkDef[]) 
*	
*	Search in BkUpTab an instrum for midi program=mprog and variation=mbank
*   If found, return number of the instrument in BkUpTab, else return -1
*
*
*****************************************************************************************/    		
int IsInBkUp(BYTE mprog,BYTE mbank,assigne BkUpTab[],int *nTabBk,SndBkDefTyp SndBkDef[])
{
int n,mm=-1;
WORD prio=0;

for(n=0;n<*nTabBk;n++)
	{
	if ((BkUpTab[n].mprog==mprog) && (BkUpTab[n].mbank==mbank))
		if (SndBkDef[BkUpTab[n].page >> 1].Prio >= prio)
			{
			prio=SndBkDef[BkUpTab[n].page >> 1].Prio;
			mm=n;
			}
	}
return mm;
}


/***************************************************************************************
*
*	BOOL ChangePriority(assigne Tab[],assigne BkUpTab[],BYTE SndBkNb,
*		WORD Prio,SndBkDefTyp SndBkDef[],int *nTab,int *nTabBk)
*	
*	Modify instruments played according to priority.
*   
*	Return FALSE if failed 
*
*
*****************************************************************************************/    
BOOL ChangePriority(assigne Tab[],assigne BkUpTab[],BYTE SndBkNb,
		WORD Prio,SndBkDefTyp SndBkDef[],int *nTab,int *nTabBk)
{ 
int n,mm;


// for each instrument in the table, we see if there is an instrum
// in the bk up table with higher priority
for(n=(*nTab)-1;n>=0;n--)
{
	if ((mm=IsInBkUp(Tab[n].mprog,Tab[n].mbank,BkUpTab,nTabBk,SndBkDef))>=0) 
	{	
		// if the new priority of the BkUp instrument is greater than
		// the new priority of instrument, let's swap them
		if ((SndBkDef[BkUpTab[mm].page >> 1].Prio) > (SndBkDef[Tab[n].page >> 1].Prio))
		{
			BYTE PgTemp;
			WORD PtTemp;

			PgTemp=Tab[n].page;
			PtTemp=Tab[n].pointer;
			Tab[n].page=BkUpTab[mm].page;
			Tab[n].pointer=BkUpTab[mm].pointer;
			BkUpTab[mm].page=PgTemp;
			BkUpTab[mm].pointer=PtTemp;
		}
	}  
}
return TRUE;
}



/***************************************************************************************
*
*  BOOL DelAssign(assigne Tab[],assigne BkUpTab[],BYTE SndBknb,
*		SndBkDefTyp SndBkDef[],int *nTab,int *nTabBk)
*	
*	Remove every instrument of SndBk from BkUpTab and Tab. If there is in BackUpTab
*   an available back up instrument for this midi prog. & variation it replace 
*	the one removed.	
*   
*	Return FALSE if failed 
*
* 	Call :	RemoveAssign  
*			IsInBkUp  
*
*****************************************************************************************/    
BOOL DelAssign(assigne Tab[],assigne BkUpTab[],BYTE SndBkNb,
		SndBkDefTyp SndBkDef[],int *nTab,int *nTabBk)
{ 
int n,mm;

// First remove every instrum of the deleted sound bank in BkUpTab   
for(n=(*nTabBk)-1;n>=0;n--)
	{
	if ((BkUpTab[n].page>>1)==SndBkNb)
		RemoveAssign(n,BkUpTab,nTabBk);
	} 
// Remove from Tab
for(n=(*nTab)-1;n>=0;n--)
	{
	if (Tab[n].page>>1==SndBkNb)
		{ 
		if ((mm=IsInBkUp(Tab[n].mprog,Tab[n].mbank,BkUpTab,nTabBk,SndBkDef))>=0) 
			{		// There is an available back up instrument for this midi prog. & variation
	                // so, replace instr. to remove
			Tab[n].page=BkUpTab[mm].page;
			Tab[n].pointer=BkUpTab[mm].pointer;
			RemoveAssign(mm,BkUpTab,nTabBk);  
			}  
		else
			// no available instr in back up
			RemoveAssign(n,Tab,nTab);
		}
	}
return TRUE;
}


/*****************************************************************
*  
*  int vxdAlloc(long vSize, WORD vType,long *vAddress)
*
*	allocate a memory space in 9407 board. Call by API_Mem_Alloc API
*   
*	return 0 if succeed, error code if failed
*******************************************************************/
int vxdAlloc(long vSize, WORD vType,long *vAddress)
{
MemBlDefTyp MemoryBlock[64];
SndBkDefTyp SndBkDef[8]; 
DWORD read,MBAdd;
int n=0,ret;

// first go in uart mod, if not already
if (!DrvOwn)
{
	WriteP16(gwBaseMPU401,UART_MOD,1);
	do
		read=MPU401_Command_Read(gwBaseMPU401);	// wait acknowledge   
	while ((read!=0xfe) && (n++<2));
	if (read!=0xfe)
		{
		Trace_Out("Can't go in UART mode");
		return DREAMERR_UNREF;                         
		} 
}
if (!GetMemoryMapping(gwBaseMPU401,MemoryBlock,SndBkDef))
{
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_ABORT;
}

ret=memorAlloc( MemoryBlock, vSize,  vType, vAddress);

if (ret==0)
{
	// update the mmt
	MBAdd=GetMemMapAddress(gwBaseMPU401); 
	if (DownLoad(gwBaseMPU401,MemoryBlock,(WORD) (MBAdd >> 16),(WORD) (MBAdd & 0xffff),(WORD) MemBlockSize))
		{                        
		Trace_Out("Error in loading MemoryMapping in card");
		if (!DrvOwn)
			WriteP16(gwBaseMPU401,0xff,1);	//reset
		return DREAMERR_UNREF;
		}   
} 
if (!DrvOwn)
	WriteP16(gwBaseMPU401,0xff,1);	//reset
Trace_Out(" go into ff");
return ret;
}   


/*****************************************************************
*  
*  int vxdFree(long Address)
*
*	free a memory space in 9407 board.
*                                        
*	return 0 if succeed, error code if failed
*******************************************************************/
int vxdFree(long Address)
{
MemBlDefTyp MemoryBlock[64];
SndBkDefTyp SndBkDef[8]; 
DWORD read,MBAdd;
int n=0,ret;


Trace_Out("VXD free");
// first go in uart mod
if (!DrvOwn)
{
	WriteP16(gwBaseMPU401,UART_MOD,1);
	do
		read=MPU401_Command_Read(gwBaseMPU401);	// wait acknowledge   
	while ((read!=0xfe) && (n++<2));
	if (read!=0xfe)
		{
		Trace_Out("Can't go in UART mode");
		return DREAMERR_UNREF;                         
		} 
}
if (!GetMemoryMapping(gwBaseMPU401,MemoryBlock,SndBkDef))
{
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_ABORT;
}

Trace_Out("go to memor free");
ret=memorFree( MemoryBlock, Address);    
Trace_Out("ret from memor free");  

if (ret==0)
{    
	MBAdd=GetMemMapAddress(gwBaseMPU401);
	// update the mmt 
	if (DownLoad(gwBaseMPU401,MemoryBlock,(WORD) (MBAdd >> 16),(WORD) (MBAdd & 0xffff),(WORD) MemBlockSize))
		{                        
		Trace_Out("Error in loading MemoryMapping in card");
		if (!DrvOwn)
			WriteP16(gwBaseMPU401,0xff,1);	//reset
		return DREAMERR_UNREF;
		}   
} 
if (!DrvOwn)
	WriteP16(gwBaseMPU401,0xff,1);	//reset
Trace_Out(" go into ff");
return ret;
}


/*****************************************************************
*  
*  int memorAlloc(MemBlDefTyp MemoryBlock[],long vSize, WORD vType,long *vAddress)
*
*	allocate a memory space in 9407 board. 
*
*******************************************************************/
int memorAlloc(MemBlDefTyp MemoryBlock[],long vSize, WORD vType,long *vAddress)
{
	NewBloc ToAdd;
	MemBlockTyp *MemMap;
	int ret;
	
if (vSize>0x40000)		//>256kW
{
	// let's seek the first block than can accept it
	int n=1;
	ret=0;
	do
	{
		if ((MemoryBlock[n].Type==1) && 
			(MemoryBlock[n+1].Address-MemoryBlock[n].Address > vSize))
			break;
		n++;
	}
	while (n<BlockNb-1);
	if (n<BlockNb-1)
	{	// the block is found
		//		let's update the mmt
		NewBloc ToAdd;
		ToAdd.Address=MemoryBlock[n].Address;
		ToAdd.Size=vSize;
		ToAdd.Type=vType;

		*vAddress=MemoryBlock[n].Address;

		if (!UpdateMemBlock(MemoryBlock,ToAdd))
			ret=DREAMERR_UNREF;

	}
	else
		ret=DREAMERR_OUTOFMEM;
	return ret;
}



	if ((MemMap=_PageAllocate(1,PG_SYS,0,0,1,1,0,0))==NULL)
	{
		Trace_Out("Can't allocate MemMap");
		return DREAMERR_OUTOFMEM;
	}
	Trace_Out("Allocate memmap");
	NBlocks=0;
	NInTable=256;

	if((MemMap=CreateMiniBlockMapping(MemoryBlock,MemMap))==NULL)
		{
		Trace_Out("Error in spliting Memory Mapping");  
		return DREAMERR_UNREF;
		} 
	Trace_Out("Mini block created");
	ToAdd.Size=vSize;
	ToAdd.Type=vType;
	//Insert it in list BinToAdd
	if (!PutNewBlockInMemory(&ToAdd,MemMap))
		return DREAMERR_OUTOFMEM; 
	Trace_Out("vaddress to be filled");
	*vAddress=ToAdd.Address; 
	Trace_Out("vaddress filled");
	// Construct new memory block
	if (!UpdateMemBlock(MemoryBlock,ToAdd))
		return DREAMERR_UNREF;
    Trace_Out("update mm ok");
	if (!(_PageFree( MemMap,0)))
	{
		Trace_Out("free memmap fail");
	}
	return 0;		//succeed
}

 
/*****************************************************************
*  
*  int memorFree(MemBlDefTyp MemoryBlock[],long Address)
*
*	free a memory space in 9407 board. 
*
*******************************************************************/
int memorFree(MemBlDefTyp MemoryBlock[],long Address)
{  
	int n=0;
	// first, research the block to delete
	n=0;
	while ((MemoryBlock[n]. Address!=Address) && (n<BlockNb)) 
		n++;
	if (n==BlockNb)
		return DREAMERR_INVADD;
	if (MemoryBlock[n-1].Type==1)
	{
		DeleteMBlock(n, MemoryBlock); 
		n-=1;
	}
	else
		MemoryBlock[n].Type=1; 
		
	//	MemoryBlock[n].Type=1  !
	
	if (MemoryBlock[n+1].Type==1)
		DeleteMBlock(n+1, MemoryBlock); 
	Trace_Out("memor free ok");		
	return 0;		//succeed    
}  



/*****************************************************************
*  
*  int vxdLoadSB(DWORD SbName,WORD NameOffset)
*
*	load a sound bank in memory board
*                                        
*	return sb nb if succeed, 0x10 + ERROR code if error
*******************************************************************/
int vxdLoadSB(DWORD SbName,WORD NameOffset)
{
DWORD hSound,read;
int n=0, sbnb;

Trace_Out("bankload");
// first go in uart mod
if (!DrvOwn)
{
	WriteP16(gwBaseMPU401,UART_MOD,1);
	do
		read=MPU401_Command_Read(gwBaseMPU401);	// wait acknowledge   
	while ((read!=0xfe) && (n++<2));
	if (read!=0xfe)
		{
		Trace_Out("Can't go in UART mode");
		return 0x10 + DREAMERR_UNREF;                         
		}  
}

// Send sysex GM reset
WriteP16(gwBaseMPU401,0xf0,0);
WriteP16(gwBaseMPU401,0x7e,0);
WriteP16(gwBaseMPU401,0x7f,0);
WriteP16(gwBaseMPU401,0x09,0);
WriteP16(gwBaseMPU401,0x01,0);
WriteP16(gwBaseMPU401,0xf7,0);
WriteP16(gwBaseMPU401,UART_MOD,1);
//Let's wait for the sam to reset
n=0;
do
	read=MPU401_Command_Read(gwBaseMPU401);	// wait acknowledge   
while ((read!=0xfe) && (n++<2));
if (read!=0xfe)
	{
	Trace_Out("Can't go in UART mode");
	return 0x10+DREAMERR_UNREF;                         
	}  

        
hSound=cOpen(SbName,NameOffset);    
Trace_Out("sb file openned");
if (!hSound)
	{
	Trace_Out("Error in openning sound bank!");
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return 0x10 + DREAMERR_FILE_NOT_FOUND;                         
	} 
// Before sending Sound Bank, we check if it isn't a .rmi without sound bank
if ( (GetChunkPos(hSound,"RMID",FALSE)!=-1) && (GetChunkPos(hSound,"drsb",FALSE)==-1))
{
	Trace_Out("RMI without dream sound bank");
	return DREAMERR_FILE_NOT_FOUND;  
} 


if ((sbnb=SendNewSoundBank(hSound,gwBaseMPU401))>8)  // send sound bank     
	{     
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return 0x10+DREAMERR_UNREF;  
	} 
if (!DrvOwn)
	WriteP16(gwBaseMPU401,0xff,1);	//reset
cClose(hSound); 
return sbnb;
}

/*****************************************************************
*  
*  int cvReInit()
*
*	For CodeView97
*	load init firmware and bank
*                                        
*	return 0 if succeed, error code if failed
*******************************************************************/
int cvReInit()
{
	DWORD hFirm,hSound;

	WriteP16(gwBaseMPU401,9,1);   // command go
	WriteP16(gwBaseMPU401,0x00,1);    
	WriteP16(gwBaseMPU401,0x00,1);  

	TempoInit(gwBaseMPU401);	// wait 200 ms  


	loadBoot(gwBaseMPU401);		

	Trace_Out("load Firmware");
	hFirm=cOpen((DWORD) FirmName,0);
	if (!hFirm)
	{
		Trace_Out("error in loading firmware");
		registryDebug("VxDerr","no FW File");	//Dream no GenINT
		return 1;
	}
	if (!LoadFirmware(hFirm,gwBaseMPU401))  // send sound bank     
		{
		cClose(hFirm);          
		return 2;  
		} 
	cClose(hFirm); 

	if (!switchUART(gwBaseMPU401))
	{
		Trace_Out("UART FAIL");
	}


	hSound=cOpen((DWORD) SoundName,0); 
	if (!hSound)
	{
		Trace_Out("error in loading sb");
		registryDebug("VxDerr","no SB File");	//Dream no GenINT
		return 3;
	}
	if (SendNewSoundBank(hSound,gwBaseMPU401)>8)  // send sound bank 
	{
		Trace_Out("error in loading sb");
		cClose(hSound);
		WriteP16(gwBaseMPU401,0xff,1);	//reset
		return 4;
	}  		
	cClose(hSound);

	WriteP16(gwBaseMPU401,0xff,1);	//reset

	return 0;
}


/*****************************************************************
*  
*  int vxdLoadFW(DWORD FwName,WORD NameOffset)
*
*	load a firmware program in 9407 board
*                                        
*	return 0 if succeed, error code if failed
*******************************************************************/
int vxdLoadFW(DWORD FwName,WORD NameOffset)
{
DWORD hFirm,read;
int n=0;

Trace_Out("load firmware api");
// first go in uart mod
if (!DrvOwn)
{
	WriteP16(gwBaseMPU401,UART_MOD,1);
	do
		read=MPU401_Command_Read(gwBaseMPU401);	// wait acknowledge   
	while ((read!=0xfe) && (n++<2));
	if (read!=0xfe)
		{
		Trace_Out("Can't go in UART mode");
		return DREAMERR_UNREF;                         
		} 
}
hFirm=cOpen(FwName,NameOffset);    
Trace_Out("fw file openned");
if (!hFirm)
	{
	Trace_Out("Error in openning firmware file!");
	return DREAMERR_FILE_NOT_FOUND;                         
	}               

// Is the card present with a running program
	WriteP16(gwBaseMPU401,GEN_INT,1);
	WriteP16(gwBaseMPU401,0,0); 
	
	Trace_Out(" gen int");
	n=0;
	while (((read=MPU401_Command_Read(gwBaseMPU401))>0x1000) && (n<3)) 
	{                              
		n++;
	}
	

	if (read==0x88)    // the gm program is running
		{ 
			MemBlDefTyp MemoryBlock[64];
			SndBkDefTyp SndBkDef[8]; 

			Trace_Out(" prog run");
			// first, we have to check if the program (@200h) is in ROM
			//		Thus, let's dowload the MMT   
			if (GetMemoryMapping(gwBaseMPU401,MemoryBlock,SndBkDef))
			{
				n=1;
				while (MemoryBlock[n].Address<0x200)
					n++;
				if (MemoryBlock[n-1].Type & 0x80) // Prog. in rom
					{
					Trace_Out("prog in rom");
					return DREAMERR_UNREF;                     // let's do nothing
					}  
			}
			// The program is in RAM
			// 	let's reset the board  
			Trace_Out("hot reset");
			WriteP16(gwBaseMPU401,HOT_RESET,1); 
			WriteP16(gwBaseMPU401,0x11,0);  
			
			n=0;
			while (((read=MPU401_Command_Read(gwBaseMPU401))!=0) && (n<10))
			{
				n++;
			}   
			if (read!=0)
				return DREAMERR_UNREF;
		}
	loadBoot(gwBaseMPU401);	

	// wait acknowledge
	{
		DWORD CnfWord=0;

		WriteP16(gwBaseMPU401,4,1); 
		WriteP16(gwBaseMPU401,0,1); 
		n=0;

		while ((n<4) && ((read=MPU401_Command_Read(gwBaseMPU401))>0x1000)) 
			n++; 
		if (read>0x1000) 
		{
			Trace_Out("no card?");
			return DREAMERR_UNREF;
		}
		CnfWord=read;
		n=0;
		while ((n<4) && ((read=MPU401_Command_Read(gwBaseMPU401))>0x1000)) 
			n++; 
		if (read>0x1000) 
		{
			Trace_Out("no card?");
			return DREAMERR_UNREF;
		}
		CnfWord+=read<<8;
		CnfWord &=0xefff;

		WriteP16(gwBaseMPU401,5,1); 
		WriteP16(gwBaseMPU401,0,1); 
		WriteP16(gwBaseMPU401,(BYTE) CnfWord,1); 
		WriteP16(gwBaseMPU401,(BYTE) (CnfWord>>8),1); 
	}
	

	Trace_Out("bootstrap loaded");		
	if (!LoadFirmware(hFirm,gwBaseMPU401))  // send sound bank     
		{
		cClose(hFirm);          
		return DREAMERR_UNREF;  
		} 
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	cClose(hFirm); 
	return 0;
}   



/*****************************************************************
*  
*  int bankGetCaps()
*
*	fill the structure BANKCAPS pointed by lpBkCaps with info on sound bank 
*	in memory
*                                        
*	return 0 if succeed, error code if failed
*******************************************************************/
int bankGetCaps()
{
MemBlDefTyp MemoryBlock[64];
SndBkDefTyp SndBkDef[8];
int n=0,nbl;
long SizeSb;       
DWORD read;
int NSound=0;

// first go in uart mod
if (!DrvOwn)
{
	WriteP16(gwBaseMPU401,UART_MOD,1);
	do
		read=MPU401_Command_Read(gwBaseMPU401);	// wait acknowledge   
	while ((read!=0xfe) && (n++<2));
	if (read!=0xfe)
		{
		Trace_Out("Can't go in UART mode");
		return DREAMERR_UNREF;                         
		} 
}

if (!GetMemoryMapping(gwBaseMPU401,MemoryBlock,SndBkDef))
{
	Trace_Out("Error in get mmt");
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;  
}
Trace_Out("ret from get mmt");

for (n=0;n<8;n++)
	{
	if (SndBkDef[n].Nam[0]!=0)
		{ 
		int nn;
		for (nn=0; nn<8;nn++)
			BkCaps.SBankDef[NSound].Name[nn]= SndBkDef[n].Nam[nn];
		BkCaps.SBankDef[NSound].Prio=SndBkDef[n].Prio;
	    BkCaps.SBankDef[NSound].Name[8]=0; 
	    BkCaps.SBankDef[NSound].SBnb=n;
	    // check the size occupied by the bank
	    SizeSb=0;
	    for (nbl=0; nbl<BlockNb-1; nbl++)
	    	{
	    	if (((MemoryBlock[nbl].Type & 0x0fff)==0x10+(n<<8)) || 
	    		((MemoryBlock[nbl].Type & 0x0fff)==0x11+(n<<8)))
	    		SizeSb+=MemoryBlock[nbl+1].Address-MemoryBlock[nbl].Address;  
	    	}
	    BkCaps.SBankDef[NSound].Size=SizeSb*2;
	    NSound++; 
	    }
	} 
BkCaps.BanksNb=NSound;
// check free size & total size
BkCaps.FreeSize=BkCaps.TotalSize=0;
for (nbl=0; nbl<BlockNb-1; nbl++)
	{
	if (MemoryBlock[nbl].Type==1)  
	{
		BkCaps.FreeSize += MemoryBlock[nbl+1].Address-MemoryBlock[nbl].Address;
		BkCaps.TotalSize += MemoryBlock[nbl+1].Address-MemoryBlock[nbl].Address;
	} 
	if (((MemoryBlock[nbl].Type & 0xff) >= 0x10 ) && ((MemoryBlock[nbl].Type & 0xff) < 0x80))
		BkCaps.TotalSize += MemoryBlock[nbl+1].Address-MemoryBlock[nbl].Address;
	} 
if (!DrvOwn)
	WriteP16(gwBaseMPU401,0xff,1);	//reset

BkCaps.FreeSize*=2;
BkCaps.TotalSize*=2;
 Trace_Out("Exit get caps"); 
return 0;
} 

/***************************************************************************************
*
*  WORD DelSoundBank(WORD SoundBkNb)
*	
*	Delete the sound bank n  SoundBkNb from the memory card
*   
*	Return 0 if ok, or error message if failed 
* 
*	Call :    	GetMemoryMapping
*             	UpLoad 
*				SplitInsMap
*				DelAssign	
*				CreateInsMap
*               DownLoad
*
*****************************************************************************************/    
WORD DelSoundBank(WORD SoundBkNb)
{
int n=0,MidExt=0,MidTab=0;
MemBlDefTyp MemoryBlock[64];
SndBkDefTyp SndBkDef[8];
long MidiMapExt=0,MidiMapAdd=0,MidiMapSize,MemMapAdd,MidiExtSize=0;
WORD *MidiMapping,hh;
assigne *InstTab,*InstBkUpTab,DrumTab[80],DrumBkUpTab[80];
BOOL found=FALSE;     
int AssignSize;
int nInst,nInstBk,nDrm,nDrmBk;
DWORD read;


Trace_Out("Delete SB");

// first go in uart mod
if (!DrvOwn)
{
	WriteP16(gwBaseMPU401,UART_MOD,1);
	do
		read=MPU401_Command_Read(gwBaseMPU401);	// wait acknowledge   
	while ((read!=0xfe) && (n++<2));
	if (read!=0xfe)
		{
		Trace_Out("Can't go in UART mode");
		return DREAMERR_UNREF;                         
		} 
}
//Get Memory Mapping from card 
if (!GetMemoryMapping(gwBaseMPU401,MemoryBlock,SndBkDef))
{
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
}

//Update Memory Mapping in removing block of the deleted sound bank
// and take address we need  

for (n=0; n<BlockNb; n++)
	{
	if ( (((MemoryBlock[n].Type & 0xff)==0x10) || ((MemoryBlock[n].Type & 0xff)==0x11)) &&
		 (((MemoryBlock[n].Type >> 8) & 0x000f)==SoundBkNb) ) 
		 {	// Block to be deleted    
		 found=TRUE;
		 MemoryBlock[n].Type=1;		// freeing it 
		 if (MemoryBlock[n+1].Type==1) 
		 	// next bloc is free. Delete it to enlarge new free block
		 	DeleteMBlock(n+1,MemoryBlock);
		 if (MemoryBlock[n-1].Type==1)  
		 	{
		 	// Precedent bloc is free. Just enlarge it
		 	DeleteMBlock(n,MemoryBlock); 
		 	n-=1;
		 	}
		}  
	}   
if (!found) 
	{
	Trace_Out("The Sound Bank can't be deleted (ex : may be in ROM)");  
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_CANNOTDELETE;
	} 


if ((MemMapAdd=GetMemMapAddress(gwBaseMPU401))==0xffffffff)				//API Dream called to Get Memory Mapping Table address
	{
	Trace_Out("Error in API GetMemMapAddress");                   
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	} 
n=0;
while ((MemMapAdd!=MemoryBlock[n].Address) && (n<BlockNb))  // research Mem Map Table in Memory Map
	n++;   
if (n==BlockNb) 
	{
	Trace_Out("Error in searching MemMapAdd in Memory Mapping");  
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	} 
if (MemoryBlock[n+1].Type==4)           //Midi Mapping Table
	{  
	MidTab=n+1;
	MidiMapAdd=MemoryBlock[n+1].Address;  
	MidiMapSize=MemoryBlock[n+2].Address-MemoryBlock[n+1].Address;
	}
if (MemoryBlock[n+2].Type==5)           //Midi Mapping Table Extension  
	{
	MidExt=n+2;
	MidiMapExt=MemoryBlock[n+2].Address;
	MidiExtSize=MemoryBlock[n+3].Address-MemoryBlock[n+2].Address;  
	} 
if (!MidiMapAdd)
	{
	Trace_Out("No Midi Mapping");                                
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	}   
     
MidiMapSize+=MidiExtSize;		//size Midi mapping+Midi mapping extension in word 
//MidiMapping=new WORD[MidiMapSize];  
if ((MidiMapping=_PageAllocate(1+(ULONG) (MidiMapSize/2048),PG_SYS,0,0,1,1,0,0))==NULL)
	{             
		Trace_Out("Can't allocate MidiMap");
		if (!DrvOwn)
			WriteP16(gwBaseMPU401,0xff,1);	//reset
		return DREAMERR_UNREF;
	} 
if (UpLoad(gwBaseMPU401,MidiMapping,(WORD) (MidiMapAdd>>16),(WORD) (MidiMapAdd & 0xffff),(WORD) MidiMapSize))	//API Dream called to Get Midi mapping
	{
	Trace_Out("Can't UpLoad Midi Mapping");                       
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	}
// remove sound bank from Sound Bank definition 
for (n=0; n<8; n++)
	SndBkDef[SoundBkNb].Nam[n]=0;
//Update Midi mapping
AssignSize=(MidiMapping[0]-0x194)/2; 

hh=MidiMapping[0];
//InstTab=new assigne[AssignSize];    
//InstBkUpTab=new assigne[AssignSize];   
if ((InstTab=_PageAllocate(1+(ULONG) ((AssignSize)/850),PG_SYS,0,0,1,1,0,0))==NULL)
{
	Trace_Out("Can't allocate InstTab");
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
}  
if ((InstBkUpTab=_PageAllocate(1+(ULONG) ((AssignSize)/850),PG_SYS,0,0,1,1,0,0))==NULL)
{
	Trace_Out("Can't allocate InstBkUpTab");
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
} 
Trace_Out("Allocate InsTab & InstBkUpTab");   
if (!SplitInsMap(MidiMapping,(WORD) MidiMapAdd,InstTab,InstBkUpTab,DrumTab,DrumBkUpTab,
			&nInst,&nInstBk,&nDrm,&nDrmBk))
  	{
	Trace_Out("Error in splitting Midi mapping");                 
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	}   
if (!DelAssign(InstTab,InstBkUpTab,(BYTE) SoundBkNb,SndBkDef, &nInst,&nInstBk))	
	{
	Trace_Out("Error in deleting sound bank in Midi mapping(ins)");     
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	}
if (!DelAssign(DrumTab,DrumBkUpTab,(BYTE) SoundBkNb,SndBkDef, &nDrm,&nDrmBk))	
	{
	Trace_Out("Error in deleting sound bank in Midi mapping (drm)");     
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	}
// Now, we have to redo midi mapping table
if (!CreateInsMap(MidiMapping,InstTab,InstBkUpTab,DrumTab,DrumBkUpTab,nInst,
		nInstBk,nDrm,nDrmBk,(WORD) (MidiMapAdd & 0xffff)))
  	{
	Trace_Out("Error in re-doing Midi mapping");                  
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	} 
if (MidExt)
	MemoryBlock[MidExt].Address=MidiMapAdd+MidiMapping[0];  
else 
	{ 
	NewBloc ToAdd;
	ToAdd.Type=5;	//MidiMapExt
	ToAdd.Address=MidiMapAdd+MidiMapping[0];
	InsertMBlock(MidTab+1,ToAdd,MemoryBlock);  
	}
//delete InstTab;
//delete InstBkUpTab; 
if (!(_PageFree(InstTab,0)))
{
	Trace_Out("error in freeing InstTab");
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
}
if (!(_PageFree(InstBkUpTab,0)))
{
	Trace_Out("error in freeing InstBkUpTab");
	return DREAMERR_UNREF;
}  
// Send midi mapping in card 
if (DownLoad(gwBaseMPU401,MidiMapping,(WORD) (MidiMapAdd >> 16),(WORD) (MidiMapAdd & 0xffff),MidiMapping[0]))
  	{                        
	Trace_Out("Error in loading MidiMapping in card");   
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	} 
if (!(_PageFree(MidiMapping,0)))
{
	Trace_Out("error in freeing InstTab");
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
}
// Now, we have to send memory mapping table
//	a) Memory bloc definition
if (DownLoad(gwBaseMPU401,MemoryBlock,(WORD) (MemMapAdd >> 16),(WORD) (MemMapAdd & 0xffff),(WORD) MemBlockSize))
  	{                        
	Trace_Out("Error in loading MemoryMapping in card ");
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	}   
//	b) Sound Bank definition
MemMapAdd+=MemBlockSize;
if (DownLoad(gwBaseMPU401,SndBkDef,(WORD) (MemMapAdd >> 16),(WORD) (MemMapAdd & 0xffff),MemSBSize))
  	{                        
	Trace_Out("Error in loading sound bank def in card");     
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	}    
if (!DrvOwn)
	WriteP16(gwBaseMPU401,0xff,1);	//reset
          
return 0;
} 


/***************************************************************************************
*
*  WORD bankSetPriority(WORD SoundBkNb, WORD Prio)
*	
*	Change the priority of a sound bank (-> change the default sounds)
*   
*	Return 0 if ok, or error message if failed 
* 
*	Call :    	GetMemoryMapping
*             	UpLoad 
*				SplitInsMap
*				ChangePriority	
*				CreateInsMap
*               DownLoad
*
*****************************************************************************************/    
WORD bankSetPriority(WORD SoundBkNb, WORD Prio)
{
int n=0,MidExt=0,MidTab=0;
MemBlDefTyp MemoryBlock[64];
SndBkDefTyp SndBkDef[8];
long MidiMapAdd=0,MidiMapSize,MemMapAdd;
WORD *MidiMapping,hh;
assigne *InstTab,*InstBkUpTab,DrumTab[80],DrumBkUpTab[80];
BOOL found=FALSE;     
int AssignSize;
int nInst,nInstBk,nDrm,nDrmBk;
DWORD read;


// first go in uart mod
if (!DrvOwn)
{
	WriteP16(gwBaseMPU401,UART_MOD,1);
	do
		read=MPU401_Command_Read(gwBaseMPU401);	// wait acknowledge   
	while ((read!=0xfe) && (n++<2));
	if (read!=0xfe)
		{
		Trace_Out("Can't go in UART mode");
		return DREAMERR_UNREF;                         
		} 
}

//Get Memory Mapping from card 
if (!GetMemoryMapping(gwBaseMPU401,MemoryBlock,SndBkDef))
{
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
}

if ((MemMapAdd=GetMemMapAddress(gwBaseMPU401))==0xffffffff)				//API Dream called to Get Memory Mapping Table address
	{
	Trace_Out("Error in API GetMemMapAddress");                   
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	} 
n=0;
while ((MemMapAdd!=MemoryBlock[n].Address) && (n<BlockNb))  // research Mem Map Table in Memory Map
	n++;   
if (n==BlockNb) 
	{
	Trace_Out("Error in searching MemMapAdd in Memory Mapping");  
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	} 
if (MemoryBlock[n+1].Type==4)           //Midi Mapping Table
	{  
	MidTab=n+1;
	MidiMapAdd=MemoryBlock[n+1].Address;  
	MidiMapSize=MemoryBlock[n+2].Address-MemoryBlock[n+1].Address;
	}
if (MemoryBlock[n+2].Type==5)           //Midi Mapping Table Extension  
	{
	MidExt=n+2;
	} 
if (!MidiMapAdd)
	{
	Trace_Out("No Midi Mapping");                                
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	}   

//MidiMapping=new WORD[MidiMapSize];  
if ((MidiMapping=_PageAllocate(1+(ULONG) (MidiMapSize/2048),PG_SYS,0,0,1,1,0,0))==NULL)
	{             
		Trace_Out("Can't allocate MidiMap");
		if (!DrvOwn)
			WriteP16(gwBaseMPU401,0xff,1);	//reset
		return DREAMERR_UNREF;
	} 
if (UpLoad(gwBaseMPU401,MidiMapping,(WORD) (MidiMapAdd>>16),(WORD) (MidiMapAdd & 0xffff),(WORD) MidiMapSize))	//API Dream called to Get Midi mapping
	{
	Trace_Out("Can't UpLoad Midi Mapping");                       
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	}

//Update Midi mapping
AssignSize=(MidiMapping[0]-0x194)/2; 

hh=MidiMapping[0];
//InstTab=new assigne[AssignSize];    
//InstBkUpTab=new assigne[AssignSize];   
if ((InstTab=_PageAllocate(1+(ULONG) ((AssignSize)/850),PG_SYS,0,0,1,1,0,0))==NULL)
{
	Trace_Out("Can't allocate InstTab");
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
}  
if ((InstBkUpTab=_PageAllocate(1+(ULONG) ((AssignSize)/850),PG_SYS,0,0,1,1,0,0))==NULL)
{
	Trace_Out("Can't allocate InstBkUpTab");
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
} 
Trace_Out("Allocate InsTab & InstBkUpTab");   
if (!SplitInsMap(MidiMapping,(WORD) MidiMapAdd,InstTab,InstBkUpTab,DrumTab,DrumBkUpTab,
			&nInst,&nInstBk,&nDrm,&nDrmBk))
  	{
	Trace_Out("Error in splitting Midi mapping");                 
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	}  
// let's modify priority
SndBkDef[SoundBkNb].Prio = Prio;
			
if (!ChangePriority(InstTab,InstBkUpTab,(BYTE) SoundBkNb,  Prio,SndBkDef, &nInst,&nInstBk))	
	{
	Trace_Out("Error in modifying sound bank prio");     
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	}
if (!ChangePriority(DrumTab,DrumBkUpTab,(BYTE) SoundBkNb,  Prio,SndBkDef, &nDrm,&nDrmBk))	
	{
	Trace_Out("Error in modifying sound bank prio");     
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	}


// Now, we have to redo midi mapping table
if (!CreateInsMap(MidiMapping,InstTab,InstBkUpTab,DrumTab,DrumBkUpTab,nInst,
		nInstBk,nDrm,nDrmBk,(WORD) (MidiMapAdd & 0xffff)))
  	{
	Trace_Out("Error in re-doing Midi mapping");                  
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	} 

//delete InstTab;
//delete InstBkUpTab; 
if (!(_PageFree(InstTab,0)))
{
	Trace_Out("error in freeing InstTab");
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
}
if (!(_PageFree(InstBkUpTab,0)))
{
	Trace_Out("error in freeing InstBkUpTab");
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
}  
// Send midi mapping in card 
if (DownLoad(gwBaseMPU401,MidiMapping,(WORD) (MidiMapAdd >> 16),(WORD) (MidiMapAdd & 0xffff),MidiMapping[0]))
  	{                        
	Trace_Out("Error in loading MidiMapping in card");   
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	} 
if (!(_PageFree(MidiMapping,0)))
{
	Trace_Out("error in freeing InstTab");
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
}
// Now, we have to send sound bank definition table
//	a) Memory bloc definition

MemMapAdd+=MemBlockSize;
if (DownLoad(gwBaseMPU401,SndBkDef,(WORD) (MemMapAdd >> 16),(WORD) (MemMapAdd & 0xffff),MemSBSize))
  	{                        
	Trace_Out("Error in loading sound bank def in card");     
	if (!DrvOwn)
		WriteP16(gwBaseMPU401,0xff,1);	//reset
	return DREAMERR_UNREF;
	} 
if (!DrvOwn)
	WriteP16(gwBaseMPU401,0xff,1);	//reset
         
return 0;
} 



//---------------------------------------------------------------------------
//  End of File: cnfgmgr.c
//---------------------------------------------------------------------------
