/****************************************************************************
 *
 *   wavein.c
 *
 *   Copyright (c) 1991-1992 Microsoft Corporation.  All Rights Reserved.
 *
 ***************************************************************************/

#include <windows.h>
#include <mmsystem.h>
#include <mmddk.h>
#include "dream94.h"   
#include "dream.h"

  
BYTE gbSizeIn;        /* sndblst.asm */
BYTE gbStereoIn;        /* init.asm */ 
extern PHARDWAREINSTANCE phwi;    
extern gwPort;		//inita.asm
extern BOOL FirstTime;		// waveout.c
extern WORD WaveState[9];			// waveout.c  
extern BYTE BRFlag[9];   
extern int SizeMem;
extern DWORD gdwPitch[9];			//		"       
extern BYTE	OpenFmt[9];				// wave.asm  data format send to P16  
long WaveBufferSizeIn=0x800;		// size in word of wave buffer (waveout.c)
MemBlDefTyp MemoryBlock[NbMemBlocks];  
WORD StopRecord=1;					// No record   
WAVEFORMATEX FmtS;      /* save of the passed format */          	
/*****************************************************************************

    internal function prototypes

 ****************************************************************************/ 

static void NEAR PASCAL widFreeQ(void);

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | widFreeQ | Free all buffers.
 *
 * @rdesc There is no return value.
 ***************************************************************************/ 
static void NEAR PASCAL widFreeQ(void)
{
LPWAVEHDR lpH, lpN;

    lpH = glpWIQueue;              /* point to top of the queue */
    glpWIQueue = NULL;             /* mark the queue as empty */

    while (lpH) {
        lpN = lpH->lpNext;
        widBlockFinished(lpH);
        lpH = lpN;
    }  
    if (hpCurInData)
    	hpCurInData = NULL;
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | widAddBuffer | Adds a buffer to our input queue.
 *
 * @rdesc The return value is an MMSYS error code (0L if success).
 ***************************************************************************/ 
static DWORD NEAR PASCAL widAddBuffer( LPWAVEHDR lpwh )
{
LPWAVEHDR   lpN;


    /* check if it's been prepared */
    if (!(lpwh->dwFlags & WHDR_PREPARED))
        return WAVERR_UNPREPARED;

    /* check if it's in our queue already */
    if (lpwh->dwFlags & WHDR_INQUEUE)
        return WAVERR_STILLPLAYING;

    /* add the buffer to our queue */
    lpwh->dwFlags |= WHDR_INQUEUE;
    lpwh->dwFlags &= ~WHDR_DONE;

    /* sanity */
    lpwh->dwBytesRecorded = 0;
    lpwh->lpNext = NULL;

    CritEnter();
    {
        if ( lpN = glpWIQueue ) {
            while ( lpN->lpNext && (lpN = lpN->lpNext) )
                ;

            lpN->lpNext = lpwh;
        }

        else 
            glpWIQueue = lpwh;
    }
    CritLeave();

    /* return success */
    return ( 0L );
}

/****************************************************************************
 * @doc INTERNAL
 * 
 * @api WORD | widSendPartBuffer | This function is called from widStop().
 *     It looks at the buffer at the head of the queue and, if it contains
 *     any data, marks it as done as sends it back to the client.
 * 
 * @rdesc The return value is the number of bytes transfered. A value of zero
 *     indicates that there was no more data in the input queue.
 ***************************************************************************/ 
void NEAR PASCAL widSendPartBuffer(void)
{
LPWAVEHDR lpH;

    /* Note that unlike midi input, we don't have to check if the
     * current buffer has data - it is only called if wave input is
     * started, which means it has data (whereas midi input being
     * started doesn't necessarily mean data has been received).
     */
    if (glpWIQueue) {
        lpH = glpWIQueue;
        glpWIQueue = glpWIQueue->lpNext;
        lpH->dwFlags |= WHDR_DONE;
        lpH->dwFlags &= ~WHDR_INQUEUE;
        dwCurInCount = 0L;
        hpCurInData = NULL;     
        widBlockFinished(lpH);
    }
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | widGetDevCaps | Get the device capabilities.
 *
 * @parm LPBYTE | lpCaps | Far pointer to a WAVEINCAPS structure to
 *     receive the information.
 *
 * @parm WORD | wSize | Size of the WAVEINCAPS structure.
 *
 * @rdesc There is no return value.
 ***************************************************************************/
void FAR PASCAL widGetDevCaps(MDEVICECAPSEX FAR * lpCaps)
{
WAVEINCAPS wc;

    wc.wMid = Mid;  // not a Microsoft driver
    wc.wPid = WiPid;
    wc.vDriverVersion = DRIVER_VERSION;
    wc.dwFormats = WAVE_FORMAT_1M08 | WAVE_FORMAT_1M16 | WAVE_FORMAT_1S08 | WAVE_FORMAT_1S16
    				| WAVE_FORMAT_2M08 | WAVE_FORMAT_2M16 | WAVE_FORMAT_2S16 | WAVE_FORMAT_2S08 
    				| WAVE_FORMAT_4M08 | WAVE_FORMAT_4M16 | WAVE_FORMAT_4S16 | WAVE_FORMAT_4S08;
    wc.wChannels = 2;
    LoadString(ghModule, IDS_DREAMREC, wc.szPname, MAXPNAMELEN);

    MemCopy(lpCaps->pCaps, &wc, min((UINT) lpCaps -> cbSize, sizeof(wc)));
}

/****************************************************************************

    This function conforms to the standard wave input driver message proc

****************************************************************************/
DWORD FAR PASCAL _loadds widMessage(WORD id, UINT msg, DWORD dwUser, DWORD dwParam1, DWORD dwParam2)
{
NPWAVEALLOC           pInClient;  /* pointer to client information structure */
const WAVEFORMATEX FAR *lpFmt;      /* pointer to passed format */    
WORD n,nn;
DWORD	MemMapAdd;  
long StartAdd; 
BOOL Found;                
DWORD  dn ;


switch (msg) {
	case WIDM_INIT:
      {
         D1( "WIDM_INIT" ) ;

         
            // dwParam2 == PnP DevNode

            return (AddDevNode( dwParam2 )) ;
      }
      break ;

      case DRVM_ENABLE:
      {
		UINT   uVxDId ;
         ULONG  cIds ;

		 D1( "WIDM_ENABLE" ) ;
         // dwParam2 == PnP DevNode

        cIds = 1 ;

         if (waveInMessage( (HMIDIOUT) dwParam1, DRV_QUERYDRIVERIDS,
                             (DWORD) (LPWORD) &uVxDId, 
                             (DWORD) (LPDWORD) &cIds ))
            return MMSYSERR_INVALPARAM ;

         return (EnableDevNode( dwParam2, uVxDId )) ;

      }
      break ;

      case DRVM_DISABLE:
      {
         D1( "WIDM_DISABLE" ) ;

         // dwParam2 == PnP DevNode

         return (DisableDevNode( dwParam2 )) ;

      }
      break ;

      case DRVM_EXIT:
      {
         D1( "WIDM_EXIT" ) ;

         // dwParam2 == PnP DevNode

         return (RemoveDevNode( dwParam2 )) ;

      }
      break ;
}
    if (!gfEnabled) {
        D1("widMessage called while disabled");
        return ((msg == WIDM_GETNUMDEVS) ? 0L : MMSYSERR_NOTENABLED);
    }  
    
    if (FirstTime)
    	{
    	FirstTime=FALSE;
    	if (!CheckFreeSize())
    		{
    		D1("error in check free size");
    		return -1;
    		}
    	}

    /* this driver only supports one device */
    if (id != 0) {               
        D1("invalid wave device id");
        return MMSYSERR_BADDEVICEID;
    }

    switch (msg) {
        case WIDM_GETNUMDEVS:
            D1("WIDM_GETNUMDEVS");
            if (SizeMem)
				return 1L;
			else
				return 0L;

        case WIDM_GETDEVCAPS:
            D1("WIDM_GETDEVCAPS");
            widGetDevCaps((MDEVICECAPSEX FAR *)dwParam1);
            
			return 0L;

        case WIDM_OPEN:
            D1("WIDM_OPEN");
            /* dwParam1 contains a pointer to a WAVEOPENDESC
             * dwParam2 contains wave driver specific flags in the LOWORD
             * and generic driver flags in the HIWORD
             */
            	
            /* make sure we can handle the format */
            lpFmt = ((LPWAVEOPENDESC)dwParam1)->lpFormat;      
            FmtS=*(lpFmt);
            
            if ((lpFmt->wFormatTag != WAVE_FORMAT_PCM) ||
                (lpFmt->nBlockAlign < 1))
            {         
            	D1("bad fmt");
                return WAVERR_BADFORMAT;
            } 
            OpenFmt[8]=0;
            if (lpFmt->nChannels == 1)  gbStereoIn=0;
            else 
            	{
            	gbStereoIn=1;    
            	OpenFmt[8]=0x2;
       		  	}   
            D1("test fmt");	
            if ((lpFmt)->wBitsPerSample == 8) 
            	{
            	gbSizeIn=0;
            	OpenFmt[8]+=1;
            	}
            else if ((lpFmt)->wBitsPerSample == 16) {gbSizeIn=1;}  
            else 
            	{
            	D1("bad fmt2");
            	return WAVERR_BADFORMAT;
                }
             
			if (lpFmt->nSamplesPerSec > 0xffff) 
            	 return WAVERR_BADFORMAT;

            /* did they just want format information? */
            if (dwParam2 & WAVE_FORMAT_QUERY)   
            	{
            	D1("query");
                return 0L; 
                }

		// Move on May 98
		   if (WaveState[8]!=FREE) 
            	{
            	D1("alloc");   
            	return MMSYSERR_ALLOCATED; 
            	}

            // Let's free the port if needed
            /*if (FreeMpuPort())
            	return MMSYSERR_ALLOCATED; */
            //IntUsed++;	
            dn = ((LPWAVEOPENDESC) dwParam1) -> dnDevNode ;

         if (NULL == 
               (phwi = DevNodeToHardwareInstance( dn )))
         {
            D1("devnode not associated with hardware instance???" ) ;
            return MMSYSERR_BADDEVICEID ;
         }
		 if (!AcquireMPU401( phwi ))
				 return MMSYSERR_ALLOCATED ;
          //  outp(gwPort+1,0x3f);    //UART mode, just to be sure
            	  
            /* attempt to 'acquire' the Wave input hardware */    
            // first, let's allocate buffer in card memory

		 	//  MAY98 : Modif for DCapture
			if (DirectSoundVolumeCheck(0x100, gwPort)==0)	// Is Direct Sound running?
			{												// Y, check the buffer Size
				// Take the reserved buffer (Type==0x2020)
				if ((MemMapAdd=GetMemMapAddress())==0xffffffff)				//API Dream called to Get Memory Mapping Table address
					{            
					ReleaseMPU401( phwi ) ;	    
					return MMSYSERR_NOTENABLED;
					}
				if (UpLoad(MemoryBlock,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),NbMemBlocks*3))	//API Dream called to Get Memory block definition
					{  
					ReleaseMPU401( phwi ) ;
					return MMSYSERR_NOTENABLED;
					} 
				n=1;  // index on first block
				while ((n<NbMemBlocks) && (MemoryBlock[n].Type!=0x2020))  
					n++; 
				if (n==NbMemBlocks) 
				{
					D1("ERROR : No block 0x2020");
					__asm int 3
					goto allocBl;
				}
				// block n attribute for record
				MemoryBlock[n].Type=0x0820;
				if (WaveBufferSizeIn<0x1000)
				{	// change the buffer size
					MemoryBlock[n+1].Address == MemoryBlock[n].Address+WaveBufferSizeIn; // resize the record block
				}
			}
			else
			{												// N, buffer not yet in memory.

            if ((MemMapAdd=GetMemMapAddress())==0xffffffff)				//API Dream called to Get Memory Mapping Table address
				{            
				ReleaseMPU401( phwi ) ;  
				return MMSYSERR_NOTENABLED;
				}
			if (UpLoad(MemoryBlock,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),NbMemBlocks*3))	//API Dream called to Get Memory block definition
				{  
				ReleaseMPU401( phwi ) ;	
				return MMSYSERR_NOTENABLED;
				}
allocBl:
			n=0;  // index on first block 
			Found=FALSE;
			do
				{
				n++;
				while ((n<NbMemBlocks) && ((MemoryBlock[n].Type!=1) ||           // not free
					(MemoryBlock[n+1].Address-MemoryBlock[n].Address < WaveBufferSizeIn)))  //too small
					n++;  
				StartAdd=MemoryBlock[n].Address;
				if (StartAdd & 1)			// odd address   
					StartAdd++;     
				if (((StartAdd+WaveBufferSizeIn)>>16)==(StartAdd>>16))  // cross page 
		        	{
		        	Found=TRUE;                      
		        	}
		        else
		        	{
		        	StartAdd=(StartAdd & 0xffff0000)+0x10000; // beginning of the next page
		        	if (StartAdd+WaveBufferSizeIn <= MemoryBlock[n+1].Address)
		        		Found=TRUE;
		        	}
		        }              
		    while ((n<NbMemBlocks) && (!Found));
			if (n==NbMemBlocks) 
				{              
				D1("no mem");  
				ReleaseMPU401( phwi ) ;
				//IntUsed--;	
				return MMSYSERR_NOMEM;
				}
			D1("block ok");
			// block n attribute for wave 
			if (StartAdd!=MemoryBlock[n].Address)  
				{		// remaining free block at the beginning
				for (nn=NbMemBlocks-1; nn>n; nn--)
					MemoryBlock[nn]=MemoryBlock[nn-1];
				MemoryBlock[n+1].Address=StartAdd;
				n++;
				}
			if (MemoryBlock[n+1].Address-MemoryBlock[n].Address == WaveBufferSizeIn) 
				MemoryBlock[n].Type=0x0820;	// no free block remaining; the block gets in wave state
			else
				{		// free block remaining
				if (MemoryBlock[NbMemBlocks-1].Type==0xffff) 
					{
					D1("no mem2"); 
					ReleaseMPU401( phwi ) ; 
					//IntUsed--;	
					return MMSYSERR_NOMEM; //no more block in memory mapping table
					}
				else
					{
					for (nn=NbMemBlocks-1; nn>n; nn--)
						MemoryBlock[nn]=MemoryBlock[nn-1];
					MemoryBlock[n].Type=0x0820;  // wave block
					MemoryBlock[n].Address=MemoryBlock[n+1].Address; 
					MemoryBlock[n+1].Address+=WaveBufferSizeIn;
					}	                                     
				} 
			D1("mmt change");
			// now, let's return the memory mapping table
			}	// end of Block allocation
			if (DownLoad(MemoryBlock,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),NbMemBlocks*3,0))	//API Dream called to Get Memory block definition
				{      
				ReleaseMPU401( phwi ) ;
				//IntUsed--;	
				return MMSYSERR_NOTENABLED;
				}          


            if ( wAcquireHardware(8,(WORD) lpFmt->nSamplesPerSec) ) {
                D1("Wave input hardware is not available!");  
                ReleaseMPU401( phwi ) ;
                //IntUsed--;	
                return MMSYSERR_ALLOCATED;
            }

            /* allocate my per-client structure */
            pInClient = (NPWAVEALLOC)LocalAlloc(LPTR, sizeof(WAVEALLOC));
            if (pInClient == NULL) {
                wClose(8);  
                ReleaseMPU401( phwi ) ;
                //IntUsed--;	
                return MMSYSERR_NOMEM;
            }

            /* and fill it with info */
            pInClient->dwCallback  = ((LPWAVEOPENDESC)dwParam1)->dwCallback;
            pInClient->dwInstance  = ((LPWAVEOPENDESC)dwParam1)->dwInstance;
            pInClient->hWave       = ((LPWAVEOPENDESC)dwParam1)->hWave;
            pInClient->dwFlags     = dwParam2;
            pInClient->dwByteCount = 0L;
            pInClient->pcmwf       = *((LPPCMWAVEFORMAT)lpFmt) ;

            /* set the sample rate */

            /* give the client my driver dw */
            *((LPDWORD)dwUser) = MAKELONG(pInClient, 0);

            /* call client's callback */
            waveCallback(pInClient, WIM_OPEN, 0L); 
            gdwPitch[8]=0x00010000;		// Pitch is init to 1
            WaveState[8]=ENDIT;		// No interrupt are expected 
            BRFlag[8]=0;            // init : no remain byte
            return 0L;

        case WIDM_CLOSE:
            D1("WIDM_CLOSE");         
                                     
            pInClient = (NPWAVEALLOC)LOWORD(dwUser);
            if (WaveState[8]==FREE) 
            	{
            	D1("Wave output hardware already free!"); 
            	waveCallback(pInClient, WIM_CLOSE, 0L);
            	return 0;
            	}
            if (glpWIQueue)
                return WAVERR_STILLPLAYING;
            
            /* just in case they started input without adding buffers... */
            if (WaveState[8]!=STOP) 
            	{
            	StopRecord=1;      // no more record
            	wClose(8);    //close channel 8 (record)
            	}

            /* call client's callback */
            waveCallback(pInClient, WIM_CLOSE, 0L);

            /* free the allocated memory */
            LocalFree((LOCALHANDLE)pInClient);

            /* now 'release' the Wave input hardware */
            WaveState[8]=FREE;		// free the wave channel
 
            // free the card memory  
            if ((MemMapAdd=GetMemMapAddress())==0xffffffff)				//API Dream called to Get Memory Mapping Table address
				return MMSYSERR_NOTENABLED;
			if (UpLoad(MemoryBlock,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),NbMemBlocks*3))	//API Dream called to Get Memory block definition
				return MMSYSERR_NOTENABLED;
            n=1;  // index on first block
			while ((n<NbMemBlocks) && (MemoryBlock[n].Type!=0x0820))  
				n++; 
			if (n==NbMemBlocks)  
				return 0;    		// block record not find
			
			//  MAY98 : Modif for DCapture
			if (DirectSoundVolumeCheck(0x100, gwPort)==0)	// Is Direct Sound running?
			{												// Y, Restore block 0x2020
				MemoryBlock[n].Type=0x2020;
			}
			else
			{												// N, delete record buffer

			// block n attribute for wave
			if (MemoryBlock[n+1].Type == 1) // next block is free 
				{
				D1("next bl free" );
				MemoryBlock[n+1].Address=MemoryBlock[n].Address;	// set its new address
		        for (nn=n; nn<NbMemBlocks-1; nn++)             // remove old record block
					MemoryBlock[nn]=MemoryBlock[nn+1];
				}
			else
				{  
				MemoryBlock[n].Type =1;            // next block not free. Just free the record block
	            D1("type=1 #bx");
	            }
			if (MemoryBlock[n-1].Type==1)
				{				// previous block is free. enlarge it and remove block n
				D1("prev bl free" );
				for (nn=n; nn<NbMemBlocks-1; nn++)             // remove old record block
					MemoryBlock[nn]=MemoryBlock[nn+1];
				}
			// now, let's return the memory mapping table       
			}	// end of delete record buffer

			if (DownLoad(MemoryBlock,(WORD) (MemMapAdd>>16),(WORD) (MemMapAdd & 0xffff),NbMemBlocks*3,0))	//API Dream called to Get Memory block definition
				return MMSYSERR_NOTENABLED;   
			

	        ReleaseMPU401( phwi ) ;  
            //IntUsed--;                 
            return 0L;

        case WIDM_ADDBUFFER:
            D1("WIDM_ADDBUFFER");
            AssertF(dwParam1 != NULL);
            //AssertF(!(((LPWAVEHDR)dwParam1)->dwFlags & ~(WHDR_INQUEUE|WHDR_DONE|WHDR_PREPARED)));
            ((LPWAVEHDR)dwParam1)->dwFlags &= (WHDR_INQUEUE|WHDR_DONE|WHDR_PREPARED);

            /* store the pointer to my WAVEALLOC structure in the wavehdr */
            pInClient = (NPWAVEALLOC)LOWORD(dwUser);
            ((LPWAVEHDR)dwParam1)->reserved = (DWORD)(LPSTR)pInClient;
            
            /* add the buffer to our queue */
            return widAddBuffer((LPWAVEHDR)dwParam1);

        case WIDM_START:
            D1("WIDM_START");
            if (WaveState[8]==FREE)
            	return MMSYSERR_NOTENABLED;   
            if (WaveState[8]==START)
            	return 0; 
            if (WaveState[8]==STOP)
	           	{       // re-open the wave
	           	if ( wAcquireHardware(8,(WORD) FmtS.nSamplesPerSec) ) 
	            	{
	                D1("Wave input hardware is not available!");
	                return MMSYSERR_ALLOCATED;
	            	}
	            }	 
	        StopRecord=0;              // record allowed
            wStart(8); 
            WaveState[8]=START;
            return 0L;

        case WIDM_STOP:
            D1("WIDM_STOP"); 
            if (WaveState[8]==FREE)
            	return MMSYSERR_NOTENABLED;   
            if (WaveState[8]==STOP)
            	return 0; 
            StopRecord=1;              // no more record
            wClose(8);   
            WaveState[8]=STOP;
            return 0L;

        case WIDM_RESET:
            D1("WIDM_RESET");

            /* stop if it is started and release all buffers */
            if (WaveState[8]!=FREE) 
            	{   
            	WaveState[8]=STOP; 
            	StopRecord=1;              // no more record         
            	wClose(8); 
            	}
            widFreeQ(); 
            /* reset byte count */
            pInClient = (NPWAVEALLOC)LOWORD(dwUser);
            pInClient->dwByteCount = 0L;           
            return 0L;

        case WIDM_GETPOS:
            D1("WIDM_GETPOS");
            return waveGetPos((NPWAVEALLOC)LOWORD(dwUser), (LPMMTIME)dwParam1, (WORD)dwParam2,gbSizeIn,gbStereoIn);

        default:
            return MMSYSERR_NOTSUPPORTED;
    }

    /* should never get here... */
    AssertF(0);
    return MMSYSERR_NOTSUPPORTED;
}
