/****************************************************************************
 *
 *   wavefix.c
 *
 *   Copyright (c) 1991-1992 Microsoft Corporation.  All Rights Reserved.
 *
 ***************************************************************************/

#include <windows.h>
#include <mmsystem.h>
#include <mmddk.h>
#include "dream94.h"   
#include "dream.h"

extern long WaveBufferSize;                    //waveout.c
extern long WaveBufferSizeIn;                  //wavein.c     
extern int SizeBuffer[9];						// waveout.c

WORD	EndBuffer;		// =1 when it is the end of the buffer sent
						// to be fill in record or play in wave out.
						// Used in dreamirq to avoid incrementing a segment
						// that is the last one.                
WORD	gwPort;				//mpu401 port (init in inita.asm)
/* Driver specific bit used to mark a wave header as being done with
 * all DMA activity--so we can post the WOM_DONE message at the correct
 * time.  See dmaLoadBuffer in wavefix.c for more information.
 */
#define WHDR_REALLYDONE 0x80000000l /* internal driver flag for wave headers */

/*****************************************************************************

    public data

 ****************************************************************************/
extern WORD WaveState[8]; // current state of each wave channel
extern WORD NextXFCount[8]; 
HPSTR     hpCurInData     = NULL;  /* ptr to data block of current input hdr */
DWORD     dwCurInCount    = 0L;    /* bytes left in current input block */
HPSTR     CurData[8]       = {NULL, NULL,NULL, NULL,NULL,
								 NULL,NULL, NULL};  /* ptr to data block of current output hdr */
DWORD     CurCount[8]      = {0L,0L,0L,0L,0L,0L,0L,0L};    /* bytes left in current output block */
LPWAVEHDR LoopStart[8]     = {NULL, NULL,NULL, NULL,NULL,
								 NULL,NULL, NULL};  /* pointer to first block of a loop */
LPWAVEHDR DeadHeads[8]     = {NULL, NULL,NULL, NULL,NULL,
								 NULL,NULL, NULL};  /* death row for wave headers */
DWORD     LoopCount[8];             /* count for current loop */
BYTE      bBreakLoop[8]      = {0,0,0,0,0,0,0,0};     /* set to non-zero to break loop */
LPWAVEHDR lpWOQueue[8]      = {NULL, NULL,NULL, NULL,NULL,
								 NULL,NULL, NULL};  /* wave output data buffer queue */

LPWAVEHDR glpWIQueue      = NULL;  /* wave input data buffer queue */

/***************************************************************************/

void FAR PASCAL wodPostAllHeaders( WORD noChannel )
{
LPWAVEHDR   lpNuke;             /* wavehdr to free */

    D2("postALLdeadheads");

    /* free the lpDeadHeads */
    while ( lpNuke = DeadHeads[noChannel] ) {
        DeadHeads[noChannel] = DeadHeads[noChannel]->lpNext;
        wodBlockFinished( lpNuke );
    }
}

/***************************************************************************/

void NEAR PASCAL wodPostDoneHeaders( WORD noChannel )
{
LPWAVEHDR   lpNuke;             /* wavehdr to free */
LPWAVEHDR   lpPrev;             /* previous wavehdr (temporary) */

    D2("postdeadheads");

    lpPrev = NULL;
    for ( lpNuke = DeadHeads[noChannel]; lpNuke; lpNuke = lpNuke->lpNext ) {
        if ( lpNuke->dwFlags & WHDR_REALLYDONE ) {
            if ( lpPrev )
                lpPrev->lpNext = NULL;
            else
                DeadHeads[noChannel] = NULL;

            /* from lpNuke down, we need to wodBlockFinished() */
            while ( lpPrev = lpNuke ) {
                lpNuke = lpNuke->lpNext;
                wodBlockFinished( lpPrev );
            }

            /* break completely out of the for() loop */
            break;
        }

        lpNuke->dwFlags |= WHDR_REALLYDONE;
        lpPrev = lpNuke;
    }
}

/****************************************************************************
 * @doc INTERNAL
 * 
 * @api WORD | wodLoadDMABuffer | This function loads a DMA buffer from the
 *      data queue.
 *
 * 
 * @parm    WORD noChannel
 *			WORD | wBufSize | Number of data to xfer in word
 * 
 * @rdesc The return value is the number of bytes transferred. A value of zero
 *     indicates that there was no more data in the output queue.
 * 
 * @comm This routine is called once when DMA is started and then again at
 *     interrupt time when a DMA block is complete.  It will in turn call a
 *     callback funtion to the app if it empties a request queue block and a
 *     callback function is defined. 
 *
 * 17-12-96
 ***************************************************************************/ 
WORD FAR PASCAL wodDMAStart(WORD noChannel)
{
WORD      wBytesTransferred; /* how many bytes transferred to DMA buffer */
WORD      wToGo;             /* min(buf space left, bytes left in data block) */
LPWAVEHDR lpNuke;            /* wavehdr to free */
LPWAVEHDR lpQ;               /* wavehdr temp for traversing list (queue) */
int       i;                 /* how many bytes to fill right */

WORD wBufSize=2*NextXFCount[noChannel];		// size to xfer in bytes 

    /* if any 'deadheads' are around, post them back to the app */
    if ( DeadHeads[noChannel] )
        wodPostDoneHeaders(noChannel);

    /* don't destroy position of glpWOQueue (unless we are looping) */
    lpQ = lpWOQueue[noChannel];
    wBytesTransferred = 0;

     if ((WaveState[noChannel]==ASK_PAUSE) || 
		 (WaveState[noChannel]==ASK_CLOSE) ||
		 (WaveState[noChannel]==RESET) )
     	goto enddma;  
     if ( !lpQ)    /* no queue at all */
        goto noqueue; 
        
    while (wBytesTransferred < wBufSize) {
        /* we break if we have no data left or we complete the request */
        if (CurData[noChannel] == NULL) {
            /* first time in for this queue */
            D3("firstq");
            CurData[noChannel] = lpQ->lpData;
            CurCount[noChannel] = lpQ->dwBufferLength;
            /* check if this is the start of a loop */
            if (lpQ->dwFlags & WHDR_BEGINLOOP) {
                LoopStart[noChannel] = lpQ;
                LoopCount[noChannel] = lpQ->dwLoops;
            }
        }

        
        /* If we are looping and no more loops need executing, then copy */
        /* nothing.  We still need to go through the motions to keep */
        /* everything updated correctly. */
         if ( LoopStart[noChannel] && (LoopCount[noChannel] == 0) )
            CurCount[noChannel] = 0;

        /* don't waste time if curcount is zero */
        if ( CurCount[noChannel] ) {
            /* hpCurData points to some chunk we can grab */ 
    
            wToGo = (WORD)min(CurCount[noChannel],(DWORD)(wBufSize - wBytesTransferred));
            
			CurCount[noChannel] -= wToGo;
			if (CurCount[noChannel]==0)
				EndBuffer=1;
			else
				EndBuffer=0;
			/* fill the buffer */
            CurData[noChannel] = DMAxfer(CurData[noChannel], wToGo,noChannel);   
            
            wBytesTransferred += wToGo;
            if (wToGo & 1)		// odd buffer size
    			wBytesTransferred-=1;   // last byte not transferred
            ((NPWAVEALLOC)LOWORD(lpQ->reserved))->dwByteCount += wToGo;
        }

        /* see if that emptied the current buffer */
        if (CurCount[noChannel] == 0) {
            D4("blockfin");

            if (lpQ->dwFlags & WHDR_ENDLOOP) {
				/* test if there is a request to break the loop */
				if (bBreakLoop[noChannel]) {
					D3("BREAKLOOP");
					LoopCount[noChannel] = 0L;
					bBreakLoop[noChannel] = 0;
				}

                if (LoopCount[noChannel] == 0) {
                    D3("loop0");
                    lpNuke  = LoopStart[noChannel];
                    lpQ = lpQ->lpNext;
                    while (lpNuke != lpQ) {
                        /* free up loop blocks */
                        LPWAVEHDR lpKillMe;

                        /* move the 'almost done' blocks to death row */
                        lpKillMe = lpNuke;
                        lpNuke = lpNuke->lpNext;
                        lpKillMe->lpNext = DeadHeads[noChannel];
                        DeadHeads[noChannel] = lpKillMe;
                    }
                    LoopStart[noChannel] = NULL;
                }
                else {
                    D3("loop--");
                    LoopCount[noChannel]--;

                    /* back to the beginning of the loop */
                    lpQ = lpWOQueue[noChannel] = LoopStart[noChannel];
               }
            }
            else {
                /* move the 'almost done' block into the lpDeadHeads list */
                lpNuke = lpQ;
                lpQ = lpQ->lpNext;
                if (LoopStart[noChannel] == NULL) {
                    lpNuke->lpNext = DeadHeads[noChannel];
                    DeadHeads[noChannel] = lpNuke;
                }
            }

            if (lpQ == NULL) {
                /* end of the list */
                D3("endofq");
                CurData[noChannel] = NULL;
                CurCount[noChannel] = 0L;

                /* from the while loop (return wBytesTransferred) */
                break;
            }

            else {
                CurData[noChannel] = lpQ->lpData;
                CurCount[noChannel] = lpQ->dwBufferLength;
                if (LoopStart[noChannel] == NULL) {
                    /* check if this is the start of a loop */
                    if (lpQ->dwFlags & WHDR_BEGINLOOP) {
                        D3("loopStart");
                        LoopStart[noChannel] = lpQ;
                        LoopCount[noChannel] = lpQ->dwLoops;
                    }
                }
            }
        }
    }

    if ( !(lpWOQueue[noChannel] = lpQ) && LoopStart[noChannel] )
        lpWOQueue[noChannel] = LoopStart[noChannel];
noqueue:
    i = (wBufSize - wBytesTransferred)/2;  // number of words to send next time
    if (i!=0) 
    	{
    	// the p16 will stop to send IT
        WaveState[noChannel]=ENDIT;   
        wodPostAllHeaders(noChannel);
    	NextXFCount[noChannel]=i;    
    	}
    else 
    	NextXFCount[noChannel]=(WORD) (SizeBuffer[noChannel]/2);
   //D1("END_XFER  next xf count=#ax");   
enddma: 
	SendCommand(END_XFER,0,0);
    SendParam((BYTE) noChannel,1,0);  

    if (WaveState[noChannel]==ASK_CLOSE) 
    	{                   
    	WaveState[noChannel]=CLOSE_RQ; 
    	} 
     if (WaveState[noChannel]==ASK_PAUSE) 
    	{                   
    	WaveState[noChannel]=PAUSE; ;
    	}
	if (WaveState[noChannel]==RESET) 
    	{  
		NextXFCount[noChannel]=SizeBuffer[noChannel]/2;    // init the first xfer at half buffer  
    	WaveState[noChannel]=ENDIT; 
    	} 
    return wBytesTransferred;
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | waveCallback | This calls DriverCallback for a WAVEHDR.
 *
 * @parm PWAVEALLOC | pWave | Pointer to wave device.
 *
 * @parm WORD | msg | The message.
 *
 * @parm DWORD | dw1 | message DWORD (dw2 is always set to 0).
 *
 * @rdesc There is no return value.
 ***************************************************************************/
void FAR PASCAL waveCallback(NPWAVEALLOC pWave, WORD msg, DWORD dw1)
{

    /* Invoke the callback function, if it exists.  dwFlags contains
     * wave driver specific flags in the LOWORD and generic driver
     * flags in the HIWORD.
     * 
     * DON'T switch stacks in DriverCallback - we already did at the
     * beginning of our ISR (using StackEnter).  No need to burn another
     * stack, as we should have plenty of room for the callback.  Also,
     * we may not have been called from an ISR.  In that case, we know
     * that we are on an app's stack, and this should be ok.
     */
    D1("CallBack");
    if (pWave->dwCallback)
                           
        DriverCallback(pWave->dwCallback,       /* user's callback DWORD */
                       HIWORD(pWave->dwFlags) | 8,  /* flags */
                       pWave->hWave,            /* handle to the wave device */
                       msg,                     /* the message */
                       pWave->dwInstance,       /* user's instance data */
                       dw1,                     /* first DWORD */
                       0L);                     /* second DWORD */
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | wodBlockFinished | This function sets the done bit and invokes
 *     the callback function if there is one.
 *
 * @parm LPWAVEHDR | lpHdr | Far pointer to the header.
 *
 * @rdesc There is no return value.
 ***************************************************************************/
void FAR PASCAL wodBlockFinished(LPWAVEHDR lpHdr)
{
NPWAVEALLOC pWav;

    D3("blkfin");

    /* set the 'done' bit */
    lpHdr->dwFlags |= WHDR_DONE;

    /* We are giving the block back to the application.  The header is no
     * longer in our queue, so we reset the WHDR_INQUEUE bit.  Also, we
     * clear our driver specific bit and cauterize the lpNext pointer.
     */
    lpHdr->dwFlags &= ~(WHDR_INQUEUE | WHDR_REALLYDONE);
    lpHdr->lpNext = NULL;

    pWav = (NPWAVEALLOC)(lpHdr->reserved);

    /* invoke the callback function */
    waveCallback(pWav, WOM_DONE, (DWORD)lpHdr);
}

/****************************************************************************
 * @doc INTERNAL
 * 
 * @api WORD | widFillBuffer | This function fills a buffer from the DMA
 *     buffer.
 * 
 * @parm WORD | wBuffer | add in the DMA buffer.
 * 
 * @parm WORD | wBufSize | Size of the buffer in bytes.
 * 
 * @rdesc The return value is the number of bytes Transferred. A value of zero
 *     indicates that there was no more data in the input queue.
 * 
 * @comm This routine is called once when DMA is started and then again at
 *     interrupt time when a DMA block is complete.  It will in turn call a
 *     callback funtion to the app if it fills a request queue block and a
 *     callback function is defined.
 ***************************************************************************/ 
WORD NEAR PASCAL widFillBuffer()
{
WORD      wBytesTransferred; /* how many bytes transferred to DMA buffer */
WORD      wToGo;             /* min(buf space left, bytes left in data block) */
LPWAVEHDR lpNext;            /* next WAVEHDR in queue */
WORD wBufSize;
wBufSize=(WORD) WaveBufferSizeIn;
    /* if no queue, vamoose */ 
    //D1("wBufSize : #ax"); 
    wBytesTransferred = 0;
    if (!glpWIQueue)
        goto Record_end;
    while (wBytesTransferred < wBufSize) {     
        /* we break if we have no data left or we complete the request */
        if (hpCurInData == NULL) {
            /* first time in for this queue */
            hpCurInData = glpWIQueue->lpData;
            dwCurInCount = glpWIQueue->dwBufferLength;
            glpWIQueue->dwBytesRecorded = 0;
        }

        /* hpCurInData points to an empty spot in a buffer */
        wToGo = (WORD)min(dwCurInCount, (DWORD)(wBufSize - wBytesTransferred));

        /* fill the buffer */
		dwCurInCount -= wToGo;
		if (dwCurInCount==0)
			EndBuffer=1;
		else
			EndBuffer=0;
        hpCurInData = dmaRecord(hpCurInData, wToGo,(WORD) 8);
        wBytesTransferred += wToGo;
        glpWIQueue->dwBytesRecorded += wToGo;
        ((NPWAVEALLOC)LOWORD(glpWIQueue->reserved))->dwByteCount += wToGo;

        /* see if that filled the current buffer */
        if (dwCurInCount == 0) {
            D4("loopfin");

            /* move on to the next block in the queue */
            lpNext = glpWIQueue->lpNext;
            glpWIQueue->dwFlags |= WHDR_DONE;
            glpWIQueue->dwFlags &= ~WHDR_INQUEUE;

            /* release the data block */
            widBlockFinished(glpWIQueue);
            glpWIQueue = lpNext;

            if (glpWIQueue == NULL) {
                /* end of the list */
                D3("endofq");
                hpCurInData = NULL;
                dwCurInCount = 0L;

                /* from the while loop (return wBytesTransferred) */
                break;
            }

            else {
                hpCurInData = glpWIQueue->lpData;
                dwCurInCount = glpWIQueue->dwBufferLength;
                glpWIQueue->dwBytesRecorded = 0;
            }
        }
    }         
Record_end:      
    if (wBytesTransferred < (WORD) WaveBufferSizeIn) 
    	{                
    	DmaFinish(((WORD) WaveBufferSizeIn-wBytesTransferred)/2); 
    	}
    SendCommand(END_XFER,0,0);
    SendParam(8,1,0); 
    
    return wBytesTransferred;
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | widBlockFinished | This function sets the done bit and invokes
 *     the callback function if there is one.
 *
 * @parm LPWAVEHDR | lpHdr | Far pointer to the header.
 *
 * @rdesc There is no return value.
 ***************************************************************************/
void FAR PASCAL widBlockFinished(LPWAVEHDR lpHdr)
{
NPWAVEALLOC  pInClient; 
    /* if it's an empty block, set the 'done' bit and length field */
    if (!(lpHdr->dwFlags & WHDR_DONE)) {
        lpHdr->dwFlags |= WHDR_DONE;
        lpHdr->dwFlags &= ~WHDR_INQUEUE;
        lpHdr->dwBytesRecorded = 0;
    }

    pInClient = (NPWAVEALLOC)(lpHdr->reserved);

    /* call client's callback */
    waveCallback(pInClient, WIM_DATA, (DWORD)lpHdr);      

} 
