        page 60, 132
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   wavea.asm
;                                                                      
;       
;   General Description:
;      Contains wave support routines that don't need to be fixed.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        .286

        .xlist  
        include mpu401.inc
        include cmacros.inc                   
        include windows.inc
        include mmsystem.inc
        include mmddk.inc
        include dream94.inc
        .list

        ?PLM=1                              ; Pascal calling convention
        ?WIN=0                              ; NO! Windows prolog/epilog code   
        public   _OpenFmt
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   extrn declarations
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
        externW  <gwPort>					;inita.asm 
        externA <__AHINCR>                  ; kernel
        externW	 <wForAfter>				; sndblst.asm      
        externB  <gbOpenChan>				; sndblast.asm
        externFP <timeGetTime>              ; MMSystem

        externFP <CReset>                 ; commona.asm
        
        externFP <WriteP16>                 ; sndblst.asm
        externFP <ReadP16>                  ; sndblst.asm  

        externNP <widSendPartBuffer>        ; wavein.c

        externFP <wodDMAStart>         ; wavefix.c

        externD <_lpWOQueue>               ; sndblst.asm
        externD <_glpWIQueue>               ; sndblst.asm  
        
        externB <_Ack_Ok>		; waveout.c  1=acknowledge received, 2=abort received
       
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   segmentation
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

IFNDEF SEGNAME
        SEGNAME equ <_TEXT>
ENDIF

createSeg %SEGNAME, CodeSeg, word, public, CODE

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   data segment
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sBegin Data
FILENAME	DB	"DEBBUG.BIN",0
HDL		DW	?	                        
_OpenFmt	DB	0,0,0,0,0,0,0,0,0   
		globalW	DataSeg,	0		; To save the pc memory segment for dma when sending 
								;  WRT_MEM or RD_MEM. Used in IRQ (AC arrived) to send datas		        
        globalW	DataOff,	0   ; idem for pc memory offset  
        globalW	DataCount,	0   ; idem for data number  
        globalW	DataMode,	0   ; =0 no int expected; =1 if Write mem asked; =1 if read mem asked

sEnd Data

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   code segment
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sBegin CodeSeg

        assumes cs, CodeSeg
        assumes ds, Data


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; @doc INTERNAL
;
; @asm wStart | This function send W_START which make SAM to send IT
;  to request wave datas
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, Data
        assumes es, nothing

cProc wStart <FAR, PASCAL, PUBLIC> <>  
ParmW	noChannel
cBegin  

        mov		ax, noChannel 
		mov		al, W_START
        mov		dx, [gwPort]
        add		dx, MPU401_REG_COMMAND 
		
		EnterCrit  
        call	WriteP16      
        mov		ax, noChannel   
        dec		dx    						; DATA
        call	WriteP16 
		  
        mov     ax, 1
       LeaveCrit
cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;   WORD FAR PASCAL wAcquireHardware( void )
;
;   DESCRIPTION:  Open Wave channel (play or record)
;
;   ENTRY:
;
;   EXIT:
;       IF success
;           AX = 0, go ahead and open
;       ELSE
;           AX = non-zero error code:
;
;   USES:
;       Flags, AX, BX, DX  
;
;  modify 12.12.95
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, Data
        assumes es, nothing

cProc wAcquireHardware <FAR, PASCAL, PUBLIC> <>   
	ParmW noChannel	
	ParmW SRate	
cBegin
        
		EnterCrit
        D2 <wAcquireHardware>
        mov		bx,	noChannel
        D2<  ch=#bx>
;	Notify the P16 for opening channel
       	mov		al, W_OPEN
        mov		dx, [gwPort]
        add		dx, MPU401_REG_COMMAND
        call	WriteP16                    ;send W_OPEN command
        mov		ax, bx                      ; channel number
        dec		dx    						; DATA port
        call	WriteP16
        mov	    al,	_OpenFmt[bx]            ; format
        call	WriteP16
        mov		ax, SRate
        call	WriteP16    
        mov		al, ah  
        call	WriteP16    
        D1 <end acq1>	  
        LeaveCrit
        xor     ax, ax                      ; success

wod_AH_Exit:
        D1 <end acq2>	
cEnd



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; @doc INTERNAL 
;
; @asm WORD | wodWrite | This function is called when a WODM_WRITE message
;	has been received. This function put the new buffer at the end of the queue
;	for the corresponding channel. 
;	Remark : Datas are transfered to the board each time interrupt are received
;           (see : dreamirq.asm & wavefix.c)
;
;     We assume that the header and block are both page locked when they
;     get here.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, Data
        assumes es, nothing

cProc wodWrite <FAR, PASCAL, PUBLIC> <si, di>
        ParmD   lpHdr                   ; pointer to header block 
        ParmW	noChannel
cBegin

        D2 <wodWrite>
		

        ; make sure that the 'next' pointer is zeroed

        les     bx, lpHdr               ; get the header pointer
        xor     ax, ax
        mov     es:[bx].lpWaveNext.off, ax
        mov     es:[bx].lpWaveNext.sel, ax

        ; walk down the current list to the last block

        EnterCrit                       ; don't want the ISR to mod the list
                                        ; while we walk it
        mov		si, noChannel
        shl		si,	2
        les     bx, _lpWOQueue[si]
        mov     ax, es
        or      ax, bx
        jnz     write1                  ; jump if there is a queue

        ; no queue, so point to current block

        les     bx, lpHdr
        mov     _lpWOQueue[si].sel, es
        mov     _lpWOQueue[si].off, bx        ; point to current block 
        shr		si, 2
        jmp     endwrite                  ; go see if we need to start DSP

write1:
        ; see if this is the last block

        mov     ax, es:[bx].lpWaveNext.off
        or      ax, es:[bx].lpWaveNext.sel
        jz      write2                  ; jump if last block

        ; move on down the list

        les     bx, es:[bx].lpWaveNext
        jmp     write1

write2:
        ; ES:BX points to last block

        mov     ax, lpHdr.off
        mov     es:[bx].lpWaveNext.off, ax
        mov     ax, lpHdr.sel
        mov     es:[bx].lpWaveNext.sel, ax
endwrite:  
       LeaveCrit 

cEnd
   
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; @doc INTERNAL 
;
; @asm WORD | wodClose | This function send a W_CLOSE message for the corresponding
;		channel.
;
; @rdesc There is no return value. 
;	create  03-01-95
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, Data
        assumes es, nothing

cProc wClose <FAR, PASCAL, PUBLIC> <>   
ParmW	noChannel
cBegin
        EnterCrit
        mov		al, W_CLOSE
        mov		dx, [gwPort]
        add		dx, MPU401_REG_COMMAND
        call	WriteP16 
        mov		ax, noChannel   
        dec		dx    						; DATA
        call	WriteP16
        LeaveCrit  
        test	noChannel, 8
        jz		wod_close_exit
        cCall   widSendPartBuffer    		; remove buffers        
wod_close_exit:

cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; @doc INTERNAL 
;
; @asm LPVOID | MemCopySrc | Copy a memory block from pc memory buffer
;	to 9407 board.		
;
; PageDst, OffDst | Destination address on 9407 board.
;
;  lpSrc | Source.
;
;  wCount | Number of bytes to copy.
; 
;	File : =1 to copy the data transfered in a file DEBUG.TXT.
;		It's a way to realize a slow DMA, in case of dma errors
; @rdesc Returns the source pointer advanced by <p cnt> bytes.
;
; @comm This function handles segment crossings in the source *only*.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        
        assumes ds, data
        
cProc MemCopySrc <FAR, PASCAL, PUBLIC> <es, di>
        ParmW   PageDst
        ParmW	OffDst
        ParmD   lpSrc
        ParmW   wCount          ; count in word
        parmW	File                
cBegin		
		mov		bx,	10				; Maximum number of try
go_mcs: 
		push	bx
		EnterCrit
        D1 <MemCopySrc>
        les     di, lpSrc             ; get source pointer
        mov		[DataSeg], es
        mov		[DataOff], di
        mov     cx, wCount 
        mov		[DataCount], cx           ; cx is count of bytes 
        D1 <add=#di wCount #cx>
        cmp		cx, 0
        jnz		notzero   
        D1 <zero>
        mov		ax, 1
        LeaveCrit	
		pop		bx				
        jmp    mcs_Exit              ; copy no bytes--return with success
notzero: 
		D1 <notzero>
        mov		dx,	[gwPort] 
        D1 <port #dx>
      	add		dx,	MPU401_REG_COMMAND
		mov		al,	WRT_MEM
		call	WriteP16
		dec		dx						; data register
		mov		ax, OffDst              ; send Start addres on 4 bytes
		call	WriteP16
		mov		al,	ah
		call	WriteP16  
		mov		ax, PageDst  
		call	WriteP16
		mov		al,	ah
		call	WriteP16  
		mov		ax,	wCount
		call	WriteP16                  ; send wCount
		mov		al,	ah 
		D1 <fills  Wait ack>
		call	WriteP16 
		mov		[_Ack_Ok], 0  
		mov		[DataMode], 1                                
		LeaveCrit    
		pop		bx
		; Now, we loop until interrupt (acknowledge or abort) arrived
        mov		cx, 0 
        mov		ah, 30              ; time out after 3s  (30*65536*1.5us)
        inc		dx					; status port
WaitAqmcs:    
		in		al, dx				; 1.5 us
		cmp		[_Ack_Ok], 0  
		loope		WaitAqmcs
		cmp		cx, 0 
		jnz		acknok2 
		dec		ah
		jnz		WaitAqmcs
        ; TIME OUT
        D1<mcs no ackno>
Tim_Out:
        mov		ax, 0               ; fail
        jmp     mcs_Exit
acknok2:
		cmp		[_Ack_Ok], 1		; dma really made ?  
		jz		mcs_ok              ; yes... exit
		dec		bx                  ; One  more time?
		jz		Tim_Out              ; no, exit
		jmp		go_mcs             ; yes, redo
mcs_ok:
		mov		ax,	1				; success  
mcs_Exit:            
cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; @doc INTERNAL 
;
; @asm LPVOID | MemCopyDest |  Copy a memory block from 9407 board 
;	to pc memory buffer.
;
;  lpDst | Destination.
;
; PageSrc, OffSrc | Source.
;
; @parm WORD | wCount | Number of bytes to copy.
;
; @rdesc Returns the destination pointer advanced by <p wCount> bytes.
;
; @comm This function handles segment crossings in the destination *only*.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, data
        assumes es, nothing

cProc MemCopyDst <FAR, PASCAL, PUBLIC> <es, si, di>
        ParmW   PageSrc
        ParmW	OffSrc
        ParmD   lpDst
        ParmW   wCount                ; count in word
cBegin       
		mov		bx,	10				; Maximum number of try
go_mcd:
		push	bx
        EnterCrit
        les     di, lpDst             ; get source pointer  
        mov		[DataSeg], es
        mov		[DataOff], di
        mov     cx, wCount 
        mov		[DataCount], cx           ; cx is count of bytes
        D1 <count #cx>
        cmp		cx, 0
        jnz		notzero2 
        mov		ax, 1  
        LeaveCrit
		pop		bx
        jmp    mcd_Exit              ; copy no bytes--return current pointer...
notzero2:
        mov		dx,	[gwPort]
      	add		dx,	MPU401_REG_COMMAND
		mov		al,	READ_MEM
		call	WriteP16
		dec		dx						; data register
		mov		ax, OffSrc              ; send Start addres on 4 bytes
		call	WriteP16
		mov		al,	ah
		call	WriteP16  
		mov		ax, PageSrc  
		call	WriteP16
		mov		al,	ah
		call	WriteP16  
		mov		ax,	wCount
		call	WriteP16                  ; send wCount
		mov		al,	ah 
		D1 <fills  Wait ack>
		call	WriteP16
		mov		[_Ack_Ok], 0
		mov		[DataMode], 2
		LeaveCrit    
		
		pop		bx		;restore count

		; Now, we loop until interrupt (acknowledge or abort) arrived
        mov		cx, 0 
        mov		ah, 30              ; time out after 3s  (30*65536*1.5us)
        inc		dx					; status port
WaitAqmcd:    
		in		al, dx				; 1.5 us
		cmp		[_Ack_Ok], 0  
		loope		WaitAqmcd
		cmp		cx, 0 
		jnz		acknok 
		dec		ah
		jnz		WaitAqmcd
        ; TIME OUT
        D1<mcd no ackno>
Tim_Out2:
        mov		ax, 0               ; fail
        jmp     mcd_Exit
acknok:
		cmp		[_Ack_Ok], 1		; dma really made ?
		jz		mcd_ok
		dec		bx                  ; One  more time?
		jz		Tim_Out2           ; no, exit
		jmp		go_mcd             ; yes, redo  
		mov		ax, 0               ; fail 
		D1 <mcd fail>
        jmp     mcd_Exit 
mcd_ok:  
		D1 <mcd succeed>
		mov		ax,	1				; success
mcd_Exit:            
cEnd
          

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; @doc INTERNAL 
;
;  GetMMTAdd 
; called by  GetMemMapAddress()
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, data

cProc GetMMTAdd <FAR, PASCAL, PUBLIC> <>
cBegin   
		EnterCrit
		mov		dx, [gwPort] 
		add		dx,	MPU401_REG_COMMAND   ;command get memory mapping table address  
		mov		al,	GET_MMT
		call	WriteP16  
		dec		dx            
		mov		al,	0
		call	WriteP16 
		LeaveCrit 
cEnd 
                    
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; @doc INTERNAL 
;
;  SetMMTAdd 
; called by  SetMemMapAddress()
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, data
        assumes es, nothing

cProc SetMMTAdd <NEAR, PASCAL, PUBLIC> <es,di>
        ParmD   Address
cBegin  
		EnterCrit
		mov		dx, [gwPort] 
		add		dx,	MPU401_REG_COMMAND   ;command get memory mapping table address  
		mov		al,	SET_MMT
		call	WriteP16 
		dec		dx			; Data port
		;les		di, Address
		mov		ax, word ptr Address
		call	WriteP16         ; send address LSB first
		mov		al, ah
		call	WriteP16
		mov		ax, word ptr Address + 2
		call	WriteP16
		mov		al, ah
		call	WriteP16   
		LeaveCrit
cEnd

   
   
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;
;  SetVolume 
; Change the current volume of the channel
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, data

cProc SetVolume <FAR, PASCAL, PUBLIC> <>
        ParmW 	noChannel
        ParmW 	VolLeft
        ParmW	VolRight
cBegin  
		EnterCrit   
		mov		bx, noChannel
		mov		dx, [gwPort] 
		add		dx,	MPU401_REG_COMMAND   ;command regiter 
		add		dx, COM_OFFSET
		D1 <left>
		mov		al,	W_VOLLEFT
		call	WriteP16 
		dec		dx			; Data port 
		mov 	ax, bx
		call	WriteP16 
		mov		ax, VolLeft 
		call	WriteP16 
		mov		al, ah
		call	WriteP16 
		inc		dx 
		D1 <right>
		mov		al,	W_VOLRIGHT
		call	WriteP16 
		dec		dx			; Data port 
		mov 	ax, bx
		call	WriteP16 
		mov		ax, VolRight
		call	WriteP16  
		mov		al, ah
		call	WriteP16
		LeaveCrit
cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;
;  SetAuxVolume 
; Change the current auxiliary volume of the channel
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, data

cProc SetAuxVolume <FAR, PASCAL, PUBLIC> <>
        ParmW 	noChannel
        ParmW 	AuxLeft
        ParmW	AuxRight
cBegin  
		EnterCrit   
		mov		bx, noChannel
		mov		dx, [gwPort] 
		add		dx,	MPU401_REG_COMMAND   ;command regiter
		add		dx, COM_OFFSET
		mov		al,	W_VOLAUXLEFT
		call	WriteP16 
		dec		dx			; Data port 
		mov 	ax, bx
		call	WriteP16 
		mov		ax, AuxLeft
		call	WriteP16 
		mov		al, ah
		call	WriteP16               
		inc		dx
		mov		al,	W_VOLAUXRIGHT
		call	WriteP16 
		dec		dx			; Data port 
		mov 	ax, bx
		call	WriteP16 
		mov		ax, AuxRight
		call	WriteP16  
		mov		al, ah
		call	WriteP16
		LeaveCrit
cEnd

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;
;  BOOL WaitAcknowledge 
; Wait for acknowledge Ack to be returned by board. If Time out, return 0.
; Return 1, success
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, data

cProc WaitAcknowledge <FAR, PASCAL, PUBLIC> <>
        ParmB   Ack  
cBegin
		EnterCrit          
		mov		cx, 1000  
read_mpu:
		call	ReadP16 
		cmp		al, Ack               ; is it our so expected acknowledge ?
		loopne	read_mpu              ; No, let's try again!
		cmp		al, Ack               
		je		ack_arrived           
		D1< Error : Time out, return 1>
		mov		ax, 1                  ; TIMEOUT  ,  return 1
		jmp		ack_exit
ack_arrived:
		D1 <Ok, return 0>
		mov		ax, 0         			;OK,  return 0  
ack_exit:
		LeaveCrit
cEnd         

      
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;
;  SendCommand 
; Send Command to port 0x331   
; End=1 if end of mpu message 
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, data

cProc SendCommand <FAR, PASCAL, PUBLIC> <>
        ParmB   Command   
        ParmB	xEnd
		ParmW	OffsetAdd
cBegin
		cli          
		mov		dx, [gwPort] 
		mov		bx, OffsetAdd
		add		dx, bx
		add		dx,	MPU401_REG_COMMAND   ;command regiter
		mov		al,	Command
		call	WriteP16
		
		mov		al, xEnd
		cmp		al, 0
		je		sc_exit 
		D1<LeaveCrit>
		sti 
sc_exit:
cEnd         

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;
;  SendParam
; Send parameter to port 0x330
; End=1 if end of mpu message 
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, data

cProc SendParam <FAR, PASCAL, PUBLIC> <>
        ParmB   Param   
        ParmB	pEnd
		ParmW	OffsetAdd
cBegin                      
		mov		dx, [gwPort]
		mov		bx, OffsetAdd  
		add		dx, bx                             
		mov		al,	Param
		call	WriteP16
		
		mov		al, pEnd
		cmp		al, 0
		je		sp_exit 
		;D1<LEAVE CRIT>
		sti 
sp_exit:
cEnd


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;
;  VoiceMemory (called by DefineVoiceMemory)
; Send comman and parameters for  VOI_MEM command
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, data

cProc VoiceMemory <NEAR, PASCAL, PUBLIC> <es, di>
        ParmB   Voice
        ParmB	Format
        ParmB	Bank
        ParmD	Start
        ParmB	BkLoop
        ParmD	PLoop
        ParmB	BkEnd
        ParmD	PEnd 
cBegin
		EnterCrit
		mov		dx, [gwPort] 
		add		dx,	MPU401_REG_COMMAND   ;command get memory mapping table address  
		mov		al,	VOI_MEM
		call	WriteP16 
		dec		dx			; Data port  
		
		mov		al, Voice  
		call	WriteP16 
		    
		mov		al, Format
		call	WriteP16  
		    
		mov		al, Bank
		call	WriteP16 
		      
		les		di, Start
		push	es
		mov 	ax, di   
		call	WriteP16 
		mov		al, ah
		call	WriteP16   
		pop		ax
		call	WriteP16 
		
		mov		al, BkLoop
		call	WriteP16 
		      
		les		di, PLoop
		push	es
		mov 	ax, di   
		call	WriteP16 
		mov		al, ah
		call	WriteP16   
		pop		ax
		call	WriteP16   
		
		mov		al, BkEnd
		call	WriteP16 
		      
		les		di, PEnd
		push	es
		mov 	ax, di   
		call	WriteP16 
		mov		al, ah
		call	WriteP16   
		;mov 	ax, es   
		pop		ax
		call	WriteP16 
	 
		LeaveCrit
cEnd	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;
;  SetModPosition (called by ModGetNewPos)
; Send command and parameters for  SET_POS command
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        assumes ds, data

cProc SetModPosition <NEAR, PASCAL, PUBLIC> <es, di>
        ParmB   Voice
        ParmB	bank
        ParmB	Bank
        ParmD	Poffset
cBegin  
		EnterCrit
		mov		dx, [gwPort] 
		add		dx,	MPU401_REG_COMMAND   ;command get memory mapping table address  
		mov		al,	SET_POS
		call	WriteP16 
		dec		dx			; Data port  
		
		mov		al, Voice  
		call	WriteP16 
		    
		mov		al, bank
		call	WriteP16  

		les		di, Poffset
		push	es
		mov 	ax, di   
		call	WriteP16 
		mov		al, ah
		call	WriteP16   
		pop		ax
		call	WriteP16
	 
		LeaveCrit
cEnd	
	
sEnd CodeSeg

        end
