
/****************************************************************************
 *
 *   midifix.c
 *
 *   Copyright (c) 1991-1992 Microsoft Corporation.  All Rights Reserved.
 *
 *   NOTE - This code makes assumptions about machine architecture. It
 *      is written relying on 'Intel' lo-byte, hi-byte data storage.
 *
 ***************************************************************************/

#include <windows.h>
#include <mmsystem.h>
#include <mmddk.h>
#include "dream94.h"
#include "dream.h"

/****************************************************************************

    MIDI defines

 ***************************************************************************/

#define MIDI_DATA_FIRST             0x00
#define MIDI_DATA_LAST              0x7F
#define MIDI_STATUS_FIRST           0x80
#define MIDI_STATUS_LAST            0xFF


/* 'channel' status bytes */
#define MIDI_STATUS_CHANNEL_FIRST   0x80
#define MIDI_STATUS_CHANNEL_LAST    0xE0
#define MIDI_STATUS_CHANNEL_MASK    0xF0

/* channel voice messages */
#define MIDI_VOICE_NOTE_OFF         0x80
#define MIDI_VOICE_NOTE_ON          0x90
#define MIDI_VOICE_POLY_PRESSURE    0xA0
#define MIDI_VOICE_CONTROL_CHANGE   0xB0
#define MIDI_VOICE_PROGRAM_CHANGE   0xC0
#define MIDI_VOICE_CHANNEL_PRESSURE 0xD0
#define MIDI_VOICE_PITCH_BEND       0xE0

/* channel mode messages */
#define MIDI_MODE_CHANNEL           MIDI_VOICE_CONTROL_CHANGE


/* 'system' status bytes */
#define MIDI_STATUS_SYSTEM_FIRST    0xF0
#define MIDI_STATUS_SYSTEM_LAST     0xFF

/* system exclusive messages */
#define MIDI_SYSEX_BEGIN            0xF0
#define MIDI_SYSEX_EOX              0xF7

/* system common messages */
#define MIDI_COMMON_TCQF            0xF1    /* time code quarter frame  */
#define MIDI_COMMON_SONG_POSITION   0xF2
#define MIDI_COMMON_SONG_SELECT     0xF3
#define MIDI_COMMON_UNDEFINED_F4    0xF4
#define MIDI_COMMON_UNDEFINED_F5    0xF5
#define MIDI_COMMON_TUNE_REQUEST    0xF6

/* system real-time messages */
#define MIDI_RTIME_TIMING_CLOCK     0xF8
#define MIDI_RTIME_UNDEFINED_F9     0xF9
#define MIDI_RTIME_START            0xFA
#define MIDI_RTIME_CONTINUE         0xFB
#define MIDI_RTIME_STOP             0xFC
#define MIDI_RTIME_UNDEFINED_FD     0xFD
#define MIDI_RTIME_ACTIVE_SENSING   0xFE
#define MIDI_RTIME_SYSTEM_RESET     0xFF  
typedef struct Mid_Pan {
		int 	LsR10;
		BYTE	Pan;
		} MidPan ;

MidPan MidiPan[24]={1060,1,750,2,530,3,370,4,220,5,190,6,160,7,140,8,130,9,110,10,100,11,80,13,
	70,17,56,21,47,25,40,29,33,33,28,37,20,41,18,45,16,49,14,53,12,57,10,61};
DWORD GMVolume;
WORD MidiCurrent=0,MidiState[2]={FREE,FREE};
int MidiNb=0;

extern gwPort;		//inita.asm 

extern PHARDWAREINSTANCE   phwi ;

extern BOOL MidiCaps;		// ApiVxd.c


//BYTE UartAc;
/*****************************************************************************

    public data

 ****************************************************************************/ 

PORTALLOC       gMidiInClient;      /* input client information structure */
MIDIINMSGCLIENT gMIMC;              /* MIDI input msg client */

BOOL MidiOut=FALSE;
/*****************************************************************************

    local data

 ****************************************************************************/ 

static PORTALLOC    gMidiOutClient[2];         /* client information */
static BYTE         gbMidiOutCurrentStatus[2]  = {0,0};
                                     
#ifdef DEBUG
#define D(x)    {x;}
DWORD   gdwDebugMODWriteErrors  = 0;
DWORD   gdwDebugMODataWrites    = 0;
DWORD   gdwDebugMOShortMsgs     = 0;
DWORD   gdwDebugMOShortMsgsRS   = 0;
DWORD   gdwDebugMOShortMsgsBogus= 0;
DWORD   gdwDebugMOLongMsgs      = 0;

DWORD   gdwDebugMIBytesRcvd     = 0;
DWORD   gdwDebugMIShortMsgsRcvd = 0;
DWORD   gdwDebugMILongMsgsRcvd  = 0;
WORD    gwDebugMILongErrors     = 0;
WORD    gwDebugMIShortErrors    = 0;

DWORD   gdwDebugMidiDrvCallbacks= 0;
#else
#define D(x)
#endif


#define MSGLENCHANNEL(bStatus)  gabMsgLenChannel[(BYTE)((bStatus) >> 4) - (BYTE)8]
#define MSGLENSYSTEM(bStatus)   gabMsgLenSystem[(BYTE)(bStatus - MIDI_STATUS_SYSTEM_FIRST)];

/* channel status message lengths */
static BYTE gabMsgLenChannel[] =
{
    3,      /* 0x80 note off        */
    3,      /* 0x90 note on         */
    3,      /* 0xA0 key pressure    */
    3,      /* 0xB0 control change  */
    2,      /* 0xC0 program change  */
    2,      /* 0xD0 channel pressure*/
    3       /* 0xE0 pitch bend      */
};

/** system status message lengths **/
static BYTE gabMsgLenSystem[] =
{
    1,      /* 0xF0 sysex begin     */
    2,      /* 0xF1 midi tcqf       */
    3,      /* 0xF2 song position   */
    2,      /* 0xF3 song select     */
    1,      /* 0xF4 undefined       */
    1,      /* 0xF5 undefined       */
    1,      /* 0xF6 tune request    */
    1,      /* 0xF7 sysex eox       */

    1,      /* 0xF8 timing clock    */
    1,      /* 0xF9 undefined       */
    1,      /* 0xFA start           */
    1,      /* 0xFB continue        */
    1,      /* 0xFC stop            */
    1,      /* 0xFD undefined       */
    1,      /* 0xFE active sensing  */
    1       /* 0xFF system reset    */
};

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | midiCallback | This calls DriverCallback for a midi device.
 *
 * @parm NPPORTALLOC| pPort | Pointer to the PORTALLOC.
 *
 * @parm WORD | msg | The message to send.
 *
 * @parm DWORD | dw1 | Message-dependent parameter.
 *
 * @parm DWORD | dw2 | Message-dependent parameter.
 *
 * @rdesc There is no return value.
 ***************************************************************************/
void FAR PASCAL midiCallback(NPPORTALLOC pPort, WORD msg, DWORD dw1, DWORD dw2)
{
#ifdef DEBUG
    switch (msg) {
        case MIM_DATA:
            gdwDebugMIShortMsgsRcvd++;
            break;

        case MIM_LONGDATA:
            gdwDebugMILongMsgsRcvd++;
            break;

        case MIM_ERROR:
            D2("MIM_ERROR");
            gwDebugMIShortErrors++;
            break;

        case MIM_LONGERROR:
            D2("MIM_LONGERROR");
            gwDebugMILongErrors++;
            break;
    }
    gdwDebugMidiDrvCallbacks++;
#endif

    /*  Invoke the callback function, if it exists.  dwFlags contains driver-
     *  specific flags in the LOWORD and generic driver flags in the HIWORD
     *
     *  DON'T switch stacks in DriverCallback - we already did at the
     *  beginning of our ISR (using StackEnter).  No need to burn another
     *  stack, we should have plenty of room for the callback.  Also,
     *  we may not have been called from an ISR.  In that case, we know
     *  that we are on an app's stack, and this should be ok.
     */
    if (pPort->dwCallback)
        DriverCallback(pPort->dwCallback,       /* client's callback DWORD */
                       HIWORD(pPort->dwFlags) | 8,  /* flags */
                       pPort->hMidi,            /* handle to the wave device */
                       msg,                     /* the message */
                       pPort->dwInstance,       /* client's instance data */
                       dw1,                     /* first DWORD */
                       dw2);                    /* second DWORD */
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | midBufferWrite | This function writes a byte into the long
 *      message buffer.  If the buffer is full or end-of-sysex byte is
 *      received, the buffer is marked as 'done' and it's owner is called
 *      back.
 *
 * @parm BYTE | byte | The byte received.
 *
 * @rdesc There is no return value
 ***************************************************************************/
static void NEAR PASCAL midBufferWrite( BYTE bByte )
{
LPMIDIHDR   lpmh;

    /* if no buffers, nothing happens */
    if ( !(lpmh = gMIMC.lpmhQueue) ) 
        return;

    /* if the long message is being terminated, only save eox byte */
    if ( (bByte < MIDI_STATUS_FIRST) || (bByte == MIDI_SYSEX_EOX) || (bByte == MIDI_SYSEX_BEGIN) ) {
        /* write the data into the long message buffer */
        *((HPSTR)(lpmh->lpData) + gMIMC.dwCurData++) = bByte;

        /* if !(end of sysex or buffer full), return */
        if ( !((bByte == MIDI_SYSEX_EOX) || (gMIMC.dwCurData >= lpmh->dwBufferLength)) )
            return;
    }

    /* send client back the data buffer */
    D4("bufferdone");
    gMIMC.lpmhQueue       = gMIMC.lpmhQueue->lpNext;
    lpmh->dwBytesRecorded = gMIMC.dwCurData;
    gMIMC.dwCurData       = 0L;
    lpmh->dwFlags        |= MHDR_DONE;
    lpmh->dwFlags        &= ~MHDR_INQUEUE;
    midiCallback( &gMidiInClient, MIM_LONGDATA, (DWORD)lpmh, gMIMC.dwMsgTime );
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | midByteRec | This function constructs the complete midi
 *      messages from the individual bytes received and passes the message
 *      to the client via his callback.
 *
 * @rdesc There is no return value
 *
 * @comm NOTE: running status is not turned off on errors
 ***************************************************************************/
void NEAR PASCAL midByteRec( BYTE bByte )
{
DWORD   dwCurTime;

    /* time byte received */
    dwCurTime = timeGetTime() - gMIMC.dwRefTime;

    D( gdwDebugMIBytesRcvd++ );

    /*  System Real-Time Messages (SRTM) range from 0xF8 to 0xFF.
     *
     *  There are no data bytes attached to SRTM status bytes and
     *  they can appear _anywhere_ in the data stream.  They should
     *  affect _nothing_.  They do not terminate SysEx, do not reset
     *  running status, nothing.  Just send them up.
     */
    if ( bByte >= MIDI_RTIME_TIMING_CLOCK ) {
        D4("rt");
        midiCallback( &gMidiInClient, MIM_DATA, (DWORD)bByte, dwCurTime );
    }

    /* if the high bit is set (>= 0x80), then it is a status byte */
    else if ( bByte >= (BYTE)MIDI_STATUS_FIRST ) {
        /*  SysEx, if going, can be terminated by either an End of 
         *  Exclusion (EOX, 0xF7) or any other Status Byte (except real-
         *  time messages which are handled above).  An EOX _should_
         *  always be sent at the end of a SysEx message, but any status
         *  byte is legal.
         */
        if ( gMIMC.fSysEx ) {
            /* bStatus should never be set if in SysEx */
            AssertT( gMIMC.bStatus );

            /* reset SysEx flag--it has been terminated */
            gMIMC.fSysEx = FALSE;

            /* post sysex data back to caller */
            midBufferWrite( bByte );

            /*  If this was an EOX, then we are done.  If it is a different
             *  status byte, then we have terminated the SysEx, but we still
             *  need to process the new status byte.
             */
            if ( bByte == MIDI_SYSEX_EOX )
                return;
        }

        /*  If there is a partially recorded short message, then post
         *  it with an error (it's considered garbage).  The first byte
         *  of the message is non-zero if partly recorded.
         */
        if ( (BYTE)gMIMC.dwShortMsg ) {
            D2("bogusshortmsg");
            midiCallback( &gMidiInClient, MIM_ERROR, gMIMC.dwShortMsg, gMIMC.dwMsgTime );
            gMIMC.dwShortMsg = 0L;
        }

        /*  The message time is always the time at which the 'status' byte
         *  for the message was received.  So set this.
         */
        gMIMC.dwMsgTime = dwCurTime;

        /*  There are two different types of messages that bByte could
         *  represent: channel messages (0x80 - 0xE0) or system messages
         *  (0xF0 - 0xFF).  We already took care of the system 'real-time
         *  messages' (0xF8 - 0xFF) above, so we don't need to check for
         *  them.
         *
         *  So is it a 'system' status byte or a 'channel' status byte?
         */
        if ( bByte >= MIDI_STATUS_SYSTEM_FIRST ) {
            /* running status applies to channel messages only */
            gMIMC.bStatus = 0;

            switch ( bByte ) {
                case MIDI_SYSEX_BEGIN:
                    D4("sysexbegin");
                    gMIMC.fSysEx = TRUE;
                    midBufferWrite( bByte );
                    break;

                case MIDI_SYSEX_EOX:
                    D4("sysexeox error");
                    gMIMC.bBytePos = 0;
                    goto midByteRecBadData;

                case MIDI_COMMON_UNDEFINED_F4:
                case MIDI_COMMON_UNDEFINED_F5:
                case MIDI_COMMON_TUNE_REQUEST:
                    D4("common0");
                    midiCallback( &gMidiInClient, MIM_DATA, (DWORD)bByte, gMIMC.dwMsgTime );
                    gMIMC.bBytePos = 0;
                    break;

                case MIDI_COMMON_TCQF:
                case MIDI_COMMON_SONG_SELECT:
                    D4("common1");
                    (BYTE)gMIMC.dwShortMsg = bByte;
                    gMIMC.bBytesLeft = 1;
                    gMIMC.bBytePos = 1;
                    break;

                case MIDI_COMMON_SONG_POSITION:
                    D4("common2");
                    (BYTE)gMIMC.dwShortMsg = bByte;
                    gMIMC.bBytesLeft = 2;
                    gMIMC.bBytePos = 1;
                    break;

#ifdef DEBUG
                default:
                    D1("VERY VERY BAD SYSTEM STATUS MSG!!!");
                    AssertT( 1 );
                    break;
#endif
            }
        }

        /* it is a 'channel' voice status byte (0x80 - 0xE0) */
        else {
            D4("voice");

            /* running status applies to channel messages only */
            gMIMC.bStatus = bByte;
            (BYTE)gMIMC.dwShortMsg = bByte;
            gMIMC.bBytePos = 1;

#ifdef DEBUG
            /* this cannot happen with the current code logic */
            if ((bByte < MIDI_STATUS_CHANNEL_FIRST) || (bByte >= MIDI_STATUS_SYSTEM_FIRST)) {
                D1("VERY VERY BAD CHANNEL STATUS MSG!!!");
                AssertT( 1 );
                gMIMC.bBytesLeft = 0;
            }
            else
#endif
            /* convert channel status byte to number of bytes remaining */
            gMIMC.bBytesLeft = MSGLENCHANNEL(bByte) - (BYTE)1;
        }
    } /* if (bByte == status byte) */

    /*  bByte is not a status byte (it is <= 0x7F and is considered a data
     *  byte).
     */
    else {
        /* if in SysEx receive mode, then record byte in long message */
        if ( gMIMC.fSysEx ) {
            D4("sx");

            /* write in long message buffer */
            midBufferWrite( bByte );
        }

        /* else if it's an expected data byte for a short message */
        else if ( gMIMC.bBytePos != 0 ) {
            D4("data");

            /* if running status */
            if ( gMIMC.bStatus && (gMIMC.bBytePos == 1) ) {
                /* setup for next short message */
                (BYTE)gMIMC.dwShortMsg = gMIMC.bStatus;
                gMIMC.dwMsgTime = dwCurTime;
            }

            /*** not portable! (like most of the code) ***/
            ((LPBYTE)&gMIMC.dwShortMsg)[ gMIMC.bBytePos++ ] = bByte;

            if ( --(gMIMC.bBytesLeft) == 0 ) {
                midiCallback( &gMidiInClient, MIM_DATA, gMIMC.dwShortMsg, gMIMC.dwMsgTime );
                gMIMC.dwShortMsg = 0L;

                if ( gMIMC.bStatus ) {
                    gMIMC.bBytesLeft = gMIMC.bBytePos - (BYTE)1;
                    gMIMC.bBytePos = 1;
                }

                else
                    gMIMC.bBytePos = 0;
            }
        }

        else {
            D2("baddata");

midByteRecBadData:
            midiCallback( &gMidiInClient, MIM_ERROR, (DWORD)bByte, gMIMC.dwMsgTime );
        }
    }
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | modSendData | This function sends RAW MIDI data; keeping
 *      track of the running status correctly.
 *
 * @rdesc The is no return value.
 *
 * @comm 
 ***************************************************************************/
static void NEAR PASCAL modSendData( HPSTR lpBuf, DWORD dwLength, WORD id )
{
BYTE    bByte;

    while ( dwLength-- ) {
        bByte = *lpBuf++;

        if ( (bByte >= MIDI_STATUS_FIRST) && (bByte < MIDI_RTIME_TIMING_CLOCK) )
        {
            gbMidiOutCurrentStatus[id] = (BYTE)((bByte < MIDI_STATUS_SYSTEM_FIRST) ? bByte : 0);
        }
        
if (!MidiOut)
	{				// let's send EN_MIDIOUT
	EnableMidi();   
	MidiOut=TRUE;
	}     
 
#ifdef DEBUG
        if ( modDataWrite( bByte ) )      
            gdwDebugMODWriteErrors++;
        else
            gdwDebugMODataWrites++; 
#else
        modDataWrite( bByte );
#endif  
    }
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | modSendLongData | This function sends a long message.
 *
 * @rdesc The return value is an error code (0L if success).
 ***************************************************************************/
static DWORD NEAR PASCAL modSendLongData( LPMIDIHDR lpHdr, WORD id )
{
    D( gdwDebugMOLongMsgs++ );

    /*  Check if it's been prepared.  NOTE: this check is ONLY necessary
     *  for compatibility with V1.0 of MMSYSTEM.  All later versions of
     *  MMSYSTEM validate this flag before the driver is called.
     */
    if ( lpHdr->dwFlags & MHDR_PREPARED ) {
        /*  NOTE: clearing the DONE bit or setting the INQUEUE bit
         *  isn't necessary here since this function is synchronous -
         *  the client will not get control back until it's done.
         */
        modSendData( lpHdr->lpData, lpHdr->dwBufferLength, id );

        /* set the done bit */
        lpHdr->dwFlags |= MHDR_DONE;

        /* notify client */
        midiCallback(&(gMidiOutClient[id]), MOM_DONE, (DWORD)lpHdr, 0L);
        return 0L;
    }

    /* oops! */
    else
        return MIDIERR_UNPREPARED;
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | modSendShortMsg | This function sends a short message.
 *
 * @rdesc The return value is the number of bytes transmitted.
 ***************************************************************************/
static BYTE NEAR PASCAL modSendShortMsg( DWORD dwShortMsg, WORD id )
{
BYTE    bByte   = (BYTE)dwShortMsg;
BYTE    bLength;
//long n;
    /* if the short msg starts with a status msg, compute length */
    if ( bByte >= MIDI_STATUS_FIRST ) {
        bLength = (bByte < MIDI_STATUS_SYSTEM_FIRST) ? MSGLENCHANNEL(bByte) : MSGLENSYSTEM(bByte);
        D( gdwDebugMOShortMsgs++ );
    }

    /* use previous running status length */
    else if ( !(gbMidiOutCurrentStatus[id]) ) {
        D( gdwDebugMOShortMsgsBogus++ );
        return 0;
    }

    /* subtract one because we don't have a status byte */
    else {
        bLength = MSGLENCHANNEL(gbMidiOutCurrentStatus[id]) - (BYTE)1;
        D( gdwDebugMOShortMsgsRS++ );
    }

    /* send the data */
    modSendData( (HPSTR)&dwShortMsg, bLength, id );

    /* return number of bytes sent */
    return ( bLength );
}

/****************************************************************************
 * @doc INTERNAL
 *
 * @api void | modReset | This function turns all notes OFF.
 *
 * @rdesc There is no return value.
 ***************************************************************************/
static void NEAR PASCAL modReset( void )
{
WORD    i;

#ifdef DEBUG
    WORD wOldDebugLevel = wDebugLevel;

    /* for normal debugging, don't flood output with note off msgs! */
    if ( (wDebugLevel > 2) && (wDebugLevel < 5) )
        wDebugLevel = 2;
#endif

    D2("modresetBEGIN");

    /*  !!! this is not recommended by midi spec !!!
     *  send a note off to each key on each channel
     */ 
     SendCommand(0xb0,1,0);
    for ( i = 0; i < 16; i++ ) {
        /* turn off damper pedal (sustain) */
        modSendShortMsg( (WORD)0x40B0 | i,0 );  
        modSendShortMsg( (WORD)0x78B0 | i,0 );
    }    
    
    SendCommand(0xb1,1,0);
    for ( i = 0; i < 16; i++ ) {
        /* turn off damper pedal (sustain) */
        modSendShortMsg( (WORD)0x40B0 | i,1 );  
        modSendShortMsg( (WORD)0x78B0 | i,1 );
    }

    D2("modresetEND");

#ifdef DEBUG
    wDebugLevel = wOldDebugLevel;

    gdwDebugMODWriteErrors  = 0;
    gdwDebugMODataWrites    = 0;
    gdwDebugMOShortMsgs     = 0;
    gdwDebugMOShortMsgsRS   = 0;
    gdwDebugMOShortMsgsBogus= 0;
    gdwDebugMOLongMsgs      = 0;

    gdwDebugMIBytesRcvd     = 0;
    gdwDebugMIShortMsgsRcvd = 0;
    gdwDebugMILongMsgsRcvd  = 0;
    gwDebugMILongErrors     = 0;
    gwDebugMIShortErrors    = 0;

    gdwDebugMidiDrvCallbacks= 0;
#endif

    /* !!! reset running status */ 
    gbMidiOutCurrentStatus[0] = 0;
    gbMidiOutCurrentStatus[1] = 0; 
}

/****************************************************************************

    This function conforms to the standard MIDI output driver message proc

 ***************************************************************************/
DWORD FAR PASCAL _loadds modMessage(WORD id, UINT msg, DWORD dwUser, DWORD dwParam1, DWORD dwParam2)
{
static WORD wMidiOutEntered = 0;        /* reentrancy check */         
BYTE MixVal,Vol,VolL,VolR;
WORD nTodiv;
DWORD       dwReturn;          

switch (msg) {
		case MODM_INIT:
      {
         D1("MODM_INIT" ) ;

         // dwParam2 == PnP DevNode

         return (AddDevNode( dwParam2 )) ;
      }
      break ;

      case DRVM_ENABLE:
      {
         UINT   uVxDId ;
         ULONG  cIds ;

         D1( "MODM_ENABLE" ) ;

         // dwParam2 == PnP DevNode

         // Query the supporting VxD ID

         cIds = 1 ;

         if (midiOutMessage( (HMIDIOUT) dwParam1, DRV_QUERYDRIVERIDS,
                             (DWORD) (LPWORD) &uVxDId, 
                             (DWORD) (LPDWORD) &cIds ))
            return MMSYSERR_INVALPARAM ;

         return (EnableDevNode( dwParam2, uVxDId )) ;

      }
      break ;

      case DRVM_DISABLE:
      {
         D1( "MODM_DISABLE" ) ;

         // dwParam2 == PnP DevNode

         return (DisableDevNode( dwParam2 )) ;

      }
      break ;

      case DRVM_EXIT:
      {
         D1( "MODM_EXIT" ) ;

         // dwParam2 == PnP DevNode

         return (RemoveDevNode( dwParam2 )) ;

      }
      break ;
}
    if ( !gfEnabled ) {
        D1("modMessage called while disabled");
        return ( (msg == MODM_GETNUMDEVS) ? 0L : MMSYSERR_NOTENABLED );
    }

    /* this driver only supports one device */
    if ( id > 1 ) {
        D1("invalid midi device id");
        return MMSYSERR_BADDEVICEID;
    }

    switch ( msg ) {

        case MODM_GETNUMDEVS:
            D1("MODM_GETNUMDEVS");

			if (!MidiCaps)		// Is the Firmware able to play midi?
				return 0;

			if (!MidiNb)
			{
				WORD wStatus;
				if (UpLoad(&wStatus,0,0x20f,1)) 	//Load the dream status byte 
				{
					return 0;
				}
				if (wStatus & 0x400)
					MidiNb=2;
				else
					MidiNb=1;
			}

           	return MidiNb;

        case MODM_GETDEVCAPS:
            D1("MODM_GETDEVCAPS");
            modGetDevCaps((MDEVICECAPSEX FAR *)dwParam1,id);
            return 0L;

        case MODM_OPEN:
            
			{
				
			DWORD  dn ;
			D1("MODM_OPEN");

			dn = ((LPMIDIOPENDESC) dwParam1) -> dnDevNode ;

			if (!MidiCaps)		// Is the Firmware able to play midi?
				return MMSYSERR_ALLOCATED;

         if (NULL == 
               (phwi = DevNodeToHardwareInstance( dn )))
         {
            D1("devnode not associated with hardware instance???" ) ;
            return MMSYSERR_BADDEVICEID ;
         }    
         	D1("phwi ok");
            /* now attempt to 'acquire' the MIDI output hardware */  
            if (!AcquireMPU401( phwi ))
			  return MMSYSERR_ALLOCATED ;
            
            D1("ret from acquire");

            // Let's free the port if needed
            /*if (FreeMpuPort())  
            	{
            	ReleaseMPU401( phwi ) ;
            	return MMSYSERR_ALLOCATED; 
            	}*/     
            if (MidiState[id]!=FREE)
            {
                D1("MIDI output hardware is unavailable!"); 
                ReleaseMPU401( phwi ) ;
                return MMSYSERR_ALLOCATED;
            }       
            MidiState[id]=MIDI_ALLOC;
            
            /* save client information */
            gMidiOutClient[id].dwCallback = ((LPMIDIOPENDESC)dwParam1)->dwCallback;
            gMidiOutClient[id].dwInstance = ((LPMIDIOPENDESC)dwParam1)->dwInstance;
            gMidiOutClient[id].hMidi      = ((LPMIDIOPENDESC)dwParam1)->hMidi;
            gMidiOutClient[id].dwFlags    = dwParam2;

            /* !!! reset running status */
            gbMidiOutCurrentStatus[id] = 0;
            
            /* notify client */
            midiCallback(&(gMidiOutClient[id]), MOM_OPEN, 0L, 0L);

            return 0L;
			}
			break;

    	case MODM_SETVOLUME:
              D1("MODM_SETVOLUME");
              GMVolume=dwParam1;
              VolL=(BYTE) ((GMVolume>>8) & 0xff);
              VolR=(BYTE) ((GMVolume >> 24) & 0xff); 
              // find the pan value
              D1("Go to checkmix");  
              MixVal=CheckMix(VolL, VolR,&nTodiv);  
              D1("ret from checkmix");  
              Vol=(BYTE)((VolL/2+VolR/2)*100/nTodiv); 
              D1("Go to send");  
			  SendCommand(CMD_MODE,1,COM_OFFSET);
	          SendCommand(GM_VOL,0,COM_OFFSET);
	          SendParam(Vol,1,COM_OFFSET);  
	          D1("Go to send2");  
			  SendCommand(CMD_MODE,1,COM_OFFSET);
	          SendCommand(GM_PAN,0,COM_OFFSET);
	          SendParam(MixVal,1,COM_OFFSET);
              return 0; 
              
        case MODM_GETVOLUME:
              D1("MODM_GETVOLUME"); 
             *((LPDWORD) dwParam1)=GMVolume;
              return 0;
              
        case MODM_CLOSE:
            D1("MODM_CLOSE");

            /* notify client */
            midiCallback(&(gMidiOutClient[id]), MOM_CLOSE, 0L, 0L);
            
            
   			ReleaseMPU401( phwi ) ;
            /* now 'release' the MIDI output hardware */
            MidiState[id]=FREE;

            return 0L;

        case MODM_RESET:
            D1("MODM_RESET");

            /* make sure we're not being reentered */
            wMidiOutEntered++;
            {
                if ( wMidiOutEntered != 1 ) {
                    D1("MODM_DATA reentered!");
                    dwReturn = MIDIERR_NOTREADY;
                }

                else {
                    /* turn all notes off */
                    modReset();
                    dwReturn = 0L;
                }
            }
            wMidiOutEntered--;
            return ( dwReturn );

        case MODM_DATA:             /* message is in dwParam1 */
            D4("MODM_DATA");

            /* make sure we're not being reentered */
            wMidiOutEntered++;
            {
                if ( wMidiOutEntered != 1 ) {
                    D1("MODM_DATA reentered!");
                    dwReturn = MIDIERR_NOTREADY;
                }

                else { 
                	if (id!=MidiCurrent) 
                		{                                
                		SendCommand((BYTE) (0xb0+ id),1,0);   
                		MidiCurrent=id;
                		}
                    modSendShortMsg( dwParam1,id );
                    dwReturn = 0L;
                }
            }
            wMidiOutEntered--;
            return ( dwReturn );

        case MODM_LONGDATA:         /* far pointer to header in dwParam1 */
            D4("MODM_LONGDATA");

            /* make sure we're not being reentered */
            wMidiOutEntered++;
            {
                if ( wMidiOutEntered != 1 ) {
                    D1("MODM_LONGDATA reentered!");
                    dwReturn = MIDIERR_NOTREADY;
                }

                else  
                	{
                	if (id!=MidiCurrent) 
                		{
                		SendCommand((BYTE)(0xb0+id),1,0);   
                		MidiCurrent=id;
                		}
                    dwReturn = modSendLongData( (LPMIDIHDR)dwParam1, id );  
                    }
            }
            wMidiOutEntered--;
            return ( dwReturn );

        default:
            return MMSYSERR_NOTSUPPORTED;
    }

    /* should never get here */
    AssertF(0);
    return MMSYSERR_NOTSUPPORTED;
}  


/********************************************************************************
*
*	BYTE CheckMix(BYTE VolL, BYTE VolR,int *nTodiv)  
* Return the corresponding Pan Value 
*	nTodiv is filled with a factor value to divide GM Volume 
*  
*********************************************************************************/

BYTE CheckMix(BYTE VolL, BYTE VolR,LPWORD nTodiv)
{  
BYTE Mix_Val;
int Q;
int n;
                   
if (VolL==VolR) 
	{
	*nTodiv=100;
	return 64;
    }  	            
if ((VolR==0) || (VolL==0)) 
	{
	Mix_Val=0;  
	*nTodiv=168;
	}          	
else
	{         
	
	if (VolL<VolR) 
		Q=(10* VolR/ VolL);
	else
		Q=(10* VolL/ VolR);
	n=0;
	while (MidiPan[n].LsR10>Q) n++; 
	Mix_Val=MidiPan[n].Pan;  
	if (Mix_Val<=11) 
		*nTodiv=168;
	else if (Mix_Val<=39)    
		*nTodiv=141;    
	else if (Mix_Val<=55)    
		*nTodiv=119; 
	else      
		*nTodiv=100;
	}  
if (VolL>VolR)
	return Mix_Val;
else             
	return 127-Mix_Val; 
}               