//---------------------------------------------------------------------------
//
//  Module:   init.c
//
//  Description:
//     MSMPU401 initialization routines
//
//---------------------------------------------------------------------------
//
//  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
//  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
//  PURPOSE.
//
//  Copyright (c) 1994 - 1995 Microsoft Corporation.	All Rights Reserved.
//
//---------------------------------------------------------------------------
#include <windows.h>

// stop compiler from griping about in-line

#pragma warning (disable:4704)

#define Not_VxD
#include <vmm.h>
#include <configmg.h>
#include <mmsystem.h>
#include <mmddk.h>
#include <mmreg.h>

#include <stdlib.h>    
#include <stdio.h>

#include "dream94.h"
#define NOSTR
#include "mixstrng.h"

#include <verinfo.h>
#include <wsshlpid.h>
/*
#define	CM_REGISTRY_HARDWARE			0x00000000	// Select hardware branch if NULL subkey
#define	CM_REGISTRY_SOFTWARE			0x00000001	// Select software branch if NULL subkey
#define	CM_REGISTRY_USER			0x00000100	// Use HKEY_CURRENT_USER
#define	CM_REGISTRY_CONFIG			0x00000200	// Use HKEY_CURRENT_CONFIG
#define	CM_REGISTRY_BITS			0x00000301	// The bits for the registry functions
*/
#ifdef DEBUG
    WORD    wDebugLevel = 3 ;       // debug level
    //
    // these strings are NOT accessed at interrupt time, so they can
    // be based in discardable code (the init seg in this case).
    //
    static char BCODE STR_DRIVER[]     = "msmpu401" ;
    static char BCODE STR_MMDEBUG[]    = "debug" ;

    //
    // these strings are accessed at interrupt time, so they must be in
    // the fixed DS
    //
    char STR_PROLOGUE[] = "Mixer95\\" ;
    char STR_SPACE[]    = " " ;
#endif
    char STR_CRLF[]     = "\r\n" ;

    char MsgStr[100];        
	extern WORD gwPort;	//wavefix.c
	extern WORD	gwMidiInPersistence;
	extern WORD	gwEOICommands;  
	extern PHARDWAREINSTANCE phwi;
// Global driver status

WORD gwGlobalStatus ;

// Module handle

HMODULE ghModule ;

// Hardware instance list

PHARDWAREINSTANCE pHardwareList = NULL ;

BYTE gfEnabled;

static char BCODE gszRegKeyLeftMaster[]     = INI_STR_MASTER ;
static char BCODE gszRegKeyLeftLineIn[]     = INI_STR_LEFTLINEIN ;
static char BCODE gszRegKeyRightLineIn[]    = INI_STR_RIGHTLINEIN ;
static char BCODE gszRegKeyLeftDAC[]        = INI_STR_LEFTDAC ;
static char BCODE gszRegKeyRightDAC[]       = INI_STR_RIGHTDAC ;
static char BCODE gszRegKeyLeftSynth[]      = INI_STR_LEFTSYNTH ;
static char BCODE gszRegKeyRightSynth[]     = INI_STR_RIGHTSYNTH ;

static char BCODE gszRegKeyLeftWaveADCLine[] =  INI_STR_LEFTWAVEADCLINE ;
static char BCODE gszRegKeyRightWaveADCLine[] = INI_STR_RIGHTWAVEADCLINE ;
static char BCODE gszRegKeyLeftWaveADCMix[] =   INI_STR_LEFTWAVEADCMIX ;
static char BCODE gszRegKeyRightWaveADCMix[] =  INI_STR_RIGHTWAVEADCMIX ;
static char BCODE gszRegKeyWaveADCSource[] =    INI_STR_WAVEADCSOURCE ;
static char BCODE gszIniDefWaveADCSource[] =    INI_DEF_WAVEADCSOURCE ;

static char BCODE gszRegKeyLeftVoiceADCMix[] =   INI_STR_LEFTVOICEADCMIX ;
static char BCODE gszRegKeyRightVoiceADCMix[] =  INI_STR_RIGHTVOICEADCMIX ;
static char BCODE gszRegKeyLeftVoiceADCLine[] =  INI_STR_LEFTVOICEADCLINE ;
static char BCODE gszRegKeyRightVoiceADCLine[] = INI_STR_RIGHTVOICEADCLINE ;
static char BCODE gszRegKeyVoiceADCSource[] =    INI_STR_VOICEADCSOURCE ;
static char BCODE gszIniDefVoiceADCSource[] =    INI_DEF_VOICEADCSOURCE ;


static char BCODE gszRegKeyMute[]           = INI_STR_MUTE ;
static char BCODE gszRegKeyMuteMsg[]        = INI_STR_MUTEMSG ;

static char BCODE gszRegValInputLineIn[]    = INI_INPUT_LINEIN ;
static char BCODE gszRegValInputAux[]       = INI_INPUT_AUX ;
static char BCODE gszRegValInputOutput[]    = INI_INPUT_OUTPUT ;
static char BCODE gszRegValInputMix[]    = INI_INPUT_MIX ;

static char BCODE gszConfig[]               = "\\Config" ;

//--------------------------------------------------------------------------
//  
//  VOID AddInstance
//  
//  Description:
//      Adds the instance to the device instance list.
//  
//  Parameters:
//      PHARDWAREINSTANCE phwi
//         ptr -> hardware instance structure
//  
//  Return (VOID):
//      Nothing.
//  
//--------------------------------------------------------------------------

VOID AddInstance
(
    PHARDWAREINSTANCE   phwi
)
{
   phwi -> pNext = pHardwareList ;
   pHardwareList = phwi ;

} // AddInstance()

//--------------------------------------------------------------------------
//  
//  VOID RemoveInstance
//  
//  Description:
//      Removes the instance from device's list
//  
//  Parameters:
//      PHARDWAREINSTANCE phwi
//         ptr -> hardware instance structure
//
//  Return (VOID):
//      Nothing.
//
//--------------------------------------------------------------------------

VOID RemoveInstance
(
    PHARDWAREINSTANCE   phwi
)
{
   PHARDWAREINSTANCE *ppCur ;

   for (ppCur = &pHardwareList ;
        *ppCur != NULL;
        ppCur = &(*ppCur)->pNext)
   {
      if (*ppCur == phwi)
      {
         *ppCur = (*ppCur)-> pNext ;
         break ;
      }
   }

} // RemoveInstance()

//--------------------------------------------------------------------------
//  
//  LRESULT AddDevNode
//  
//  Description:
//      "Registers" a devnode with the driver.  If an instance of
//      this devnode already exists, the count is incremented.
//  
//  Parameters:
//      DWORD dn
//         devnode from MMSYSTEM
//
//  Return (LRESULT):
//      MMSYSERR_NOERROR if everything OK otherwise an appropriate
//      error code is returned.
//  
//--------------------------------------------------------------------------

LRESULT FAR PASCAL AddDevNode
(
    DWORD           dn
)
{
   PHARDWAREINSTANCE  phwi ;

   D1("AddDevNode" ) ;

   if (NULL != (phwi = DevNodeToHardwareInstance( dn )))
   {
      phwi -> cReference++ ;
      return MMSYSERR_NOERROR ;
   }

   if (NULL == 
      (phwi = (PHARDWAREINSTANCE) LocalAlloc( LPTR, 
                                              sizeof( HARDWAREINSTANCE ) )))
      return MMSYSERR_NOMEM ;

   phwi -> dn = dn ;
   phwi -> cReference = 1 ;
   AddInstance( phwi ) ;

   return MMSYSERR_NOERROR ;

} // AddDevNode()

//--------------------------------------------------------------------------
//  
//  LRESULT EnableDevNode
//  
//  Description:
//      Enables a devnode.
//  
//  Parameters:
//      DWORD dn
//         devnode from MMSYSTEM
//
//      UINT uVxDId
//         Supporting VxD ID
//  
//  Return (LRESULT):
//      MMSYSERR_NOERROR if everything OK otherwise an appropriate
//      error code is returned.
//  
//--------------------------------------------------------------------------

LRESULT FAR PASCAL EnableDevNode
(
    DWORD           dn,
    UINT            uVxDId
)
{                            
PIPEOPENSTRUCT      pos ;

   D1("EnableDevNode" ) ;

   if (NULL == (phwi = DevNodeToHardwareInstance( dn )))
      return MMSYSERR_INVALHANDLE ;

   if (phwi -> cEnable++)
      return MMSYSERR_NOERROR ;

   phwi -> uVxDId = uVxDId ;
   D1("Get Vxd entry");
   if ((NULL == (phwi -> pVxDEntry = GetVxDEntry( phwi -> uVxDId ))) ||
       !GetVxDInfo( phwi, dn ))
      return MMSYSERR_INVALHANDLE ;

   D1("vxd entry ok");
#pragma message( REMIND( "Need to read MIDI-in persistence from registry" ) )

   gwMidiInPersistence=phwi -> wMidiInPersistence = DEF_MIDIINPERSISTENCE ;

   if (phwi -> wHardwareOptions & MSMPU401_HWOPTIONSF_IRQSHARED)
   {
      pos.cbSize = sizeof( pos ) ;
      pos.pClientProc = isrPipeProc ;
      if (NULL == (phwi -> hpisr = pipeOpen( phwi, "MSMPUISR", &pos )))
      {
         D1("pipeOpen() failed!" ) ;
      }
   }
   else if (phwi -> bIRQ != (BYTE) -1)
   {
     /* if (!Create_ISR( phwi ))
      {
         D1( "Failed to create ISR!!!\r\n" ) ;

         return MMSYSERR_NOTENABLED ;
      }*/


      D1("hooking interrupt " ) ;

      // Command structure needed to EOI the PIC

      gwEOICommands=phwi -> wEOICommands = (phwi -> bIRQ > 7) ?
                                (0x6200 | (0x60 | (phwi -> bIRQ & 0x07)) ) : 
                                ((WORD) (phwi -> bIRQ | 0x60) << 8) ;
      phwi -> bOrigIntMask =
         (BYTE) SetInterruptMask( phwi -> bIRQ, 1 ) ;    
      sprintf(MsgStr, "test");
                                                        
      phwi -> lpOldISR =
         SetInterruptVector( phwi -> bIRQ,1) ; // set interrup proc
      SetInterruptMask( phwi -> bIRQ, 0 ) ;
	  D1("set  it mask2 ok");
   }

   if (phwi -> wIOAddressMPU401)
   {
	   gfEnabled=phwi -> fEnabled = 1 ;
	   gwPort=phwi -> wIOAddressMPU401;
	   SetwPort();		// set the gwPort variable use in .asm files
   }
      __asm nop

   MxdInit(phwi);

/*
   pos.cbSize = sizeof( pos ) ;
   pos.pClientProc = mixerPipeProc ;
   if (NULL == (phwi -> hpmxd = pipeOpen( phwi, "MSOPLMXD", &pos )))
   {
      DPF( 1, "pipeOpen() failed!" ) ;
   }
*/
   DrvLoadVolumeFromReg( phwi );

   return MMSYSERR_NOERROR ;

} // EnableDevNode()

//--------------------------------------------------------------------------
//  
//  LRESULT DisableDevNode
//  
//  Description:
//      Decrements the enabled count for the hardware instance.
//  
//  Parameters:
//      DWORD dn
//         devnode from MMSYSTEM
//  
//  Return (LRESULT):
//      MMSYSERR_NOERROR if everything OK otherwise an appropriate
//      error code is returned.
//  
//--------------------------------------------------------------------------

LRESULT FAR PASCAL DisableDevNode
(
    DWORD           dn
)
{
   PHARDWAREINSTANCE  phwi ;
   
   D1("Disable*************");
   if (NULL == (phwi = DevNodeToHardwareInstance( dn )))
      return MMSYSERR_INVALHANDLE ;

   if (--phwi -> cEnable)
      return MMSYSERR_NOERROR ;

   if (phwi -> wHardwareOptions & MSMPU401_HWOPTIONSF_IRQSHARED)
   {
      if (phwi -> hpisr)
      {
         pipeClose( phwi, phwi -> hpisr ) ;
         phwi  -> hpisr = NULL ;
      }

   }
   else if (phwi -> bIRQ != (BYTE) -1)
   {
      // Disable the interrupt

      SetInterruptMask( phwi -> bIRQ, 1 ) ;
      SetInterruptVector( phwi -> bIRQ,0) ; //reset old int proc
      SetInterruptMask( phwi -> bIRQ, phwi -> bOrigIntMask ) ;\

      //
      // Free the ISR stub...
      //

      GlobalFree( phwi -> uISRDataSel ) ;
      FreeSelector( phwi -> uISRCodeSel ) ;
      phwi -> uISRDataSel = NULL ;
      phwi -> uISRCodeSel = NULL ;
   }
// Save mixer settings...

   if (DrvSaveVolumeToReg( phwi ))
   {
	  DPF( 1, "failed to save volume settings to registry!" ) ;
   }

   gfEnabled=phwi -> fEnabled = 0 ;

   return MMSYSERR_NOERROR ;

} // DisableDevNode()

//--------------------------------------------------------------------------
//  
//  LRESULT RemoveDevNode
//  
//  Description:
//      Removes a reference to the given devnode, when reference count
//      of zero is reached the hardware instance structure is removed.
//  
//  Parameters:
//      DWORD dn
//         devnode from MMSYSTEM
//  
//  Return (LRESULT):
//      MMSYSERR_NOERROR if everything OK otherwise an appropriate
//      error code is returned.
//  
//--------------------------------------------------------------------------

LRESULT FAR PASCAL RemoveDevNode
(
    DWORD           dn
)
{
   PHARDWAREINSTANCE  phwi ;

   D1("RemoveDevNode" ) ;

   if (NULL == (phwi = DevNodeToHardwareInstance( dn )))
      return MMSYSERR_INVALHANDLE ;

   if (--phwi -> cReference)
      return MMSYSERR_NOERROR ;

   if (phwi -> cEnable)
   {
      D1("Trying to remove devnode but ref != enable" ) ;
      return MMSYSERR_ALLOCATED ;
   }

   RemoveInstance( phwi ) ;

   LocalFree( (LOCALHANDLE) phwi ) ;

   return MMSYSERR_NOERROR ;

} // RemoveDevNode()

//--------------------------------------------------------------------------
//  
//  PHARDWAREINSTANCE DevNodeToHardwareInstance
//  
//  Description:
//  
//  
//  Parameters:
//      DWORD dn
//  
//  Return (PHARDWAREINSTANCE):
//  
//--------------------------------------------------------------------------

PHARDWAREINSTANCE FAR PASCAL DevNodeToHardwareInstance
(
    DWORD           dn
)
{
   PHARDWAREINSTANCE  pCur ;

   if (!pHardwareList)
      return NULL ;

   for (pCur = pHardwareList; pCur != NULL; pCur = pCur -> pNext)
   {
      if (pCur -> dn == dn)
          return pCur ;
   }

   return NULL ;

} // DevNodeToHardwareInstance()

//------------------------------------------------------------------------
//  LRESULT FAR PASCAL DrvInit( VOID )
//
//  Description:
//     Verifies that the VxD loaded successfully.
//
//  Parameters:
//     Nothing.
//
//  Return Value (LRESULT):
//     MMSYSERR_NOERROR if no problem.
//
//------------------------------------------------------------------------

LRESULT FAR PASCAL DrvInit()
{
   D1("DrvInit" ) ;

   return 0 ;

} // end of DrvInit()

//--------------------------------------------------------------------------
//  
//  LRESULT isrPipeProc
//  
//  Description:
//  
//  
//  Parameters:
//      HPIPE hp
//  
//      DWORD dwMsg
//  
//      DWORD dwParam1
//  
//      DWORD dwParam2
//  
//  Return (LRESULT):
//  
//--------------------------------------------------------------------------

LRESULT FAR PASCAL _loadds isrPipeProc
(
    HPIPE           hp,
    DWORD           dwMsg,
    DWORD           dwParam1,
    DWORD           dwParam2
)
{
   PHARDWAREINSTANCE  phwi ;

   //
   // dwParam1 is PnP DevNode
   //

   if (NULL == (phwi = DevNodeToHardwareInstance( dwParam1 )))
      return PIPE_ERR_INVALIDPARAM ;

   switch( dwMsg )
   {
      case PIPE_MSG_OPEN:
         break ;

      case PIPE_MSG_INIT:
         phwi -> fnisrPipe = (FNPIPECALLBACK) dwParam2 ;
         break ;

      case PIPE_MSG_CLOSE:
         phwi -> hpisr = NULL ;
         phwi -> fnisrPipe = NULL ;
         break ;
   }

   return PIPE_ERR_NOERROR ;

} // isrPipeProc()

//------------------------------------------------------------------------
//  VOID DrvEnd
//
//  Description:
//     Closes up the hardware and interrupts.
//
//  Parameters:
//     None.
//
//  Return Value:
//     None.
//
//
//------------------------------------------------------------------------

VOID FAR PASCAL DrvEnd()
{
   D1("DrvEnd" ) ;

} // end of DrvEnd()


//--------------------------------------------------------------------------
//  
//  int LibMain
//  
//  Description:
//      Library initialization code
//  
//  Parameters:
//      HMODULE hModule
//         Module handle
//  
//      UINT uDataSeg
//         selector of data segment
//
//      UINT uHeapSize
//         Heap size as specified in .DEF
//  
//      LPSTR lpCmdLine
//         command line passed from kernel
//  
//  Return (int):
//      1 if successful
//  
//  
//--------------------------------------------------------------------------

int FAR PASCAL LibMain
(
    HMODULE         hModule,
    UINT            uDataSeg,
    UINT            uHeapSize,
    LPSTR           lpCmdLine
)
{
#ifdef DEBUG
    // get debug level - default is 3

    wDebugLevel = GetProfileInt( STR_MMDEBUG, STR_DRIVER, 3 ) ;
#endif

    //
    //  save our module handle
    //

    ghModule = hModule;

    //
    //  succeed the load...
    //
    return (1) ;

} // LibMain()
//------------------------------------------------------------------------
//  LRESULT DrvSaveVolumeToReg
//
//  Description:
//     Saves the volume information and other information to the
//     SOUND.INI file.
//
//  Parameters:
//     PHARDWAREINSTANCE  phwi
//        pointer to hardware instance structure
//
//  Return Value (LRESULT):
//
//
//------------------------------------------------------------------------

LRESULT FAR PASCAL DrvSaveVolumeToReg
(
    PHARDWAREINSTANCE   phwi
)
{
   char             szDevNodeCfg[ 512 ] ;
   HKEY             hkSW ;
   LPSTR            lpsz ;
   PMIXERINSTANCE   pmi ;
char  szDebug[ 532 ] ;

   DPF( 1, "DrvSaveVolumeToReg" ) ;

   if (CM_Get_DevNode_Key( phwi -> dn, NULL, szDevNodeCfg, 
                           sizeof( szDevNodeCfg ), 
                           CM_REGISTRY_SOFTWARE ))
      return MMSYSERR_KEYNOTFOUND ;

   strcat( szDevNodeCfg, gszConfig ) ;

    wsprintf( szDebug, "save DevNode = %s", szDevNodeCfg ) ;
    DPF( 1, szDebug ) ;

   if (RegOpenKey( HKEY_LOCAL_MACHINE, szDevNodeCfg, &hkSW ))
   {
      if (RegCreateKey( HKEY_LOCAL_MACHINE, szDevNodeCfg, &hkSW ))
         return MMSYSERR_BADDB ;
   }

   pmi = phwi -> pmi ;

   //---------------------------------
   //
   // Save mute
   //
   //---------------------------------

   RegSetValueEx( hkSW, gszRegKeyMute, 0, REG_BINARY, 
                  (LPBYTE) &(pmi -> dwValue[ MUTE_OUTLINE ][ 0 ]),
                  sizeof( DWORD ) ) ;

   //---------------------------------
   //
   // Master attenuation
   //
   //---------------------------------

   RegSetValueEx( hkSW, gszRegKeyLeftMaster, 0, REG_BINARY, 
                  (LPBYTE) &(pmi -> dwValue[ VOL_OUTLINE ][ 0 ]),
                  sizeof( DWORD ) ) ;
   //---------------------------------
   //
   // Line-In attenuation
   //
   //---------------------------------

   RegSetValueEx( hkSW, gszRegKeyLeftLineIn, 0, REG_BINARY, 
                  (LPBYTE) &(pmi -> dwValue[ VOL_OUTAUX1 ][ 0 ]),
                  sizeof( DWORD ) ) ;

   RegSetValueEx( hkSW, gszRegKeyRightLineIn, 0, REG_BINARY, 
                  (LPBYTE) &(pmi -> dwValue[ VOL_OUTAUX1 ][ 1 ]),
                  sizeof( DWORD ) ) ;

   //---------------------------------
   //
   // Wave attenuation
   //
   //---------------------------------

   RegSetValueEx( hkSW, gszRegKeyLeftDAC, 0, REG_BINARY, 
                  (LPBYTE) &(pmi -> dwValue[ VOL_OUTDAC ][ 0 ]),
                  sizeof( DWORD ) ) ;

   RegSetValueEx( hkSW, gszRegKeyRightDAC, 0, REG_BINARY, 
                  (LPBYTE) &(pmi -> dwValue[ VOL_OUTDAC ][ 1 ]),
                  sizeof( DWORD ) ) ;

   //---------------------------------
   //
   // midi attenuation
   //
   //---------------------------------


      RegSetValueEx( hkSW, gszRegKeyLeftSynth, 0, REG_BINARY, 
                    (LPBYTE) &(pmi -> dwValue[ VOL_OUTMIDI ][ 0 ]),
                    sizeof( DWORD ) ) ;

      RegSetValueEx( hkSW, gszRegKeyRightSynth, 0, REG_BINARY, 
                    (LPBYTE) &(pmi -> dwValue[ VOL_OUTMIDI ][ 1 ]),
                    sizeof( DWORD ) ) ;

   //---------------------------------
   //
   // WAVE ADC attenuation & source
   //
   //---------------------------------
   RegSetValueEx( hkSW, gszRegKeyLeftWaveADCLine, 0, REG_BINARY, 
                  (LPBYTE) &(pmi -> dwValue[ VOL_W_INAUX1 ][ 0 ]),
                  sizeof( DWORD ) ) ;

   RegSetValueEx( hkSW, gszRegKeyRightWaveADCLine, 0, REG_BINARY, 
                  (LPBYTE) &(pmi -> dwValue[ VOL_W_INAUX1 ][ 1 ]),
                  sizeof( DWORD ) ) ;


   RegSetValueEx( hkSW, gszRegKeyLeftWaveADCMix, 0, REG_BINARY,
                  (LPBYTE) &(pmi -> dwValue[ VOL_W_INMIX ][ 0 ]),
                  sizeof( DWORD ) ) ;

   RegSetValueEx( hkSW, gszRegKeyRightWaveADCMix, 0, REG_BINARY,
                  (LPBYTE) &(pmi -> dwValue[ VOL_W_INMIX ][ 1 ]),
                  sizeof( DWORD ) ) ;

   // Save the WAVE-IN ADC source.

   switch (pmi -> dwValue[ MUX_WAVEIN ][ 0 ])
   {
      case MUXINPUT_AUX1:
         lpsz = gszRegValInputLineIn ;
         break ;

      case MUXINPUT_MIX:
         lpsz = gszRegValInputOutput ;
         break ;
   }

   RegSetValueEx( hkSW, gszRegKeyWaveADCSource, 0, REG_SZ, 
                  (LPBYTE) lpsz, 0 ) ;


   RegCloseKey( hkSW ) ;

   return MMSYSERR_NOERROR ;

} // DrvSaveVolumeToReg()

//------------------------------------------------------------------------
//  LRESULT DrvLoadVolumeFromReg
//
//  Description:
//     Load the volume information from the registry.
//
//  Parameters:
//     PHARDWAREINSTANCE  phwi
//        pointer to hardware instance structure
//
//  Return Value (LRESULT):
//
//
//------------------------------------------------------------------------

LRESULT FAR PASCAL DrvLoadVolumeFromReg
(
   PHARDWAREINSTANCE  phwi
)
{
   char                          szTemp[ 32 ], szDevNodeCfg[ 256 ] ;
   HKEY                          hkSW ;
   MIXERCONTROLDETAILS           mcd ;
   MIXERCONTROLDETAILS_BOOLEAN   mcd_f[ 2 ] ;  // !!! max multiple items is 2
   MIXERCONTROLDETAILS_UNSIGNED  mcd_u[ 2 ] ;
   PMIXERINSTANCE                pmi ;
   ULONG                         cbLen ;
   WORD                          wCount ;
char  szDebug[ 256 ] ;

   DPF( 1, "DrvLoadVolumeFromReg" ) ;

   if (CM_Get_DevNode_Key( phwi -> dn, NULL, szDevNodeCfg, 
                           sizeof( szDevNodeCfg ),
                           CM_REGISTRY_SOFTWARE ))
      return MMSYSERR_KEYNOTFOUND ;

   strcat( szDevNodeCfg, gszConfig ) ;

    wsprintf( szDebug, "load DevNode = %s", szDevNodeCfg ) ;
    DPF( 1, szDebug ) ;

   if (RegOpenKey( HKEY_LOCAL_MACHINE, szDevNodeCfg, &hkSW ))
      hkSW = NULL ;

   pmi = phwi -> pmi ;

   //------------------------------------
   //
   // Get mute setting
   //
   //------------------------------------
    DPF( 1, "Get Mute Setting") ;

   // default value is FALSE

   mcd_f[ 0 ].fValue = FALSE ;

   if (hkSW)
   {
      cbLen = sizeof( MIXERCONTROLDETAILS_BOOLEAN ) ;
      RegQueryValueEx( hkSW, gszRegKeyMute, NULL, NULL, 
                       (LPSTR) &mcd_f[ 0 ].fValue, &cbLen ) ;
   }

   //
   // Set the mute as appropriate.
   //

   mcd.dwControlID = MUTE_OUTLINE ;
   mcd.cbStruct = sizeof( MIXERCONTROLDETAILS ) ;
   mcd.cChannels = pmi -> auControlMap[ MUTE_OUTLINE ][ CM_CHANNELS ] ;
   mcd.cMultipleItems = 0;
   mcd.cbDetails  = sizeof( MIXERCONTROLDETAILS_BOOLEAN ) ;
   mcd.paDetails = mcd_f ;

   MxdSetControlDetails( phwi, &mcd, 0 ) ;

   //------------------------------------
   //
   // WAVE-IN mux setting & attenuations
   //
   //------------------------------------

   // default value is "Line-In"
    DPF( 1, "Wavein Mute Setting") ;

   strcpy( szTemp, gszIniDefWaveADCSource ) ;

   if (hkSW)
   {
      cbLen = sizeof( szTemp ) ;
      RegQueryValueEx( hkSW, gszRegKeyWaveADCSource, NULL, NULL, 
                       (LPSTR) szTemp, &cbLen ) ;
   }

   mcd.dwControlID = MUX_WAVEIN ;
   mcd.cbStruct = sizeof( MIXERCONTROLDETAILS ) ;

   mcd.cChannels = 1 ; // UNIFORM mux
   mcd.cMultipleItems = pmi -> mxc[ mcd.dwControlID ].cMultipleItems ;
   mcd.cbDetails  = sizeof( MIXERCONTROLDETAILS_BOOLEAN ) ;
   mcd.paDetails = mcd_f ;

   for (wCount = 0; wCount < (WORD) mcd.cMultipleItems; wCount++)
      mcd_f[ wCount ].fValue = FALSE ;

   if (!lstrcmpi( szTemp, gszRegValInputLineIn ))
      wCount = MUXINPUT_AUX1 ;
   else if (!lstrcmpi( szTemp, gszRegValInputOutput ))
      wCount = MUXINPUT_MIX ;

   mcd_f[ wCount ].fValue = TRUE ;

   MxdSetControlDetails( phwi, &mcd, 0 ) ;

   //
   // Attenuation levels for WAVE-IN (Line)
   //
    DPF( 1, "Wavein Attenuation") ;

   mcd_u[ 0 ].dwValue = INI_DEF_LEFTADC ;
   mcd_u[ 1 ].dwValue = INI_DEF_RIGHTADC ;

   if (hkSW)
   {
      cbLen = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
      RegQueryValueEx( hkSW, gszRegKeyLeftWaveADCLine, NULL, NULL, 
                       (LPSTR) &mcd_u[ 0 ].dwValue, 
                       &cbLen ) ;

      cbLen = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
      RegQueryValueEx( hkSW, gszRegKeyRightWaveADCLine, NULL, NULL, 
                       (LPSTR) &mcd_u[ 1 ].dwValue, 
                       &cbLen ) ;
   }


   mcd.dwControlID = VOL_W_INAUX1 ;
   mcd.cbStruct = sizeof( MIXERCONTROLDETAILS ) ;
   mcd.cChannels = pmi -> auControlMap[ VOL_W_INAUX1 ][ CM_CHANNELS ] ;
   mcd.cMultipleItems = 0;
   mcd.cbDetails  = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
   mcd.paDetails = mcd_u ;

   MxdSetControlDetails( phwi, &mcd, 0 ) ;


   //
   // Attenuation levels for WAVE-IN (mixer)
   //

    DPF( 1, "Wavein Levels") ;
    
   mcd_u[ 0 ].dwValue = INI_DEF_LEFTADC ;
   mcd_u[ 1 ].dwValue = INI_DEF_RIGHTADC ;

   if (hkSW)
   {
      cbLen = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
      RegQueryValueEx( hkSW, gszRegKeyLeftWaveADCMix, NULL, NULL,
                       (LPSTR) &mcd_u[ 0 ].dwValue,
                       &cbLen ) ;

      cbLen = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
      RegQueryValueEx( hkSW, gszRegKeyRightWaveADCMix, NULL, NULL,
                       (LPSTR) &mcd_u[ 1 ].dwValue,
                       &cbLen ) ;
   }

   mcd.dwControlID = VOL_W_INMIX ;
   mcd.cbStruct = sizeof( MIXERCONTROLDETAILS ) ;
   mcd.cChannels = pmi -> auControlMap[ VOL_W_INMIX ][ CM_CHANNELS ] ;
   mcd.cMultipleItems = 0;
   mcd.cbDetails  = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
   mcd.paDetails = mcd_u ;

   MxdSetControlDetails( phwi, &mcd, 0 ) ;

   //--------------------------
   //
   // DAC attenuation
   //
   //--------------------------
    DPF( 1, "Waveout level") ;

   mcd_u[ 0 ].dwValue = INI_DEF_LEFTDAC ;
   mcd_u[ 1 ].dwValue = INI_DEF_RIGHTDAC ;

   if (hkSW)
   {
      cbLen = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
      RegQueryValueEx( hkSW, gszRegKeyLeftDAC, NULL, NULL, 
                       (LPSTR) &mcd_u[ 0 ].dwValue, 
                       &cbLen ) ;

      cbLen = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
      RegQueryValueEx( hkSW, gszRegKeyRightDAC, NULL, NULL, 
                       (LPSTR) &mcd_u[ 1 ].dwValue, 
                       &cbLen ) ;
   }

   mcd.dwControlID = VOL_OUTDAC ;
   mcd.cbStruct = sizeof( MIXERCONTROLDETAILS ) ;
   mcd.cChannels = pmi -> auControlMap[ VOL_OUTDAC ][ CM_CHANNELS ] ;
   mcd.cMultipleItems = 0;
   mcd.cbDetails  = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
   mcd.paDetails = mcd_u ;

   MxdSetControlDetails( phwi, &mcd, 0 ) ;

   //--------------------------
   //
   // Synth attenuation
   //
   //--------------------------
    DPF( 1, "Midi level") ;

      mcd_u[ 0 ].dwValue = INI_DEF_LEFTSYNTH ;
      mcd_u[ 1 ].dwValue = INI_DEF_RIGHTSYNTH ;

      if (hkSW)
      {
         cbLen = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
         RegQueryValueEx( hkSW, gszRegKeyLeftSynth, NULL, NULL, 
                          (LPSTR) &mcd_u[ 0 ].dwValue, 
                          &cbLen ) ;

         cbLen = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
         RegQueryValueEx( hkSW, gszRegKeyRightSynth, NULL, NULL, 
                          (LPSTR) &mcd_u[ 1 ].dwValue, 
                          &cbLen ) ;
      }

      mcd.dwControlID = VOL_OUTMIDI ;
      mcd.cbStruct = sizeof( MIXERCONTROLDETAILS ) ;
      mcd.cChannels = pmi -> auControlMap[ VOL_OUTMIDI ][ CM_CHANNELS ] ;
      mcd.cMultipleItems = 0;
      mcd.cbDetails  = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
      mcd.paDetails = mcd_u ;

      MxdSetControlDetails( phwi, &mcd, 0 ) ;

   //--------------------------
   //
   // Line-In attenuation
   //
   //--------------------------
    DPF( 1, "Linein level") ;

   mcd_u[ 0 ].dwValue = INI_DEF_LEFTLINEIN ;
   mcd_u[ 1 ].dwValue = INI_DEF_RIGHTLINEIN ;

   if (hkSW)
   {
      cbLen = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
      RegQueryValueEx( hkSW, gszRegKeyLeftLineIn, NULL, NULL, 
                       (LPSTR) &mcd_u[ 0 ].dwValue, 
                       &cbLen ) ;

      cbLen = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
      RegQueryValueEx( hkSW, gszRegKeyRightLineIn, NULL, NULL, 
                       (LPSTR) &mcd_u[ 1 ].dwValue, 
                       &cbLen ) ;
   }

   mcd.dwControlID = VOL_OUTAUX1 ;
   mcd.cbStruct = sizeof( MIXERCONTROLDETAILS ) ;
   mcd.cChannels = pmi -> auControlMap[ VOL_OUTAUX1 ][ CM_CHANNELS ] ;
   mcd.cMultipleItems = 0;
   mcd.cbDetails  = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
   mcd.paDetails = mcd_u ;

   MxdSetControlDetails( phwi, &mcd, 0 ) ;

   //--------------------------
   //
   // Master attenuation
   //
   //--------------------------

   DPF( 1, "Master Vol") ;
   mcd_u[ 0 ].dwValue = INI_DEF_LEFTMASTER ;
   mcd_u[ 1 ].dwValue = INI_DEF_RIGHTMASTER ;

   if (hkSW)
   {
      cbLen = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
      RegQueryValueEx( hkSW, gszRegKeyLeftMaster, NULL, NULL, 
                       (LPSTR) &mcd_u[ 0 ].dwValue, 
                       &cbLen ) ;

   }

   mcd.dwControlID = VOL_OUTLINE ;
   mcd.cbStruct = sizeof( MIXERCONTROLDETAILS ) ;
   mcd.cChannels = pmi -> auControlMap[ VOL_OUTLINE ][ CM_CHANNELS ] ;
   mcd.cMultipleItems = 0;
   mcd.cbDetails  = sizeof( MIXERCONTROLDETAILS_UNSIGNED ) ;
   mcd.paDetails = mcd_u ;

   MxdSetControlDetails( phwi, &mcd, 0 ) ;

   if (hkSW)
      RegCloseKey( hkSW ) ;

   return MMSYSERR_NOERROR ;

} // end of DrvLoadVolumeFromReg()

//---------------------------------------------------------------------------
//  End of File: init.c
//---------------------------------------------------------------------------
