/********************************************************************************
*
*
*        DDDDDD          RRRRRR         EEEEEE         AAA            MM     M
*       D     D         R     R        E             A    A          M M  M  M
*      D     D         RRRRRR         EEEEEE        AAAAAAA         M   M   M
*     D     D         R   R          E             A     A         M       M
*    DDDDDD          R     R        EEEEEE        A     A         M       M
*
*  Digital         Research  in  Electronics    Acoustics        &     Music
*______________________________________________________________________________
*
* SAM9407-9503 based product
*-------------------------------------------
* COPYRIGHT (c) DREAM S.A. 1993-1996
*-------------------------------------------       *
*			     _______________
*				|	            |
*				|	API DREAM   | 
*				|_______________|
*				
*	
*		To use these API in an application, add the directive :
*						#include "dream.h" in your source code (for compilation)	
*		and, add the file 
*						dream16.lib		to your project
*
***********************************************************************************/

// Constant values 

// Dream Error Codes
#define DREAMERR_UNREF		1
#define DREAMERR_OUTOFMEM	2
#define DREAMERR_INVADD     3
#define DREAMERR_INVCOUNT	4
#define DREAMERR_ABORT		5
#define DREAMERR_NOTSUPPORTED		6
#define DREAMERR_INVCOM		7
#define DREAMERR_FILENOTFOUND		8
#define	DREAMERR_CANNOTDELETE	9

#define	DREAMERR_CANNOTSAVEBANK		10
#define	DREAMERR_CANNOTRESTOREBANK	11
#define	DREAMERR_PATHTOOLONG	12


// Sturctures for bankGetCaps API
typedef struct sSoundDef {
	char Name[16];
	DWORD Prio;
	DWORD Size;
	DWORD SBnb;
	} SOUNDDEF, _far *LPSOUNDDEF;

typedef struct sBankCaps {
	DWORD TotalSize;
	DWORD FreeSize;
	DWORD	BanksNb;
	SOUNDDEF SBankDef[8];
	} BANKCAPS, _far *LPBANKCAPS;

 
// Filter
#define WAVE_FC		0x4a
#define WAVE_Q  	0x4b

// MOD CONTROL TYPE
#define  VOI_VOL	0x56				// type volume
#define  VOI_MAIN	0x57				// type pan     
#define  VOI_PITCH	0x58				// type pitch
#define  VOI_AUX	0x59				// type effect 
#define  VOI_FILT	0x5a				// type filter

// MOD COMMAND
#define  MOD_START	0x54				
#define  MOD_STOP	0x55			
#define  MOD_CLOSE	0x53


// memLoadFirmware Flags
#define  FIRMWCAPS_UART			0x1	
#define  FIRMWCAPS_MIDI			0x2	
#define  FIRMWCAPS_WAVEIN			0x4
#define  FIRMWCAPS_WAVEOUT			0x8
#define  FIRMWCAPS_PRO3D		0x10
#define  FIRMWCAPS_HARM			0x20
#define  FIRMWCAPS_4WAVES		0x40
#define  FIRMWARE_SAVEBANKS		0x1000
#define  FIRMWARE_RESTOREBANKS	0x2000


#ifdef __cplusplus
extern "C" {            /* Assume C declarations for C++ */
#endif	/* __cplusplus */


/****************************************************************************
*
*    API dream - mpuMessage(WORD wCommand,LPBYTE lpParam, WORD wCount)
*    Send MPU command via the driver
*    
*		wCommand - mpu command to send
*       lpParam	 - pointer to parameters table
*		wCount	 - parameter count
*    		
*    Return : 0 if successfull
*    		 1 if fail
****************************************************************************/
WORD FAR PASCAL _loadds mpuMessage(WORD wCommand,LPBYTE lpParam, WORD wCount); 





/****************************************************************************
*
*    API dream - mpuMessageAc(WORD wCommand,LPBYTE lpParam, WORD wCount)
*    Send MPU command via the driver, AND wait for acknowledge Ack to be returned
*    
*		wCommand - mpu command to send
*       lpParam	 - pointer to parameters table
*		wCount	 - parameter count
*    		
*    Return : 0 if successfull
*    		 1 if fail
****************************************************************************/
WORD FAR PASCAL _loadds mpuMessageAc(WORD wCommand,LPBYTE lpParam, WORD wCount,BYTE Ack); 





/****************************************************************************

    API dream - genControlRead(BYTE *Value, BYTE bCommand)
    	 
	bCommand : -(0-7f) The control nb for which the value is returned in Value
				-if noCommand=0xff, Value is assumed to be a 128 BYTE table
				and is filled whith 128 control values. (Value[n] is the value 
				for the control nb n.
	Value	: Pointer on a location filled by the returned control value
				(one BYTE if bCommand<7f) or with every control values
				(128 BYTE if bCommand=0xff)

  	return 0 if succesfull
			error code if failed
  	
****************************************************************************/  
WORD FAR PASCAL _loadds genControlRead(LPBYTE Value, BYTE bCommand);




/****************************************************************************

    API dream - memWrite(LPVOID lpSrc,DWORD dwDestAddress,WORD wCount)  
    Transfert a memory bloc from Pc memory to dream card
    lpSrc	:	Pointer to memory bloc to transfer
    dwDestAddress 	: address (page|offset) of destination   
    wCount	 	: nb of word to copy
   
    Return : 0 if successfull
    		 error code if failed (see documentation)
****************************************************************************/ 
WORD FAR PASCAL _loadds memWrite(LPVOID lpSrc,DWORD dwDestAddress,WORD wCount); 



  

/****************************************************************************

    API dream - memRead(LPVOID lpDst,DWORD dwSrcAddress,WORD wCount)  
    Transfert a memory bloc from dream card memory to PC.
    lpDst	:	Pointer to memory bloc to receive bytes.
    dwSrcAddress	: Address (Page|offset) of source
    wCount	 	: nb of word to copy
    
    Return : 0 if successfull
    		 error code if failed (see documentation)
****************************************************************************/
WORD FAR PASCAL _loadds memRead(LPVOID lpDst,DWORD dwSrcAddress,WORD wCount);  



 

/****************************************************************************

    API dream - memGetMapAddress 
    Return 32 bit Address of the Memory Mapping Table
    (FFFFFFFF if failed)

****************************************************************************/  
DWORD FAR PASCAL _loadds memGetMapAddress(void);          





/****************************************************************************

    API dream - memSetMapAddress 
    Called to inform card that client have modify the Memory Mapping Table
    address.
    
    return 	0 if succeed  

****************************************************************************/ 
WORD FAR PASCAL _loadds memSetMapAddress(DWORD address);          




/****************************************************************************
*
*    API dream - surroundSetVolume(WORD Value) 
*    Set 3D effect
*    Value - 0 (Band cut) 255 (Max)
*    
*    Return : 0 if successfull  
****************************************************************************/ 
WORD FAR PASCAL _loadds surroundSetVolume(WORD wVolume);  




/****************************************************************************
*
*    API dream -  equalizerSetBand(WORD wBand, WORD wChannel,WORD wVolume)
*    Set new state of equalizer 
*    wVolume - 0 (Band cut) 127 (Max)
*    wBand	0->Low
*    		1->Medium low
*    		2->Medium high
*    		3->High
*    wChannel 0->Left & Right
*    		1->Left
*    		2->Right
*    		
*    Return : 0 if successfull   
****************************************************************************/ 
WORD FAR PASCAL _loadds equalizerSetBand(WORD wBand, WORD wChannel,WORD wVolume);


                                                                        
                                                                                  
/****************************************************************************
*
*    API dream - waveSetAuxVolume(WORD Id,WORD AuxLeft,WORD AuxRight)
*    Set aux volume
*    Value - 0 (Band) 65535 (Max)
*    
*    Return : 	0 if ok
*				1 if bad Id
*  
****************************************************************************/
WORD FAR PASCAL _loadds waveSetAuxVolume(WORD Id,WORD AuxLeft,WORD AuxRight);   




/****************************************************************************
*
*    API dream - waveSetMainVolume(WORD Id,WORD AuxLeft,WORD AuxRight)
*    Set aux volume
*    Value - 0 (Band) 65535 (Max)
*    
*    Return : 	0 if ok
*				1 if bad Id
*  
****************************************************************************/
WORD FAR PASCAL _loadds waveSetMainVolume(WORD Id,WORD AuxLeft,WORD AuxRight); 
                      
                                                      
                                                      
                                                      
/****************************************************************************
*
*    API dream -  waveSetPitch(WORD Id,WORD AbsolutePitch)
*    Set the sample rate for a device id ( no effect on the waveOutGetPitch
*		Windows API)
*    Value - 0 (Band) 65535 (Max)
*    
*    Return : 	0 if ok
*				1 if bad Id
*  
****************************************************************************/
WORD FAR PASCAL _loadds waveSetPitch(WORD Id,WORD AbsolutePitch);              




/****************************************************************************
*
*    API dream - waveSetFilter(WORD Id,WORD Type,WORD Value)
*    Set filter parameters
*    Type	: 	Fc=0x4a  
*				Q=0x4b
*	 Value	: 0xffff : cut				
*    Return : 0 
*             1 if bad type  
*			  2 if bad id
****************************************************************************/  
WORD FAR PASCAL _loadds waveSetFilter(WORD Id,WORD Type,WORD Value);

/****************************************************************************
*
*    API dream - WORD FAR PASCAL _loadds waveSetBufferSize(WORD wSize,BOOL ForPlay)
*    Set the size of the wave buffers for every next opennings
*    Size : in word
*    ForPlay : 	TRUE ->change the play buffer size
*				FALSE -> change the record buffer size
*    Return : 0 
*  
****************************************************************************/
WORD FAR PASCAL _loadds waveSetBufferSize(WORD wSize,BOOL ForPlay);      



  
/****************************************************************************
*
*    API dream - WideEffect(WORD Value) 
*    Set 3D effect
*    Value - 0 (Band cut) 255 (Max)
*    
*    Return : 0 if successfull
*    		 1 if fail
****************************************************************************/
WORD FAR PASCAL _loadds WideEffect(WORD Value);


                                                                          
                                                                          
/****************************************************************************
*
*    API dream - Equalizer(WORD Value,WORD Band, WORD Channel)
*    Set new state of equalizer 
*    Value - 0 (Band cut) 127 (Max)
*    Band	0->Low
*    		1->Medium low
*    		2->Medium high
*    		3->High
*    Channel 0->Left & Right
*    		1->Left
*    		2->Right
*    		
*    Return : 0 if successfull
*    		 1 if fail
****************************************************************************/
WORD FAR PASCAL _loadds Equalizer(WORD Value,WORD Band, WORD Channel);  




/****************************************************************************

    API dream - DownLoad(LPVOID lpSrc,WORD wDestPage,WORD wDestOffset,WORD wCount,WORD File)  
    Transfert a memory bloc from Pc memory to dream card
    lpSrc	:	Pointer to memory bloc to transfer
    wDestOffset 	: offset of destination
    wDestPage	: destination page
    wCount	 	: nb of word to copy
    File		: 	0 (normal) 
    				1 (slow transfert)
    Return : 0 if successfull
    		 1 if fail wCount>32kWords  or page number too high
    		 2	other errors
****************************************************************************/
WORD FAR PASCAL _loadds DownLoad(LPVOID lpSrc,WORD wDestPage,WORD wDestOffset,WORD wCount,WORD File);
 
 
 
 
/****************************************************************************
*
*    API dream - UpLoad 
*    Transfert a memory bloc from dream card memory to PC 
*    lpDst	:	Pointer to memory bloc to receive datas
*    wSrcOffset 	: offset of source in 64K page
*    wSrcPage	: source page
*    dwCount	 	: nb of word to copy  (0x8000->32K max)
*     
* 	The memory space to copy must be in 64Kw page !! (else error 2 is return)
*
*      Return : 0 if successfull
*    		 	1 if fail wCount>32kWords or page nb too large
*    		 	2 not in page
****************************************************************************/  
WORD FAR PASCAL _loadds UpLoad(LPVOID lpDst,WORD wSrcPage,WORD wSrcOffset,WORD wCount);
 
 
 
 
/****************************************************************************
*
*    API dream - GetMemMapAddress 
*    Return 32 bit Address of the Memory Mapping Table
*    (FFFFFFFF if failed)
*
****************************************************************************/  
DWORD FAR PASCAL _loadds GetMemMapAddress(void);   
   
   
   
   
/****************************************************************************
*
*    API dream - SetMemMapAddress 
*    Called to inform card that client have modify the Memory Mapping Table
*    address.
*    
*    return 	0 if succeed
*    		1 if failed
*
****************************************************************************/  
WORD FAR PASCAL _loadds SetMemMapAddress(DWORD address);

  
  
  
/****************************************************************************

    API dream - ModGetVoiceNumber()
    	 
    Return the number of Available voices (MOD PLAYER)


****************************************************************************/  
WORD FAR PASCAL _loadds modGetVoiceNumber(); 
 
          
          
          
/****************************************************************************

    API dream - modOpenVoice(WORD Voice, BYTE Vol, WORD VMain, WORD VAux,
		WORD Pitch, WORD Filt)
    	 
    Open a channel for playing a voice (MOD PLAYER) and init volume, pan pitch
    		effect, filter.
    		
    
    Vol - 	0-ff
    VMain - 	LSB-->Right (0-ff)
    						MSB-->Left (0-ff)
    Pitch - 400h=nominal frequency and linearly scalled (200h = 1/2 nom. freq.)
    VAux	-  Aux-Fx	-   MSB->Aux-Left (0-ff) 	
    						LSB->Right  (0-ff) 
    Filt	MSB-> Fc 	0(open)-ff(close)
            LSB->Q      0(resonnance max.)-ff(no resonnance )
    
    return 	0 if succeed                       
****************************************************************************/  
WORD FAR PASCAL _loadds modOpenVoice(WORD wVoice, BYTE bVol, WORD wVMain, WORD wVAux,
		WORD wPitch, WORD wFilt);
   
                                   
                                   
                                   
/****************************************************************************

    API dream - modChangeParam(WORD wVoice,WORD wType, WORD wValue)
    	 
    Modify the value of one parameters on the voice (MOD PLAYER)
    
    Voice : voice number
    
    According to Type the Value is :
    if wType=VOI_VOL				Vol - 	0-ff          
    if wType=VOI_MAIN		LSB-->Right (0-ff)
    						MSB-->Left (0-ff)
    if wType=PITCH				Pitch - 400h=nominal frequency and linearly 
    						scalled (200h = 1/2 nom. freq.)
    if wType=VOI_AUX				Aux-Fx	-   MSB->Aux-Left (0-ff) 	
    						LSB->Right  (0-7f) 	
    if wType=VOI_FILT				Filt	MSB-> Fc 	0(open)-ff(close)
          							LSB->Q      0(resonnance max.)-ff(no resonnance )
	return 	0 if succeed
			1 if any error occurs

****************************************************************************/  
WORD FAR PASCAL _loadds modChangeParam(WORD wVoice,BYTE bType, WORD wValue);
     
     
     
     
/****************************************************************************

    API dream - modDefineVoiceMemory(WORD Voice, WORD Format,
    				DWORD Start, DWORD Loop, DWORD End)
    	 
    Define the memory format for voice buffer (MOD PLAYER)
    define start,loop, and end point and define the sample format
    Format : 	bit 7	: 0->16 bits ; 1->8 bits
    		    bit 6	: used if bit 7=1. 	0->Sample in low byte
    		    							1->Sample in high byte  
    		    bit 0-5 : loop type
    		    			0 : forward loop
    		    			1 : reverse loop
    		    			2 : reverse loop with sign inversion
    		    			(See Notice)							
    
    Voice : voice number

  	Start, Loop, End, 	: absolute address (32 bits) 
****************************************************************************/  
WORD FAR PASCAL _loadds modDefineVoiceMemory(WORD Voice, WORD Format, DWORD Start, 
						DWORD Loop, DWORD End); 
						
						
						
						
/****************************************************************************

    API dream - modGetPos(WORD wVoice)
    	 
   	 give the (new) current position
    
    Voice	: voice number
    
  	return absolute address, FFFFFFFF if failed
  	
****************************************************************************/  
DWORD FAR PASCAL _loadds modGetPos(WORD wVoice); 
                    
                    
  
/****************************************************************************

    API dream - modSetNewPos(WORD wVoice, DWORD dwOffset)
    	 
   	 Add offset to current position		(MOD_PLAYER)	
    and give the (new) current position
    
    Voice	: voice number
    offset	: absolute offset (32bits) to add at actual position 
    
  	return 0 if succeed, error msg if failed
  	 
****************************************************************************/  
WORD FAR PASCAL _loadds modSetNewPos(WORD wVoice, DWORD dwOffset); 



                  
                    
/****************************************************************************

    API dream - modCommand(WORD wVoice,BYTE bCommand) 
    	 
    Do the corresponding command (MOD PLAYER)
    
    Command	=	MOD_START
    			MOD_STOP
    			MOD_CLOSE
	return 	0 if succeed
			1 if any error occurs

****************************************************************************/  
WORD FAR PASCAL _loadds modCommand(WORD Voice,BYTE Command);   	


/****************************************************************************

    API dream - modOpen()
    	 
    acquire mpu port for mod. To be called before any mod API
    	
    return 	0 if succeed  , MMSYSERR_ALLOCATED if fail                     
****************************************************************************/  
WORD FAR PASCAL _loadds modOpen();

  
/****************************************************************************

    API dream - modClose()
    	 
    release mpu port after mod. To be called after mod API
    	                    
****************************************************************************/  
void FAR PASCAL _loadds modClose();			


//#ifdef _WIN32
/***************************************************************
*
*	DWORD FAR PASCAL memAlloc(DWORD dwSize, WORD wType)
*                                      
*	dwSize : The size (in 16 bits Words) of the block to allocate
*			must be <64 kW
*			unless for	wType & 0xff =0x11 
*									(Sound Pcm, dwSize must be < 256 kWords)
*						wType & 0xff =0x30 (Static buffer, no limit)
*	dwType :	cf "SAM9407 Developers' Reference" 2 Firmware Structures -
*										  Memory Mapping Table
*
*	Return : Address of memory space allocated if succeed, 0 if failed
*
****************************************************************/

DWORD FAR PASCAL _loadds memAlloc(DWORD dwSize, WORD wType);



/***************************************************************
*
*	WORD FAR PASCAL memFree(DWORD Address)
*                                      
*	dwAddress : Address of the block to delete
*
*	Return : 0 if succeed, error code if failed
*
****************************************************************/

WORD FAR PASCAL _loadds memFree(DWORD Address);



/***************************************************************
*
*	WORD FAR PASCAL bankLoad(LPCHAR BankName)
*                                      
*	BankName : Name of th sound bank file (.94b)
*
*	Return : Sound bank number if succeed, 0x10+error code if failed
*
****************************************************************/

WORD FAR PASCAL _loadds bankLoad(char far *BankName);



/***************************************************************
*
*	WORD FAR PASCAL memLoadFirmware(char far *FirmName)
*                                      
*	FirmName : name of the firmware file (.bin)
*
*	Return : 0 if succeed, error code if failed
*
****************************************************************/

WORD FAR PASCAL _loadds memLoadFirmware(char far *FirmName);

/***************************************************************
*
*	WORD FAR PASCAL bankGetCaps(LPBANKCAPS lpBankCaps)
*                                      
*	Fill the stucture BANKCAPS with information on 9407 board memory
*
*	Return : 0 if succeed, error code if failed
*
****************************************************************/

WORD FAR PASCAL _loadds bankGetCaps(LPBANKCAPS lpBankCaps);



/***************************************************************
*
*	WORD FAR PASCAL _loadds bankSetPriority(WORD wBankNb, wBankPriority)
*                                      
*	Change the priority of the sound bank
*
*	Return : 0 if succeed, error code if failed
*
****************************************************************/

WORD FAR PASCAL _loadds bankSetPriority(WORD wBankNb, WORD wBankPriority);


/***************************************************************
*
*	WORD FAR PASCAL _loadds bankUnLoad(WORD wBankNb)
*                                   
*	Remove the sound bank from 9407 boar memory
*
*	Return : 0 if succeed, error code if failed
*
****************************************************************/

WORD FAR PASCAL _loadds bankUnload(WORD wBankNb);

/***************************************************************
*
*	WORD FAR PASCAL memLoadFirmwareEx(char far *FirmName, DWORD Flags)
*
*                                      
*	FirmName : name of the firmware file (.bin) (<256 char)
*
*	Flags	 :	FIRMWCAPS_MIDI		(Capability : The new Firmware is able to play midi)
*				FIRMWCAPS_WAVEIN		(Capability : The new Firmware is able to play wave in)
*				FIRMWCAPS_WAVEOUT		(Capability : The new Firmware is able to play wave out)
*				FIRMWARE_SAVEBANKS	(Option		: Save the sound banks to be restored after
*									reloading a GM Firmware. 
*									DREAMERR_CANNOTSAVEBANK is returned if the Firmware deleted isn't a
*									Midi Firmware or if the new Firmware loaded is going to
*									erase some part of sound banks.
*				FIRMWARE_RESTOREBANKS (Option	: Restore previously saved Sound Banks).
*
*
*	Return : 0 if succeed, error code if failed 
*			(	DREAMERR_CANNOTSAVEBANK if the option 
*			FIRMWARE_SAVEBANKS is specified and it would be impossible to
*			restore the memory state (sound banks) later) 
*
*	**	If you ask to load a Firmware with FIRMWARE_SAVEBANKS or FIRMWARE_RESTOREBANKS options and
*	**	that the option asked cannot be successfully achieved, the Firmware isn't loaded on board.
*	**	Application programmers should handle this case by loading (or not) the Firmware without 
*	**	option.
*
*
*****************************************************************/

WORD FAR PASCAL _loadds memLoadFirmwareEx(char far *FirmName, DWORD Flags);

//#endif


#ifdef __cplusplus
}                       /* End of extern "C" { */
#endif	/* __cplusplus */   				