// mixer driver data
int mixerNb;
MIXERCAPS MixCaps;
//HMIXER hmx[8];
HMIXEROBJ hmx[8];
UINT uMxId=0;
int midiInNb;
int midiOutNb;
int waveInNb;
int waveOutNb;
int auxNb;
MIXERLINE mixLine,mxLine[16];
MIXERCONTROL mxCtrl[32];
MIXERLINECONTROLS mxLCtrl[16];
int cConnections=0;
MIXERCONTROLDETAILS mxCtrlD[16];
MIXERCONTROLDETAILS_UNSIGNED detVal[16][2];
MIXERCONTROLDETAILS_BOOLEAN bdetVal[3][2];
UINT MicMin,MicMax,MicVol,MicPan;
UINT LineMin,LineMax,LineVol,LinePan;
UINT CDMin,CDMax,CDVol,CDPan;

int MicId,LineId,CDId;
int dwMicId,dwLineId,dwCDId;


MIXERLINE RLine[1];
MIXERCONTROL RCtrl[1];
MIXERLINECONTROLS RLCtrl[1];
MIXERCONTROLDETAILS RCtrlD[1];

UINT DVolMin,DVolMax,DVolVol,DVolPan;
UINT DLineMin,DLineMax,DLineVolL,DLineVolR;
UINT DMidiMin,DMidiMax,DMidiVol,DMidiPan;
UINT DWaveMin,DWaveMax,DWaveVol,DWavePan;

UINT DWIMin,DWIMax,DWISel;

int DVolId,DWaveInId,DLineId,DMidiId,DWaveId;
int dwDVolId,dwDWaveInId,dwDLineId,dwDMidiId,dwDWaveId;
int cbDreamDest=0;




int GetMixerValues(HWND);
BOOL GetDreamMixerValues(HWND hWnd);
int GetLineId(HMIXER hmix,LPSTR linename);
int GetLineId2(HMIXER hmix,DWORD CompoType);
WORD GetDestLineId(HMIXER hmix,LPSTR linename,WORD cDestinations);
int GetLineDetails(HMIXER hmx,LPMIXERLINE pmxLine,LPMIXERLINECONTROLS pmxLCtrl,LPMIXERCONTROL pmxCtrl,LPMIXERCONTROLDETAILS pmxCtrlD,MIXERCONTROLDETAILS_UNSIGNED *pdetVal);
WORD GetMasterVol(HMIXER hmx,LPMIXERLINE pmxLine,LPMIXERLINECONTROLS pmxLCtrl,LPMIXERCONTROL pmxCtrl,LPMIXERCONTROLDETAILS pmxCtrlD,MIXERCONTROLDETAILS_UNSIGNED *pdetVal,WORD cDestinations);
WORD GetRecordStatus(HMIXER hmx,LPMIXERLINE pmxLine,LPMIXERLINECONTROLS pmxLCtrl,LPMIXERCONTROL pmxCtrl,LPMIXERCONTROLDETAILS pmxCtrlD,MIXERCONTROLDETAILS_BOOLEAN *pdetVal,WORD cDestinations);

unsigned int GetMSMixVol(int LineId,int chanNb);
unsigned int GetMSMixPan(int LineId);
//***************************************************************
int GetMixerValues(HWND hWnd)
{
int i;
MMRESULT mmres;
char txt[255];
int ConnectedMixerId=-1;
int DreamMixerId=-1;


mixerNb=mixerGetNumDevs();
if(mixerNb==0)
{
	FrameStatus[0]=0;
	return(0);
}
for (i=0;i<mixerNb;i++)
    { 
    mmres=mixerGetDevCaps(i, (LPMIXERCAPS) &MixCaps,sizeof(MIXERCAPS));
	strcpy(txt,MixCaps.szPname);
	strupr(txt);
	if(strstr(txt,szExtMixName))
		{
		ConnectedMixerId=i;
		break;
		}
		
    }
if(ConnectedMixerId==-1)
	{
	bExtMixer=FALSE;
	FrameStatus[0]=0;
	return(-1);
	}
//mmres=mixerOpen((LPHMIXER)&hmx[0],uMxId,0,0,MIXER_OBJECTF_MIXER);
uMxId=ConnectedMixerId;
mmres=mixerOpen((LPHMIXER)&hmx[0],uMxId,hWnd,0,CALLBACK_WINDOW);
MicId=GetLineId(hmx[0],(LPSTR)MicTxt);
LineId=GetLineId(hmx[0],(LPSTR)LineTxt);
CDId=GetLineId(hmx[0],(LPSTR)CDTxt);

//MicId=GetLineId2(hmx[0],MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE);
//LineId=GetLineId2(hmx[0],MIXERLINE_COMPONENTTYPE_SRC_LINE);
//CDId=GetLineId2(hmx[0],MIXERLINE_COMPONENTTYPE_SRC_AUXILIARY);

GetLineDetails(hmx[0],&mxLine[0],&mxLCtrl[0],&mxCtrl[0],&mxCtrlD[0],&detVal[0][0]);
if(MicId!=-1)
{
	dwMicId=mxCtrlD[MicId].dwControlID;
	MicMin=mxLCtrl[MicId].pamxctrl->Bounds.lMinimum;
	MicMax=mxLCtrl[MicId].pamxctrl->Bounds.lMaximum;
	MicVol=detVal[MicId][0].dwValue;
}
else
{
	MicMin=0;
	MicMax=0;
	MicVol=0;
}
if(LineId!=-1)
{
	dwLineId=mxCtrlD[LineId].dwControlID;
	LineMin=mxLCtrl[LineId].pamxctrl->Bounds.lMinimum;
	LineMax=mxLCtrl[LineId].pamxctrl->Bounds.lMaximum;
	LineVol=GetMSMixVol(LineId,2);
	LinePan=GetMSMixPan(LineId);
	if(LinePan==-1)
		LinePan=63;
}
else
{
	LineMin=0;
	LineMax=0;
	LineVol=0;
	LinePan=0;
}
if(CDId!=-1)
{
	dwCDId=mxCtrlD[CDId].dwControlID;
	CDMin=mxLCtrl[CDId].pamxctrl->Bounds.lMinimum;
	CDMax=mxLCtrl[CDId].pamxctrl->Bounds.lMaximum;
	CDVol=GetMSMixVol(CDId,2);
	CDPan=GetMSMixPan(CDId);
	if(CDPan==-1)
		CDPan=63;
}
else
{
	CDMin=0;
	CDMax=0;
	CDVol=0;
	CDPan=0;
}
return(1);
}
//***************************************************************
BOOL GetDreamMixerValues(HWND hWnd)
{
int i;
MMRESULT mmres;
char txt[255];
int ConnectedMixerId=-1;
int DreamMixerId=-1;


mixerNb=mixerGetNumDevs();
if(mixerNb==0)
{
	FrameStatus[0]=0;
	return(FALSE);
}
for (i=0;i<mixerNb;i++)
    { 
    mmres=mixerGetDevCaps(i, (LPMIXERCAPS) &MixCaps,sizeof(MIXERCAPS));
	strcpy(txt,MixCaps.szPname);
	strupr(txt);
	if(strstr(txt,szDreamMixName))
		{	
		DreamMixerId=i;
		break;
		}
    }
if(DreamMixerId==-1)
	{
	//bExtMixer=FALSE;
	//FrameStatus[0]=0;
	return(FALSE);
	}
//mmres=mixerOpen((LPHMIXER)&hmx[0],uMxId,0,0,MIXER_OBJECTF_MIXER);
uMxId=DreamMixerId;
mmres=mixerOpen((LPHMIXER)&hmx[1],uMxId,hWnd,0,CALLBACK_WINDOW);


DLineId=GetLineId(hmx[1],(LPSTR)"LINE");
DMidiId=GetLineId(hmx[1],(LPSTR)"MIDI");
DWaveId=GetLineId(hmx[1],(LPSTR)"WAVE");
cbDreamDest=MixCaps.cDestinations;

DVolId=GetDestLineId(hmx[1],(LPSTR)"VOL",cbDreamDest);
DWaveInId=GetDestLineId(hmx[1],(LPSTR)"REC",cbDreamDest);

if(DVolId!=-1)
{
	GetMasterVol(hmx[1],&mxLine[0],&mxLCtrl[0],&mxCtrl[0],&mxCtrlD[0],&detVal[0][0],DVolId);
	dwDVolId=mxCtrlD[DVolId].dwControlID;
	DVolMin=mxLCtrl[DVolId].pamxctrl->Bounds.lMinimum;
	DVolMax=mxLCtrl[DVolId].pamxctrl->Bounds.lMaximum;
	DVolVol=detVal[DVolId][0].dwValue;
}

GetLineDetails(hmx[1],&mxLine[0],&mxLCtrl[0],&mxCtrl[0],&mxCtrlD[0],&detVal[0][0]);
if(DMidiId!=-1)
{
	dwDMidiId=mxCtrlD[DMidiId].dwControlID;
	DMidiMin=mxLCtrl[DMidiId].pamxctrl->Bounds.lMinimum;
	DMidiMax=mxLCtrl[DMidiId].pamxctrl->Bounds.lMaximum;
	DMidiVol=GetMSMixVol(DMidiId,2);
	DMidiPan=GetMSMixPan(DMidiId);
	if(DMidiPan==-1)
		DMidiPan=63;
}
if(DWaveId!=-1)
{
	dwDWaveId=mxCtrlD[DWaveId].dwControlID;
	DWaveMin=mxLCtrl[DWaveId].pamxctrl->Bounds.lMinimum;
	DWaveMax=mxLCtrl[DWaveId].pamxctrl->Bounds.lMaximum;
	DWaveVol=GetMSMixVol(DWaveId,2);
	DWavePan=GetMSMixPan(DWaveId);
	if(DWavePan==-1)
		DWavePan=63;
}
if(DLineId!=-1)
{
	dwDLineId=mxCtrlD[DLineId].dwControlID;
	DLineMin=mxLCtrl[DLineId].pamxctrl->Bounds.lMinimum;
	DLineMax=mxLCtrl[DLineId].pamxctrl->Bounds.lMaximum;
	DLineVolL=detVal[DLineId][0].dwValue;
	DLineVolR=detVal[DLineId][1].dwValue;
}   

if(DWaveInId!=-1)
{
	GetRecordStatus(hmx[1],&RLine[0],&RLCtrl[0],&RCtrl[0],&RCtrlD[0],&bdetVal[0][0],DWaveInId);
	dwDWaveInId=RCtrlD[0].dwControlID;
	DWIMin=RLCtrl[0].pamxctrl->Bounds.lMinimum;
	DWIMax=RLCtrl[0].pamxctrl->Bounds.lMaximum;
	DWISel=bdetVal[0][0].fValue;
}
return(TRUE);
}
//*****************************************************
int GetLineId(HMIXER hmix,LPSTR linename)
{
//MIXERLINE mxline;
int cConx,i,res1;//,res2;
MMRESULT mmres;
char text1[50];
char text2[50];

strcpy(text1,strupr(linename));
mixLine.cbStruct=sizeof(MIXERLINE);
mmres=mixerGetLineInfo(hmix,(LPMIXERLINE) &mixLine,MIXER_OBJECTF_HMIXER);
cConx=mixLine.cConnections;
for (i=0;i<cConx;i++)
	{
	mxLine[0].cbStruct=sizeof(MIXERLINE);
	mxLine[0].dwSource=i;
	mxLine[0].dwDestination=mixLine.dwDestination;
	mmres=mixerGetLineInfo(hmix,(LPMIXERLINE) &mxLine[0],MIXER_GETLINEINFOF_SOURCE);
	strcpy(text2,strlwr(mxLine[0].szShortName));
	strupr(text2);
	res1=strstr(text2,text1);

	if (res1 != NULL)
		return(i);
	}
return(-1);
}
//*****************************************************
int GetLineId2(HMIXER hmix,DWORD CompoType)
{
//MIXERLINE mxline;
int cConx,i,res1;//,res2;
MMRESULT mmres;


mixLine.cbStruct=sizeof(MIXERLINE);
mmres=mixerGetLineInfo(hmix,(LPMIXERLINE) &mixLine,MIXER_OBJECTF_HMIXER);
cConx=mixLine.cConnections;
for (i=0;i<cConx;i++)
	{
	mxLine[0].cbStruct=sizeof(MIXERLINE);
	mxLine[0].dwSource=i;
	mxLine[0].dwDestination=mixLine.dwDestination;
	mmres=mixerGetLineInfo(hmix,(LPMIXERLINE) &mxLine[0],MIXER_GETLINEINFOF_SOURCE);
	
	
	if(CompoType==MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE)
	{
	if((mxLine[0].dwComponentType==CompoType)||(mxLine[0].dwComponentType==MIXERLINE_COMPONENTTYPE_SRC_PCSPEAKER))
		return(i);
	}
	else
	{
	if((mxLine[0].dwComponentType==CompoType)||(mxLine[0].dwComponentType==MIXERLINE_COMPONENTTYPE_SRC_PCSPEAKER))
		return(i);	
	}
	/*strcpy(text2,strlwr(mxLine[0].szShortName));
	strupr(text2);
	res1=strstr(text2,text1);

	if (res1 != NULL) 
		return(i);	*/
		
	}
return(-1);
}
//*****************************************************
WORD GetDestLineId(HMIXER hmix,LPSTR linename,WORD cDestinations)
{
//MIXERLINE mxline;
int cConx,i,res1;//,res2;
MMRESULT mmres;
char text1[50];
char text2[50];

strcpy(text1,strupr(linename));
mixLine.cbStruct=sizeof(MIXERLINE);
for (i=0;i<cDestinations;i++)
{
	mmres=mixerGetLineInfo(hmix,(LPMIXERLINE) &mixLine,MIXER_OBJECTF_HMIXER);
	
	mxLine[0].cbStruct=sizeof(MIXERLINE);
	//pmxLine->dwSource=i;
	mxLine[0].dwDestination=i;
	mmres=mixerGetLineInfo(hmix,(LPMIXERLINE) &mxLine[0],MIXER_GETLINEINFOF_DESTINATION);
/*

	mxLCtrl[0].cbStruct=sizeof(MIXERLINECONTROLS);
	mxLCtrl[0].pamxctrl=(LPMIXERCONTROL)mxCtrl;
	mxLCtrl[0].dwLineID=mxLine[0].dwLineID;
	mxLCtrl[0].cControls=mxLine[0].cControls;
	mxLCtrl[0].cbmxctrl=sizeof(MIXERCONTROL);
	mmres=mixerGetLineControls(hmix,(LPMIXERLINECONTROLS)mxLCtrl,MIXER_GETLINECONTROLSF_ALL);
*/
	
	strcpy(text2,strlwr(mxLine[0].szShortName));
	strupr(text2);
	res1=strstr(text2,text1);

	if (res1 != NULL)
	{
		if((mxLine[0].fdwLine & 0x00008000)==0)
			return(i);
		else
		    return(-1);
	} 
}	
return(-1);
}


//*********************************************************
int GetLineDetails(HMIXER hmx,LPMIXERLINE pmxLine,LPMIXERLINECONTROLS pmxLCtrl,LPMIXERCONTROL pmxCtrl,LPMIXERCONTROLDETAILS pmxCtrlD,MIXERCONTROLDETAILS_UNSIGNED *pdetVal)
{
MMRESULT mmres;
int i;

mixLine.cbStruct=sizeof(MIXERLINE);
mmres=mixerGetLineInfo(hmx,(LPMIXERLINE)&mixLine,MIXER_OBJECTF_HMIXER);
cConnections=mixLine.cConnections;
for (i=0;i<cConnections;i++)
	{
	pmxLine->cbStruct=sizeof(MIXERLINE);
	pmxLine->dwSource=i;
	pmxLine->dwDestination=0;
	mmres=mixerGetLineInfo(hmx,(LPMIXERLINE) pmxLine,MIXER_GETLINEINFOF_SOURCE);

	pmxLCtrl->cbStruct=sizeof(MIXERLINECONTROLS);
	pmxLCtrl->pamxctrl=(LPMIXERCONTROL)pmxCtrl;
	pmxLCtrl->cControls=pmxLine->cControls;
	pmxLCtrl->dwLineID=pmxLine->dwLineID;
	pmxLCtrl->cbmxctrl=sizeof(MIXERCONTROL);
	mmres=mixerGetLineControls(hmx,(LPMIXERLINECONTROLS)pmxLCtrl,MIXER_GETLINECONTROLSF_ALL);

	pmxCtrlD->paDetails=pdetVal;
	pmxCtrlD->cbDetails=sizeof(*pdetVal);
	pmxCtrlD->cbStruct=sizeof(MIXERCONTROLDETAILS);
	pmxCtrlD->dwControlID=pmxCtrl->dwControlID;
	pmxCtrlD->cChannels=pmxLine->cChannels;
	pmxCtrlD->cMultipleItems=pmxCtrl->cMultipleItems;
	mmres=mixerGetControlDetails(hmx,(LPMIXERCONTROLDETAILS)pmxCtrlD,MIXER_GETCONTROLDETAILSF_VALUE);

	pmxLine++;
	pmxLCtrl++;
	pmxCtrl++;	
	pmxCtrlD++;
	pdetVal+=2;

	}
}

//**************************************
unsigned int GetMSMixVol(int LineId,int chanNb)
{
unsigned int vol;
	if (chanNb==1)
		vol=detVal[LineId][0].dwValue;
	else if(chanNb==2)
		vol=max(detVal[LineId][0].dwValue,detVal[LineId][1].dwValue);
	else
		vol=0;

return(vol);
}
//*********************************************
unsigned int GetMSMixPan(int LineId)
{
double pan;
unsigned int left,right;
left=detVal[LineId][0].dwValue;
right=detVal[LineId][1].dwValue;
if(right-left!=0)
	pan=(double)63-(double)63*(((double)left-(double)right)/(double)max(right,left)) + (double)0.5;
else
{
	if(right==0)
		pan=-1;
	else
		pan=63;
}
	
return((unsigned int)pan);
}
//*********************************************************
WORD GetMasterVol(HMIXER hmx,LPMIXERLINE pmxLine,LPMIXERLINECONTROLS pmxLCtrl,LPMIXERCONTROL pmxCtrl,LPMIXERCONTROLDETAILS pmxCtrlD,MIXERCONTROLDETAILS_UNSIGNED *pdetVal,WORD cDestinations)
{
MMRESULT mmres;
int i;

mixLine.cbStruct=sizeof(MIXERLINE);

mmres=mixerGetLineInfo(hmx,(LPMIXERLINE)&mixLine,MIXER_OBJECTF_HMIXER);

	pmxLine->cbStruct=sizeof(MIXERLINE);
	//pmxLine->dwSource=i;
	pmxLine->dwDestination=cDestinations;
	mmres=mixerGetLineInfo(hmx,(LPMIXERLINE) pmxLine,MIXER_GETLINEINFOF_DESTINATION);

	pmxLCtrl->cbStruct=sizeof(MIXERLINECONTROLS);
	pmxLCtrl->pamxctrl=(LPMIXERCONTROL)pmxCtrl;
	pmxLCtrl->dwLineID=pmxLine->dwLineID;
	pmxLCtrl->cControls=pmxLine->cControls;
	pmxLCtrl->cbmxctrl=sizeof(MIXERCONTROL);
	mmres=mixerGetLineControls(hmx,(LPMIXERLINECONTROLS)pmxLCtrl,MIXER_GETLINECONTROLSF_ALL);

	pmxCtrlD->paDetails=pdetVal;
	pmxCtrlD->cbDetails=sizeof(MIXERCONTROLDETAILS_UNSIGNED);
	pmxCtrlD->cbStruct=sizeof(MIXERCONTROLDETAILS);
	pmxCtrlD->dwControlID=pmxCtrl->dwControlID;
	pmxCtrlD->cChannels=pmxLine->cChannels;
	mmres=mixerGetControlDetails(hmx,(LPMIXERCONTROLDETAILS)pmxCtrlD,MIXER_GETCONTROLDETAILSF_VALUE);

return((WORD)(pdetVal->dwValue));

}
//*********************************************************
WORD GetRecordStatus(HMIXER hmx,LPMIXERLINE pmxLine,LPMIXERLINECONTROLS pmxLCtrl,LPMIXERCONTROL pmxCtrl,LPMIXERCONTROLDETAILS pmxCtrlD,MIXERCONTROLDETAILS_BOOLEAN *pdetVal,WORD cDestinations)
{
MMRESULT mmres;
int i;

mixLine.cbStruct=sizeof(MIXERLINE);

mmres=mixerGetLineInfo(hmx,(LPMIXERLINE)&mixLine,MIXER_OBJECTF_HMIXER);

	pmxLine->cbStruct=sizeof(MIXERLINE);
	//pmxLine->dwSource=i;
	pmxLine->dwDestination=cDestinations;
	mmres=mixerGetLineInfo(hmx,(LPMIXERLINE) pmxLine,MIXER_GETLINEINFOF_DESTINATION);

	pmxLCtrl->cbStruct=sizeof(MIXERLINECONTROLS);
	pmxLCtrl->pamxctrl=(LPMIXERCONTROL)pmxCtrl;
	pmxLCtrl->dwLineID=pmxLine->dwLineID;
	pmxLCtrl->cControls=pmxLine->cControls;
	pmxLCtrl->cbmxctrl=sizeof(MIXERCONTROL);
	mmres=mixerGetLineControls(hmx,(LPMIXERLINECONTROLS)pmxLCtrl,MIXER_GETLINECONTROLSF_ALL);

	pmxCtrlD->paDetails=pdetVal;
	pmxCtrlD->cbDetails=sizeof(*pdetVal);
	pmxCtrlD->cbStruct=sizeof(MIXERCONTROLDETAILS);
	pmxCtrlD->dwControlID=pmxCtrl->dwControlID;
	pmxCtrlD->cChannels=1;
	pmxCtrlD->cMultipleItems=pmxCtrl->cMultipleItems;
	mmres=mixerGetControlDetails(hmx,(LPMIXERCONTROLDETAILS)pmxCtrlD,MIXER_GETCONTROLDETAILSF_VALUE);



return(1);

}

