// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#ifndef __XX_PROTOCOL_CPP__
#define __XX_PROTOCOL_CPP__
#endif

#include "xx_protocol.h"
#include "platform.h"


 WORD    CProtocol::vio_SupportedPRFeatures()
						{
							m_PlayFormats   = (STREAM_FMT_LIN_16|STREAM_FMT_LIN_24);
							m_RecordFormats = (STREAM_FMT_LIN_16|STREAM_FMT_LIN_24);
							return SUCCESS;
						};


//////////////////////////////////////////////////////////////////////
// Construction  (currently called only once at driver startup)
//
CProtocol::CProtocol( PDSP_INFO PmpDspInfo, CPIOCommands *PmpPIO) : m_PIO(PmpPIO)
{
	DOUT (DBG_PROT_INIT, ("CProtocol::CProtocol() PmpPIO = %p\n",PmpPIO));

    WORD i = 0;

    ASSERT(m_PIO);

	m_PIO			=	PmpPIO;
    m_pDSPInfo		=	PmpDspInfo;

	// Initialize the chaining of STREAM_INFO data
    // for both out and in streams	
    // ********************************************
	BZERO2( m_Out_Stream_Info_Array, STREAM_INFO, MAX_OUTSTREAM);
	BZERO2( m_In_Stream_Info_Array,  STREAM_INFO, MAX_INSTREAM);
	
	m_FatalDspError = 0;

	m_SrcIT = 0;
	m_TimerIT = 0;
	m_TimerIT_Refs = 0;

	// Update DSP_INFO
	BZERO2( m_pDSPInfo, DSP_INFO, 1);

	// SpinLock handling !!
	//
#ifndef SIMLXES
	m_MsgLock = m_PIO->GetMsgSpinLock();
#endif

    // must be init later, when the version of the dsp software is checked
    //
    m_PlayFormats   = 0;
    m_RecordFormats = 0;

    m_PCMOnlyGranularity = 144; // default for PCX boards

    m_AudioInMask_Reserving_Src =0;
    m_AudioInMask_UER_SRC_Def=0;
    m_AudioInMask_UER_SRC_Async=0;


} // End of regular Constructor

/*
*/
CProtocol::~CProtocol()
{
	DOUT (DBG_PROT_INIT, ("CProtocol::~CProtocol()\n"));
	if (m_pDSPInfo) m_pDSPInfo->dsEtat = 0;
}

/*
*/
WORD CProtocol::IResource_Source_Release_Audios(IN DWORDLONG PmAudioMask) 
{
	// remove pipe from reservation mask
	DWORDLONG LcAudioMask = m_AudioInMask_Reserving_Src & PmAudioMask;
	WORD  LcAudioNum = 0;

#ifndef SIMLXES

	while( LcAudioMask)
	{
		WORD LcRet;
		if (LcAudioMask & 0x1) {
			// source is free

			LcRet = m_PIO->PIOSetOneAudioSource(LcAudioNum, DATA_FROM_NO_INPUT) ;

			if (LcRet & ERROR_MASK) {
				DOUT( DBG_ERROR,("IResource_Source RELEASE audio %lx FAILED :%lx\n",LcAudioNum,LcRet));
				return LcRet;
			}
			else {
				DWORD LcTempAudioMask = ~( 1L << LcAudioNum );
				DWORD LcDependencyMask = m_PIO->PIOGetSourceAudioDependency( LcAudioNum );

				DOUT( DBG_SOURCE,("IResource_Source RELEASE Audio %d from Reservation Mask %lx\n",LcAudioNum, m_AudioInMask_Reserving_Src));

				// remove audio source reservation and eventual UER SRC reservation
				//
                m_AudioInMask_Reserving_Src &= LcTempAudioMask;
				m_AudioInMask_UER_SRC_Def   &= LcTempAudioMask;

				// if nobody reserves a stereo couple of audios, reset their UER SRC
				//
				if( ((m_AudioInMask_Reserving_Src | m_AudioInMask_UER_SRC_Def) & LcDependencyMask) == 0 )
				{
					m_AudioInMask_UER_SRC_Async &= ~LcDependencyMask;
					m_PIO->PIOSetConfigSRC(LcAudioNum, SRC_off);
					DOUT( DBG_SOURCE,("IResource_Source RELEASE: SRC switch OFF Mask = %lx\n",LcDependencyMask));
				}
			}
		}

		LcAudioNum++;
		LcAudioMask >>=1;
	} // foreach audio

#endif // SIMLXES

	return SUCCESS;
} // IResource_Source_Release_Audios



WORD    CProtocol::IResource_Source_TestClock_Audio(	IN WORD PmAudio,
														IN BYTE PmSourceType,
														IN WORD PmClockType,
														IN DWORD PmSyncInputNum,
														IN DWORD PmFrequency,
														INOUT PBYTE PmUER_SRC)
{
#ifndef SIMLXES

	
	WORD  LcDescAudioIn = m_PIO->PIOGetDescAudioIn(PmAudio/2);
	BYTE  LcPhysInFeat2 = m_PIO->PIOGetPhysInFeature2(PmAudio/2);

	// *************************************************************
	// general audio source limitations
	// *************************************************************
	switch( PmSourceType )
	{
	case DATA_FROM_NO_INPUT:
		break;
	case DATA_FROM_ANALOG:
		if( !(LcDescAudioIn & AUDIO_ANALOG_MSK))
			return ED_INVALID_BOARD_AUDIO;
		break;
	case DATA_FROM_MICRO:
		if( !(LcDescAudioIn & AUDIO_MICRO_MSK))
			return ED_INVALID_BOARD_AUDIO;
		break;
	case DATA_FROM_DIGITAL_SYNCHRO:
		if( !(LcDescAudioIn & AUDIO_DIGITAL1_MSK))
			return ED_INVALID_BOARD_AUDIO;
		break;
	case DATA_FROM_DIGITAL_DATA:
		if( !(LcDescAudioIn & AUDIO_DIGITAL2_MSK))
			return ED_INVALID_BOARD_AUDIO;
		break;
	case DATA_FROM_SYNC_CONNECTOR:
		if( !(LcPhysInFeat2 & AUDIO_SYNC_CONNECTOR_MSK))
			return ED_INVALID_BOARD_AUDIO;
		break;
	default:
		return ED_BAD_SOURCE;
	}

	if( (PmSourceType == DATA_FROM_DIGITAL_SYNCHRO) ||
		(PmSourceType == DATA_FROM_DIGITAL_DATA)    ||
		(PmSourceType == DATA_FROM_SYNC_CONNECTOR)  )
	{
		switch( PmClockType )
		{
		case CLOCK_TYPE_INTERNAL:
			if( *PmUER_SRC == IN_NO_PROPERTIES )
				*PmUER_SRC = IN_PROPERTIES_UER_ASYNC;		// auto : use SRC !
			break;
		case CLOCK_TYPE_PROGRAMMABLE_CLOCK:
			if( *PmUER_SRC != IN_PROPERTIES_UER_SYNC )
				return ED_SET_PIPE_SOURCE_REFUSED;			// auto and ASYNC : fail
			break;
		case CLOCK_TYPE_UER_SYNCHRO:

            // force SYNC if source audio == source clock ( both on this board)
            //
            if (     ( PmSyncInputNum == (PmAudio/2 + 1)) 
                &&   ( m_PIO->PIOGetActualClkType() != SLAVE_CLOCK)
                )
                { *PmUER_SRC = IN_PROPERTIES_UER_SYNC; break; } ;


			if( *PmUER_SRC == IN_NO_PROPERTIES )
			{
				if( (PmSyncInputNum == 0) ||						// SYNC if SYNC clock
					((LcPhysInFeat2 & AUDIO_SRC_PRESENT_MASK) == 0) // SYNC if no SRC available (compatibility with np driver)
                   )	
				{
					*PmUER_SRC = IN_PROPERTIES_UER_SYNC;
				}
				else
				{
					*PmUER_SRC = IN_PROPERTIES_UER_ASYNC;
				}
			}
			break;
		case CLOCK_TYPE_WORD_CLOCK:
		case CLOCK_TYPE_ETHERSOUND:
		case CLOCK_TYPE_VIDEO:							// auto : do not use SRC (see below)
			// MBR (10/12/2004) pourquoi pas ???
			//if( PmSourceType == DATA_FROM_DIGITAL_SYNCHRO )
			//	return ED_SET_PIPE_SOURCE_REFUSED;		// compatibility with np driver
			break;
		}
		if( *PmUER_SRC == IN_NO_PROPERTIES )
		{
			*PmUER_SRC = IN_PROPERTIES_UER_SYNC;	// auto : if no use of SRC preferred.
		}
	}
	else	// DATA_FROM_ANALOG || DATA_FROM_MICRO
	{
		*PmUER_SRC = IN_PROPERTIES_UER_SYNC;
	}

	if( *PmUER_SRC == IN_PROPERTIES_UER_ASYNC )
	{
		if( (LcPhysInFeat2 & AUDIO_SRC_PRESENT_MASK) == 0 )
			return ED_SET_PIPE_SOURCE_REFUSED;

		// TODO - Test also if SRC OUT used !

		if( (PmClockType == CLOCK_TYPE_INTERNAL) && (PmFrequency > 96000) )
			return ED_SET_PIPE_SOURCE_REFUSED;

		if( PmSourceType == DATA_FROM_SYNC_CONNECTOR )
			return ED_SRC_UNAVAILABLE;	// no SRC available for DATA_FROM_SYNC_CONNECTOR
	}
#endif
	return SUCCESS;

}



/*
*/
WORD    CProtocol::IResource_Source_Change_Audios(IN DWORDLONG PmAudioMask, IN BYTE PmSourceType, IN BYTE PmUER_SRC)
{
   /*
    CHECK AUDIO HARDWARE DEPENDENCIES
   */
	WORD  LcRet = SUCCESS;
	WORD  LcAudioNum = 0;
	DWORDLONG LcAudioMask = PmAudioMask;
	BOOLEAN LcResyncFull = FALSE;
	BOOLEAN LcComputeFreq = FALSE;

    DOUT( DBG_SOURCE,("IResource_Source COMPAT : check Mask %x against reserved %x \n",PmAudioMask, m_AudioInMask_Reserving_Src));

#ifndef SIMLXES

	while( LcAudioMask )
	{
        if( LcAudioMask & 0x01 )
		{
			WORD  LcTempRet;
			WORD  LcKeepNum;
			DWORDLONG LcKeepMask;
			BYTE  LcAutoUER_SRC = PmUER_SRC;

			// dependency mask for this audio (should be a stereo mask like 0x03,0x0C,0x30,..)
			DWORD LcDependencyMask = m_PIO->PIOGetSourceAudioDependency( LcAudioNum );

			if( LcDependencyMask == 0 )	// is the audio invalid ?
			{
				DOUT( DBG_ERROR,("IResource_Source COMPAT : invalid PmAudioMask !\n"));
				return ED_INVALID_BOARD_AUDIO;
			}

			// mask of audios in this dependency we do NOT want to chage
			//
			LcKeepMask = LcDependencyMask & ~PmAudioMask;

			// *************************************************************
			// SRC available or reserved by depending audio
			// *************************************************************
			if( LcKeepMask & m_AudioInMask_UER_SRC_Def )
			{
				// not compatible with what we want ?
				if( LcAutoUER_SRC == IN_PROPERTIES_UER_SYNC )
				{
					if( m_AudioInMask_UER_SRC_Async & LcKeepMask )
					{
						DOUT( DBG_ERROR,("IResource_Source COMPAT ERROR : %x reserved SRC ASYNC; SRC SYNC not available for %x\n", LcKeepMask, PmAudioMask));
						return ED_SRC_UNAVAILABLE;
					}
				}
				else
				if( LcAutoUER_SRC == IN_PROPERTIES_UER_ASYNC )
				{
					if( (m_AudioInMask_UER_SRC_Async & LcKeepMask) == 0)
					{
						DOUT( DBG_ERROR,("IResource_Source COMPAT ERROR : %x reserved SRC SYNC; SRC ASYNC not available for %x\n", LcKeepMask, PmAudioMask));
						return ED_SRC_UNAVAILABLE;
					}
				}
				else	// *LcAutoUER_SRC == IN_NO_PROPERTIES
				{
					if( m_AudioInMask_UER_SRC_Async & LcKeepMask )
					{
						LcAutoUER_SRC = IN_PROPERTIES_UER_ASYNC;
						DOUT( DBG_WARNING,("IResource_Source COMPAT : %x reserved SRC ASYNC ! use same for AudioMask %d\n", LcKeepMask, PmAudioMask));
					}
					else
					{
						LcAutoUER_SRC = IN_PROPERTIES_UER_SYNC;
						DOUT( DBG_WARNING,("IResource_Source COMPAT : %x reserved SRC SYNC ! use same for AudioMask %d\n", LcKeepMask, PmAudioMask));
					}
				}
			}

			// *************************************************************
			// check the audio if it's compatible with clock and SRC
			// and choose automatically SRC usage if not specified
			// *************************************************************
			LcTempRet = IResource_Source_TestClock_Audio(	LcAudioNum,
															PmSourceType,
															m_PIO->PIOGetActualClkSource(),
															m_PIO->PIOGetActualClkInputNum(),
															m_PIO->PIOGetActualClockFrequency(),
															&LcAutoUER_SRC );
			if( LcTempRet != SUCCESS )
			{
				DOUT( DBG_ERROR,("IResource_Source COMPAT : Audio Source NOT compatible with Clock/SRC\n"));
				return LcTempRet;
			}

			// *************************************************************
			// check the depending audio sources we do not want to change
			// *************************************************************
			LcKeepNum = 0;
			while( LcKeepMask )
			{
				if( LcKeepMask & 0x01 )
				{
					DWORD LcTestMask = (1 << LcKeepNum);

					// the audio that is depending, but not wished to be changed,
					// is it already reserved and has a different source ?
					//
					if(m_AudioInMask_Reserving_Src & LcTestMask)
					{
						if(m_PIO->PIOGetOneAudioSource( LcKeepNum ) != PmSourceType)
						{
							DOUT( DBG_ERROR,("IResource_Source COMPAT: chang'g mask %lx implies changing %lx FAIL !\n", PmAudioMask, LcTestMask ));
							return ED_SET_PIPE_SOURCE_REFUSED;
						}
					}
				}
				LcKeepNum ++;
				LcKeepMask >>= 1;
			}

			// *************************************************************
			// apply it to the card
			// *************************************************************
			if ( m_PIO->PIOGetOneAudioSource(LcAudioNum) != PmSourceType )
			{
				LcTempRet = m_PIO->PIOSetOneAudioSource( LcAudioNum, PmSourceType );
				if (LcTempRet == SUCCESS) {
					DOUT( DBG_SOURCE,("IResource_Source CHANGE audio %x to source %d\n",LcAudioNum,PmSourceType));
					LcTempRet = IClock_BoardModifyInputs( LcAudioNum );
				}
				if (LcTempRet != SUCCESS) {
					DOUT( DBG_ERROR,("IResource_Source CHANGE audio %x FAILED :%x\n",LcAudioNum,LcTempRet));
					return LcTempRet;
				}
			}

			// addref if success
			DWORD LcCurrentAudioMask = ( 1 << LcAudioNum);

			m_AudioInMask_Reserving_Src |= LcCurrentAudioMask;
			DOUT( DBG_SOURCE,("IResource_Source ADDREF : reserved %lx\n", m_AudioInMask_Reserving_Src));

			// SRC forced ?
			if( (PmUER_SRC != IN_NO_PROPERTIES) &&
				(PmSourceType != DATA_FROM_ANALOG) &&
				(PmSourceType != DATA_FROM_MICRO) )
			{
				m_AudioInMask_UER_SRC_Def |= LcCurrentAudioMask;	// reservation
			}
			else
				m_AudioInMask_UER_SRC_Def &= ~LcCurrentAudioMask;	// remove reservation

			// SRC status
			if( LcAutoUER_SRC == IN_PROPERTIES_UER_ASYNC )
			{
				m_PIO->PIOSetConfigSRC(LcAudioNum, SRC_in);

				m_AudioInMask_UER_SRC_Async |= LcDependencyMask;	// add the dependency to SRC ASYNC
			}
			else
			{
				ASSERT(LcAutoUER_SRC == IN_PROPERTIES_UER_SYNC);

				m_PIO->PIOSetConfigSRC(LcAudioNum, SRC_off);

				m_AudioInMask_UER_SRC_Async &= ~LcDependencyMask;	// remove the dependency from SRC ASYNC
			}
			// *************************************************************

			if( LcAutoUER_SRC != PmUER_SRC )
			{
				if(LcAutoUER_SRC == IN_PROPERTIES_UER_ASYNC)
				{
					DOUT( DBG_WARNING,("IResource_Source COMPAT : UER ASYNC assigned for mask %x\n", LcDependencyMask));

					if(LcRet != WD_SRC_ASSIGNED) LOAD_PCX_ERROR( LcRet, WD_SRC_ASSIGNED );
				}
				else
				{
					DOUT( DBG_WARNING,("IResource_Source COMPAT : UER SYNC assigned for mask %x\n", LcDependencyMask));
				}
			}
		}
		LcAudioNum ++;
		LcAudioMask >>= 1;
    } // while

	// defect 4043 : digital record problem with VX822
	//
	if( LcResyncFull )
	{
		IClock_BoardModifyClock(	TRUE,               // Synchronize the FIFO
									LcComputeFreq );    // Compute the frequency
	}

#endif // SIMLXES


    return LcRet;

} //IResource_Source_Change_Audios



/*
 * When the clock changes, check all the audio sources
 * e.g. if we came from internal clock to external clock, set analog
 * audio source if there is no SRC available !
 */
WORD    CProtocol::IResource_Source_Check_Audios_New_Clock(	IN WORD PmClockType,
																IN DWORD PmSyncInputNum,
																IN DWORD PmFrequency,
																IN DWORDLONG PmAudioMask,
																IN BYTE PmUER_SRC)
{
   /*
    CHECK AUDIO SOURCE COMPATIBILITY WITH NEW CLOCK
   */
	WORD  LcAudioNum;
	DWORD LcAudioMask;

	DWORD LcAudioSwitchToAnalogMask = 0;
	DWORD LcAudioNeedSrcAsyncMask = 0;

	WORD  LcRet = SUCCESS;

#ifndef SIMLXES

    DOUT( DBG_SOURCE,("IResource_Source NEW CLOCK : check AudioMask %x\n", PmAudioMask));

	LcAudioNum = 0;
	LcAudioMask = 0x00000001;

	while( LcAudioNum < m_pDSPInfo->dsManagedPhysicalInputNumber)	// test all phys in audios
	{
		// Audio specified by SetClock ? YES : use PmUER_SRC; NO : use IN_NO_PROPERTIES
		//
		BYTE LcUER_SRC = (PmAudioMask & LcAudioMask) ? PmUER_SRC : IN_NO_PROPERTIES;
		BYTE LcAutoUER_SRC = LcUER_SRC;

		// *************************************************************
		// check the audio source if it's compatible with clock and SRC
		// and choose automatically SRC usage if not specified
		// *************************************************************
		BYTE LcSourceType = m_PIO->PIOGetOneAudioSource( LcAudioNum );

		WORD LcTempRet = IResource_Source_TestClock_Audio(	LcAudioNum,
															LcSourceType,
															PmClockType,
															PmSyncInputNum,
															PmFrequency,
															&LcAutoUER_SRC );
		if( LcTempRet != SUCCESS )
		{
			// Compatibility NP :
			// if we come from external clock to internal and IN_PROPERTIES_UER_ASYNC is not
			// specified, simply switch in audios to analog (if possible) !
			//
			if( (LcUER_SRC != IN_PROPERTIES_UER_ASYNC) &&
				((PmClockType == CLOCK_TYPE_INTERNAL) || (PmClockType == CLOCK_TYPE_PROGRAMMABLE_CLOCK)) &&
				(m_PIO->PIOGetActualClkSource() != CLOCK_TYPE_INTERNAL) &&
				(m_PIO->PIOGetActualClkSource() != CLOCK_TYPE_PROGRAMMABLE_CLOCK) &&
				(m_PIO->PIOGetDescAudioIn(LcAudioNum / 2) & AUDIO_LEVEL_MSK))
			{
				// will switch all audios to analog input !
				//
				LcAudioSwitchToAnalogMask |= LcAudioMask;
				LcAutoUER_SRC = IN_PROPERTIES_UER_SYNC;
				DOUT( DBG_WARNING,("IResource_Source NEW CLOCK : compat : set in audios to ANALOG %x\n", LcAudioSwitchToAnalogMask));
			}
			else
			{
				DOUT( DBG_ERROR,("IResource_Source NEW CLOCK : Audio Source %x NOT compatible %x\n", LcSourceType, LcTempRet));
				return LcTempRet;
			}
		}

		if( LcAutoUER_SRC == IN_PROPERTIES_UER_ASYNC )
		{
			LcAudioNeedSrcAsyncMask |= LcAudioMask;

			if( (LcUER_SRC == IN_NO_PROPERTIES) && (LcRet != WD_SRC_ASSIGNED) )
				LOAD_PCX_ERROR( LcRet, WD_SRC_ASSIGNED );
		}

		LcAudioNum ++;
		LcAudioMask <<= 1;
	}

	/*
    SET SRC SYNC/ASYNC AND AUDIO SOURCE TO ANALOG IF NECESSARY
	*/

	LcAudioNum = 0;
	LcAudioMask = 0x00000001;

	while( LcAudioNum < m_pDSPInfo->dsManagedPhysicalInputNumber)	// check all phys in audios
	{
		// dependency mask for this audio (should be a stereo mask like 0x03,0x0C,0x30,..)
		DWORD LcDependencyMask = m_PIO->PIOGetSourceAudioDependency( LcAudioNum );

		BYTE LcSourceType = m_PIO->PIOGetOneAudioSource(LcAudioNum);

		if( LcAudioMask & LcAudioSwitchToAnalogMask )
		{
            if( LcSourceType != DATA_FROM_ANALOG )
            {
                WORD LcTempRet = m_PIO->PIOSetOneAudioSource( LcAudioNum, DATA_FROM_ANALOG);
                if ( LcTempRet != SUCCESS ) EXIT_PCX_ERROR( LcTempRet );
            }
		}
		if( LcAudioMask & LcAudioNeedSrcAsyncMask )
		{
			m_PIO->PIOSetConfigSRC(LcAudioNum, SRC_in);

			DOUT( DBG_SOURCE,("IResource_Source NEW CLOCK : set SRC ASYNC for audio %d\n", LcAudioNum));

			m_AudioInMask_UER_SRC_Async |= LcDependencyMask;
		}
		else
		{
			// MBR (2005/04/07) Defect #4067 : Pb SRC avec pipe en mono
			if(LcSourceType != DATA_FROM_NO_INPUT)
			{
				m_PIO->PIOSetConfigSRC(LcAudioNum, SRC_off);

				DOUT( DBG_SOURCE,("IResource_Source NEW CLOCK : set SRC SYNC for audio %d\n", LcAudioNum));
			}

			m_AudioInMask_UER_SRC_Async &= ~LcDependencyMask;	// remove the dependency from SRC ASYNC
		}

		LcAudioNum ++;
		LcAudioMask <<= 1;
	}

	if( PmUER_SRC == IN_NO_PROPERTIES )
	{
		// cancel all old SRC reservations of the card !
		//
		m_AudioInMask_UER_SRC_Def = 0;
	}
	else
	{
		m_AudioInMask_UER_SRC_Def = PmAudioMask;
	}

#endif // SIMLXES


	return LcRet;
} // IResource_Source_Check_Audios_New_Clock


//**************************************************************************
//
// CProtocol::IDiag_StreamGetInfo( ... )
//
//Input Parameters:
//*****************
//
//    WORD   PmAdr           : address of the record in the TbStreamOut or
//                             TbStreamIn array.
//
//Output Paramaters:
//******************
//
//    PBYTE  *PmPPStreamInfo : PmAdr
//    PWORD  PmPSize         : size of the record.
//
//Return value:
//*************
//
//  an error code.
//
//**************************************************************************
//
// Function used to dump the TbStreamOut/TbStreamIn arrays.
// This function is called by the DriverDebugFct function.
//
//**************************************************************************
WORD CProtocol:: IDiag_StreamGetInfo(
    IN  DWORD   PmAdr,
    OUT PBYTE   *PmPPStreamInfo,
    OUT PWORD   PmPSize )
{
    WORD i;

	DOUT (DBG_PROT_DIAG, ("CProtocol::IDiag_StreamGetInfo() \n"));

    for ( i = 0 ; i < MAX_OUTSTREAM ; i++ )
    {
        if ( (ULONG_PTR)( m_Out_Stream_Info_Array + i ) == PmAdr )
        {
            *PmPPStreamInfo = (PBYTE) ( m_Out_Stream_Info_Array + i );
            *PmPSize        = sizeof( STREAM_INFO );
            return( SUCCESS );
        }
    }

    for ( i = 0 ; i < MAX_INSTREAM ; i++ )
    {
        if ( (ULONG_PTR)( m_In_Stream_Info_Array + i ) == PmAdr )
        {
            *PmPPStreamInfo = (PBYTE) ( m_In_Stream_Info_Array + i );
            *PmPSize        = sizeof( STREAM_INFO );
            return( SUCCESS );
        }
    }

	DOUT (DBG_ERROR, ("CProtocol::IDiag_StreamGetInfo() :ED_INVALID_ADDRESS \n"));

    return ED_INVALID_ADDRESS;
}	// GetStreamInfo


//**************************************************************************
//
// IDiag_AudioCheckAvailability( ... )
//
//Input Parameters:
//*****************
//	IN  BYTE        PmAudioNum :	zero based audio number
//	IN  WORD        PmAudioAttrib : AUDIO_IN or AUDIO_OUT in combination with 
//                                  AUDIO_PHYSICAL or AUDIO_VIRTUAL
//Return value:
//*************
//
//  SUCCESS if audio is available, or an error code.
//
//**************************************************************************
WORD CProtocol::IDiag_AudioCheckAvailability( IN  BYTE    PmAudioNum,     // numero d'audio sur la carte
											  IN  WORD    PmAudioAttrib)  // in ou out
{
	WORD LcManagedAudio;
	DWORDLONG LcFreeAudio;

	DOUT (DBG_PROT_DIAG, ("CProtocol::IDiag_CheckAudioAvailability()\n"));

	// The dsp must be loaded and running
	// -----------------------------------
	if ( m_pDSPInfo->dsEtat == 0 ) EXIT_PCX_ERROR( ED_INVALID_DSP_SOFTWARE );

	if (   ( m_pDSPInfo->dsEtat < DSP_FIRST_SOFT )
		|| ( m_pDSPInfo->dsEtat > DSP_LAST_SOFT ) )
	{
		EXIT_PCX_ERROR( ED_DSP_CRASHED );
	}

	// Select the right table to scan for the audio
	// --------------------------------------------
	if ( PmAudioAttrib & AUDIO_PHYSICAL )
	{
		if(PmAudioAttrib & AUDIO_IN)
		{
		    LcManagedAudio = m_pDSPInfo->dsManagedPhysicalInputNumber ;
		    LcFreeAudio    = m_pDSPInfo->dsMaskVPIn ;
	    }
	    else    // AUDIO_OUT
	    {
		    LcManagedAudio = m_pDSPInfo->dsManagedPhysicalOutputNumber ;
		    LcFreeAudio    = m_pDSPInfo->dsMaskVPOut ;
	    }

		if (PmAudioNum >= LcManagedAudio )	EXIT_PCX_ERROR( ED_ALLOCATE_AUDIO_IMPOSSIBLE );
    }
    else    // AUDIO_VIRTUAL
    {
	    if ( PmAudioAttrib & AUDIO_IN )
	    {
		    LcManagedAudio = m_pDSPInfo->dsManagedVirtualInputNumber ;
		    LcFreeAudio    = m_pDSPInfo->dsMaskVVIn ;
	    }
	    else    // AUDIO_OUT
	    {
		    LcManagedAudio = m_pDSPInfo->dsManagedVirtualOutputNumber ;
		    LcFreeAudio    = m_pDSPInfo->dsMaskVVOut ;
	    }

        // Check whether the audio exists
		// ------------------------------
		if ( PmAudioNum >= LcManagedAudio )	EXIT_PCX_ERROR( ED_INVALID_BOARD_AUDIO );
    }

	// Check whether the audio is allocated
	// ------------------------------------
	if ( LcFreeAudio & UTIMask64bit( PmAudioNum ) )
	{
		// This audio is available
		// -----------------------
		return SUCCESS;
	}

	EXIT_PCX_ERROR( ED_ALLOCATE_AUDIO_IMPOSSIBLE );
	
}	// IDiag_CheckAudioAvailability

//////////////////////////////////////////////////////////////////////
// End of DIAG and INIT
//////////////////////////////////////////////////////////////////////


//**************************************************************************
//
// WORD IBuffer_TransferSoundPipe( IN PTARGET_INFO, IN BOOLEAN, IN WORD )
//
// Input Parameters:
// *****************
//
//      PTARGET_INFO PmTarget   : Pointer to a target which describes a pipe
//                                - tgCarte, tgDsp, TgPipe, tgVioHandlePipe
//      BOOLEAN PmEndOfCondition: TRUE if a end of play or end of record for
//                                the pipe has been received.
//      WORD    PmNbStreams     : Number of streams of the pipe
//
// Return value:
// *************
//
// 0 if no error, error otherwise
//
//**************************************************************************
//
// Transfer the sound for all the streams of a pipe. If the pipe is in
// play, manages the pause bit and the end of play., In record, manage the
// end of record.
//
//**************************************************************************
WORD CProtocol::IBuffer_TransferSoundPipe(
    IN  PTARGET_INFO    PmPtrTgPipe,
    IN  BOOLEAN         PmEndOfCondition,
    IN  WORD            PmNbStreams)
{
    WORD    LcRet;

    // Dispatch the transfer request
    // on appropriate play/record handling functions
    // ---------------------------------------------
    if ( PmPtrTgPipe->tgCaracPipeVoie == OPER_PLAY )
    {
            LcRet = vio_SoundTransferPlayNP(PmPtrTgPipe,PmEndOfCondition,PmNbStreams);
    }
    else
    {
            LcRet = vio_SoundTransferRecordNP(PmPtrTgPipe,PmEndOfCondition,PmNbStreams);
    }

    return( LcRet );
}


//**************************************************************************
//
// WORD IBuffer_GiveStreamBuffer()
//
//Input Parameters:
//*****************
//
//  PTARGET_INFO PmTgPipe:    Identify the target stream
//  LPBC_HEADER_INFO PmPtBuffer : Points to the request bloc of the souncd buffer
//  WORD PmNbStreams : Total number of streams of this pipe
//
//Output Paramaters:
//******************
//
//Return value:
//*************
//
// 0 if no error, error otherwise
//
//**************************************************************************
//
// Adds a sound buffer for a stream. If, for this stream, no sound is waiting,
// tries to send it to the board.
//
// We suppose that this stream was declared.
//
//**************************************************************************
WORD CProtocol::IBuffer_GiveStreamBuffer(
    PTARGET_INFO        PmTarget,
    LPBC_HEADER_INFO    PmPtBuffer,
    WORD                PmNbStreams )
{
    PSTREAM_INFO        LcPtStream;
    LPBC_HEADER_INFO    LcPtBuffer;
    DWORD               LcStreamMask;

    // Update the remaining length for a out stream
    // ********************************************
    if ( PmTarget->tgCaracPipeVoie == OPER_PLAY )
    {
        ((LPPLAY_REQ_INFO)PmPtBuffer)->plqForDriver.dprCurrentLength =
                                ((LPPLAY_REQ_INFO)PmPtBuffer)->plqDataLength;
    }
    else
    {
        // ## FS (30/10/1997) - A specified record buffer size must
        // correspond to a buffer of 32-bit words.
        //
        ((LPRECORD_REQ_INFO)PmPtBuffer)->rcqForDriver.dprCurrentLength = 0 ;
    }

    // Test if the given buffer is not empty
    // *************************************
    if ( ((LPPLAY_REQ_INFO)PmPtBuffer)->plqDataLength == 0L )
        EXIT_PCX_ERROR( ED_INVALID_BUFFER );

    // Test buffer-overflow done in API:
    //DWORD LcBuffSize;
    //BUFGetFeatures( NULL, NULL, &LcBuffSize );
    //if ( ((LPPLAY_REQ_INFO)PmPtBuffer)->plqDataLength > LcBuffSize )
    //    EXIT_PCX_ERROR( ED_INVALID_BUFFER );

    // Calculate the Stream pointer
    // ****************************
    LcPtStream = (PSTREAM_INFO) PmTarget->tgVioHandle;
    LcStreamMask = PmTarget->tgMaskFlux >> 1;
    while (LcStreamMask)
    {
        LcPtStream = LcPtStream->siAdrNextStream;
        LcStreamMask >>= 1;
    }

    // The buffer given in parameter must point to NULL
    // ************************************************
    ((LPPLAY_REQ_INFO)PmPtBuffer)->plqForDriver.dprAdrNextBlk = NULL;

    // If there is no buffer for this stream
    // *************************************
    if ( LcPtStream->siAdrBuffer == NULL )
    {
        WORD    LcErrorCode ;

        //debp(1,"Buffer started\n");

        LcPtStream->siAdrBuffer = PmPtBuffer;

        LcPtStream->siAdrNextBufferToGive = (LPBC_HEADER_INFO)PmPtBuffer;

        // ## FM (07/10/97) -- If this fails, we must unchain the buffer
        //
        if ( (LcErrorCode = IBuffer_TransferSoundPipe(PmTarget, (BOOLEAN) FALSE,PmNbStreams)) != SUCCESS )
        {
            LcPtStream->siAdrBuffer = (LPBC_HEADER_INFO) NULL ;
            LcPtStream->siAdrNextBufferToGive = (LPBC_HEADER_INFO) NULL ;
        }

        return(LcErrorCode) ;
    }
    // Else
    // ****
    else
    {
        //debp(1,"Buffer queued\n");

        // Chain the received buffer
        // -------------------------
        LcPtBuffer = LcPtStream->siAdrBuffer;

        while (((LPPLAY_REQ_INFO)LcPtBuffer)->plqForDriver.dprAdrNextBlk != NULL)
        {
            LcPtBuffer = ((LPPLAY_REQ_INFO)LcPtBuffer)->plqForDriver.dprAdrNextBlk;
        }

        ((LPPLAY_REQ_INFO) LcPtBuffer)->plqForDriver.dprAdrNextBlk = PmPtBuffer;

        if(  LcPtStream->siAdrNextBufferToGive == NULL )
        {
            WORD    LcErrorCode ;

            LcPtStream->siAdrNextBufferToGive = (LPBC_HEADER_INFO)PmPtBuffer;

            // ## FM (07/10/97) -- If this fails, we must unchain the buffer
            //
            if ( (LcErrorCode = IBuffer_TransferSoundPipe( PmTarget,
                                                      (BOOLEAN) FALSE,
                                                      PmNbStreams) ) != SUCCESS )
            {
                ((LPPLAY_REQ_INFO) LcPtBuffer)->plqForDriver.dprAdrNextBlk =
                                                         (LPBC_HEADER_INFO) NULL ;
                LcPtStream->siAdrNextBufferToGive = (LPBC_HEADER_INFO) NULL ;
            }
            return(LcErrorCode) ;
        }

        // ## FS (03/03/1997) -- Send the record buffer in case the previous one
        //                       was almost empty and waiting for another one
        //
        if ( PmTarget->tgCaracPipeVoie == OPER_REC )
        {
            WORD    LcErrorCode ;

            // ## FM (07/10/97) -- If this fails, we must unchain the buffer
            //
            if ( (LcErrorCode = IBuffer_TransferSoundPipe(PmTarget,
                                    (BOOLEAN) FALSE,PmNbStreams)) != SUCCESS )
            {
                ((LPPLAY_REQ_INFO) LcPtBuffer)->plqForDriver.dprAdrNextBlk =
                                                         (LPBC_HEADER_INFO) NULL ;
            }

            return(LcErrorCode) ;
        }
    }
    // Endif
    // *****

    return SUCCESS;
}	// IBuffer_GiveStreamBuffer


//**************************************************************************
//
// WORD CProtocol::IBuffer_CutBuffersQueued()
//
// Input Parameters:
// *****************
//
//  PTARGET_INFO PmTgPipe:    Identify the target stream
//  WORD    PmFirstBuffer:    The Number of the buffer where to cut the queue
//
//**************************************************************************
//
// Removes sound buffers for a stream.
//
//**************************************************************************
//
WORD    CProtocol::IBuffer_CutBuffersQueued(
    IN  PTARGET_INFO        PmPtrTgPipe  ,
    IN  DWORD               PmFirstBuffer,
   OUT  PDWORD              PmNbBuffers )
{
    PSTREAM_INFO            LcPtStream;
    LPPLAY_REQ_INFO         LcPtBuffer;
    LPPLAY_REQ_INFO         LcPtPrevBuffer;
    LPPLAY_REQ_INFO         LcPtNextBuffer;
    DWORD                   LcStreamMask;
    BOOLEAN                 LcIsAfterLastSent;

    // No buffers cancelled yet
    //
    *PmNbBuffers = 0;

    // Warning, we only cut buffers if there are still in the queue
    // not sent yet to the DSP
    // -------------------------------------------------------

    // Calculate the Stream pointer
    // ****************************
    LcPtStream = (PSTREAM_INFO) PmPtrTgPipe->tgVioHandle;
    LcStreamMask = PmPtrTgPipe->tgMaskFlux >> 1;

    while (LcStreamMask)
    {
        LcPtStream = LcPtStream->siAdrNextStream;
        LcStreamMask >>= 1;
    }

    // Retrieve the 1st buffer in the stream buffer list
    // ----------------------------------------------
    LcPtBuffer = (LPPLAY_REQ_INFO)LcPtStream->siAdrBuffer;

    // Just in case...
    if ( LcPtBuffer == NULL)
    {
        EXIT_PCX_ERROR( WD_CANNOT_CANCEL );
    }

    // Walk along the STREAM_INFO chain till
    // the requested buffer is found
    // Note tht on PCXnp boards, we must pay attention
    // whether the first buffer not sent yet to the DSP
    // is met or not along the chain, since we cannot
    // cancel it if the DSP gets it.
    // For non-PCXnp boards, this test will be done
    // afterwards, according to the data length within the buffer
    // -------------------------------------------------------
    LcIsAfterLastSent = FALSE ;
    LcPtPrevBuffer = NULL ;
    while ( (LcPtBuffer->plqForDriver).dprAdrNextBlk != NULL )
    {
        // On PCXnp boards, first non sent buffer is the one pointed by
        // siAdrNextBufferToGive
        // -------------------------------------------------------------
        if (  LcPtStream->siAdrNextBufferToGive
            && (LcPtBuffer == (LPPLAY_REQ_INFO)LcPtStream->siAdrNextBufferToGive) )
        {
            LcIsAfterLastSent = TRUE ;
        }

        // Stop there if it matchs
        //
        if (LcPtBuffer->plqBuffNum == PmFirstBuffer)
            break;

        // Otherwise, next buffer
        //
        LcPtPrevBuffer = LcPtBuffer ;
        LcPtBuffer = (LPPLAY_REQ_INFO) (LcPtBuffer->plqForDriver).dprAdrNextBlk;
    }

    // If found after the last buffer
    //
    if (  (LcPtBuffer->plqBuffNum == PmFirstBuffer)
       && (LcIsAfterLastSent != FALSE) )
    {
        // Remove the buffer
        // -----------------
        if ( LcPtBuffer == (LPPLAY_REQ_INFO)LcPtStream->siAdrNextBufferToGive )
        {
            LcPtStream->siAdrNextBufferToGive = NULL ;
        }

        if ( LcPtPrevBuffer )
        {
            (LcPtPrevBuffer->plqForDriver).dprAdrNextBlk = NULL ;
            *PmNbBuffers = 1 ;

            LcPtNextBuffer = (LPPLAY_REQ_INFO)(LcPtBuffer->plqForDriver).dprAdrNextBlk ;

            // Let's count the number of buffers cancelled
            // -------------------------------------------
            while ( LcPtNextBuffer != NULL )
            {
                LPPLAY_REQ_INFO    LcPtNextNextBuffer;

                (*PmNbBuffers)++ ;

                // Get pointer to next buffer before releasing
                //
                LcPtNextNextBuffer = (LPPLAY_REQ_INFO)(LcPtNextBuffer->plqForDriver).dprAdrNextBlk ;

                // Release the buffer back to the application
                //
                // MBR(26/11/2002) no more APHFreeBuffer( LcPtNextBuffer );
                vio_FreeBuffer( OPER_PLAY,
                                LcPtStream,
                                (LPBC_HEADER_INFO)LcPtNextBuffer );

                // Switch to next
                //
                LcPtNextBuffer = LcPtNextNextBuffer;
            }
        }
        else
        {
            LcPtStream->siAdrBuffer = NULL ;
            *PmNbBuffers = 1 ;
        }

        // Release the buffer back to the application
        //
        // MBR(26/11/2002) no more APHFreeBuffer( LcPtBuffer );
        vio_FreeBuffer( OPER_PLAY,
                        LcPtStream,
                        (LPBC_HEADER_INFO)LcPtBuffer );

        // Let's complete successfully
        //
        return SUCCESS;
    }

    // If all other cases, let's complete with a warning
    //
    EXIT_PCX_ERROR( WD_CANNOT_CANCEL );
} // CProtocol::IBuffer_CutBufferQueued


//**************************************************************************
//
// WORD CProtocol::IBuffer_BypassPauseAtBufferEnd()
//
// Input Parameters:
// *****************
//
//  PTARGET_INFO PmTgPipe:    Identify the target stream
//  WORD    PmFirstBuffer:    Number of the buffer where to cut the queue
//
//**************************************************************************
//
// Removes sound buffers for a stream.
//
//**************************************************************************
//
WORD    CProtocol::IBuffer_BypassPauseAtBufferEnd(
    IN  PTARGET_INFO        PmPtrTgPipe  ,
    IN  DWORD               PmBufferNum )
{
    PSTREAM_INFO            LcPtStream;
    LPPLAY_REQ_INFO         LcPtBuffer;
    LPPLAY_REQ_INFO         LcPtPrevBuffer;
    DWORD                   LcStreamMask;
    BOOLEAN                 LcIsAfterLastSent;

    // Warning, we only cut buffers if there are still in the queue
    // not sent yet to the DSP
    // -------------------------------------------------------

    // Calculate the Stream pointer
    // ****************************
    LcPtStream = (PSTREAM_INFO) PmPtrTgPipe->tgVioHandle;
    LcStreamMask = PmPtrTgPipe->tgMaskFlux >> 1;

    while (LcStreamMask)
    {
        LcPtStream = LcPtStream->siAdrNextStream;
        LcStreamMask >>= 1;
    }

    // Retrieve the 1st buffer in the stream buffer list
    // ----------------------------------------------
    LcPtBuffer = (LPPLAY_REQ_INFO)LcPtStream->siAdrBuffer;

    // Just in case...
    if ( LcPtBuffer == NULL)
    {
        EXIT_PCX_ERROR( WD_CANNOT_CANCEL );
    }

    // Walk along the STREAM_INFO chain till
    // the requested buffer is found
    // Note that on PCXnp boards, we must pay attention
    // whether the first buffer not sent yet to the DSP
    // is met or not along the chain, since we cannot
    // cancel it if the DSP gets it.
    // For non-PCXnp boards, this test will be done
    // afterwards, according to the data length within the buffer
    // -------------------------------------------------------
    LcIsAfterLastSent = FALSE ;
    LcPtPrevBuffer = NULL ;
    while ( (LcPtBuffer->plqForDriver).dprAdrNextBlk != NULL )
    {
        // On PCXnp boards, first non sent buffer is the one pointed by
        // siAdrNextBufferToGive
        // -------------------------------------------------------------
        if (  LcPtStream->siAdrNextBufferToGive
            && (LcPtBuffer == (LPPLAY_REQ_INFO)LcPtStream->siAdrNextBufferToGive) )
        {
            LcIsAfterLastSent = TRUE ;
        }

        // Stop there if it matchs
        //
        if (LcPtBuffer->plqBuffNum == PmBufferNum)
            break;

        // Otherwise, next buffer
        //
        LcPtPrevBuffer = LcPtBuffer ;
        LcPtBuffer = (LPPLAY_REQ_INFO) (LcPtBuffer->plqForDriver).dprAdrNextBlk;
    }

    // If found after the last buffer
    //
    if (LcPtBuffer->plqBuffNum == PmBufferNum)
    {
            // For PCXnp boards cancel only if the buffer has not been
            // sent yet to the DSP
            //
            if (LcIsAfterLastSent != FALSE)
            {
                // For non-PCXnp boards cancel if the buffer has not been
                // sent yet to the DSP of it has been sent only partially
                // i.e. the pause request has not been sent yet
                //

                // Clear the pause request at end of buffer
                // ----------------------------------------
                LcPtBuffer->plqPause = 0;

                // Let's complete successfully
                //
                return SUCCESS;
            }
            else
            {
                // cancel pause not implemented on firmware

                EXIT_PCX_ERROR( WD_CANNOT_CANCEL );
            }
    }

    // If all other cases, let's issue a warning
    //
    EXIT_PCX_ERROR( WD_CANNOT_CANCEL );
}


//**************************************************************************
//
//  VOID vio_FreeBuffer( LPPLAY_REQ_INFO )
//
// Input Parameters:
// *****************
//
//  LPPLAY_REQ_INFO    PmPtReq   :    Play/Record Request
//
//**************************************************************************
//
// Purge any waiting buffers
//
//**************************************************************************
VOID    CProtocol::vio_FreeBuffer(
        IN  BYTE                PmCaracPipeVoie,
        IN  PSTREAM_INFO        PmStreamPtr,
        IN  LPBC_HEADER_INFO    PmReqPtr  )
{
    LPRESP_HEADER_INFO LcRepHeader;
    LPPLAY_RECORD_DRIVER_INFO LcpPRDInfo;
    PDWORD LcIrp;

    // Is this a DirectSound Buffer ??
    if ( PmStreamPtr && (PmStreamPtr->siAPINP == FALSE) )
    {
        DOUT (DBG_ERROR, ("ERROR vio_FreeBuffer() for NON-APINP\n"));
        return;
    }

    if ( PmCaracPipeVoie == OPER_REC ) 
	{
		//RECORD
		
		LPRECORD_REQ_INFO LcBuffer = (LPRECORD_REQ_INFO) PmReqPtr ;
        LcpPRDInfo = &LcBuffer->rcqForDriver;

		LcIrp = (PDWORD) LcpPRDInfo->dprParent ;   
		LcRepHeader = (LPRESP_HEADER_INFO) LcpPRDInfo->dprAdrBlkResp ;

		LcpPRDInfo->dprAdrNextBlk = NULL ;

        // Fill in the actual data length of the buffer in the reply bloc
		((LPRECORD_RESP_INFO)(LcRepHeader))->rrpDataLength = LcpPRDInfo->dprCurrentLength ;

        DOUT (DBG_PROT_VIO, ("*** vio_FreeBuffer() REC address(%x)\n", LcpPRDInfo->dprPhysicalAddress));
    } 
	else 
	{
		//PLAY

		LPPLAY_REQ_INFO LcBuffer = (LPPLAY_REQ_INFO) PmReqPtr ;
        LcpPRDInfo = &LcBuffer->plqForDriver;

		LcIrp = (PDWORD) LcpPRDInfo->dprParent ;
		LcRepHeader = (LPRESP_HEADER_INFO) LcpPRDInfo->dprAdrBlkResp;

		LcpPRDInfo->dprAdrNextBlk = NULL ;

        LcpPRDInfo->dprCurrentLength = 0 ;
		LcpPRDInfo->dprParent =  NULL ;
		//LcBuffer->Header.hdFamily = (BYTE) 0 ;
		//LcBuffer->Header.hdComNum = (BYTE) 0 ;

        DOUT (DBG_PROT_VIO, ("*** vio_FreeBuffer() PLAY address(%x)\n", LcpPRDInfo->dprPhysicalAddress));
    }

	// Free the buffer, by releasing its reply bloc
	LcRepHeader->rhT = PROCESSED ;
#ifndef SIMLXES
#ifndef DRIVER_MACOSX 

    if( LcRepHeader->rhCptr != ED_CANCELLED )
    {
        if ( LcIrp != NULL )
        {
            WNTSetEvent( LcIrp, STATUS_SUCCESS );
        }
    }
#endif
    if ( PmStreamPtr ) InterlockedIncrement(&PmStreamPtr->siReleasedBuffers);
#endif		

}
