//**************************************************************************
//
//  COPYRIGHT (C) 2006 DIGIGRAM. ALL RIGHTS RESERVED.
//
//***************************************************************************


/** @file	LXPROTOCOL.H
*	@brief	definitions for lxprotocolclass and Driver/Card interface
*/
//  Project:                :   LXES
//
//***************************************************************************
#ifndef _LXPROTOCOL_H
#define _LXPROTOCOL_H

#include	"xx_protocol.h"
#include	"if_drv_mb.h"
#include	"ethersound.h"


/// LX Protocol Implementation Class.
/**
*	@class CLXProtocol 
*/
class CLXProtocol: public	CProtocol
{

	static	DSP_CMD_INFO	m_DspCommands[];

	static 	DWORD	m_Peak2Sample[];

	WORD	m_K	;				/**< number of XES interrupts for which a PCI IRQ is relayed (when this feature is used).*/

	DWORDLONG	m_Pipe_In_StartedMask;
	DWORDLONG	m_Pipe_Out_StartedMask;

    DWORDLONG	m_Pipe_In_WaitToggleMask;
	DWORDLONG	m_Pipe_Out_WaitToggleMask;

	DWORDLONG	m_Stream_Out_MutedMask;
	DWORDLONG	m_Stream_In_MutedMask;

	public:
	/**
	*	Constructor, 
	*	one and only one protocol object must be instancied for each board.
	*	@param 	PmpDspInfo	(for compatibility with VX32)
	*	@param  pPIO		(Board type abstraction and Bus accesses, typically instancied by adapter object)
	*	@see	VXWDM project : CAdapterCommon::InitDsp()
	*/
	CLXProtocol( PDSP_INFO PmpDspInfo, CPIOCommands* PmpPIO);

    /**
	*	Destructor 
	*	@see	VXWDM project : ~CAdapterCommon()
	*/
	virtual ~CLXProtocol() {};

    // IIIIIIIII    Interface RESOURCE MANAGER     IIIIIIIIIIIIII//

/**
 * \defgroup Methodes for Pipe resource reservation 
 */
/*@{*/
	//WORD   IResource_Source_XXX....
/*@}*/

    // IIIIIIIII    Interface INIT et DIAG      IIIIIIIIIIIIII//

/**
 * \defgroup Init_and_Diag Initialisation and Diagnostic Interface
 */
/*@{*/

	WORD	IDiag_DspSetTimerInterrupt( IN WORD PmSamples);
	
	WORD	IDiag_HaltEmbedded();

	WORD    IInit_GetVersionAndFeatures( BYTE PmSoftNum, PGENERAL_INFO PmGenInfo, PDWORD PmDspVersion );

	WORD	IDiag_HandleBoardIBL(	INOUT LPIBL_RESP_INFO	PmPtrIBLRep);

/*@{*/


    // IIIIIIIII    Interface CLOCK      IIIIIIIIIIIIII//

/**
 * \defgroup Clock and Synchro Signal Settings Interface
 */
/*@{*/
	/**
	*	CLOCK Interface : Read the current UER clock 
	*	@see	TraitHardItBoard
	*	@return SUCCESS or error code.
	*/
	WORD	IClock_BoardGetClockFrequency(	OUT PDWORD          PmFrequencyPtr,
											OUT PBOOLEAN        PmPFirstChange,
											OUT PDWORD			PmPRawData	 = NULL );


/*@{*/

	// IIIIIIIII    Interface LEVELS & Meters      IIIIIIIIIIIIII//
	
/**
 * \defgroup Levels Levels and Meters Management Interface
 */
/*@{*/
	
	WORD	ILevel_AudioSetDigitalLevel(	IN PTARGET_INFO        PmPtrTgPipe,
											IN DWORDLONG           PmAudioMask,
											IN PLEVEL_AUDIO_INFO   PmPtrLevelInf );  		
	/**
	*	LEVEL Interface :	Get Peak Meters
	*
	*	@param	 PmIsInput	    
	*	@param	 PmAudioID	the number of the audio (0 to 63 on LX6464ES)
	*	@param	 PmPtrVuPicMeterInf pointer to the Array of meter infos
	*
	*	@see API : GetAudioVuMeterSubFct
	*	@return SUCCESS or error code.
	*/  
	WORD	ILevel_AudioGetVuPicMeter(	IN BOOLEAN				PmIsInput,
										IN DWORDLONG            PmAudioMask,
										IN WORD                 PmNbAudio,
										OUT PVU_PIC_METER_INFO  PmPtrVuPicMeterInf );

	/**
	*	LEVEL Interface :	Get Audio Levels
	*
	*	@param	 PmIsInput	
	*	@param	 PmAudioID	the number of the audio (0 to 63 on LX6464ES)
	*	@param	 PmPtrLevelInf  OUT	pointer to the array of Info Structures
	*
	*	@see API : GetOutAudioLevelsSubFct
	*	@return SUCCESS or error code.
	*/  
	WORD	ILevel_AudioGetLevels(	IN BOOLEAN      PmIsInput,
									IN DWORDLONG    PmAudioMask,
									IN WORD         PmNbAudio,
									OUT PLEVEL_AUDIO_INFO  PmPtrLevelInf );
/*@}*/

	
	// IIIIIIIII    Interface FLOW      IIIIIIIIIIIIII//

/**
 * \defgroup FLow Sound Transport Management Interface
 */
/*@{*/

	
	/**
	*	FLOW Interface :	Start the Pipe's unique stream
	*
	*	@param		PmPtrTgPipe		IN	tgPipe,tgCaracPipeVoie,tgVioHandle are relevant
	*	@return SUCCESS or error code.
	*	@warning On VX boards, starting/pause or stopping a stream while the pipe is running
	*	may cause the board to output noise. This won't lead to a malfunction, it is just noisy.
	*	This means that one should always care to follow this sequence : a) send buffers b) start stream
	*	c) start pipe.....[n) pause pipe/ n+1) start pipe]....z) stop pipe.
	*/
    WORD	IFlow_StreamStart( IN PTARGET_INFO PmPtrTgPipe );

    /**
	*	FLOW Interface :	Stop the Pipe's unique stream
	*	StopPipe should be used alone.
	*
	*	@param		PmPtrTgPipe		IN	tgPipe,tgCaracPipeVoie,tgVioHandle are relevant
	*	@return SUCCESS or error code.
	*	@warning On VX boards, starting/pause or stopping a stream while the pipe is running
	*	may cause the board to output noise. This won't lead to a malfunction, it is just noisy.
	*	This means that one should always care to follow this sequence : a) send buffers b) start stream
	*	c) start pipe.....[n) pause pipe/ n+1) start pipe]....z) stop pipe.
	*/  
    WORD	IFlow_StreamStop( IN PTARGET_INFO PmPtrTgPipe );

     /**
	*	FLOW Interface :	Pause the Pipe's unique stream
	*
	*	@param		PmPtrTgPipe		IN	tgPipe,tgCaracPipeVoie,tgVioHandle are relevant
	*	@return SUCCESS or error code.
	*	@warning On VX boards, starting/pause or stopping a stream while the pipe is running
	*	may cause the board to output noise. This won't lead to a malfunction, it is just noisy.
	*	This means that one should always care to follow this sequence : a) send buffers b) start stream
	*	c) start pipe.....[n) pause pipe/ n+1) start pipe]....z) stop pipe.
	*/  
    WORD IFlow_StreamPause( IN PTARGET_INFO PmPtrTgPipe, BOOLEAN PmDrain = FALSE );


	/**
	*	FLOW Interface :	Set the Output Stream playback Format
	*
	*	@return		SUCCESS or error code.
	*	@warning	No default format should be assumed. Must match DSP mixing capabilities
	*/  
    WORD  IFlow_StreamOutSetFormat(     IN PTARGET_INFO PmPtrTgPipe ,
                                        IN DWORD        PmFmtParams,
                                        IN DWORD        PmHeaderHiLo,
                                        IN DWORD        PmChannelMask,
										IN DWORD        PmSamplesPerChannel
                                        );
   
	/**
	*	FLOW Interface :	Set the actual Input Pipe recording Format
	*
	*	@return		SUCCESS or error code.
	*	@warning	No default format should be assumed.
	*/  
    WORD    IFlow_StreamInSetFormat(   IN PTARGET_INFO PmPtrTgPipe ,
                                       IN DWORD        PmFmtParams,
                                       IN DWORD        PmHeaderHiLo,
                                       IN DWORD        PmChannelMask,
									   IN DWORD        PmSamplesPerChannel);

	/**
	*	FLOW Interface :	Get the State of many Streams
	*	
	*	@param PmPtrTgPipe		IN	target pipe (board/dsp/pipe)
	*	@param PmNbStream		IN	Number of streams
	*	@param PmPtrStreamInf	OUT	States for each stream
	*	@return		SUCCESS or error code.
	*/ 
	WORD	IFlow_StreamGetState(	IN PTARGET_INFO         PmPtrTgPipe,
									IN WORD                 PmNbStream,
									OUT PSTATE_STREAM_INFO  PmPtrStreamInf );
		
    /**
	*	FLOW Interface :	Get Stream Sample Position
	*	@param PmPtrTgPipe		IN	target pipe (board/dsp/pipe)
	*	@param PmNbStream		IN	Number of streams
	*	@param PmPtrStreamInf	OUT	sample position being played for each stream
	*	@return		SUCCESS or error code.
	*/  
    WORD    IFlow_StreamSamplePosition(	IN  PTARGET_INFO    PmPtrTgPipe     ,
										IN  WORD            PmNbStream      ,
										OUT PPCX_TIME       PmPtrStreamInf  );

	/**
	*	FLOW Interface : Pipe Allocation Method
	*
	*	@param PmNbMaxFlux	IN	nb of streams the Caller wishes
	*	@param PmNbAudioIO	IN	nb of audios supported by the pipe (output is always stereo)
	*	@param PmManagement	IN	Management options : see PIPE_DECL_INFO, pcxall_e.h
	*	@param PmFrameInfo	IN	bitrate information (optional, may be left empty)
	*	@param PmIsAPINP	IN	the pipe is allocated in classic npAPI mode
	*	@param PmPtrTgPipe	IN	pipe description structure (see code for relevant fields)
	*	@param PmPHdlPipe	OUT	pointer to a vioHandle  (in fact STREAM_INFO) structure
	*	@param PmStreamFifoSizeArray	OUT	Size of stream FIFO, for each stream (slave boards)
	*	@param PmNbAllocatedStreams		OUT	number of streams availeble on this pipe
	*
	*	@return		SUCCESS or error code.
	*/     
	WORD	IFlow_PipeDef(		IN BYTE PmAttributes,
								IN WORD PmFirstAudio,
                                IN BYTE PmNbMaxFlux,
								IN WORD PmNbAudioIO,
								IN DWORD PmChannelMask,
								IN WORD PmManagement,
								IN PFRAME_INFO PmFrameInfo,
                                IN BOOLEAN PmIsAPINP,
								OUT PHANDLE_PIPE PmPHdlPipe,
								OUT PWORD PmNbAllocatedStreams );


	WORD	vio_TogglePipeState(IN BYTE         PmState,
								IN BYTE         PmCondition,
								IN BYTE         PmNbPipe,
								IN PTARGET_INFO PmPtrTgPipe,
								IN PTIME_CODE_START_INFO PmPTimeCodeStart);

    /**
	*	FLOW Interface :	Stop One Pipe
	*
	*	@param		PmPtrTgPipe		IN	tgPipe,tgCaracPipeVoie,tgVioHandle are relevant
	*	@return SUCCESS or error code.
	*	@warning While the API makes usage of this function, StopPipeFct is not meant for pipes
	*	belonging to different boards anymore (by opposition to the real np API), erratical behave may result.
	*/  
	WORD	IFlow_PipeStop( IN  PTARGET_INFO    PmPtrTgPipe);

	
	/**
	*	FLOW Interface : Get a Pipe's State.
	*	
	*	@param PmPtrTgPipe	IN	tgCaracPipeVoie and tgPipe are relevant
	*	@param PmState		OUT	1 if pipe is started, 0 if paused/stop
	*
	*	@return		SUCCESS or error code.
	*	@warning	don't poll too much on this,
	*	the StartPipe function already insures that a Pipe is started, if no "DSP BUSY" occured.
	*	@see		#vio_TogglePipeState .
	*/     
    WORD	IFlow_PipeState(	IN  PTARGET_INFO PmPtrTgPipe,
								OUT PBYTE        PmState );

	/**
	*	FLOW Interface : Remove 1 Pipe
	*
	*  @param PmPtrTgPipe	IN	Identies the target pipe.
    *  @param PmCommit		IN	Whether to forward the request to the board or not
    *  @return  SUCCESS or error code.
	*/     
	WORD	IFlow_PipeRelease(	IN  PTARGET_INFO PmPtrTgPipe,
                                IN  BOOLEAN      PmCommit );
    
	/**
	*	FLOW Interface :	Retrieve the Pipe Time in samples
	*
	*	@param		PmPtrTgPipe		IN	tgPipe,tgCaracPipeVoie,tgVioHandle are relevant
	*	@param		PmSampleCount	OUT	returned Sample Count
	*	@return SUCCESS or error code.
	*	@warning While the API makes usage of this function, StopPipeFct is not meant for pipes
	*	belonging to different boards anymore (by opposition to the real np API), erratical behave may result.
	*/  
    WORD	IFlow_PipeSampleCount(  IN	PTARGET_INFO    PmPtrTgPipe     ,
									OUT PPCX_TIME       PmSampleCount   );

/*@}*/


    // IIIIIIIII    Interface BUFFER      IIIIIIIIIIIIII//

/**
 * \defgroup Buffer Buffer Management Interface
 */
/*@{*/

	/**
	*	BUFFER Interface :	function added to manage IRP cancellation : this function simply removes the buffer from the stream, with no extra processing.
	*
	*	@param		PmPtrTgPipe			IN	tgPipe,tgCaracPipeVoie,tgDsp,tgVioHandle are relevant
	*	@param		PmEndOfCondition	IN	BOOLEAN TRUE if a end of play or end of record for the pipe has been received.
	*	@param		PmNbStreams			IN	Number of streams of the pipe.
	*	@return SUCCESS or error code.
	*/  
	VOID    IBuffer_CancelStreamBuffer( IN  PTARGET_INFO	PmPtrTgPipe  ,
										IN  LPBC_HEADER_INFO    PmPtBuffer  );

/*@{*/


    // IIIIIIIII    Interface EVENT      IIIIIIIIIIIIII//

/**
 * \defgroup Events/Notifications and Interrupt Management Interface
 */
/*@{*/


	BOOLEAN IEvent_AcknowledgeIRQ( BOOLEAN* PmTimerOccured, BOOLEAN* PmAsyncPending, BOOLEAN* PmAsyncESCMD );

	/**
	*	EVENT Interface : Retrieve the IRQ source, and Asynchrounous Events details.
	*	@param PmPEndStartOnTimeCode	OUT	is TRUE if a timecode event was received (pipe start on LTC).
	*	@param PmPFrequencyChange	OUT	is TRUE if the UER clock changed.
    *   @param   PmPNotifiedOutPipeMask
    *	@param   PmPNotifiedInPipeMask
	*	@param	 PmES_Response
	*	@return  SUCCESS or error code.
	*	@see	#IEvent_TestITSrc	
	*/     
	WORD	IEvent_AsynchronousEvents(  OUT PBOOLEAN         PmPEndStartOnTimeCode,
                                        OUT PBOOLEAN         PmPFrequencyChange,
                                        OUT PDWORDLONG       PmPNotifiedOutPipeMask,
                                        OUT PDWORDLONG       PmPNotifiedInPipeMask,
										OUT PES_DRV_RESP	 PmES_Response);

	/*	
	*	Wait for the time of a pseudo-frame, bo be sure a setting has been taken into account
	*	or the current sound transfer is done.
	*/
	VOID	IEvent_WaitEndOfCoding( IN PTARGET_INFO PmTarget );

	WORD	IEvent_WaitEndOfStartPipe( IN PTARGET_INFO PmTarget );

    WORD    IEvent_WaitPipeState( IN PTARGET_INFO PmTarget, IN BYTE PmState );

/*@}*/

	WORD	SendMessage(  ) ;

	VOID	InitMessage( cmd_mb_opcodes op_code ) ;

	/**
	*	This will ask for the buffer status on the given pipe.
	*	@warning	on LXES, all finished buffers are freed at once with this command
	*				and must be notified to the application (no "More" bit)
	*
	*	@param	PmNbNeededPtr		IN Pointer to the variable that receives the number of Needed buffers.
	*	@param	PmNbFreedPtr		IN Pointer to the variable that receives the number of Freed buffers.
	*	@param	PmBufferSizeArray	IN array of at least MAX_STREAM_BUFFERS DWORDS, that receive the size of the freed capture buffers.
	*/
	WORD	vio_InitSoundTransferLX(	IN PTARGET_INFO PmPtrTarget,
										OUT PDWORD      PmNbNeededPtr,
										OUT PDWORD      PmNbFreedPtr,
										OUT PDWORD      PmBufferSizeArray);
	
	
	/**
	*	Send a buffer for play or capture on a LXES card
	*
	*   @param	IN	PmPtrTarget
	*   @param	IN	PmBuffDataLength
	*   @param	IN	PmBuffAddressLo
	*   @param	IN	PmBuffAddressHi		set to zero if 64bit transfer not supported, or HIGH part is zero
	*   @param	IN	PmPauseRequest
	*   @param	IN	PmNotifyBuffer
	*   @param	IN	PmMisc
	*	@param	OUT PmBufferIndex
	*	@see	vio_StreamGiveBufferNP
	*/
	WORD vio_StreamGiveBufferLX(IN	PTARGET_INFO     PmPtrTarget,
								IN	DWORD            PmBuffDataLength,
								IN	DWORD            PmBuffAddressLo,
								IN	DWORD            PmBuffAddressHi,
								IN	BYTE             PmPauseRequest,
								IN	BOOLEAN          PmNotifyBuffer,
								IN	DWORD            PmMisc,
								OUT	PBYTE			 PmBufferIndex);

	WORD	vio_StreamCancelBuffer  (   IN PTARGET_INFO     PmPtrTarget,
										IN WORD             PmCurrentStream,
										IN DWORD            PmBuffDataLength,
										IN DWORD            PmBuffAddress);

	WORD	vio_FreeBufferAndGetSizeNP( IN  PTARGET_INFO    PmPtrTarget,
										IN  WORD            PmCurrentStream,
										OUT PDWORD          PmBufferSizePtr);


	WORD	vio_SoundTransferPlayNP(    IN  PTARGET_INFO    PmTarget,
										IN  BOOLEAN         PmEndOfPlayRequested,
										IN  WORD            PmNbStreams);

	WORD	vio_SoundTransferRecordNP(	IN  PTARGET_INFO    PmTarget,
										IN  BOOLEAN         PmFinishing,
										IN  WORD            PmNbStreams);

};


#endif // _LXPROTOCOL_H





