// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#ifndef _DRVDBG_H_
#define _DRVDBG_H_


//
// Modified version of ksdebug.h to support runtime debug level changes.
//
#define DBG_NONE        0x00000000
#define DBG_PRINT       0x00000001 // Blabla. Function entries for example
#define DBG_WARNING     0x00000002 // warning level
#define DBG_ERROR       0x00000004 // this doesn't generate a breakpoint

// specific debug output; you don't have to enable DBG_PRINT for this.
#define DBG_STREAM      0x00000010 // Enables stream output.
#define DBG_POWER       0x00000020 // Enables power management output.
#define DBG_DMA         0x00000040 // Enables DMA engine output.
#define DBG_REGS        0x00000080 // Enables register outout.
#define DBG_PROBE       0x00000100 // Enables hardware probing output.
#define DBG_SYSINFO     0x00000200 // Enables system info output.
#define DBG_VSR         0x00000400 // Enables variable sample rate output.
#define DBG_PROPERTY    0x00000800 // Enables property handler output
#define DBG_BOARD       0x00001000 // Enables board detection + init output
#define DBG_SYNCNPAPI   0x00002000 // Enables sync DirectSound/NpApi output
#define DBG_UER         0x00004000 // Digital Data/Sync commands
#define DBG_SOURCE      0x00008000 // input source selection commands

/* Protocol Interfaces */
#define DBG_PROT_INIT   0x00010000 
#define DBG_PROT_DIAG   0x00020000 
#define DBG_PROT_FLOW   0x00040000 
#define DBG_PROT_BUFFER 0x00080000 
#define DBG_PROT_CLOCK  0x00100000 
#define DBG_PROT_VIO    0x00200000 
#define DBG_PROT_EVENT  0x00400000 
#define DBG_PROT_LEVEL  0x00800000 
#define DBG_PROT_ALL    0x00ff0006 

/* IOCommand Interfaces */
#define DBG_PIO_CMD     0x01000000 // Enables dump of PIO commands in XXIOCommmands
#define DBG_PIO_DSP     0x02000000 // Enables DSP communication dump of XXIOCommmands
#define DBG_PIO_ALL     0x03000006 // Enables all dump of XXIOCommmands

#define DBG_BUFFER      0x04000000 // Enables dump of buffer mappings

#define DBG_PINS        0x10000000 // Enables dump of created pins in topology
#define DBG_NODES       0x20000000 // Enables dump of created nodes in topology
#define DBG_CONNS       0x40000000 // Enables dump of the connections in topology

/* test  */
#define DBG_TEST		0x80000000


#define DBG_ALL         0xFFFFFFFF
#define DBG_DEFAULT     0x00000006 // Errors and warnings
    

#if defined(__cplusplus)
extern "C" {
#endif // #if defined(__cplusplus)


//
// Define global debug variable.
//
#ifdef DEFINE_DEBUG_VARS
#ifdef DBG_VIEWER
unsigned long g_ulDebugOut =  DBG_DEFAULT;
#endif

#else // !DEFINED_DEBUG_VARS
#ifdef DBG_VIEWER
extern unsigned long g_ulDebugOut;
#endif
#endif

//
// DBG is 1 in checked builds
//
#ifdef DBG_VIEWER
#define DOUT(lvl, strings)          \
    if ((lvl) & g_ulDebugOut)         \
    {                               \
        DbgPrint##strings;          \
    }

#define BREAK()                     \
    DbgBreakPoint()

#else // if (!DBG_VIEWER)
#define DOUT(lvl, strings)
#define BREAK()
#endif // !DBG_VIEWER    


#if defined(__cplusplus)
}
#endif // #if defined(__cplusplus)




#ifdef DBG_VIEWER
    #define DPrint DbgPrint  
#else
    #define DPrint  1 ? 0 :
#endif


#define EXIT_PCX_ERROR(expr)                                 \
    {                                                        \
        WORD error = (expr) ;                                \
        if ( error != 0 )                                    \
            DPrint("*** ---> message:%x file:%s, line:%d\n", \
                   (error),__FILE__,__LINE__);               \
        return error;                                        \
    }                                                           

#define LOAD_PCX_ERROR(target,expr)                          \
    {                                                        \
        WORD error = (expr) ;                                \
        if ( error != 0 )                                    \
            DPrint("*** ---> message:%x file:%s, line:%d\n", \
                   (error),__FILE__,__LINE__);               \
        target = error ;                                     \
    }                                                           

#define SHOW_PCX_ERROR(expr)                                 \
    {                                                        \
        WORD error = (expr) ;                                \
        if ( error != 0 )                                    \
            DPrint("*** ---> message:%x file:%s, line:%d\n", \
                   (error),__FILE__,__LINE__);               \
    }                                                           

#endif // _DRVDBG_H_


