// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#ifndef _BUFF_HDL_H
#define _BUFF_HDL_H

#include "drvdef.h"

#include "ifapidrv.h"


// Shared constants
// ****************


// default is 32KBytes buffers, max is 512K buffers
// min is 4K [## FS (01/OCT/1999)]
// min/max is 12K for VX boards [## FM (10/12/1999)]
//
#define MIN_BUFFER_SIZE         (4*1024)
#define MAX_BUFFER_SIZE         (512*1024)

#define DEFAULT_BUFFER_SIZE     (4*1024)

// Shared typedefs
// ***************

// TAG_DEBUG_DRIVER : DEB

typedef struct _GEN_BUFFER_INFO {
    DWORD   gbBuffTotalNb;          // Total number of buffers
    DWORD   gbBuffAvailNb;          // Remaining buffers available
    DWORD   gbBuffSize;             // Size of a buffer (bytes)
    DWORD   gbBigBuffNb;            // Number of special big buffers (ASIO)
    DWORD   gbBigBuffSize;          // Size of a big buffer (bytes)
} GEN_BUFFER_INFO, * PGEN_BUFFER_INFO, FAR *LPGEN_BUFFER_INFO;

typedef LPGEN_BUFFER_INFO   *GEN_BUFFER_INFO_HANDLE;

typedef struct  _BUFFER_INFO {
    BYTE    biCarac;        // 1: buffer available, 0: no buffer or reserved one
    BYTE    Padding[3];
    PVOID   biAddress1;

} BUFFER_INFO, *PBUFFER_INFO, FAR *LPBUFFER_INFO;

typedef LPBUFFER_INFO   *BUFFER_INFO_HANDLE;

// TAG_DEBUG_DRIVER : FIN

// Global functions
// ****************
#ifdef __cplusplus
extern "C" {
#endif

EXTERN VOID BUFInit(
    OUT GEN_BUFFER_INFO_HANDLE    PmPGeneralBuffer,
    OUT BUFFER_INFO_HANDLE        PmPBufferTab );

EXTERN WORD BUFAllocateBuffers(
    IN  DWORD           PmNbBuffers,
    IN  DWORD           PmBufferSize,
    OUT PDWORD          PmPNbBuffers,
    OUT PHANDLE_BUFFER  PmHandleBuffers );

EXTERN VOID BUFFreeBuffers(
    IN PHANDLE_BUFFER   PmPHandleBuffers    ,
    IN LPADD_DESC_INFO  PmAddrDescTab      );

EXTERN VOID BUFFillAddressInfo(
    IN WORD             PmBufferNumber  ,
    IN PHANDLE_BUFFER   PmPHandleBuffers ,
    IN WORD             PmWorld,
    OUT LPADD_DESC_INFO PmPAddressInfo  );

EXTERN VOID BUFGetFeatures(
    OUT LPDWORD  PmPTotalBuff,
    OUT LPDWORD  PmPAvailBuff,
    OUT LPDWORD PmPBuffSize  );

EXTERN WORD BUFGetBufferInfoForTransNP(
    IN DWORD            PmBufferNumber,
    IN PHANDLE_BUFFER   PmPHandleBuffers,
    IN DWORD            PmOffset,
    IN DWORD            PmLength,
    OUT PDWORD          PmPLength,
    OUT PDWORD          PmAddress );

EXTERN DWORD BUFAllocateAllBuffers(INOUT LPVOID) ;

EXTERN VOID  BUFFreeAllBuffers(INOUT LPVOID) ;

EXTERN WORD BUFGetBufferInfoForDebug(
    IN  DWORD   PmIndex,
    OUT PBYTE   *PmPPBufferInfo,
    OUT PWORD   PmPSize );

EXTERN WORD BUFGetPhysMapInfoForDebug(
    IN  WORD    PmIndex,
    OUT PBYTE   *PmPPBufferInfo,
    OUT PWORD   PmPSize );


#ifdef __cplusplus
}
#endif


#endif   // _BUFF_HDL_H



