// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#ifndef _UTIL_H_
#define _UTIL_H_

// Included files
// **************
#include "apidef.h"

// Global Functions
// ****************

// ****************************************************************************
// EXTERN WORD  UTIMaskWord()
// EXTERN DWORD UTIMaskDWord()
// ***************************
//
// Input parameters :
// ****************
//
//      WORD PmVal  :   the value that is to be converted to a mask
//
// Output parameters :
// *******************
//
//      NONE
// 
// Return value :
// **************
//
//      The resulting WORD (resp. DWORD) mask with bit PmVal is set
//
// ****************************************************************************
//
// Converts a value to a mask where the corresponding bit is set
//
// ****************************************************************************
EXTERN WORD     UTIMaskWord( IN WORD );
EXTERN DWORD    UTIMaskDWord( IN WORD );


// ****************************************************************************
// EXTERN WORD UTIDWMask2Word()
// ***************************
//
// Input parameters :
// ****************
//
//      DWORD PmMask  :   a mask with at least one bit set
//
// Output parameters :
// *******************
//
//      NONE
// 
// Return value :
// **************
//
//      The number of the first set-bit found in the mask
//
// ****************************************************************************
//
//  Scan the mask bits from right to left, and returns the position of
// the first set_bit encountered
//                                 
// ****************************************************************************
EXTERN WORD     UTIDWMask2Word( IN DWORD );

#endif // _UTIL_H_

