// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#include "apidef.h"
#include "pcxapi_e.h"
#include "pcxerr_e.h"
#include "util.h"

// ********************************************************************
// Error code structure reminder
// *****************************
//
// An error code is 16 bits :
//
//    Bit 15 : 1 = error, 0 = warning
//
//    Bits 14-->11 : source of error/warning
//          0x1 = TOOLS source error/warning
//          0x2 = API source error/warning
//          0x3 = AUDIO source error/warning
//          0x4 = DRV source error/warning
//          0x5-->0x7 = reserved
//          0x8 = BOARD source error/warning
//          0x9-->0xe = reserved
//          0xf = free for USER usage
//
//    Bits 8-->10 : Class code
//
//    Bits 0-->7  : Code
//
// *********************************************************************

typedef struct _ERROR_INFO {
        WORD            errCode ;
        BOTH_STR_INFO   errMsg  ;
} ERROR_INFO, * PERROR_INFO, ** PPERROR_INFO ;

STATIC BOTH_STR_INFO EmptyString = _BOTH_TEXT("");
STATIC BOTH_STR_INFO SuccessString = _BOTH_TEXT("SUCCESS");

// Complete API warning code for the general class
// -----------------------------------------------
STATIC ERROR_INFO Warnings[] = {
        {   WA_MORE_DATA,                   _BOTH_TEXT("WA_MORE_DATA")                 },
        {   WA_NO_MORE_DATA,                _BOTH_TEXT("WA_NO_MORE_DATA")              },
        {   WA_COMMAND_NOT_AVAILABLE,       _BOTH_TEXT("WA_COMMAND_NOT_AVAILABLE")     },
        {   WA_LEVEL_OUT_OF_RANGE,          _BOTH_TEXT("WA_LEVEL_OUT_OF_RANGE")        },
        {   WA_PARAMETER_ADJUSTED,          _BOTH_TEXT("WA_PARAMETER_ADJUSTED")        },
        {   WA_CANNOT_CANCEL,               _BOTH_TEXT("WA_CANNOT_CANCEL")             },
        {   WD_MORE_DATA,                   _BOTH_TEXT("WD_MORE_DATA")                 },
        {   WD_NO_MORE_DATA,                _BOTH_TEXT("WD_NO_MORE_DATA")              },
        {   WD_UNDER_ALLOCATE_BUFFER,       _BOTH_TEXT("WD_UNDER_ALLOCATE_BUFFER")     },
        {   WD_REPLY_TRUNCATED,             _BOTH_TEXT("WD_REPLY_TRUNCATED")           },
        {   WD_PRIVATE_DATA,                _BOTH_TEXT("WD_PRIVATE_DATA")              },
        {   WD_NO_HARDWARE_SUPPORT,         _BOTH_TEXT("WD_NO_HARDWARE_SUPPORT")       },
        {   WD_DSP_VERSION_MISMATCH,        _BOTH_TEXT("WD_DSP_VERSION_MISMATCH")      },
        {   WD_EXTERNAL_CLOCK_LOST,         _BOTH_TEXT("WD_EXTERNAL_CLOCK_LOST")       },
        {   WD_SRC_ASSIGNED,                _BOTH_TEXT("WD_SRC_ASSIGNED")              },
        {   WD_CANNOT_CANCEL,               _BOTH_TEXT("WD_CANNOT_CANCEL")             },
        {   WD_UER_FREQUENCY_MODIFICATION,  _BOTH_TEXT("WD_UER_FREQUENCY_MODIFICATION")},
        {   WD_WORD_CLOCK_FREQUENCY_MODIFICATION,  _BOTH_TEXT("WD_WORD_CLOCK_FREQUENCY_MODIFICATION") },
        {   WB_COMMAND_NOT_IMPLEMENTED_YET, _BOTH_TEXT("WB_COMMAND_NOT_IMPLEMENTED_YET")},
        {   WB_PREVIOUS_STATUS_DIALOG_IMPOSSIBLE,
                                      _BOTH_TEXT("WB_PREVIOUS_STATUS_DIALOG_IMPOSSIBLE")},
        {   WB_LOW_DIFFERED_COMMAND,        _BOTH_TEXT("WB_LOW_DIFFERED_COMMAND")      },
        {   WB_STATUS_TOO_BIG,              _BOTH_TEXT("WB_STATUS_TOO_BIG")            },
        {   WB_COMMAND_WILL_NOT_BE_NOTIFIED,_BOTH_TEXT("WB_COMMAND_WILL_NOT_BE_NOTIFIED")},
        {   WB_BAD_EFFECT_PARAMETER,        _BOTH_TEXT("WB_BAD_EFFECT_PARAMETER")      },
        {   WB_CANNOT_CANCEL,               _BOTH_TEXT("WB_CANNOT_CANCEL")             },
        {   0,                              _BOTH_TEXT("WA_UNKNOWN_ERROR_CODE")        }
};

// Complete API error code for the general class
// ---------------------------------------------
STATIC ERROR_INFO ErrorMsgApiGN[] = {
        {   EA_DRIVER_NOT_LOADED,           _BOTH_TEXT("EA_DRIVER_NOT_LOADED")         },
        {   EA_UNKNOWN_MEMORY_TYPE,         _BOTH_TEXT("EA_UNKNOWN_MEMORY_TYPE")       },
        {   EA_USE_XMS_MEMORY_IMPOSSIBLE,   _BOTH_TEXT("EA_USE_XMS_MEMORY_IMPOSSIBLE") },
        {   EA_CANT_TAKE_MUTEX,             _BOTH_TEXT("EA_CANT_TAKE_MUTEX")           },
        {   EA_VERSION_MISMATCH,            _BOTH_TEXT("EA_VERSION_MISMATCH")          },
        {   EA_FILE_CORRUPTED,              _BOTH_TEXT("EA_FILE_CORRUPTED")            },
        {   EA_DLL_NOT_LOADED,              _BOTH_TEXT("EA_DLL_NOT_LOADED")            },
        {   EA_UNKNOWN_BOARD,               _BOTH_TEXT("EA_UNKNOWN_BOARD")             },
        {   EA_CREATE_THREAD_FAILED,        _BOTH_TEXT("EA_CREATE_THREAD_FAILED")      },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete API error code for the invalid command class
// -----------------------------------------------------
STATIC ERROR_INFO ErrorMsgApiIC[] = {
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete API error code for the invalid standard object class
// -------------------------------------------------------------
STATIC ERROR_INFO ErrorMsgApiISO[] = {
        {   EA_INVALID_BUFFER,              _BOTH_TEXT("EA_INVALID_BUFFER")             },
        {   EA_INVALID_PCX_HANDLE,          _BOTH_TEXT("EA_INVALID_PCX_HANDLE")         },
        {   EA_INVALID_PIPE,                _BOTH_TEXT("EA_INVALID_PIPE")               },
        {   EA_INVALID_PARAMETER,           _BOTH_TEXT("EA_INVALID_PARAMETER")          },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete API error code for impossible resource allocation class
// ----------------------------------------------------------------
STATIC ERROR_INFO ErrorMsgApiRI[] = {
        {   EA_ALLOCATE_ASYNC_IMPOSSIBLE,   _BOTH_TEXT("EA_ALLOCATE_ASYNC_IMPOSSIBLE")  },
        {   EA_ALLOCATE_CMD_BLK_IMPOSSIBLE, _BOTH_TEXT("EA_ALLOCATE_CMD_BLK_IMPOSSIBLE")},
        {   EA_ALLOCATE_MEMORY_IMPOSSIBLE,  _BOTH_TEXT("EA_ALLOCATE_MEMORY_IMPOSSIBLE") },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete API error code for wrong call context class
// ----------------------------------------------------
STATIC ERROR_INFO ErrorMsgApiWCC[] = {
        {   EA_BUFFER_REFUSED,              _BOTH_TEXT("EA_BUFFER_REFUSED")             },
        {   EA_WAIT_REQUEST_REFUSED,        _BOTH_TEXT("EA_WAIT_REQUEST_REFUSED")       },
        {   EA_LOAD_DSP_REFUSED,            _BOTH_TEXT("EA_LOAD_DSP_REFUSED")           },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete API error code for bad specific parameter class
// ----------------------------------------------------------
STATIC ERROR_INFO ErrorMsgApiWSP[] = {
        {   EA_APPLICATION_NAME_SIZE,       _BOTH_TEXT("EA_APPLICATION_NAME_SIZE")      },
        {   EA_BAD_SYNC_SOURCE,             _BOTH_TEXT("EA_BAD_SYNC_SOURCE")            },
        {   EA_OPEN_FILE_IMPOSSIBLE,        _BOTH_TEXT("EA_OPEN_FILE_IMPOSSIBLE")       },
        {   EA_READ_FILE_IMPOSSIBLE,        _BOTH_TEXT("EA_READ_FILE_IMPOSSIBLE")       },
        {   EA_FILE_TOO_LARGE,              _BOTH_TEXT("EA_FILE_TOO_LARGE")             },
        {   EA_BAD_STREAM_NUMBER,           _BOTH_TEXT("EA_BAD_STREAM_NUMBER")          },
        {   EA_BAD_AUDIO_NUMBER,            _BOTH_TEXT("EA_BAD_AUDIO_NUMBER")           },
        {   EA_BAD_EFFECT_ID,               _BOTH_TEXT("EA_BAD_EFFECT_ID")              },
        {   EA_BAD_EFFECT_PARAMETER,        _BOTH_TEXT("EA_BAD_EFFECT_PARAMETER")       },
        {   EA_BAD_FREQUENCY_VALUE,         _BOTH_TEXT("EA_BAD_FREQUENCY_VALUE")        },
        {   EA_MODE_NOT_AVAILABLE,          _BOTH_TEXT("EA_MODE_NOT_AVAILABLE")         },
        {   EA_CONTEXT_NOT_AVAILABLE,       _BOTH_TEXT("EA_CONTEXT_NOT_AVAILABLE")      },
        {   EA_BAD_DSP_FEATURES,            _BOTH_TEXT("EA_BAD_DSP_FEATURES")           },
        {   EA_BAD_PLAY_FORMATS,            _BOTH_TEXT("EA_BAD_PLAY_FORMATS")           },
        {   EA_BAD_RECORD_FORMATS,          _BOTH_TEXT("EA_BAD_RECORD_FORMATS")         },
        {   EA_BAD_PLAY_EFFECTS,            _BOTH_TEXT("EA_BAD_PLAY_EFFECTS")           },
        {   EA_BAD_RECORD_EFFECTS,          _BOTH_TEXT("EA_BAD_RECORD_EFFECTS")         },
        {   EA_BAD_SOUND_FORMAT,            _BOTH_TEXT("EA_BAD_SOUND_FORMAT")           },
        {   EA_BAD_TIME_CODE_NUMBER,        _BOTH_TEXT("EA_BAD_TIME_CODE_NUMBER")       },
        {   EA_BAD_BAND_NUMBER,             _BOTH_TEXT("EA_BAD_BAND_NUMBER")            },
        {   EA_INVALID_POINTER,             _BOTH_TEXT("EA_INVALID_POINTER")            },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete API error code for real time class
// -------------------------------------------
STATIC ERROR_INFO ErrorMsgApiRT[] = {
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete DRV error code for the general class
// ---------------------------------------------
STATIC ERROR_INFO ErrorMsgDrvGN[] = {
        {   ED_CONCURRENCY,                 _BOTH_TEXT("ED_CONCURRENCY")                },
        {   ED_DSP_CRASHED,                 _BOTH_TEXT("ED_DSP_CRASHED")                },
        {   ED_UNKNOWN_BOARD,               _BOTH_TEXT("ED_UNKNOWN_BOARD")              },
        {   ED_NOT_INSTALLED,               _BOTH_TEXT("ED_NOT_INSTALLED")              },
        {   ED_CANNOT_OPEN_SVC_MANAGER,     _BOTH_TEXT("ED_CANNOT_OPEN_SVC_MANAGER")    },
        {   ED_CANNOT_READ_REGISTRY,        _BOTH_TEXT("ED_CANNOT_READ_REGISTRY")       },
        {   ED_DSP_VERSION_MISMATCH,        _BOTH_TEXT("ED_DSP_VERSION_MISMATCH")       },
        {   ED_UNAVAILABLE_FEATURE,         _BOTH_TEXT("ED_UNAVAILABLE_FEATURE")        },
        {   ED_CANCELLED,                   _BOTH_TEXT("ED_CANCELLED")                  },
        {   ED_NO_RESPONSE_AT_IRQA,         _BOTH_TEXT("ED_NO_RESPONSE_AT_IRQA")        },
        {   ED_INVALID_ADDRESS,             _BOTH_TEXT("ED_INVALID_ADDRESS")            },
        {   ED_DSP_CORRUPTED,               _BOTH_TEXT("ED_DSP_CORRUPTED")              },
        {   ED_PENDING_OPERATION,           _BOTH_TEXT("ED_PENDING_OPERATION")          },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete DRV error code for the invalid command class
// -----------------------------------------------------
STATIC ERROR_INFO ErrorMsgDrvIC[] = {
        {   ED_INVALID_FAM,                 _BOTH_TEXT("ED_INVALID_FAM")                },
        {   ED_INVALID_CMD_FAM1,            _BOTH_TEXT("ED_INVALID_CMD_FAM1")           },
        {   ED_INVALID_CMD_FAM2,            _BOTH_TEXT("ED_INVALID_CMD_FAM2")           },
        {   ED_INVALID_CMD_FAM3,            _BOTH_TEXT("ED_INVALID_CMD_FAM3")           },
        {   ED_INVALID_CMD_FAM4,            _BOTH_TEXT("ED_INVALID_CMD_FAM4")           },
        {   ED_INVALID_CMD_FAM5,            _BOTH_TEXT("ED_INVALID_CMD_FAM5")           },
        {   ED_INVALID_CMD_FAM6,            _BOTH_TEXT("ED_INVALID_CMD_FAM6")           },
        {   ED_INVALID_CMD_FAM7,            _BOTH_TEXT("ED_INVALID_CMD_FAM7")           },
        {   ED_INVALID_CMD_FAM8,            _BOTH_TEXT("ED_INVALID_CMD_FAM8")           },
        {   ED_INVALID_CMD_FAM9,            _BOTH_TEXT("ED_INVALID_CMD_FAM9")           },
        {   ED_INVALID_CMD_FAM10,           _BOTH_TEXT("ED_INVALID_CMD_FAM10")          },
        {   ED_INVALID_CMD_FAM11,           _BOTH_TEXT("ED_INVALID_CMD_FAM11")          },
        {   ED_INVALID_CMD_FAM12,           _BOTH_TEXT("ED_INVALID_CMD_FAM12")          },
        {   ED_INVALID_CMD_FAM13,           _BOTH_TEXT("ED_INVALID_CMD_FAM13")          },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete DRV error code for the invalid standard object class
// -------------------------------------------------------------
STATIC ERROR_INFO ErrorMsgDrvISO[] = {
        {   ED_INVALID_PCX_HANDLE,          _BOTH_TEXT("ED_INVALID_PCX_HANDLE")         },
        {   ED_INVALID_PIPE,                _BOTH_TEXT("ED_INVALID_PIPE")               },
        {   ED_INVALID_STREAM,              _BOTH_TEXT("ED_INVALID_STREAM")             },
        {   ED_INVALID_PIPE_AUDIO,          _BOTH_TEXT("ED_INVALID_PIPE_AUDIO")         },
        {   ED_INVALID_BUFFER,              _BOTH_TEXT("ED_INVALID_BUFFER")             },
        {   ED_INVALID_DSP_SOFTWARE,        _BOTH_TEXT("ED_INVALID_DSP_SOFTWARE")       },
        {   ED_INVALID_BOARD,               _BOTH_TEXT("ED_INVALID_BOARD")              },
        {   ED_INVALID_DSP,                 _BOTH_TEXT("ED_INVALID_DSP")                },
        {   ED_INVALID_BOARD_AUDIO,         _BOTH_TEXT("ED_INVALID_BOARD_AUDIO")        },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete DRV error code for impossible resource allocation class
// ----------------------------------------------------------------
STATIC ERROR_INFO ErrorMsgDrvRI[] = {
        {   ED_DECL_APP_IMPOSSIBLE,         _BOTH_TEXT("ED_DECL_APP_IMPOSSIBLE")        },
        {   ED_SET_CLOCK_IMPOSSIBLE,        _BOTH_TEXT("ED_SET_CLOCK_IMPOSSIBLE")       },
        {   ED_ALLOCATE_BUFFER_IMPOSSIBLE,  _BOTH_TEXT("ED_ALLOCATE_BUFFER_IMPOSSIBLE") },
        {   ED_ALLOCATE_AUDIO_IMPOSSIBLE,   _BOTH_TEXT("ED_ALLOCATE_AUDIO_IMPOSSIBLE")  },
        {   ED_LOAD_DSP_IMPOSSIBLE,         _BOTH_TEXT("ED_LOAD_DSP_IMPOSSIBLE")        },
        {   ED_REQUEST_BLOC_TOO_SHORT,      _BOTH_TEXT("ED_REQUEST_BLOC_TOO_SHORT")     },
        {   ED_ALLOCATE_STREAM_IMPOSSIBLE,  _BOTH_TEXT("ED_ALLOCATE_STREAM_IMPOSSIBLE") },
        {   ED_REPLY_BLOC_TOO_SHORT,        _BOTH_TEXT("ED_REPLY_BLOC_TOO_SHORT")       },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete DRV error code for wrong call context class
// ----------------------------------------------------
STATIC ERROR_INFO ErrorMsgDrvWCC[] = {
        {   ED_USE_DSP_REFUSED,             _BOTH_TEXT("ED_USE_DSP_REFUSED")            },
        {   ED_FREE_DSP_REFUSED,            _BOTH_TEXT("ED_FREE_DSP_REFUSED")           },
        {   ED_SUPPRESS_PIPE_REFUSED,       _BOTH_TEXT("ED_SUPPRESS_PIPE_REFUSED")      },
        {   ED_SET_CLOCK_REFUSED,           _BOTH_TEXT("ED_SET_CLOCK_REFUSED")          },
        {   ED_DIFFERED_CMD_REFUSED,        _BOTH_TEXT("ED_DIFFERED_CMD_REFUSED")       },
        {   ED_SET_CLOCK_THESEPIPES_REFUSED,_BOTH_TEXT("ED_SET_CLOCK_THESEPIPES_REFUSED")},
        {   ED_MANY_PIPES_REFUSED,          _BOTH_TEXT("ED_MANY_PIPES_REFUSED")         },
        {   ED_MANY_AUDIOS_REFUSED,         _BOTH_TEXT("ED_MANY_AUDIOS_REFUSED")        },
        {   ED_SET_PIPE_SOURCE_REFUSED,     _BOTH_TEXT("ED_SET_PIPE_SOURCE_REFUSED")    },
        {   ED_CONTEXT_REFUSED,             _BOTH_TEXT("ED_CONTEXT_REFUSED")            },
        {   ED_START_IN_PROGRESS,           _BOTH_TEXT("ED_START_IN_PROGRESS")          },
        {   ED_START_ON_TIME_CODE_IN_PROGRESS, _BOTH_TEXT("ED_START_ON_TIME_CODE_IN_PROGRESS")},
        {   ED_AUDIO_MANAGED_BY_DHS_PANEL,  _BOTH_TEXT("ED_AUDIO_MANAGED_BY_DHS_PANEL")},
        {   ED_CLOCK_MANAGED_BY_DHS_PANEL,  _BOTH_TEXT("ED_CLOCK_MANAGED_BY_DHS_PANEL")},
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};


// Complete DRV error code for bad specific parameter class
// ----------------------------------------------------------
STATIC ERROR_INFO ErrorMsgDrvWSP[] = {
        {   ED_APPLICATION_NAME_SIZE,       _BOTH_TEXT("ED_APPLICATION_NAME_SIZE")      },
        {   ED_UNKNOWN_APPLICATION_ATTRIB,  _BOTH_TEXT("ED_UNKNOWN_APPLICATION_ATTRIB") },
        {   ED_UNKNOWN_PIPE_ATTRIB,         _BOTH_TEXT("ED_UNKNOWN_PIPE_ATTRIB")        },
        {   ED_UNKNOWN_AUDIO_ATTRIB,        _BOTH_TEXT("ED_UNKNOWN_AUDIO_ATTRIB")       },
        {   ED_INCOMPATIBLE_PIPE_AUDIO_ATTRIB,
                                        _BOTH_TEXT("ED_INCOMPATIBLE_PIPE_AUDIO_ATTRIB") },
        {   ED_FORMAT_NOT_SUPPORTED,        _BOTH_TEXT("ED_FORMAT_NOT_SUPPORTED")       },
        {   ED_LEVEL_OUT_OF_RANGE,          _BOTH_TEXT("ED_LEVEL_OUT_OF_RANGE")         },
        {   ED_CLOCK_UER_BOARD,             _BOTH_TEXT("ED_CLOCK_UER_BOARD")            },
        {   ED_BAD_UER_FREQUENCY,           _BOTH_TEXT("ED_BAD_UER_FREQUENCY")          },
        {   ED_BAD_UER_MODE,                _BOTH_TEXT("ED_BAD_UER_MODE")               },
        {   ED_BAD_CLOCK_FREQUENCY,         _BOTH_TEXT("ED_BAD_CLOCK_FREQUENCY")        },
        {   ED_BAD_VALIDATION_MASK,         _BOTH_TEXT("ED_BAD_VALIDATION_MASK")        },
        {   ED_BAD_SOURCE,                  _BOTH_TEXT("ED_BAD_SOURCE")                 },
        {   ED_CLOCK_WORD_CLOCK_BOARD,      _BOTH_TEXT("ED_CLOCK_WORD_CLOCK_BOARD")     },
        {   ED_CONTEXT_NOT_FOUND,           _BOTH_TEXT("ED_CONTEXT_NOT_FOUND")          },
        {   ED_CMD_MUST_BE_DIFFERED,        _BOTH_TEXT("ED_CMD_MUST_BE_DIFFERED")       },
        {   ED_CLOCK_PROGRAMMABLE_CLOCK_BOARD, _BOTH_TEXT("ED_CLOCK_PROGRAMMABLE_CLOCK_BOARD")},
        {   ED_BAD_UER_EXTRA_PARAM,         _BOTH_TEXT("ED_BAD_UER_EXTRA_PARAM")        },
        {   ED_SRC_UNAVAILABLE,             _BOTH_TEXT("ED_SRC_UNAVAILABLE")            },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete BOARD error code for real time class
// ---------------------------------------------
STATIC ERROR_INFO ErrorMsgDrvRT[] = {
        {   ED_DSP_TIMED_OUT,               _BOTH_TEXT("ED_DSP_TIMED_OUT")              },
        {   ED_DSP_CHK_TIMED_OUT,           _BOTH_TEXT("ED_DSP_CHK_TIMED_OUT")          },
        {   ED_STREAM_OVERRUN,              _BOTH_TEXT("ED_STREAM_OVERRUN")             },
        {   ED_DSP_BUSY,                    _BOTH_TEXT("ED_DSP_BUSY")                   },
        {   ED_DSP_SEMAPHORE_TIME_OUT,      _BOTH_TEXT("ED_DSP_SEMAPHORE_TIME_OUT")     },
        {   ED_BOARD_TIME_OUT,              _BOTH_TEXT("ED_BOARD_TIME_OUT")             },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete BOARD error code for the general class
// -----------------------------------------------
STATIC ERROR_INFO ErrorMsgBrdGN[] = {
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete BOARD error code for the invalid command class
// -------------------------------------------------------
STATIC ERROR_INFO ErrorMsgBrdIC[] = {
        {   EB_INVALID_COMMAND,             _BOTH_TEXT("EB_INVALID_COMMAND")            },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete BOARD error code for the invaid standard object class
// --------------------------------------------------------------
STATIC ERROR_INFO ErrorMsgBrdISO[] = {
        {   EB_INVALID_EFFECT,              _BOTH_TEXT("EB_INVALID_EFFECT")             },
        {   EB_INVALID_PIPE,                _BOTH_TEXT("EB_INVALID_PIPE")               },
        {   EB_INVALID_STREAM,              _BOTH_TEXT("EB_INVALID_STREAM")             },
        {   EB_INVALID_AUDIO,               _BOTH_TEXT("EB_INVALID_AUDIO")              },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete BOARD error code for impossible resource allocation class
// ------------------------------------------------------------------
STATIC ERROR_INFO ErrorMsgBrdRI[] = {
        {   EB_ALLOCATE_ALL_STREAM_TRANSFERT_BUFFERS_IMPOSSIBLE,
                       _BOTH_TEXT("EB_ALLOCATE_ALL_STREAM_TRANSFER_BUFFERS_IMPOSSIBLE")},
        {   EB_ALLOCATE_PIPE_SAMPLE_BUFFER_IMPOSSIBLE,
                       _BOTH_TEXT("EB_ALLOCATE_PIPE_SAMPLE_BUFFER_IMPOSSIBLE")          },
        {   EB_ALLOCATE_DIFFERED_CMD_IMPOSSIBLE,
                                    _BOTH_TEXT("EB_ALLOCATE_DIFFERED_CMD_IMPOSSIBLE")   },
        {   EB_TOO_MANY_DIFFERED_CMD,       _BOTH_TEXT("EB_TOO_MANY_DIFFERED_CMD")      },
        {   EB_RBUFFERS_TABLE_OVERFLOW,     _BOTH_TEXT("EB_RBUFFERS_TABLE_OVERFLOW")    },
        {   EB_ALLOCATE_EFFECTS_IMPOSSIBLE, _BOTH_TEXT("EB_ALLOCATE_EFFECTS_IMPOSSIBLE")},
        {   EB_ALLOCATE_EFFECT_POS_IMPOSSIBLE,
                                    _BOTH_TEXT("EB_ALLOCATE_EFFECT_POS_IMPOSSIBLE")     },
        {   EB_RBUFFER_NOT_AVAILABLE,       _BOTH_TEXT("EB_RBUFFER_NOT_AVAILABLE")      },
        {   EB_ALLOCATE_CONTEXT_LIII_IMPOSSIBLE,
                                     _BOTH_TEXT("EB_ALLOCATE_CONTEXT_LIII_IMPOSSIBLE")  },
        {   EB_STATUS_DIALOG_IMPOSSIBLE,    _BOTH_TEXT("EB_WRONG_STATUS")               },
        {   EB_CONTROL_CMD_IMPOSSIBLE,      _BOTH_TEXT("EB_TOO_MANY_PARAMETERS")        },
        {   EB_STATUS_SEND_IMPOSSIBLE,      _BOTH_TEXT("EB_STATUS_TOO_BIG")             },
        {   EB_ALLOCATE_PIPE_IMPOSSIBLE,    _BOTH_TEXT("EB_ALLOCATE_PIPE_IMPOSSIBLE")   },
        {   EB_ALLOCATE_STREAM_IMPOSSIBLE,  _BOTH_TEXT("EB_ALLOCATE_STREAM_IMPOSSIBLE") },
        {   EB_ALLOCATE_AUDIO_IMPOSSIBLE,   _BOTH_TEXT("EB_ALLOCATE_AUDIO_IMPOSSIBLE")  },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete BOARD error code for wrong call context class
// ------------------------------------------------------
STATIC ERROR_INFO ErrorMsgBrdWCC[] = {
        {   EB_CMD_REFUSED,                 _BOTH_TEXT("EB_CMD_REFUSED")                },
        {   EB_SPC_REFUSED,                 _BOTH_TEXT("EB_SPC_REFUSED")                },
        {   EB_CSN_REFUSED,                 _BOTH_TEXT("EB_CSN_REFUSED")                },
        {   EB_CSE_REFUSED,                 _BOTH_TEXT("EB_CSE_REFUSED")                },
        {   EB_START_STREAM_REFUSED,        _BOTH_TEXT("EB_START_STREAM_REFUSED")       },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete BOARD error code for bad specific parameter class
// ------------------------------------------------------------
STATIC ERROR_INFO ErrorMsgBrdWSP[] = {
        {   EB_BAD_DSP_MESSAGE_SIZE,        _BOTH_TEXT("EB_BAD_DSP_MESSAGE_SIZE")        },
        {   EB_BAD_PIPE_MESSAGE_SIZE,       _BOTH_TEXT("EB_BAD_PIPE_MESSAGE_SIZE")       },
        {   EB_BAD_EFFECT_PARAMETER,        _BOTH_TEXT("EB_BAD_EFFECT_PARAMETER")        },
        {   EB_BAD_STREAM_MESSAGE_SIZE,     _BOTH_TEXT("EB_BAD_STREAM_MESSAGE_SIZE")     },
        {   EB_BAD_AUDIO_MESSAGE_SIZE,      _BOTH_TEXT("EB_BAD_AUDIO_MESSAGE_SIZE")      },
        {   EB_BAD_DSP_MESSAGE_PARAMETER,   _BOTH_TEXT("EB_BAD_DSP_MESSAGE_PARAMETER")   },
        {   EB_BAD_PIPE_MESSAGE_PARAMETER,  _BOTH_TEXT("EB_BAD_PIPE_MESSAGE_PARAMETER")  },
        {   EB_BAD_STREAM_MESSAGE_PARAMETER,_BOTH_TEXT("EB_BAD_STREAM_MESSAGE_PARAMETER")},
        {   EB_BAD_AUDIO_MESSAGE_PARAMETER, _BOTH_TEXT("EB_BAD_AUDIO_MESSAGE_PARAMETER") },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")         }
};

// Complete BOARD error code for real time class
// ---------------------------------------------
STATIC ERROR_INFO ErrorMsgBrdRT[] = {
        {   EB_STREAM_UNDERRUN,             _BOTH_TEXT("EB_STREAM_UNDERRUN")            },
        {   EB_STREAM_FRAME_CRC_FAILED,     _BOTH_TEXT("EB_STREAM_FRAME_CRC_FAILED")          },
        {   EB_STREAM_INVALID_FRAME,        _BOTH_TEXT("EB_STREAM_INVALID_FRAME")       },
        {   EB_STREAM_INCOMPATIBLE_LAYER,   _BOTH_TEXT("EB_STREAM_INCOMPATIBLE_LAYER")       },
        {   EB_STREAM_RBUFFER_READ_ERROR,   _BOTH_TEXT("EB_STREAM_BUFFER_READ_ERROR")   },
        {   EB_STREAM_RBUFFER_TOO_SMALL,    _BOTH_TEXT("EB_STREAM_BUFFER_TOO_SMALL")    },
        {   EB_STREAM_FORMAT_MISUSED,       _BOTH_TEXT("EB_STREAM_FORMAT_MISUSED")      },
        {   EB_STREAM_RBUFFER_WRITE_ERROR,  _BOTH_TEXT("EB_STREAM_BUFFER_WRITE_ERROR")  },
        {   EB_STREAM_MULTICHANNEL_ERROR,   _BOTH_TEXT("EB_STREAM_MULTICHANNEL_ERROR")  },
        {   EB_PIPE_UNDERRUN,               _BOTH_TEXT("EB_PIPE_UNDERRUN")              },
        {   EB_STREAM_LAYER3_FRAME_ERROR,   _BOTH_TEXT("EB_STREAM_LAYER3_FRAME_ERROR")  },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

// Complete BOARD error code for internal error class
// ---------------------------------------------
STATIC ERROR_INFO ErrorMsgBrdIE[] = {
        {   EB_GENERIC_FATAL_ERROR,         _BOTH_TEXT("EB_GENERIC_FATAL_ERROR")        },
        {   EB_CSNR_I1_FATAL_ERROR,         _BOTH_TEXT("EB_CSNR_I1_FATAL_ERROR")        },
        {   EB_CSNR_I2_FATAL_ERROR,         _BOTH_TEXT("EB_CSNR_I2_FATAL_ERROR")        },
        {   EB_CSNR_I3_FATAL_ERROR,         _BOTH_TEXT("EB_CSNR_I3_FATAL_ERROR")        },
        {   EB_REENTRY_FATAL_ERROR,         _BOTH_TEXT("EB_REENTRY_FATAL_ERROR")        },
        {   EB_CONN_RE_FATAL_ERROR,         _BOTH_TEXT("EB_CONN_RE_FATAL_ERROR")        },
        {   0,                              _BOTH_TEXT("EA_UNKNOWN_ERROR_CODE")        }
};

STATIC PERROR_INFO ApiErrors[] = {
        ErrorMsgApiGN,
        ErrorMsgApiIC,
        ErrorMsgApiISO,
        ErrorMsgApiRI,
        ErrorMsgApiWCC,
        ErrorMsgApiWSP,
        ErrorMsgApiRT,
        (PERROR_INFO) NULL
};

STATIC PERROR_INFO DrvErrors[] = {
        ErrorMsgDrvGN,
        ErrorMsgDrvIC,
        ErrorMsgDrvISO,
        ErrorMsgDrvRI,
        ErrorMsgDrvWCC,
        ErrorMsgDrvWSP,
        ErrorMsgDrvRT,
        (PERROR_INFO) NULL
};

STATIC PERROR_INFO BrdErrors[] = {
        ErrorMsgBrdGN,
        ErrorMsgBrdIC,
        ErrorMsgBrdISO,
        ErrorMsgBrdRI,
        ErrorMsgBrdWCC,
        ErrorMsgBrdWSP,
        ErrorMsgBrdRT,
        ErrorMsgBrdIE
};

// ****************************************************************************
// STATIC PBOTH_STR_INFO LookupErrorString()
// *********************************
//
// Input parameters :
// ****************
//
//      PmErrorNum:    The error number
//
// Return value :
// **************
//
//      A string corresponding to the error PmErrorNum
//
// ****************************************************************************
//
//  Returns the error string corresponding if any, or convert the error code
// into a string
//
// ****************************************************************************
STATIC PBOTH_STR_INFO LookupErrorString(
    IN PERROR_INFO  PmErrorTab,
    IN WORD         PmErrorNum )
{
    PERROR_INFO     LcErrorInfo ;

    // Verify there is a table for this error class
    // ------------------------------------------------
    if ( PmErrorTab == NULL )
    {
        return( &EmptyString ) ;
    }

    // Scan the table, and lookup a matching error code
    // ------------------------------------------------
    LcErrorInfo = &PmErrorTab[0];
    while (   ( LcErrorInfo->errCode != 0 )
           && ( LcErrorInfo->errCode != PmErrorNum ) )
    {
        LcErrorInfo ++;
    }

    if ( LcErrorInfo->errCode == 0 )
    {
        return( &EmptyString ) ;
    }
    else
    {
        return( &(LcErrorInfo->errMsg) ) ;
    }
}

// ****************************************************************************
// STATIC PBOTH_STR_INFO GenericErrorString()
// LPWSTR PCXErrorStringW()
// LPCHAR PCXErrorStringA()
// **********************
//
// Input parameters :
// ****************
//
//      PmErrorNum:    The error number
//
// Return value :
// **************
//
//      A string corresponding to the error PmErrorNum
//
// ****************************************************************************
//
//  Returns the error string corresponding if any, or convert the error code
// into a string
//
// ****************************************************************************
STATIC PBOTH_STR_INFO GenericErrorString(
    IN WORD PmErrorNum )
{
    PPERROR_INFO    LcErrorListTab = 0;
    PERROR_INFO     LcErrorList ;
    PBOTH_STR_INFO  LcString = 0;
    WORD            LcClass;

    if ( PmErrorNum == SUCCESS )
    {
        LcString = &SuccessString ;
        goto clean_exit ;
    }

    if ( PmErrorNum & ERROR_MASK )
    {                                       // Select the list of errors info

        // First select the appropriate table of error lists according
        // to the error class and origin
        // -----------------------------------------------------------
        switch ( PmErrorNum & SOURCE_MASK )
        {
        case E_SOURCE_API:
            LcErrorListTab = ApiErrors ;
            break ;
        case E_SOURCE_DRV:
            LcErrorListTab = DrvErrors ;
            break;
        case E_SOURCE_BOARD:
            LcErrorListTab = BrdErrors ;
            break;
        default:
            LcString = 0 ;
            goto clean_exit;
        }

        LcClass = ( PmErrorNum & CLASS_MASK ) ;
        if ( LcClass == E_CLASS_FREE )
        {
            LcString = 0 ;
            goto clean_exit;
        }

        LcClass >>= UTIDWMask2Word( CLASS_MASK ) ;

        LcErrorList = LcErrorListTab[LcClass] ;
    }
    else
    {                                       // Use the list of warnings info
        LcErrorList = Warnings ;
    }

    LcString = LookupErrorString( LcErrorList, PmErrorNum ) ;

clean_exit:

    return( LcString );
}
#ifdef WIN32
LPWSTR _CDECL_ PCXErrorStringW(
    IN WORD PmErrorNum )
{
    PBOTH_STR_INFO  LcString = 0;

    LcString = GenericErrorString( PmErrorNum ) ;

    return( LcString ? LcString->bsUnicodeString : 0 );
}
#endif
LPSTR  _CDECL_ PCXErrorStringA(
    IN WORD PmErrorNum )
{
    PBOTH_STR_INFO  LcString = 0;

    LcString = GenericErrorString( PmErrorNum ) ;

    return( LcString ? LcString->bsAnsiString : 0 );
}

