// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#ifndef _common_H_
#define _common_H_

// include files
// *************
#include "apidef.h"

#include "ifapidrv.h"

#define CLOSE_HANDLE(hdl)   { \
	if ( (hdl) && ((hdl) != INVALID_HANDLE_VALUE )) \
{                               \
	CloseHandle( (hdl) );       \
}                               \
	(hdl) = INVALID_HANDLE_VALUE;   \
}

// Exported variables
// ******************
typedef struct _MY_PIPE_INFO {
    DWORDLONG piPipeAudioMask;
    DWORD piPipeChannelMask;
    DWORD piPipeNbChannels;
//    DWORD piStreamChannelMaskArray[MAX_STREAMS];
} MY_PIPE_INFO, *PMY_PIPE_INFO;

typedef struct _SSharedMemory
{
	MY_PIPE_INFO	PipeInfoIn[MAX_INPIPE];
	MY_PIPE_INFO	PipeInfoOut[MAX_INPIPE];
	PCX_HANDLE		DHSAppHandleDLL;
}SSharedMemory, *PSSharedMemory;

// for Get command

extern HANDLE               PCX_HSharedMem;
extern EFFECT_MX_PARAM_INFO TbAudioInMXSettings[MAX_INPIPE];
extern EFFECT_EQ_PARAM_INFO TbAudioInEQSettings[MAX_INPIPE][3 /*bands*/];
extern MY_PIPE_INFO         *TbPipeInfo_IN;
extern MY_PIPE_INFO         *TbPipeInfo_OUT;

//EXTERN HANDLE hInstance;
#ifdef __cplusplus
extern "C" {
#endif
EXTERN PCX_HANDLE RegisterTab[MAX_PCX_HANDLE];
EXTERN PCX_HANDLE* g_pDHSAppHandleDLL;
#ifdef __cplusplus
}
#endif

// typedef of handles for exchanging pointers to request/reply block
//
typedef LPBC_HEADER_INFO    FAR * BC_HEADER_HANDLE;
typedef LPRESP_HEADER_INFO  FAR * RESP_HEADER_HANDLE;

// Exported functions
// ******************


#ifdef __cplusplus
extern "C" {
#endif

// ****************************************************************************
// VOID COMCallDriver()
// ************************
//
// Input parameters :
// ****************
// LPBC_HEADER_INFO   PmReq     : points to the request block already filled
//                               by API.
// RESP_HEADER_HANDLE PmRespHdl : a pointer to a response block already
//                               allocated or set to NULL
//
// Output parameters :
// ****************
// RESP_HEADER_HANDLE PmRespHdl : a pointer to the response block filled by
//                               the driver.
//
// ****************************************************************************
// This function is used to send a command to the driver. It returns a
// reply command block filled-in and allocates it if necessary.
//
// ****************************************************************************
EXTERN VOID COMCallDriver(
    IN    LPBC_HEADER_INFO    PmReq,
    IN    DWORD               PmReqSize,
    INOUT RESP_HEADER_HANDLE  PmRespHdl,
    IN    HANDLE              PmEventHandle );

// ****************************************************************************
// VOID COMAsynchronCommandFinishedOrAborted()
// ************************
//
// Input parameters :
// ****************
// PVOID    PmOverlapped: pointer to structure OVERLAPPED.
//
// Output parameters :
// ****************
// BOOL     bRet: TRUE if command is finished or aborted.
//
// ****************************************************************************
// This function is used to see if a asynchron command is finished/cancelled
// Useful when commands like PCXWait*** were cancelled by the system.
// This happens when Windows NT/2000 Threads ended that called this function !
// ****************************************************************************
EXTERN BOOL COMAsynchronCommandFinishedOrAborted( IN PVOID  PmOverlapped );

// BOOL COMCreateLocalMutex()
// *************************
//
// ****************************************************************************
// This function create the global mutex object
//
// ****************************************************************************
EXTERN BOOL COMCreateLocalMutex(IN LPSECURITY_ATTRIBUTES pSecurityHeritable );

// ****************************************************************************
// BOOL COMCreateGlobalMutex()
// *************************
//
// ****************************************************************************
// This function create the global mutex object
//
// ****************************************************************************
EXTERN BOOL COMCreateGlobalMutex(IN LPSECURITY_ATTRIBUTES pSecurityHeritable );

// ****************************************************************************
// VOID COMCloseLocalMutex()
// *************************
//
// ****************************************************************************
// This function close the local mutex object
//
// ****************************************************************************
EXTERN VOID COMCloseLocalMutex(VOID);

// ****************************************************************************
// BOOL COMCloseGlobalMutex()
// *************************
//
// ****************************************************************************
// This function close the global mutex object
//
// ****************************************************************************
EXTERN VOID COMCloseGlobalMutex(VOID);

// ****************************************************************************
// BOOL COMCreateDummySyncOverlapped()
// *************************
//
// Output parameters :
// ****************
// BOOL     bRet: TRUE if overlapped object has been successfully created.
//
// ****************************************************************************
// This function create the overlapped synchronisation object
//
// ****************************************************************************
EXTERN BOOL COMCreateDummySyncOverlapped(VOID );

// ****************************************************************************
// BOOL COMCreateDriverHandle()
// *************************
//
// Output parameters :
// ****************
// BOOL     bRet: TRUE if driver handle has been successfully created.
//
// ****************************************************************************
// This function create the driver handle
//
// ****************************************************************************
EXTERN BOOL COMCreateDriverHandle(VOID );

// ****************************************************************************
// VOID COMCloseDriver()
// *************************
//
// ****************************************************************************
// This function close the local mutex object
//
// ****************************************************************************
EXTERN VOID COMCloseDriver(VOID);

// ****************************************************************************

// ****************************************************************************
// BOOL COMWaitGlobalExmut()
// *************************
//
// ****************************************************************************
// This function waits for the global mutual exclusion object under NT
//
// ****************************************************************************
EXTERN BOOL COMWaitGlobalExmut( void );

// ****************************************************************************
// BOOL COMReleaseGlobalExmut()
// ************************
//
// ****************************************************************************
// This function release the global mutual exclusion object under NT
//
// ****************************************************************************
EXTERN BOOL COMReleaseGlobalExmut( void );

// ****************************************************************************
// BOOL COMWaitExmut()
// ************************
//
// ****************************************************************************
// This function waits for a local mutual exclusion object under NT
//
// ****************************************************************************
EXTERN BOOL COMWaitExmut( void );

// ****************************************************************************
// BOOL COMReleaseExmut()
// ************************
//
// ****************************************************************************
// This function release the local mutual exclusion object under NT
//
// ****************************************************************************
EXTERN BOOL COMReleaseExmut( void );

// ****************************************************************************
// VOID COMFillBcHeader()
// ***************************
//
// Input parameters :
// ****************
//
// BYTE         PmFamily: field family of the header
// BYTE         PmComNum: field command number of the header
// APP_HANDLE   PmHandle: field application handle of the header
// WORD         PmBreqSize: field request block size of the header
// WORD         PmBrspSize: field response block size of the header
// BC_HEADER_HANDLE PmHdHdl: a pointer to a the beginning of an already allocated
//                       header or must be NULL
//
// Output parameters :
// *******************
//
// BC_HEADER_HANDLE PmHdHdl: a pointer to a the beginning of the header filled in
//
//
// ****************************************************************************
//
// This function fills in the header of a control block, and allocate it if
// necessary
//
// ****************************************************************************
EXTERN VOID COMFillBcHeader(
    IN    BYTE             PmFamily,
    IN    BYTE             PmComNum,
    IN    APP_HANDLE       PmHandle,
    IN    DWORD            PmBreqSize,
    IN    WORD             PmBrspSize,
    INOUT BC_HEADER_HANDLE PmHdHdl );
                             
#ifdef __cplusplus
}
#endif

#endif

