//
// ShMemAllocator.h : Digigram shared memory allocation service.
//

#ifndef _SHMEMALLOCATOR_H_
//{
#define _SHMEMALLOCATOR_H_

// Semaphore names
    // SHMEM_ORDER_SEM semaphore protects the processing of a shared memory order.
    // It assures only one shared memory order is processed at a time.
    // It is created by the service and used by the applications.
    #define SHMEM_ORDER_SEM         "Global\\Digigram_ShMem_Oder_Sem"

// Shared memory names
    // SHMEM_ORDER_SHMEM is the shared memory where the shared memory orders are located.
    // It is written by the applications and read by the serice.
    #define SHMEM_ORDER_SHMEM       "Global\\Digigram_ShMem_Order_ShMem"

// Event names
    // SHMEM_ORDER_READY_EVT is the event set by the application to wake up the
    // service when a share memory order has been laced in SHMEM_ORDER_SHMEM
    #define SHMEM_ORDER_READY_EVT   "Global\\Digigram_ShMem_Order_Ready_Evt"
    #define SHMEM_DELIVERED_EVT     "Global\\Digigram_ShMem_Delivered_Evt"


#pragma pack(1)
//{

// Shared memory order
#define _SHMEM_NAME_MAX_SIZE_   128
typedef struct ShMem_Order
        {
            unsigned long mySize; // receive the size of tShMemOrder (used for version compatibility)
            char name[_SHMEM_NAME_MAX_SIZE_];
            unsigned long flags;
            unsigned long sizeHigh;
            unsigned long sizeLow;
            unsigned long lastError;
        } tShMemOrder;

//}
#pragma pack()

//}
#endif
