// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#ifndef _ifapidrv_H_
#define _ifapidrv_H_

#pragma pack(1)

//{

// Include files necessary
// ***********************
#include "basicdef.h"
#include "pcxdef_e.h"
#include "pcxall_e.h"
//#include "dspdef.h"

#define MIN( a, b )     ( (a) < (b) ? (a) : (b) )
#define MAX( a, b )     ( (a) > (b) ? (a) : (b) )

// Start/Pause condition for pipes (PCXStartPipeOnTimeCode, PCXPausePipe)
// This definition is not in pcxall_e.h because the user has not to
// see them.
// ************************************************************
// #define START_PAUSE_IMMEDIATE         0
// #define START_PAUSE_ON_SYNCHRO        1
#define START_PAUSE_ON_TIME_CODE      2

// Constants definitions
// *********************

#define MAX_PCX_HANDLE              128

#define MAX_BUFFER                  1024
#define MAX_BITMAP_BUFFER           1024
#define MAX_AUDIO_PIPE              64
#define MAX_STREAMS                 24

#define MAX_STREAM_PIPE             1
#define MAX_DRV_INPIPE              64
#define MAX_DRV_OUTPIPE             64

// BEWARE: the following constants are also
// described in pcxapi.h
// --
// FS : the constants seen by the API have been moved
//      to pcxdef_e.h and can be used as well in the
//      the driver
// ***************************************************
#define MAX_APPNAME_SIZE            SIZE_MAX_APP_NAME
#define MAX_BOARD_DSP               1
#define MAX_BOARD_INPUTS            64
#define MAX_BOARD_OUTPUTS           64
#define MAX_CURVE_LEVELS            28
#define BOARD_CLOCK_UER             0
#define BOARD_CLOCK_WCL             1
#define BOARD_CLOCK_VIDEO           2
#define BOARD_CLOCK_ETHERSOUND      3
#define BOARD_CLOCK_UER_IN1         4
#define BOARD_CLOCK_UER_IN2         5
#define BOARD_CLOCK_UER_IN3         6
#define BOARD_CLOCK_UER_IN4         7
#define MAX_BOARD_CLOCK_INPUTS      8

#if( MAX_BOARD_INPUTS > MAX_BOARD_OUTPUTS )
#define MAX_BOARD_AUDIO     MAX_BOARD_INPUTS
#else
#define MAX_BOARD_AUDIO     MAX_BOARD_OUTPUTS
#endif


// Max length of DSP file name (including Path)
#define MAX_DSP_FILE_NAME_LEN       172

// Max length of a short file name (= 8+3+.+\0)
#define MAX_SHORT_FILE_NAME_LEN     13

// Length of a board serial number (not including '\0')
#define SERIAL_NUMBER_LEN           16
/*
 * ## FM (06/10/97) -- The name of the various folders where to find the various
 *                     driverNP files!
 * ## FM (08/27/98) -- Add support for NP boards with PLX chip
 */
#define XILINX__PATH    _T("xilinx\\")
#define DSP_____PATH    _T("dsp\\")
#define BOOT____PATH    _T("boot\\")
#define CONTEXT_PATH    _T("context\\")
#define PLUGIN__PATH    _T("plugin\\")
#define HEADER__PATH    _T("header\\")
#define SOURCE__PATH    _T("source\\")
#define EEPROM__PATH    _T("eeprom\\")


// Driver file identifier
// ----------------------
#define PCX_DEVICE_TYPE         FILE_DEVICE_UNKNOWN

// IOCtl command index for PCX software interrupt under NT
// -------------------------------------------------------
#define PCX_IOCTL_INDEX         0x115C


// The common code agreed between the API
// and the driver
// ---------------------------------------
#define IOCTL_PCX_COMMAND           (DWORD) CTL_CODE( (DWORD) PCX_DEVICE_TYPE,    \
                                                      (DWORD) PCX_IOCTL_INDEX,    \
                                                      (DWORD) METHOD_BUFFERED,    \
                                                      (DWORD) FILE_ANY_ACCESS     )
// Driver command execution status
// -------------------------------
#define PROCESSED          0x80
#define NOT_PROCESSED      0x00

// Command family definitions
// --------------------------
#define INVALID_FAM             0
#define GENE_FAM                1
#define IO_BOARD_CTRL_FAM       2
#define PIPE_CTRL_FAM           3
#define IO_PIPE_CTRL_FAM        4
#define STREAM_PIPE_CTRL_FAM    5
#define PIPE_STATUS_FAM         6
#define IO_PIPE_STATUS_FAM      7
#define STREAM_PIPE_STATUS_FAM  8
#define PLAY_RECORD_FAM         9
#define ASYNC_EVT_FAM           10
// This is a special family code for driver private use (e.g. uninstall)
#define PRIVATE_FAM             11
// other common family codes (cont'd)
#define IO_BOARD_STATUS_FAM     12


// This is the driver pseudo application handle
// to avoid a bogus call from application
#define DRIVER_KEY              0xa5

// Application Handle Attribute Masks (Register)
// ----------------------------------------------
#define ALL_APPLICATION_ATTRIB_MASK     0x01
#define PRIVATE_HANDLE_MASK             0x01

// Max I/O address ranges occupied by a board (Hardware Board Features)
// ---------------------------------------------------------------------
#define MAX_IO_RANGES       2

// Caracteristics of an audio (Hardware Board Features)
// -----------------------------------------------------
#define AUDIO_ANALOG_MSK            AUDIO_ANALOG_PRESENT_MASK
#define AUDIO_DIGITAL1_MSK          AUDIO_DIGITAL_SYNCHRO_PRESENT_MASK
#define AUDIO_DIGITAL2_MSK          AUDIO_DIGITAL_DATA_PRESENT_MASK
#define AUDIO_MICRO_MSK             AUDIO_ANALOG_MICRO_PRESENT_MASK
#define AUDIO_LEVEL_MSK             AUDIO_LEVEL_PRESENT_MASK
#define AUDIO_CD_MSK                AUDIO_CD_ANALOG_INPUT_PRESENT_MASK

// Extended values
// ---------------
#define AUDIO_LINE_IN_LEVEL_MSK     AUDIO_LINE_IN_LEVEL_PRESENT_MASK << 8
#define AUDIO_MICRO_IN_LEVEL_MSK    AUDIO_MICRO_IN_LEVEL_PRESENT_MASK << 8
#define AUDIO_CD_IN_LEVEL_MSK       AUDIO_CD_IN_LEVEL_PRESENT_MASK << 8
#define AUDIO_MIC_IN_48V_MSK        AUDIO_MIC_IN_48V_PRESENT_MASK << 8
#define AUDIO_MIC_IN_COMPR_MSK      AUDIO_MIC_IN_COMPRESSOR_PRESENT_MASK << 8

// ciPhysicalInFeature2 in CARD_FEATURES_INFO
// ------------------------------------------
#define AUDIO_MIXED_MICRO_MSK       AUDIO_MIXED_MICRO_PRESENT_MASK
#define AUDIO_SYNC_CONNECTOR_MSK    AUDIO_ON_SYNC_CONNECTOR_PRESENT_MASK

// Possible board options (Hardware Board Features)
// -----------------------------------------------------
#define OPT_TS_CF_EFFECTS		0x01
#define OPT_MPEG123_FORMATS		0x02
#define OPT_EQUALIZER_EFFECTS	0x04
#define OPT_MAXIMIZER_EFFECTS	0x08
#define OPT_PCXVX_V2			0x40
#define OPT_VX_PRO_MODE			0x80

#define OPT_EBT_IS_VX       0x0100
#define PCI_MASTER_OPTION   0x0200

// DSP software special state (Software Board Features)
// -----------------------------------------------------
#define DSP_STATE_CRASHED       0xff


// DSP capabilities, formats supported (Software Board Features, Define Pipe)
// -------------------------------------------------------------------------
#define ONLINE_CAP_MSK          0x00000001
#define OFFLINE_CAP_MSK         0x00000002
//#define MPEGI_CAP_MSK           STREAM_FMT_MPEGI
//#define MPEGII_CAP_MSK          STREAM_FMT_MPEGII
//#define MPEGIII_CAP_MSK         STREAM_FMT_MPEGIII
//#define LIN_8_CAP_MSK           STREAM_FMT_LIN_8
//#define LIN_16_CAP_MSK          STREAM_FMT_LIN_16
//#define LIN_24_CAP_MSK          STREAM_FMT_LIN_24
//#define GSM_CAP_MSK		      STREAM_FMT_GSM
//#define AAC_CAP_MSK		      STREAM_FMT_AAC


// Number of buffers reserved for downloading
// Maximum size of a DSP software is indicated
// in kilo-bytes ( 2/3 * max board mem size in bytes )
// ---------------------------------------------------

#define MAX_DSP_SOFTWARE_SIZE   ( 256 * 1024 )
#define MAX_DOWNLOAD_BUFFERS    64  // Because buffer size can be as little as 4K


// Pipe Attributes Masks (Pipe Definition)
// ----------------------------------------
#define ALL_PIPE_ATTRIB_MASK    0x03

#define OPER_PLAY       0x00
#define OPER_REC        0x01

#define PIPE_PLAYREC_MASK       (OPER_PLAY | OPER_REC)
#define PIPE_OFFLINE_MASK       0x02

// Audio Attributes Masks (Pipe Definition)
// ----------------------------------------
#define ALL_AUDIO_ATTRIB_MASK   (AUDIO_PHYSICAL | AUDIO_VIRTUAL)

#define AUDIO_DHS_CONTROL_MASK  0x10

// Floating levels
// ----------------
// Levels are coded from 0 to 0x1ff ( +0dB = 0x1b7 )
// with a 1/4dB step
//
#define NEGATIVE_INFINITY_LEVEL_VALUE   ( (FLOAT) -110.0 )
#define MAX_LEVEL_DRV_VALUE             ( (WORD) 0x1ff )
#define MAX_LEVEL_VALUE                 MAX_DIGITAL_LEVEL
#define MAX_ANALOG_LEVEL_DRV_VALUE      ( (WORD) 0x1b7 )
#define MAX_ANALOG_LEVEL_VALUE          MAX_ANALOG_LEVEL
#define DRV_LEVEL_STEP                  4
#define INIT_ANALOG_LEVEL               ( (WORD) 0x0 )  // NEGATIVE_INFINITY


/*
Store offset gains in api/drv interface to avoid incoherence
*/
#define OFFSET_LINE_OUT_NP_V2           2400
#define OFFSET_LINE_IN_NP_V2            1750
#define OFFSET_LINE_IN_HR               1550    // Gain Fix  = -16.0dB, CS3310 = +31.5, 31.5 - 16.0 = 15.5

#define OFFSET_LINE_OUT_PV2             2300
#define OFFSET_LINE_IN_PV2              1700
#define OFFSET_MICRO_PV2                5950



#define SEP_SIZE 13 // number of DWORD between the request block header and the
                    // request block body. This is the size of the greatest
                    // asynchronous reply block.

// Out stream set parameters (OUT_STREAM_SET_PARAM_INFO)
// *****************************************************
// Bits to validate parameters (ssqPar1)
#define OUT_STREAM_SET_PARAM_FORMAT_MASK   0x00000001
#define OUT_STREAM_SET_PARAM_AUTOMAT_MASK  0x00000002

// In stream set parameters  (IN_STREAM_SET_PARAM_INFO)
// ****************************************************
// Bits to validate parameters (ssqPar1)
#define IN_STREAM_SET_PARAM_FORMAT_MASK    0x00000001

// Values for uer/wcl syncro (ckSync in CLOCK_INFO)
// ************************************************
#define DRV_SYNC_UNKNOWN            0
#define DRV_NO_SYNC                 1
#define DRV_SYNC_PRESENT            2

// Values for PCXPocket event (wprEvent in WAIT_POCKET_RESP_INFO)
// **************************************************************
#define POCKET_EVENT_NOTHING        0
#define POCKET_EVENT_BOARD_ADDED    1
#define POCKET_EVENT_BOARD_REMOVED  2


// Values for hdWorld (BC_HEADER_INFO)
// ***********************************
#define WORLD_32BITS                0
#define WORLD_16BITS                1

// value of the LPGPIO_REQ_INFO.gpioRequest field
// ********************************************
#define GPIO_CMD_OPEN               1
#define GPIO_CMD_READ               2
#define GPIO_CMD_WRITE              3
#define GPIO_CMD_CLOSE              4
#define GPIO_CMD_FEATURE            5
// temporary fix values for GPIO's : 2 OUT + 2 IN
#define GPIO_NP2_NB_BITS            4
#define GPIO_NP2_WRITE_MASK         0x00000003
#define GPIO_NP2_READ__MASK         0x0000000C
#define GPIO_NP2_FIFO_SIZE          8


// Types Definitions
// *****************

typedef BYTE APP_HANDLE,* PAPP_HANDLE,FAR *LPAPP_HANDLE;

typedef struct  _FIRMWARE_BUFFER {
    LPBYTE  fbAddress;
    DWORD   fbSize;
} FIRMWARE_BUFFER, *LPFIRMWARE_BUFFER;


typedef struct _APP_STR_INFO {
    DWORD       asStringType ;  // 0: Ansi string
                                // 1: Unicode String
#define APP_ANSI_STRING     ((DWORD) 0)
#define APP_UNICODE_STRING  ((DWORD) 1)

    union _u_APP_STR_INFO {
        CHAR    uasAnsiString[MAX_APPNAME_SIZE + 1];
#ifdef _WIN32
        WCHAR   uasUnicodeString[MAX_APPNAME_SIZE + 1];
#endif
    } asString ;

#define asAnsiString    asString.uasAnsiString
#define asUnicodeString asString.uasUnicodeString

} APP_STR_INFO, * PAPP_STR_INFO, FAR * LPAPP_STR_INFO ;

// Control blocks description
// --------------------------

// In every asynchronous request block, the header and the body are separated
// by (3 + n) DWORDs set to zero (where n is the size of the greatest
// asynchronous reply size i.e. 10 at present).
//
typedef DWORD BRQ_SEP_TYPE[SEP_SIZE];

// block header: request blocks and response blocks have the same header.
//
typedef struct _BC_HEADER_INFO {
    BYTE        hdFamily;       // commande family identification
    BYTE        hdComNum;       // commande number within its family
    APP_HANDLE  hdHandle;       // Application handle
    BYTE        hdZero1;
    WORD        hdBrSize;       // Size of the response block
    WORD        hdWorld;        // Call from a 16 or 32 bits world
    DWORD       hdRequestSize;  // Request Size
} BC_HEADER_INFO,* PBC_HEADER_INFO,FAR *LPBC_HEADER_INFO;

// Response Block: every response blocks have the same header (wich included
// the control block header
//
typedef struct _RESP_HEADER_INFO {
    BC_HEADER_INFO  Header;         // block header
    WORD            rhCptr;         // error status
    BYTE            rhZero2;        // unused
    BYTE            rhT;            // flag: 0x80 if the command has been processed
                                    // 0 otherwise
    WORD            rhSize;         // block size
    WORD            rhZero3;
    DWORD           rhZero4;        // unused
} RESP_HEADER_INFO,* PRESP_HEADER_INFO,FAR *LPRESP_HEADER_INFO;

//*****************************************************************************
//  types and constants for the general family commands.
//*****************************************************************************

// Command number definitions

#define INVALID_CMD             0  // relevant for all the families.
#define REG_CMD                 1
#define SYSTEM_FEATURE_CMD      2
#define APP_LIST_CMD            3
#define PIPES_LIST_CMD          4
#define DRIVER_PATH_CMD         5
#define DSP_MANAGE_CMD          6
#define DSP_BUFF_ADDR_CMD       7
#define IO_MANAGE_CMD           8
#define PIPE_DEF_CMD            9
#define PIPE_DEL_CMD            10
#define BOARD_HARD_FEATURE_CMD  11
#define BOARD_SOFT_FEATURE_CMD  12
#define DSP_TRACE_CMD           13
#define DSP_RECOVER_ERROR_CMD   14
#define AUDIO_INFO_CMD          15
#define EFFECT_CTXT_LOAD_CMD    16
#define BOARD_CLOCK_CMD         17
#define UNUSED_CMD              18
#define TIME_CODE_CMD           19
#define DRIVER_TRACE_CMD        20
#define SYNCED_PIPES_CMD        21
#define GPIO_CMD                22
#define BOOST_THREAD_CMD        23
#define DSP_RESOURCES_CMD		24
#define IBL_CMD					25
#define ES_HW_CFG_CMD			26

// value of the  field Handle of a REG_REQ_INFO structure for a register
// command and a unregister command
#define REGISTER_CMD_CDE        0xFF
#define UNREGISTER_CMD_CDE      0x00

// value of the  field NbBuff of a DSP_USE_REQ_INFO structure for a
// Dsp free command and a DSP use command
#define DSP_FREE_CMD_CDE        0xFFFF
#define DSP_USE_CMD_CDE         0

// ## FM (10/14/97) -- Value of the SYSTEM_RESP_INFOS.sfTypeMem field
//
//#define MEM_CONV        ( (BYTE) 0 )
//#define MEM_XMS         ( (BYTE) 1 )
#define MEM_NT_NONPAGED ( (BYTE) 2 )
//#define MEM_95_NONPAGED ( (BYTE) 3 )

// value of the TIME_CODE_REQ_INFO.eepRequest field
//
#define TIME_CODE_CMD_GET             ((BYTE) 1)

// Maximum number of time-code on which a pipe can start.
//
#define MAX_TIME_CODE                 5

// maximum number of bytes that can be read via a call to a driver
// trace request
//
#define DRIVER_TRACE_RESP_LEN         80

// Maximum number of coeff in the stream  equalization.
//
#define MAX_EQUALIZATION_MPEG_COEFF			32		//MPEG
#define MAX_EQUALIZATION_LINEAR_COEFF		3		///LINEAR

// Maximum number of parameters in the requests:
// SET_OUT_STREAM_EFFECTS_CMD and GET_OUT_STREAM_EFFECTS_CMD
//
#define STREAM_EFFECTS_MAX_PARAM      MAX_EQUALIZATION_MPEG_COEFF

//pipe out and audio in effects
//
//#define MAX_EQ_DSP_PARAMS	13
//#define MAX_MX_DSP_PARAMS	6
//#define FX_MAX_USER_PARAMETERS	    MAX_EQ_DSP_PARAMS // max out


//
// Types Definitions
// *****************

// REGISTER/Deregister commande request block
//
typedef struct _REG_REQ_INFO {
    BC_HEADER_INFO Header;          // block header
    DWORD           rgqZero;        // unused
    BYTE            rgqAttributes;  // Application attributes
                                    //  bit0:  1: private handle
                                    //         0: public handle shareable
    DWORD           rgqWindowHandle;// Application handle windows, if this one want to
                                    // deal with others applications
    DWORD           rgqWindowMessage;// Application Message windows, if this one want to
                                    // deal with others applications
    BYTE            rgqNameSize;    // size of the application name string, this string
                                    // must be ended with a NULL, the NULL character is
                                    // not taken into account in this value
    WORD            rgqZero1;       // unused
    DWORD           rgqZero2;       // unused
    DWORD           rgqAppInfoEx;   // used to identify App
    APP_STR_INFO    rgqAppName;     // String representing the
                                    // application name
} REG_REQ_INFO,* PREG_REQ_INFO,FAR *LPREG_REQ_INFO;

// Register/Deregister command response block
//
typedef struct _REG_REP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    APP_HANDLE      rgpHandle;      // application handle for a Register, nothing for a
                                    // Deregister
    BYTE            rgpZero1;       // unused
    WORD            rgpZero2;       // unused
} REG_REP_INFO,* PREG_REP_INFO,FAR *LPREG_REP_INFO;

// System feature command request block
//
typedef struct _SYSTEM_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    DWORD           srqZero;
} SYSTEM_REQ_INFO,* PSYSTEM_REQ_INFO,FAR *LPSYSTEM_REQ_INFO;

// System feature response block
//
typedef struct _SYSTEM_RESP_INFO {
    RESP_HEADER_INFO    RespHeader; // common response header
    BYTE                sfRelease;  // release number
    BYTE                sfNVers;    // version number
    BYTE                sfTVers;    // type of version
                                    //      0: driver RELEASE version
                                    //      1: driver ALPHA version
                                    //      2: driver BETA version
    BYTE                sfZero1;
    DWORD               sfAllocBuff; // total number of buffer allocated
    DWORD               sfAvailBuff; // number of buffer available
    DWORD               sfBuffSize; // buffer size
    BYTE                sfTypeMem;  // memory type
    BYTE                sfZero4[3];
    WORD                sfPresentBoard; // Mask of present boards
    WORD                sfZero5;
    DWORD               sfZero6[12];
} SYSTEM_RESP_INFO,*PSYSTEM_RESP_INFO,FAR *LPSYSTEM_RESP_INFO;

// I/O Range
//
typedef struct _IO_RANGE_INFO {
    PORT_ADDRESS_TYPE   ioStart;
    PORT_ADDRESS_TYPE   ioEnd;
} IO_RANGE_INFO, * PIO_RANGE_INFO, FAR * LPIO_RANGE_INFO;

// Hardware board feature command request block
//
typedef struct _BOARD_HARD_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    WORD            bhrBoardMask;   // Mask of requested board
    WORD            bhrZero;
} BOARD_HARD_REQ_INFO,* PBOARD_HARD_REQ_INFO,FAR *LPBOARD_HARD_REQ_INFO;

// Hardware board feature response block
//
typedef struct _BOARD_HARD_RESP_INFO {
    RESP_HEADER_INFO    RespHeader; // common response header
    BYTE                bhfBoardType;   // board Type
    BYTE                bhfBus;         // bus interface of the board
    BYTE                bhfExtendedType;    // extended board Type
    BYTE                bhfZero1;
    BYTE                bhfSn;          // number of Synchro input(s)
    BYTE                bhfNbWcl;       // Number of word clock inputs
    BYTE                bhfMiscFeatures; // Presence of SMPTE...
    BYTE                bhfMiscFeatures2;// Presence of COM ports...
    BYTE                bhfDspNum;      // number of DSP
    BYTE                bhfMACAddress[6];
    WORD                bhfOptions;
    IO_RANGE_INFO       bhfIO[MAX_IO_RANGES]; // I/O address ranges of board
    DWORD               bhfEtherSound0;     /**<Board specific EtherSound data.*/
    DWORD               bhfEtherSound1;     /**<Board specific EtherSound data.*/
    WORD                bhfIrqNum;      // IRQ used by the board
    WORD                bhfCSID;
    DWORD               bhfZero5[2];
    BYTE                bhfOutAudio[MAX_BOARD_OUTPUTS];
    BYTE                bhfInAudio[MAX_BOARD_INPUTS];
    BYTE                bhfExtraInAudio[MAX_BOARD_INPUTS];
    BYTE                bhfInAudio2[MAX_BOARD_INPUTS];
    BYTE                bhfOutAudio2[MAX_BOARD_OUTPUTS];
} BOARD_HARD_RESP_INFO,*PBOARD_HARD_RESP_INFO,FAR *LPBOARD_HARD_RESP_INFO;

// Software board feature command request block
//
typedef struct _BOARD_SOFT_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    WORD            bsrBoardMask;   // Mask of requested board
    WORD            bsrZero;
} BOARD_SOFT_REQ_INFO,* PBOARD_SOFT_REQ_INFO,FAR *LPBOARD_SOFT_REQ_INFO;

// Software board feature response block
//
typedef struct _BOARD_SOFT_RESP_INFO {
    RESP_HEADER_INFO    RespHeader; // common response header
    BYTE                bsfDspNum;  // number of DSP present
    BYTE                bsfZero1[3];
    DWORD               bsfZero2[2];
} BOARD_SOFT_RESP_INFO,*PBOARD_SOFT_RESP_INFO,FAR *LPBOARD_SOFT_RESP_INFO;

// The following structure describes one DSP one a board.
// There will have as many structure like this as DSP on the board
//
typedef struct _DRV_DSP_INFO {
    BYTE    ddiDspState;    // DSP state
                            //      0: unused DSP
                            //   0xff: DSP software crashed
                            //     >0: software loaded on the DSP
    BYTE    ddiZero1;
    BYTE    ddiZero5;
    BYTE    ddiZero2;
    BYTE    ddiAppNum;      // Number of applications using this DSP
    BYTE    ddiZero3[3];
    DWORD   diZero4[2];
} DRV_DSP_INFO,* PDRV_DSP_INFO,FAR *LPDRV_DSP_INFO;

// This structure appears after DSP_INFO structure if the DSP state is != 0
//
typedef struct _DSP_SOFT_INFO {
    WORD        dsiManagedPhysOut;  // managed physical output
    WORD        dsiManagedVirtOut;  // managed virtual output
    WORD        dsiManagedPhysIn;   // managed physical input
    WORD        dsiManagedVirtIn;   // managed virtual input
    DWORDLONG   dsiPhysOut;         // available physical output mask
    DWORDLONG   dsiVirtOut;         // available virtual output mask
    DWORDLONG   dsiPhysIn;          // available physical input mask
    DWORDLONG   dsiVirtIn;          // available virtual input mask
    BYTE        dsiMaxBoardOutStream; // max number of streams managed
    BYTE        dsiMaxPipeOutStream;  // max number of streams per pipe
    WORD        dsiZero1;
    DWORD       dsiFirmwareVersion;	/**The firmware version 0x00MMmmbb, update is required if MM or mm do not match the driver.*/
    DWORD       dsiZero2;
} DSP_SOFT_INFO,* PDSP_SOFT_INFO,FAR *LPDSP_SOFT_INFO;

#define MAX_BOARD_SOFT_RESP_SIZE  \
        (  sizeof ( BOARD_SOFT_RESP_INFO ) \
         + MAX_BOARD_DSP * (  sizeof( DRV_DSP_INFO ) \
                            + sizeof( DSP_SOFT_INFO ) ) )

// Read board external clock command request block
//
typedef struct _GET_BOARD_CLOCK_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    WORD            bcrBoardMask;   // Mask of requested board
    WORD            bcrZero;
    DWORD           bcrZero2;
} GET_BOARD_CLOCK_REQ_INFO,* PGET_BOARD_CLOCK_REQ_INFO,
  FAR *LPGET_BOARD_CLOCK_REQ_INFO;

// Read board external clock response block
//
typedef struct _BOARD_CLOCK_INFO {
    BYTE                bcType;
    BYTE                bcZero3[3];
    DWORD               bcFrequency;
    DWORD               bcVal2;        // unused: only for sake of matching
                                       // the SAMPLE_CLK_REQ struct
    BYTE                bcSync;
    BYTE                bcZero4[3];
} BOARD_CLOCK_INFO, *PBOARD_CLOCK_INFO, FAR *LPBOARD_CLOCK_INFO;

typedef struct _GET_BOARD_CLOCK_RESP_INFO {
    RESP_HEADER_INFO    RespHeader; // common response header
    WORD                bcpNbClockInputs;
    WORD                bcpZero;
    BOARD_CLOCK_INFO    bcpClock[MAX_BOARD_CLOCK_INPUTS];
} GET_BOARD_CLOCK_RESP_INFO,*PGET_BOARD_CLOCK_RESP_INFO,
  FAR *LPGET_BOARD_CLOCK_RESP_INFO;

// Application list command request
//
typedef struct _APP_LIST_REQ_INFO {
    BC_HEADER_INFO  alqHeader;
    DWORD           alqZero1;
} APP_LIST_REQ_INFO, * PAPP_LIST_REQ_INFO, FAR * LPAPP_LIST_REQ_INFO;

// Application list response
//
typedef struct _APP_LIST_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    BYTE            alpNbHandle;    // number of public applications
    BYTE            alpZero1;
    WORD            alpZero2;
    DWORD           alpZero3;
    // followed by alpNbHandle structure APP_DESC
} APP_LIST_RESP_INFO,* PAPP_LIST_RESP_INFO,FAR *LPAPP_LIST_RESP_INFO;

// The following structure describes the public application, and there are
// as many of it as public application in the structure APP_LIST_RESP_INFO
//
typedef struct _APP_DESC {
    BYTE            adHandle;
    BYTE            adZero1;
    BYTE            adAttribut;
    BYTE            adZero2;
    APP_STR_INFO    adAppName;     // String representing the
                                   // application name
    DWORD           adWindowHandle;
    DWORD           adWindowMessage;
    DWORD           adAppInfoEx;
} APP_DESC,* PAPP_DESC,FAR * LPAPP_DESC;

#define MAX_APP_LIST_RESP_SIZE (  sizeof( APP_LIST_RESP_INFO ) \
                                + MAX_PCX_HANDLE * sizeof( APP_DESC ) )

// Pipes list command request
//
typedef struct _PIPE_LIST_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    APP_HANDLE      plqHandle;
    BYTE            plqZero1;
    DWORD           plqZero2;
} PIPE_LIST_REQ_INFO,* PPIPE_LIST_REQ_INFO,FAR *LPPIPE_LIST_REQ_INFO;

// Pipes list response
//
typedef struct _PIPE_LIST_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    BYTE            plpNbIn;
    BYTE            plpNbOut;
    WORD            plpZero1;
    DWORD           plpZero2[2];
    // followed by "plpNbOut + plpNbIn" PIPE_DESC structures
} PIPE_LIST_RESP_INFO,* PPIPE_LIST_RESP_INFO,FAR * LPPIPE_LIST_RESP_INFO;

// PIPE_DESC structure
//
typedef struct _PIPE_DESC_INFO {
    ULARGE_INTEGER  pdPipeMask64;
    BYTE            pdNbIO;
    BYTE            pdMaxStream;
    WORD            pdPipeAttrib;
    DWORD           pdZero;
} PIPE_DESC_INFO,* PPIPE_DESC_INFO,FAR *LPPIPE_DESC_INFO;

#define MAX_PIPE_LIST_RESP_SIZE (  sizeof( PIPE_LIST_RESP_INFO ) \
                                 + MAX_DRV_INPIPE * sizeof( PIPE_DESC_INFO ) \
                                 + MAX_DRV_OUTPIPE * sizeof( PIPE_DESC_INFO ) )

// Sync'ed Pipes list command request
typedef struct _SYNCED_PIPE_LIST_REQ_INFO
{
    BC_HEADER_INFO      Header;   // block header
    APP_HANDLE          splqHandle;
    BYTE                splqZero1;
    DWORD               splqZero2;
} SYNCED_PIPE_LIST_REQ_INFO,* PSYNCED_PIPE_LIST_REQ_INFO,
        FAR *LPSYNCED_PIPE_LIST_REQ_INFO;

// Pipes list response
typedef struct _SYNCED_PIPE_LIST_RESP_INFO
{
    RESP_HEADER_INFO    RespHeader;     // common response header
    DWORD               splpNbOfSyncedGroups;
    DWORD               splpUnused;
    // followed by "splpNbOfSyncedGroups SYNCED_PIPE_DESC structures
} SYNCED_PIPE_LIST_RESP_INFO,* PSYNCED_PIPE_LIST_RESP_INFO,
        FAR * LPSYNCED_PIPE_LIST_RESP_INFO;

// SYNC_PIPE_DESC structure
typedef struct _SYNCED_PIPE_DESC_INFO
{
    ULARGE_INTEGER      spdOutPipeMask64;
    ULARGE_INTEGER      spdInPipeMask64;
    DWORD spdUnused;
} SYNCED_PIPE_DESC_INFO,* PSYNCED_PIPE_DESC_INFO,FAR *LPSYNCED_PIPE_DESC_INFO;

#define MAX_SYNCED_PIPE_LIST_RESP_SIZE (  sizeof( SYNCED_PIPE_LIST_RESP_INFO ) \
                                        + MAX_DRV_INPIPE * sizeof( SYNCED_PIPE_DESC_INFO ) \
                                        + MAX_DRV_OUTPIPE * sizeof( SYNCED_PIPE_DESC_INFO ) )

// Driver Path command request
//
typedef struct _DRIVER_PATH_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    WORD            dnqZero1;
    DWORD           dnqZero2;
} DRIVER_PATH_REQ_INFO,* PDRIVER_PATH_REQ_INFO,FAR *LPDRIVER_PATH_REQ_INFO;

// Driver Path response
//
typedef struct _DRIVER_PATH_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    BYTE             dnpSize;                  // string size counting the null
    BYTE             dnpZero[3];
    CHAR             dnpFileName[MAX_DSP_FILE_NAME_LEN];
} DRIVER_PATH_RESP_INFO,* PDRIVER_PATH_RESP_INFO,FAR *LPDRIVER_PATH_RESP_INFO;

// DSP use command request
//
typedef struct _DSP_USE_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    WORD            duqBoardMask;
    BYTE            duqDspMask;
    BYTE            duqZero1;
    WORD            duqNbBuff;
    WORD            duqZero2;
    BYTE            duqNumLog;
    BYTE            duqNumFirm;
    WORD            duqZero4;
    DWORD           duqMustFakeFrequency;
    DWORD           duqDspFeatures;
    // followed by as structure BUFF_DESC as necessary
} DSP_USE_REQ_INFO,* PDSP_USE_REQ_INFO,FAR *LPDSP_USE_REQ_INFO;

// The following structure is used in the DSP_USE_REQ_INFO to describe each
// buffer used to load the DSP software
//
typedef struct _BUFF_DESC_INFO {
    DWORD           bdNumBuff;      // buffer number
    DWORD           bdDataSize;     // size in byte of data
    DWORD           bdZero2;
} BUFF_DESC_INFO,* PBUFF_DESC_INFO,FAR * LPBUFF_DESC_INFO;

#define MAX_DSP_USE_REQ_SIZE ( sizeof( DSP_USE_REQ_INFO ) \
                              + (  MAX_DOWNLOAD_BUFFERS \
                                 * sizeof( BUFF_DESC_INFO )) )

// the dsp management response is only a RESP_HEADER_INFO structure
typedef RESP_HEADER_INFO    DSP_USE_RESP_INFO,
                            *PDSP_USE_RESP_INFO,
                            FAR *LPDSP_USE_RESP_INFO ;


// DSP resources command request
//
typedef struct _DSP_RESOURCES_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    WORD            drqBoardMask;
} DSP_RESOURCES_REQ_INFO,* PDSP_RESOURCES_REQ_INFO,FAR *LPDSP_RESOURCES_REQ_INFO;

// DSP consumption command response
//
typedef struct _DSP_RESOURCES_RESP_INFO {
    RESP_HEADER_INFO	Header;				// block header
    DWORD				drpDspCurrentCounter;	
    DWORD				drpDspRefCounter;	
	WORD				drpMemAvailable;		// size of available memory 
	WORD				drpMemSize;				// total memory size
} DSP_RESOURCES_RESP_INFO,* PDSP_RESOURCES_RESP_INFO,FAR *LPDSP_RESOURCES_RESP_INFO;


// buffer management
typedef struct _HANDLE_BUFFER {
    // ## FM (07/17/98) -- As this structure is part of an other structure
    //                     passed to the driver, its size must be the same
    //                     whatever the number of buffers.
    //
    DWORD   hbMask[ MAX_BITMAP_BUFFER / ( sizeof(DWORD) * 8 ) ];
} HANDLE_BUFFER, * PHANDLE_BUFFER;

// DSP Buffer addresses command request
//
typedef struct _DSP_BUFF_REQ_INFO {
    BC_HEADER_INFO      Header;     // block header
} DSP_BUFF_REQ_INFO, *PDSP_BUFF_REQ_INFO, FAR *LPDSP_BUFF_REQ_INFO;

// DSP Buffer addresses command reply
//
typedef struct _DSP_BUFF_RESP_INFO {
    RESP_HEADER_INFO    RespHeader; // common response header
    WORD                dbReservedBuffers;
    WORD                dbZero;
                        // to be continued...
                        // followed by one ADD_DESC_INFO structure
                        // per reserved buffer
} DSP_BUFF_RESP_INFO, *PDSP_BUFF_RESP_INFO, FAR *LPDSP_BUFF_RESP_INFO;

// the following structure describes a buffer address
//
typedef struct _ADD_DESC_INFO {
    DWORD   adAddr1;
    DWORD   adAddr2; // selector (if used by a 16 bits application)
    DWORD   adAddr3;
} ADD_DESC_INFO,* PADD_DESC_INFO,FAR * LPADD_DESC_INFO;

#define MAX_DSP_BUFF_RESP_SIZE  (  sizeof( DSP_BUFF_RESP_INFO ) \
                                 + (  MAX_DOWNLOAD_BUFFERS \
                                    * sizeof( ADD_DESC_INFO ) ) )

// The following structure is found within the IO_MNGT_REQ_INFO.
// It describes the intputs-outputs on a dsp
//
typedef struct _DSPIO_DESC_INFO {
    BYTE            dioBoardNum;
    BYTE            dioDspNum;
    WORD            dioZero1;
    DWORD           dioPhysOutMask;
    DWORD           dioVirtOutMask;
    DWORD           dioPhysInMask;
    DWORD           dioVirtInMask;
    DWORD           dioZero2;
} DSPIO_DESC_INFO,* PDSPIO_DESC_INFO,FAR *LPDSPIO_DESC_INFO;

// the inputs-outputs management response is only
// a RESP_HEADER_INFO structure

// Pipe definition command
//
typedef struct _PIPE_DEF_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    BYTE            pdqMaxStream;   // Max number of streams
    BYTE            pdqZero1;
    BYTE            pdqAudioNum;    // Number of audio
    BYTE            pdqZero2;
    WORD            pdqAttributes;  // Pipe attributes
    WORD            pdqBuffersNum;  // Number of buffers
    WORD            pdqManagement;  // Pipe attributes
    WORD            pdqZero3;
    DWORD           pdqChannelMask; // like in WAVE_FORMAT_EXTENSIBLE
    DWORD           pdqBufferSize;
                    // to be continued...
                    // followed by "pdqMaxStream" PIPE_STREAM_INFO records
                    // then followed by "pdqAudioNum" PIPE_AUDIO_INFO records
} PIPE_DEF_REQ_INFO,* PPIPE_DEF_REQ_INFO,FAR * LPPIPE_DEF_REQ_INFO;

typedef struct _PIPE_STREAM_INFO {
    DWORD           psFormat;       // Requested formats (mask)
    DWORD           psBitRate;      // Requested bit rate
    DWORD           psZero[3];
} PIPE_STREAM_INFO,* PPIPE_STREAM_INFO,FAR * LPPIPE_STREAM_INFO;

typedef struct _PIPE_AUDIO_INFO {
    BYTE            paBoard;        // board selected
    BYTE            paDsp;          // Dsp selected
    WORD            paAudioNum;     // audio number selected
    WORD            paAudioAttributes; // audio attributes
                                       //    bit0:  1: physical audio
                                       //           0: virtual audio
    WORD            paZero1;
    DWORD           paZero2[3];
} PIPE_AUDIO_INFO, * PPIPE_AUDIO_INFO, FAR * LPPIPE_AUDIO_INFO ;

#define MAX_PIPE_DEF_REQ_SIZE (  sizeof( PIPE_DEF_REQ_INFO )        \
                               + (  MAX_STREAM_PIPE                 \
                                  * sizeof( PIPE_STREAM_INFO ) )    \
                               + (  MAX_AUDIO_PIPE                  \
                                  * sizeof( PIPE_AUDIO_INFO ) ) )

// Pipe definition command reply
//
typedef struct _PIPE_DEF_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    ULARGE_INTEGER  pdpPipeMask64;
    WORD            pdpMaxAllocatedStream; // used for under allocation
    WORD            pdpZero1;
    WORD            pdpBuffersNum;
    WORD            pdpZero2;
                    // to be continued...
                    // followed by "pdpBuffersNum" ADD_DESC_INFO
} PIPE_DEF_RESP_INFO,* PPIPE_DEF_RESP_INFO ,FAR * LPPIPE_DEF_RESP_INFO;

#define MAX_PIPE_DEF_RESP_SIZE  (  sizeof( PIPE_DEF_RESP_INFO )     \
                                 + ( MAX_BUFFER * sizeof( ADD_DESC_INFO ) ) )

// pipe delete request
//
typedef struct _PIPE_REM_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  prqOutMask64;
    ULARGE_INTEGER  prqInMask64;
} PIPE_REM_REQ_INFO,* PPIPE_REM_REQ_INFO,FAR * LPPIPE_REM_REQ_INFO;

// The pipe removing response is only a RESP_HEADER_INFO structure
typedef RESP_HEADER_INFO    PIPE_REM_RESP_INFO,
                            *PPIPE_REM_RESP_INFO,
                            FAR *LPPIPE_REM_RESP_INFO;



typedef struct _DSP_TRACE_REQ_INFO {
    BC_HEADER_INFO  Header;
    WORD            dspCarteNum;
    WORD            dspDspNum;
    WORD            dspRequest;
    WORD            dspParam1;
    WORD            dspParam2;
                    // possibly followed by
                    // dspParam2 DWORD params
} DSP_TRACE_REQ_INFO, * PDSP_TRACE_REQ_INFO, FAR * LPDSP_TRACE_REQ_INFO;

typedef RESP_HEADER_INFO DSP_TRACE_RESP_INFO,
                        * PDSP_TRACE_RESP_INFO,
                        FAR * LPDSP_TRACE_RESP_INFO;

#define MAX_DSP_TRACE_RESP_SIZE     (sizeof(RESP_HEADER_INFO) + 256)

#define SUBREQ_FORCE_RESYNCSSI          0
#define SUBREQ_FORCE_CLEAR_DBG          1
#define SUBREQ_FORCE_WRITE_CODEC_REG    2
#define SUBREQ_FORCE_DSP_TYPE           3
#define SUBREQ_FORCE_DUMP_MAILBOX       4
#define SUBREQ_FORCE_IRQB               5
#define SUBREQ_FORCE_SET_MUTE_OUT       6
#define SUBREQ_FORCE_XTAL_CLOCK         7
#define SUBREQ_TRIGGER_IRB_TIMER        8
#define SUBREQ_SET_SPEED_RATIO          9
#define SUBREQ_DUMP_MEM_LXES            10
#define SUBREQ_DUMP_RESET_LXES          11
#define SUBREQ_PARK_MICROBLAZE          12

typedef struct _DRIVER_TRACE_REQ_INFO {
    BC_HEADER_INFO  Header;
    WORD            driRequest;
    WORD            driParam1;
    WORD            driParam2;
    WORD            driParam3;
    WORD            driParam4;
    DWORD           driParams[5]; // extension
} DRIVER_TRACE_REQ_INFO, * PDRIVER_TRACE_REQ_INFO, FAR * LPDRIVER_TRACE_REQ_INFO;

typedef struct _DRIVER_TRACE_RESP_INFO {
    RESP_HEADER_INFO RespHeader;
    WORD            driBufferLen;
    WORD            driRemaining;
    BYTE            driBuffer[DRIVER_TRACE_RESP_LEN];
} DRIVER_TRACE_RESP_INFO, *PDRIVER_TRACE_RESP_INFO, FAR * LPDRIVER_TRACE_RESP_INFO;

// FH 25/02/97 V3 management
// add a new structure

// DSP error recovering command request
//
typedef struct _DSP_ERROR_REQ_INFO {
    BC_HEADER_INFO  Header;
    WORD            derqCarteNum;
    WORD            derqDspNum;
} DSP_ERROR_REQ_INFO, * PDSP_ERROR_REQ_INFO, FAR * LPDSP_ERROR_REQ_INFO;

// DSP error recovering command reply
//
typedef struct _DSP_ERROR_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    WORD            derspDspError;
    WORD            derspZero;
} DSP_ERROR_RESP_INFO,* PDSP_ERROR_RESP_INFO ,FAR * LPDSP_ERROR_RESP_INFO;


// FH 26/02/97 V3 management
// add a new structure

// Application audio owner command request
//
typedef struct _APP_AUDIO_OWNER_REQ_INFO {
    BC_HEADER_INFO  Header;
    PIPE_AUDIO_INFO AudioInf;
} APP_AUDIO_OWNER_REQ_INFO , * PAPP_AUDIO_OWNER_REQ_INFO, FAR * LPAPP_AUDIO_OWNER_REQ_INFO;

// Application audio owner command reply
//
typedef struct _APP_AUDIO_OWNER_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    APP_DESC        AppliInf;
} APP_AUDIO_OWNER_RESP_INFO, * PAPP_AUDIO_OWNER_RESP_INFO, FAR * LPAPP_AUDIO_OWNER_RESP_INFO;

typedef struct _EFFECT_CTXT_LOAD_REQ_INFO {
    BC_HEADER_INFO  Header;
    ULARGE_INTEGER  ecqOutPipeMask64;
    DWORD           ecqZero1;
    DWORD           ecqZero2;
    PCX_EFFECT_HANDLE ecqEffectID;
    WORD            ecqContextID;
    WORD            ecqNbBuffers;
    WORD            ecqZero3;
    DWORD           ecqZero4;
    // followed by as many BUFF_DESC_INFO descriptors as
    // buffers containing the context
    // --------------------------------------------------
} EFFECT_CTXT_LOAD_REQ_INFO, * PEFFECT_CTXT_LOAD_REQ_INFO,
  FAR * LPEFFECT_CTXT_LOAD_REQ_INFO;

#define MAX_EFFECT_CTXT_LOAD_REQ_SIZE ( sizeof( EFFECT_CTXT_LOAD_REQ_INFO ) \
                                       + (  MAX_DOWNLOAD_BUFFERS \
                                          * sizeof( BUFF_DESC_INFO )) )

typedef struct _EFFECT_CTXT_LOAD_RESP_INFO {
    RESP_HEADER_INFO RespHeader;
    BYTE            ecrContextNum;
    BYTE            ecrZero1;
    WORD            ecrZero2;
} EFFECT_CTXT_LOAD_RESP_INFO, * PEFFECT_CTXT_LOAD_RESP_INFO,
  FAR * LPEFFECT_CTXT_LOAD_RESP_INFO;



typedef struct _ELEM_GPIO_INFO
{
	WORD		gpioBoardNumber;	/* one Board */
	WORD		gpioUnused0;
	DWORD		gpioNum;			/* GPIO number */
	DWORD		gpioType;			/* le type ( Input=1 or Output=2,.. )  */ 
	DWORD		gpioData;			/* Data read, or Data to write */
	DWORD		gpioUnused1;		/*  */
	DWORD		gpioUnused2;		/*  */
	DWORD		gpioUnused3;		/*  */
	DWORD		gpioUnused4;		/*  */
} ELEM_GPIO_INFO, *PELEM_GPIO_INFO ;

// GPIO command request block
typedef struct _GPIO_REQ_INFO {
    BC_HEADER_INFO  Header;         // Block header
	DWORD           gpioRequest;     // Request type (write/read...)
	DWORD			gpioTabSize;
	ELEM_GPIO_INFO  gpioTabInfo[1]; //there is "gpioTabSize" element
    
}       GPIO_REQ_INFO,
      * PGPIO_REQ_INFO,
  FAR * LPGPIO_REQ_INFO;

// GPIO response block
typedef struct _GPIO_RESP_INFO {
    RESP_HEADER_INFO    RespHeader;     // Common response header
	DWORD				gpioRequest;     // Request type (write/read...)
	DWORD				gpioTabSize;
	ELEM_GPIO_INFO		gpioTabInfo[1]; //there is "gpioTabSize" element

}       GPIO_RESP_INFO,
      * PGPIO_RESP_INFO,
  FAR * LPGPIO_RESP_INFO;


// IBL command request block
typedef struct _IBL_REQ_INFO {
    BC_HEADER_INFO  Header;         // Block header
	WORD            iblBoardMask;   // queried board 
	WORD           iblSamples;     // number of samples (pipetime) before next IRQ
}       IBL_REQ_INFO,
	* PIBL_REQ_INFO,
FAR * LPIBL_REQ_INFO;

/**
*	IBL response block
*	This structure is returned by the IBL Get/Set command.
*/
typedef struct _IBL_RESP_INFO {
    RESP_HEADER_INFO    RespHeader;     // Common response header. 
	WORD           iblSamples;			// number of samples (pipetime) before next IRQ. 
	WORD           iblMax;				// underruns will occur above this maximum value. 
	WORD           iblMin;				// recommanded minimum value for this board. 
	WORD           iblGranularity;		// granularity, not to overlook! 
	
}       IBL_RESP_INFO,
	* PIBL_RESP_INFO,
FAR * LPIBL_RESP_INFO;


// ESHardwareConfSet command request block
typedef struct _ES_HW_CFG_REQ_INFO {
    BC_HEADER_INFO  Header;             // Block header
	WORD            ehcBoardMask;
    WORD            ehcUnused;
    DWORD           ehcEtherSound0;
    DWORD           ehcEtherSound1;
}       ES_HW_CFG_REQ_INFO,
    *   PES_HW_CFG_REQ_INFO,
FAR *   LES_HW_CFG_REQ_INFO;

// The output pipe effects response is only a RESP_HEADER_INFO structure

// TIME_CODE command request block
//
typedef struct _TIME_CODE_REQ_INFO {
    BC_HEADER_INFO  Header;         // Block header
    WORD            tcoBoardMask;   // Mask of requested board
    BYTE            tcoRequest;     // Request type
} TIME_CODE_REQ_INFO,* PTIME_CODE_REQ_INFO;

// TIME_CODE response block
//
typedef struct _TIME_CODE_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // Common response header
    DWORD           tcoNewTimeCode; // Indicate if it is a new time-code
    DWORD           tcoBackward;    // Receipt time-code direction
    DWORD           tcoConfigInProgress;
                                    // A Config on timeCode is active
    PCX_TIME_CODE   tcoTimeCode;    // Time code.
    PCX_TIME        tcoPcxTime;     // Board reference time
} TIME_CODE_RESP_INFO,*PTIME_CODE_RESP_INFO;


//*****************************************************************************
//  types and constants for all the control family commands:
//      pipe control family commands
//      streams control family commands
//      audio control family commands
//*****************************************************************************

// Constants definitions
// *********************

// Command number definitions for pipe control family commands
//
#define START_PIPES_CMD             1
#define PAUSE_PIPES_CMD             2
#define STOP_PIPES_CMD              3
#define OUT_PIPES_SETTINGS_CMD      4
#define OUT_PIPES_EFFECTS_CMD       5
#define IN_PIPES_SETTINGS_CMD       6
#define OFFLINE_LOOPS_CMD           7
#define SAMPLE_CLOCK_CMD            8
#define NOTIFY_TIME_CMD             9
#define PURGE_DCMDS_CMD             10
#define CHANGE_MONIT_SOURCE_CMD     11

// Command number definitions for audio(pipe) control commands
// Command number definitions for audio(board) control commands
//
#define OUT_AUDIO_SET_LEVELS_CMD    1
#define  IN_AUDIO_SET_LEVELS_CMD    2
#define  IN_AUDIO_SET_EFFECT_CMD    3
#define  IN_AUDIO_SET_PARAM_CMD     4

// Command number definitions for streams(pipe) control commands
//
#define START_STREAM_CMD            1
#define PAUSE_STREAM_CMD            2
#define STOP_STREAM_CMD             3
#define RESERVED_STREAM_CMD         4
#define OUT_STREAM_SETTINGS_CMD     5
#define OUT_STREAM_LEVELS_CMD       6
#define SET_OUT_STREAM_EFFECTS_CMD  7
#define IN_STREAM_SETTINGS_CMD      8
#define OUT_STREAM_LCURVE_CMD       9
#define NOTIFY_STREAM_TIME_CMD      10
#define CANCEL_STR_BUFFER_CMD       11
#define CANCEL_BUFFER_PAUSE_CMD     12

// Types Definitions
// *****************

// Start pipe, pause pipe and stop pipe command request blocks
//
typedef struct _TIME_CODE_START_INFO {
    BYTE            tcsBoardNum;
    BYTE            tcsNbOfTimeCode;
    WORD            tcsUnused;
    DWORD           tcsSamplesCount;
    PCX_TIME_CODE   tcsTabTimeCode[MAX_TIME_CODE];
} TIME_CODE_START_INFO, *PTIME_CODE_START_INFO,FAR * LPTIME_CODE_START_INFO;

typedef struct _PIPE_CMD_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  spqOutPipeMask64;
    ULARGE_INTEGER  spqInPipeMask64;
    BYTE            spqDiffered;
    BYTE            spqZero1;
    WORD            spqZero2;
    PCX_TIME        spqHour;
    BYTE            spqAttributes; // one of the START_PAUSE_* constants
    TIME_CODE_START_INFO spqTimeCodeStart;
} PIPE_CMD_REQ_INFO, *PPIPE_CMD_REQ_INFO,FAR * LPPIPE_CMD_REQ_INFO;

// Start pipe, pause pipe and stop pipe command response blocks
//
typedef struct _PIPE_CMD_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    PCX_TIME        sprHour;
} PIPE_CMD_RESP_INFO, *PPIPE_CMD_RESP_INFO,FAR * LPPIPE_CMD_RESP_INFO;

// Output pipe settings command
typedef struct _OUT_PIPE_SET_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  opqOutPipeMask64;
    BYTE            opqDiffered;
    BYTE            opqZero1;
    WORD            opqZero2;
    PCX_TIME        opqHour;
    DWORD           opqPar1;
    DWORD           opqPar2;
    BYTE            opqUer;
    BYTE            opqUerExtra;
    WORD            opqZero4;
    DWORD           opqFrequency;
    BYTE            opqMpeg;
    BYTE            opqBackward;
    WORD            opqZero6;
} OUT_PIPE_SET_REQ_INFO,* POUT_PIPE_SET_REQ_INFO,FAR * LPOUT_PIPE_SET_REQ_INFO;

// The output pipe settings response is only a RESP_HEADER_INFO structure

#define FX_MAX_USER_PARAMETERS  7

// output pipe effects request block
//
typedef struct _OUT_PIPE_EFFECTS_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  oeqOutPipeMask64;
    BYTE            oeqDiffered;
    BYTE            oeqZero1;
    WORD            oeqZero2;
    PCX_TIME        oeqHour;
    PCX_EFFECT_HANDLE       oeqEffectID;
    WORD            oeqZero3;
    WORD            oeqMode;
    WORD            oeqZero4;
    DWORD           oeqParams[FX_MAX_USER_PARAMETERS];
    DWORD           oeqZero5;
} OUT_PIPE_EFFECTS_REQ_INFO,* POUT_PIPE_EFFECTS_REQ_INFO,
  FAR * LPOUT_PIPE_EFFECTS_REQ_INFO;


// The output pipe effects response is only a RESP_HEADER_INFO structure

// Input pipe settings command
typedef struct _IN_PIPE_SET_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  ipqInPipeMask64;
    BYTE            ipqDiffered;
    BYTE            ipqZero1;
    WORD            ipqZero2;
    PCX_TIME        ipqHour;
    DWORD           ipqPar1;
    DWORD           ipqPar2;
    BYTE            ipqSource;
    BYTE            ipqADProperties;
    WORD            ipqZero3;
} IN_PIPE_SET_REQ_INFO,* PIN_PIPE_SET_REQ_INFO,FAR * LPIN_PIPE_SET_REQ_INFO;

// The input pipe settings response is only a RESP_HEADER_INFO structure

// Offline loops command
//
typedef struct _OFFLINE_LOOPS_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    BYTE            olqNbLoops;
    BYTE            olqZero1;
    WORD            olqZero2;
    // followed by "olqNbLoops" structures LOOPS_DESC_INFO
} OFFLINE_LOOPS_REQ_INFO,* POFFLINE_LOOPS_REQ_INFO,
  FAR * LPOFFLINE_LOOPS_REQ_INFO;

// The following structures is found within the structure
// OFFLINE_LOOPS_REQ_INFO and describes each inputs - outputs
// that must be in the loop
//
typedef struct _LOOPS_DESC {
    ULARGE_INTEGER  ldOutPipeMask64;
    WORD            ldOutMask;
    WORD            ldZero3;
    DWORD           ldZero4;
    ULARGE_INTEGER  ldInPipeMask64;
    WORD            ldInMask;
    WORD            ldZero5;
    DWORD           ldZero6;
} LOOPS_DESC_INFO,* PLOOPS_DESC_INFO,FAR * LPLOOPS_DESC_INFO;

// The offline loops response is only a RESP_HEADER_INFO structure

#define MAX_OFFLINE_LOOPS_REQ_SIZE  (   sizeof( OFFLINE_LOOPS_REQ_INFO ) \
                                     +  (  MAX_AUDIO_PIPE                \
                                         * MAX_DRV_INPIPE                    \
                                         * sizeof( LOOPS_DESC_INFO ) ) )

// ## FM (10/26/98) -- Change monitoring source command
//
typedef struct _MONIT_CHANGES_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    BYTE            mcqNbChanges;
    BYTE            mcqZero1;
    WORD            mcqZero2;
    // followed by "mcqNbChanges" CHANGE_DESC_INFO structures
} MONIT_CHANGES_REQ_INFO,* PMONIT_CHANGES_REQ_INFO,
  FAR * LPMONIT_CHANGES_REQ_INFO;

// The following structures is found within the MONIT_CHANGES_REQ_INFO structure
// and describes for each audio outputs the new source (an audio input) for
// monitoring.
//
typedef struct _CHANGE_DESC {
    ULARGE_INTEGER  cdOutPipeMask64;
    WORD            cdOutMask;
    WORD            cdZero3;
    DWORD           cdZero4;
    ULARGE_INTEGER  cdInPipeMask64;
    WORD            cdInMask;
    BYTE            cdZero6;
    BYTE            cdPrivateBoard;
    WORD            cdPrivateAudioIn;
    WORD            cdPrivateAudioOut;
} CHANGE_DESC_INFO,* PCHANGE_DESC_INFO,FAR * LPCHANGE_DESC_INFO;

// The change monitoring source response is only a RESP_HEADER_INFO structure

#define MAX_MONIT_CHANGES_REQ_SIZE  (   sizeof( MONIT_CHANGES_REQ_INFO ) \
                                     +  (  MAX_AUDIO_PIPE                \
                                         * MAX_DRV_OUTPIPE               \
                                         * sizeof( CHANGE_DESC_INFO ) ) )

// Notify pipe nth command request
//
typedef struct _NOTIFY_PIPE_TIME_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    BYTE            nptqDiffered;
    BYTE            nptqZero1;
    WORD            nptqZero2;
    PCX_TIME        nptqHour;
    DWORD           nptqZero3;
    ULARGE_INTEGER  nptqOutPipeMask64;
    ULARGE_INTEGER  nptqInPipeMask64;
    DWORD           nptqZero4;
} NOTIFY_PIPE_TIME_REQ_INFO,* PNOTIFY_PIPE_TIME_REQ_INFO,
  FAR * LPNOTIFY_PIPE_TIME_REQ_INFO;

// The notify pipe time response is only a RESP_HEADER_INFO structure

// Purge differed commands request
//
typedef struct _PURGE_DCMDS_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    BYTE            pdqDiffered;
    BYTE            pdqZero1;
    WORD            pdqZero2;
    DWORD           pdqParam1;
    DWORD           pdqParam2;
    DWORD           pdqZero3;
    ULARGE_INTEGER  pdqOutPipeMask64;
    ULARGE_INTEGER  pdqInPipeMask64;
    DWORD           pdqZero4;
    WORD            pdqCommandCode;     // commands to cancel
} PURGE_DCMDS_REQ_INFO,* PPURGE_DCMDS_REQ_INFO,
  FAR * LPPURGE_DCMDS_REQ_INFO;

// The purge differed commands response is only a RESP_HEADER_INFO structure

// Set output levels and set input levels command request blocks
// for pipe-relative audios
//
typedef struct _OUT_AUDIO_SET_LEVEL_REQ_INFO {
    DWORD           oasliPar1;
    DWORD           oasliPar2;
    WORD            oasliAnalogLevel;
    WORD            oasliZero4;
    WORD            oasliDigitalLevel;
    WORD            oasliZero5;
    WORD            oasliMonitorLevel;
    WORD            oasliZero6;
    WORD            oasliMute;
    WORD            oasliZero7;
    WORD            oasliMonitorMute1;
    WORD            oasliZero8;
    WORD            oasliMonitorMute2;
    WORD            oasliZero9;
} OUT_AUDIO_SET_LEVEL_REQ_INFO, *POUT_AUDIO_SET_LEVEL_REQ_INFO,
 FAR *LPOUT_AUDIO_SET_LEVEL_REQ_INFO;

typedef struct _OUT_AUDIO_SET_LEVELS_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  oslqPipeMask64;
    WORD            oslqAudioMask;
    WORD            oslqZero1;
    BYTE            oslqDiffered;
    BYTE            oslqZero2;
    WORD            oslqZero3;
    PCX_TIME        oslqHour;
    OUT_AUDIO_SET_LEVEL_REQ_INFO    oslqLevelInfo ;
} OUT_AUDIO_SET_LEVELS_REQ_INFO, * POUT_AUDIO_SET_LEVELS_REQ_INFO,
  FAR * LPOUT_AUDIO_SET_LEVELS_REQ_INFO;

typedef struct _IN_AUDIO_SET_LEVEL_REQ_INFO {
    DWORD           iasliPar1;
    DWORD           iasliPar2;
    WORD            iasliAnalogLevel;
    WORD            iasliMicroLevel;
    WORD            iasliDigitalLevel;
    BYTE            iasliAnalogMute;
    BYTE            iasliMicroMute;
} IN_AUDIO_SET_LEVEL_REQ_INFO, * PIN_AUDIO_SET_LEVEL_REQ_INFO,
  FAR *LPIN_AUDIO_SET_LEVEL_REQ_INFO;

typedef struct _IN_AUDIO_SET_LEVELS_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  islqPipeMask64;
    WORD            islqAudioMask;
    WORD            islqZero1;
    BYTE            islqDiffered;
    BYTE            islqZero2;
    WORD            islqZero3;
    PCX_TIME        islqHour;
    IN_AUDIO_SET_LEVEL_REQ_INFO islqLevelInfo;
} IN_AUDIO_SET_LEVELS_REQ_INFO, * PIN_AUDIO_SET_LEVELS_REQ_INFO,
  FAR * LPIN_AUDIO_SET_LEVELS_REQ_INFO;

// The set output levels and set input level response blocks
// for pipe-relative audios are only RESP_HEADER_INFO structures
/*
typedef struct _IN_AUDIO_EFFECT_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    union
    {
        DWORD       iaqInPipeMask;
        DWORD       iaqInBoardMask;
    } u;
    WORD            iaqInAudioMask;
    WORD            iaqIdentifier;
    LONG            iaqCompThreshold;
    LONG            iaqCompRatio;
    LONG            iaqNoiseThreshold;
    LONG            iaqOutputGain;
} IN_AUDIO_EFFECT_REQ_INFO, * PIN_AUDIO_EFFECT_REQ_INFO,
  FAR *LPIN_AUDIO_EFFECT_REQ_INFO;
*/

typedef struct _IN_AUDIO_EFFECT_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    WORD                iaqInAudioMask;
    PCX_EFFECT_HANDLE   iaqIdentifier;
    DWORD               iaqCommand;  /*SET GET REMOVE, when applicable*/

    union
    {
        DWORD       iaqInPipeMask;
        WORD        iaqInBoardNum;
    } iaqHandle ;

    union
    {
      struct {
            LONG            iaqCompThreshold;
            LONG            iaqCompRatio;
            LONG            iaqNoiseThreshold;
            LONG            iaqOutputGain;
      } hw; /* HW_EFFECT_COMPRESSOR_LIMITER */

      DWORD Param[FX_MAX_USER_PARAMETERS]; /* EFFECT_MAXIMIZER, EFFECT_EQUALIZATION_PIPE	*/

    } iaqParams;
    WORD			iaqNbParams;

} IN_AUDIO_EFFECT_REQ_INFO, * PIN_AUDIO_EFFECT_REQ_INFO,
  FAR *LPIN_AUDIO_EFFECT_REQ_INFO;


// input AUDIO effects RESPONSE block
//
typedef struct _IN_AUDIO_EFFECT_RESP_INFO { /* GET command */
    RESP_HEADER_INFO  RespHeader;   // common response header
    DWORD             iapParams[FX_MAX_USER_PARAMETERS];
} IN_AUDIO_EFFECT_RESP_INFO,* PIN_AUDIO_EFFECT_RESP_INFO,
  FAR * LPIN_AUDIO_EFFECT_RESP_INFO;


// The input audio set effect response is only a RESP_HEADER_INFO structure

typedef struct _IN_AUDIO_PARAM_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    DWORD           iapqInBoardMask;
    WORD            iapqInAudioMask;
    DWORD           iapqValidationMask;
    WORD            iapqMic48V;
} IN_AUDIO_PARAM_REQ_INFO, * PIN_AUDIO_PARAM_REQ_INFO,
  FAR *LPIN_AUDIO_PARAM_REQ_INFO;

// The input audio set param response is only a RESP_HEADER_INFO structure

// Set output levels and set input levels command request blocks
// for board-relative audios
//
typedef struct _OUT_BOARD_AUDIO_SET_LEVELS_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    PIPE_AUDIO_INFO obslqAudio;
    BYTE            obslqDiffered;
    BYTE            obslqZero2;
    WORD            obslqZero3;
    PCX_TIME        obslqHour;
    OUT_AUDIO_SET_LEVEL_REQ_INFO    obslqLevelInfo ;
} OUT_BOARD_AUDIO_SET_LEVELS_REQ_INFO, * POUT_BOARD_AUDIO_SET_LEVELS_REQ_INFO,
  FAR * LPOUT_BOARD_AUDIO_SET_LEVELS_REQ_INFO;

typedef struct _IN_BOARD_AUDIO_SET_LEVELS_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    PIPE_AUDIO_INFO ibslqAudio;
    BYTE            ibslqDiffered;
    BYTE            ibslqZero2;
    WORD            ibslqZero3;
    PCX_TIME        ibslqHour;
    IN_AUDIO_SET_LEVEL_REQ_INFO ibslqLevelInfo;
} IN_BOARD_AUDIO_SET_LEVELS_REQ_INFO, * PIN_BOARD_AUDIO_SET_LEVELS_REQ_INFO,
  FAR * LPIN_BOARD_AUDIO_SET_LEVELS_REQ_INFO;

// The set output levels and set input level response blocks
// for board-relative audios are only RESP_HEADER_INFO structures

// Streams commands command request blocks
//
typedef struct _STREAM_CMD_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  scqOutPipeMask64;
    ULARGE_INTEGER  scqInPipeMask64;
    DWORD           scqStreamMask;
    BYTE            scqDiffered;
    BYTE            scqZero1;
    WORD            scqZero2;
    PCX_TIME        scqHour;
} STREAM_CMD_REQ_INFO,* PSTREAM_CMD_REQ_INFO, FAR * LPSTREAM_CMD_REQ_INFO;

// The streams commands response blocks are only RESP_HEADER_INFO structures


// Output stream levels command request block
//
typedef struct _OUT_STREAM_LEVELS_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  slqOutPipeMask64;
    DWORD           slqStreamMask;
    BYTE            slqDiffered;
    BYTE            slqZero1;
    WORD            slqZero2;
    PCX_TIME        slqHour;
    DWORD           slqPar1;
    DWORD           slqPar2;
    WORD            slqLeftChannelToOutput1DigitalLevel ;
    WORD            slqZero3;
    WORD            slqLeftChannelToOutput2DigitalLevel ;
    WORD            slqZero4;
    WORD            slqRightChannelToOutput1DigitalLevel ;
    WORD            slqZero5;
    WORD            slqRightChannelToOutput2DigitalLevel ;
    WORD            slqZero6;
    WORD            slqDigitalLevel1 ;
    WORD            slqZero7;
    WORD            slqDigitalLevel2 ;
    WORD            slqZero8;
    WORD            slqMute1 ;
    WORD            slqZero9;
    WORD            slqMute2;
    WORD            slqZero10;
} OUT_STREAM_LEVELS_REQ_INFO,* POUT_STREAM_LEVELS_REQ_INFO,
  FAR * LPOUT_STREAM_LEVELS_REQ_INFO;

// The output stream levels response block is only a RESP_HEADER_INFO structure

// Set output stream effects command request block
//
typedef struct _SET_OUT_STREAM_EFFECTS_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  sseqOutPipeMask64;
    DWORD           sseqStreamMask;
    BYTE				sseqDiffered;
    PCX_EFFECT_HANDLE	sseqEffectId;
    BYTE				sseqZero1;
    PCX_TIME        sseqHour;
    DWORD           sseqZero2;
    DWORD           sseqParam[STREAM_EFFECTS_MAX_PARAM];
    DWORD           sseqZero3;
    DWORD           sseqZero4;
} SET_OUT_STREAM_EFFECTS_REQ_INFO,* PSET_OUT_STREAM_EFFECTS_REQ_INFO,
  FAR * LPSET_OUT_STREAM_EFFECTS_REQ_INFO;

// The set output stream effects response block is only a RESP_HEADER_INFO structure


#define BIT_FMP_HEADER          23
#define BIT_FMP_SD              22
#define BIT_FMP_MULTICHANNEL    19


typedef struct _STREAM_SETTINGS {
    ULARGE_INTEGER  PipeMask64;
    DWORD           StreamMask;
    BYTE            Differed;
    BYTE            Automation;
    WORD            Zero1;
    PCX_TIME        Hour;
    DWORD           Par1;
    DWORD           Par2;
    DWORD           dwChannelMask;
    DWORD           dwSamplesPerChannel;
    DWORD           DeCodeForm1;
    DWORD           DeCodeForm2;
    DWORD           DeCodeForm3;
} STREAM_SETTINGS,* PSTREAM_SETTINGS,
  FAR * LPSTREAM_SETTINGS;


// Input stream settings command request block
//
typedef struct _IN_STREAM_SETTINGS_REQ_INFO {
    BC_HEADER_INFO      Header;         // block header
    STREAM_SETTINGS     isq;
} IN_STREAM_SETTINGS_REQ_INFO,* PIN_STREAM_SETTINGS_REQ_INFO,
  FAR * LPIN_STREAM_SETTINGS_REQ_INFO;

// The input stream settings response block is only a RESP_HEADER_INFO structure


// Output stream settings command request block
//
typedef struct _OUT_STREAM_SET_REQ_INFO {
    BC_HEADER_INFO      Header;         // block header
    STREAM_SETTINGS     ssq;
} OUT_STREAM_SET_REQ_INFO,* POUT_STREAM_SET_REQ_INFO,
  FAR * LPOUT_STREAM_SET_REQ_INFO;

// The output stream settings response block is only a RESP_HEADER_INFO structure

// Output stream level curve command request block
//
typedef struct _OUT_STREAM_LCURVE_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  oslqOutPipeMask64;
    DWORD           oslqStreamMask;
    BYTE            oslqDiffered;
    BYTE            oslqZero1;
    WORD            oslqZero2;
    PCX_TIME        oslqHour;
    DWORD           oslqPar1;
    DWORD           oslqPar2;
    WORD            oslqLevelNumber;
    WORD            oslqZero3;
    DWORD           oslqStep;
    DWORD           oslqZero4;
    WORD            oslqLevelValue[(MAX_CURVE_LEVELS + 1)/2];
} OUT_STREAM_LCURVE_REQ_INFO,* POUT_STREAM_LCURVE_REQ_INFO,
  FAR * LPOUT_STREAM_LCURVE_REQ_INFO;

// The Output stream level curve response block is
// only a RESP_HEADER_INFO structure

// Notify stream time command request block
//
typedef struct _NOTIFY_STREAM_TIME_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    BYTE            nstqDiffered;
    BYTE            nstqZero1;
    WORD            nstqZero2;
    PCX_TIME        nstqHour;
    DWORD           nstqZero3;
    ULARGE_INTEGER  nstqOutPipeMask64;
    ULARGE_INTEGER  nstqInPipeMask64;
    DWORD           nstqStreamMask;
    DWORD           nstqZero4;
} NOTIFY_STREAM_TIME_REQ_INFO,* PNOTIFY_STREAM_TIME_REQ_INFO,
  FAR * LPNOTIFY_STREAM_TIME_REQ_INFO;

// The notify stream time command response block is
// only a RESP_HEADER_INFO structure

// Cancel stream buffer command request block
//
typedef struct _CANCEL_BUFFER_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    BYTE            cbqDiffered;
    BYTE            cbqZero1;
    WORD            cbqZero2;
    PCX_TIME        cbqHour;
    DWORD           cbqZero3;
    ULARGE_INTEGER  cbqOutPipeMask64;
    ULARGE_INTEGER  cbqInPipeMask64;
    DWORD           cbqStreamMask;
    DWORD           cbqBuffNum;
    DWORD           cbqZero4;
} CANCEL_BUFFER_REQ_INFO,* PCANCEL_BUFFER_REQ_INFO,
  FAR * LPCANCEL_BUFFER_REQ_INFO;

// Cancel stream buffer command reply block
//
typedef struct _CANCEL_BUFFER_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    DWORD           cbrCancelledNumber;
} CANCEL_BUFFER_RESP_INFO, *PCANCEL_BUFFER_RESP_INFO,
  FAR * LPCANCEL_BUFFER_RESP_INFO;

// Cancel pause at end of buffer command request block
//
typedef struct _CANCEL_PAUSE_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    BYTE            cbpqDiffered;
    BYTE            cbpqZero1;
    WORD            cbpqZero2;
    PCX_TIME        cbpqHour;
    DWORD           cbpqZero3;
    ULARGE_INTEGER  cbpqOutPipeMask64;
    DWORD           cbpqStreamMask;
    DWORD           cbpqBuffNum;
    DWORD           cbpqZero4;
} CANCEL_PAUSE_REQ_INFO,* PCANCEL_PAUSE_REQ_INFO,
  FAR * LPCANCEL_PAUSE_REQ_INFO;

// The cancel pause at end of buffer command reply block
// is only a RESP_HEADER_INFO structure

//*****************************************************************************
//  types and constants for the private family
//*****************************************************************************

#define RESERVED_PRIVATE_CMD    1

//*****************************************************************************
//  types and constants for all the status family commands:
//      pipe status family commands
//      pipe audio inputs-outputs status family commands
//      stream pipe status family commands
//*****************************************************************************

// Constants definitions
// *********************

// Command numbers for pipe status family
#define SAMPLE_COUNTING_CMD         1
#define PIPE_STATE_CMD              2
#define PIPE_GET_NOTIFICATION_CMD   3
#define PIPE_GET_CLOCK_CMD          4

// Command numbers for pipe  audio inputs-outputs status family
// Command numbers for board audio inputs-outputs status family
#define AUDIO_VU_PEAK_METERS_CMD    1
#define UER_CMD                     2
#define OUT_AUDIO_GET_LEVELS_CMD    3
#define IN_AUDIO_GET_LEVELS_CMD     4
#define IN_AUDIO_GET_CBYTE_CMD      5

// Command numbers for stream pipe status family
#define STREAM_VU_PEAK_METERS_CMD   1
#define STREAM_STATE_CMD            2
#define STREAM_SAMPLE_CMD           3
#define STREAM_BYTE_CMD				4
#define STREAM_POSITION_CMD			5
#define OUT_STREAM_GET_LEVELS_CMD   6
#define GET_OUT_STREAM_EFFECTS_CMD  7

// Types Definitions
// *****************

// Sample counting and pipe state commands request block
//
typedef struct _PIPE_STATUS_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  scqOutputPipeMask64;
    ULARGE_INTEGER  scqInputPipeMask64;
    BYTE            scqForceActual; /*force read of the board clock*/
    BYTE            scqZero[7];
} PIPE_STATUS_INFO,* PPIPE_STATUS_INFO,FAR * LPPIPE_STATUS_INFO;

// Sample counting response block
//
typedef struct _SAMPLE_COUNTING_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    DWORD            scpReserved[2];
    PCX_TIME         scpSampleCount;
} SAMPLE_COUNTING_RESP_INFO,* PSAMPLE_COUNTING_RESP_INFO,
  FAR *LPSAMPLE_COUNTING_RESP_INFO;

// Pipe state response block
//
typedef struct _PIPE_STATE_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    BYTE            pspStart;
    BYTE            pspZero1;
    WORD            pspZero2;
} PIPE_STATE_RESP_INFO,*PPIPE_STATE_RESP_INFO,FAR * LPPIPE_STATE_RESP_INFO;

// Pipe read notification request block
//
typedef struct _PIPE_NOTIFICATION_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  pnqOutPipeMask64;
    ULARGE_INTEGER  pnqInPipeMask64;
    DWORD           pnqZero;                // Free for future use
} PIPE_NOTIFICATION_REQ_INFO, * PPIPE_NOTIFICATION_REQ_INFO,
  FAR * LPPIPE_NOTIFICATION_REQ_INFO;

// Pipe read notification request block
//
typedef struct _PIPE_NOTIFICATION_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    ULARGE_INTEGER  pnrOutPipeMask64;
    ULARGE_INTEGER  pnrInPipeMask64;
    WORD            pnrCommandCode; // command notified
    WORD            pnrZero1;       // unused
    BYTE            pnrDiffered;    // differed param of the command
    BYTE            pnrZero2;       // unused
    WORD            pnrZero3;       //
    PCX_TIME        pnrHour;        // notification time
    DWORD           pnrParam1;      // 1st param of the command
    DWORD           pnrParam2;      // 2nd param of the command
    DWORD           pnrZero4;       // Free for future use
} PIPE_NOTIFICATION_RESP_INFO, * PPIPE_NOTIFICATION_RESP_INFO,
  FAR * LPPIPE_NOTIFICATION_RESP_INFO;

// Get pipe clock request block
//
typedef PIPE_STATUS_INFO PIPE_GET_CLOCK_REQ_INFO, *PPIPE_GET_CLOCK_REQ_INFO,
 FAR *LPPIPE_GET_CLOCK_REQ_INFO;

// Get pipe clock response block
//
typedef struct _PIPE_GET_CLOCK_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    ULARGE_INTEGER  pcrOutputMask64;
    ULARGE_INTEGER  pcrInputMask64;
    BYTE            pcrSource;
    BYTE            pcrZero1[2];
    BYTE            pcrSRCRatio;
    DWORD           pcrFrequency;
    DWORD           pcrZero2;
    BYTE            pcrSync;
	BYTE			pcrFlags;
    WORD            pcrMisc;
} PIPE_GET_CLOCK_RESP_INFO, *PPIPE_GET_CLOCK_RESP_INFO,
 FAR *LPPIPE_GET_CLOCK_RESP_INFO;

// Vu meter commands request block
//
typedef struct _AUDIO_VUMETER_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  avqOutputPipeMask64;
    ULARGE_INTEGER  avqInputPipeMask64;
    WORD            avqAudioMask;
    WORD            avqZero;
    DWORD           avqZero1[2];
} AUDIO_VUMETER_REQ_INFO,* PAUDIO_VUMETER_REQ_INFO,
  FAR * LPAUDIO_VUMETER_REQ_INFO;

// Audio vu meter response block is a RESP_HEADER_INFO structure
// followed by as VU_METER_RESP_INFO structure than inputs-outputs in avqAudioMask
//
typedef struct _VU_METER_RESP_INFO {
    DWORD           vmVuMeter;
    DWORD           vmPeakMeter;
    BYTE            vmSaturation;
    BYTE            vmZero1[3];
    DWORD           vmZero2;
} VU_METER_RESP_INFO,* PVU_METER_RESP_INFO,FAR *LPVU_METER_RESP_INFO;

#define MAX_VU_METER_RESP_SIZE (  sizeof(RESP_HEADER_INFO) \
                                + (MAX_BOARD_AUDIO * sizeof(VU_METER_RESP_INFO)))

// UER command request block
//
typedef struct _UER_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  urqInputPipeMask64;
    WORD            urqAudioMask;
    WORD            urqZero;
    DWORD           urqZero2[2];
} UER_REQ_INFO,* PUER_REQ_INFO,FAR *LPUER_REQ_INFO;

// UER response block is a RESP_HEADER_INFO structure
// followed by as UER_RESP-INFO structure than inputs-outputs in urqAudioMask
//
typedef struct _UER_RESP_INFO {
    DWORD           urpUnused1;
    BYTE            urpData;
    BYTE            urpUnused2;
    BYTE            urpMode;
    BYTE            urpExtra;
    DWORD           urpFrequency;
} UER_RESP_INFO,* PUER_RESP_INFO,FAR * LPUER_RESP_INFO;

#define MAX_UER_RESP_SIZE (  sizeof(RESP_HEADER_INFO) \
                           + (MAX_AUDIO_PIPE * sizeof(UER_RESP_INFO)))

// Get audio output level command request block
//
typedef struct _OUT_AUDIO_LEVELS_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  olqOutputPipeMask64;
    WORD            olqAudioMask;
    WORD            olqZero;
    DWORD           olqZero2[2];
} OUT_AUDIO_GET_LEVELS_REQ_INFO, * POUT_AUDIO_GET_LEVELS_REQ_INFO,
  FAR *LPOUT_AUDIO_GET_LEVELS_REQ_INFO;

// audio output level response block is a RESP_HEADER_INFO structure
// followed by as OUT_LEVELS_RESP_INFO structure than inputs-outputs
// in ilqAudioMask
//
typedef struct _OUT_AUDIO_GET_LEVELS_RESP_INFO {
    WORD            olpAnalogLevel;
    WORD            olpUnused1;
    WORD            olpDigitalLevel;
    WORD            olpUnused2;
    WORD            olpMonitoringLevel;
    WORD            olpUnused3;
    WORD            olpMute;
    WORD            olpUnused5;
    WORD            olpMonitoringMute1;
    WORD            olpUnused4;
    WORD            olpMonitoringMute2;
    WORD            olpZero1;
    DWORD           olpZero2[2];
} OUT_AUDIO_GET_LEVELS_RESP_INFO, * POUT_AUDIO_GET_LEVELS_RESP_INFO,
  FAR * LPOUT_AUDIO_GET_LEVELS_RESP_INFO;

#define MAX_OUT_LEVELS_RESP_SIZE  \
            (  sizeof( RESP_HEADER_INFO ) \
             + MAX_AUDIO_PIPE * sizeof( OUT_AUDIO_GET_LEVELS_RESP_INFO ) )

// Get audio input level command request block
//
typedef struct _IN__AUDIO_GET_LEVELS_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  ilqInPipeMask64;
    WORD            ilqAudioMask;
    WORD            ilqZero;
    DWORD           ilqZero2[2];
} IN_AUDIO_GET_LEVELS_REQ_INFO, * PIN_AUDIO_GET_LEVELS_REQ_INFO,
  FAR * LPIN_AUDIO_GET_LEVELS_REQ_INFO;

// audio input level response block is a RESP_HEADER_INFO structure
// followed by as IN_LEVELS_RESP_INFO structure than inputs-outputs in
// ilqAudioMask
//
typedef struct _IN_AUDIO_GET_LEVELS_RESP_INFO {
    WORD            ilpAnalogLevel;
    WORD            ilpMicroLevel;
    WORD            ilpDigitalLevel;
    BYTE            ilpAnalogMute;
    BYTE            ilpMicroMute;
    DWORD           ilpZero2;
    DWORD           ilpZero3;
} IN_AUDIO_GET_LEVELS_RESP_INFO, * PIN_AUDIO_GET_LEVELS_RESP_INFO,
  FAR * LPIN_AUDIO_GET_LEVELS_RESP_INFO;

#define MAX_IN_LEVELS_RESP_SIZE  \
            (  sizeof( RESP_HEADER_INFO ) \
             + MAX_AUDIO_PIPE * sizeof( IN_AUDIO_GET_LEVELS_RESP_INFO ) )

// ---

// Vu meter commands request block (board-relative)
//
typedef struct _BOARD_AUDIO_VUMETER_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    PIPE_AUDIO_INFO bavqAudioInf;
} BOARD_AUDIO_VUMETER_REQ_INFO,* PBOARD_AUDIO_VUMETER_REQ_INFO,
  FAR * LPBOARD_AUDIO_VUMETER_REQ_INFO;

typedef struct _BOARD_AUDIO_VUMETER_RESP_INFO {
    RESP_HEADER_INFO    RespHeader; // Common response header
    VU_METER_RESP_INFO  bavrVuMeter;
} BOARD_AUDIO_VUMETER_RESP_INFO, *PBOARD_AUDIO_VUMETER_RESP_INFO,
  FAR *LPBOARD_AUDIO_VUMETER_RESP_INFO;

// UER command request block (board-relative)
//
typedef struct _BOARD_UER_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    PIPE_AUDIO_INFO buqAudioInf;
} BOARD_UER_REQ_INFO,* PBOARD_UER_REQ_INFO,FAR *LPBOARD_UER_REQ_INFO;

typedef struct _BOARD_UER_RESP_INFO {
    RESP_HEADER_INFO    RespHeader; // Common response header
    UER_RESP_INFO       burUer;
} BOARD_UER_RESP_INFO,* PBOARD_UER_RESP_INFO,FAR *LPBOARD_UER_RESP_INFO;

// Get audio output level command request block (board-relative)
//
typedef struct _OUT_BOARD_AUDIO_LEVELS_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    PIPE_AUDIO_INFO oblqAudioInf;
} OUT_BOARD_AUDIO_GET_LEVELS_REQ_INFO, * POUT_BOARD_AUDIO_GET_LEVELS_REQ_INFO,
  FAR *LPOUT_BOARD_AUDIO_GET_LEVELS_REQ_INFO;

typedef struct _OUT_BOARD_AUDIO_LEVELS_RESP_INFO {
    RESP_HEADER_INFO    RespHeader; // Common response header
    OUT_AUDIO_GET_LEVELS_RESP_INFO oblrLevels;
} OUT_BOARD_AUDIO_GET_LEVELS_RESP_INFO, * POUT_BOARD_AUDIO_GET_LEVELS_RESP_INFO,
  FAR *LPOUT_BOARD_AUDIO_GET_LEVELS_RESP_INFO;

// Get audio input level command request block (board-relative)
//
typedef struct _IN_BOARD_AUDIO_GET_LEVELS_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    PIPE_AUDIO_INFO iblqAudioInf;
} IN_BOARD_AUDIO_GET_LEVELS_REQ_INFO, * PIN_BOARD_AUDIO_GET_LEVELS_REQ_INFO,
  FAR * LPIN_BOARD_AUDIO_GET_LEVELS_REQ_INFO;

typedef struct _IN_BOARD_AUDIO_GET_LEVELS_RESP_INFO {
    RESP_HEADER_INFO    RespHeader; // Common response header
    IN_AUDIO_GET_LEVELS_RESP_INFO iblrLevels;
} IN_BOARD_AUDIO_GET_LEVELS_RESP_INFO, * PIN_BOARD_AUDIO_GET_LEVELS_RESP_INFO,
  FAR * LPIN_BOARD_AUDIO_GET_LEVELS_RESP_INFO;

// Get audio input AES3 cbyte command request block (board-relative)
//
typedef struct _IN_AUDIO_GET_CBYTE_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    PIPE_AUDIO_INFO iacqAudioInf;
	BYTE            iacqByteID;
	BYTE            iacqZero1[3];
} IN_AUDIO_GET_CBYTE_REQ_INFO, * PIN_AUDIO_GET_CBYTE_REQ_INFO,
  FAR * LPIN_AUDIO_GET_CBYTE_REQ_INFO;

typedef struct _IN_AUDIO_GET_CBYTE_RESP_INFO {
    RESP_HEADER_INFO    RespHeader; // Common response header
    BYTE                iacpValidity;
	BYTE                iacpByteValue;
    WORD                iacpZero1;
} IN_AUDIO_GET_CBYTE_RESP_INFO, * PIN_AUDIO_GET_CBYTE_RESP_INFO,
  FAR * LPIN_AUDIO_GET_CBYTE_RESP_INFO;

// Get streams vu meter command request block
//
typedef struct _STREAM_VU_METER_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  svqOutPipeMask64;
    DWORD           svqStreamMask;
    WORD            svqAudioMask;
    WORD            svqZero1;
    DWORD           svqZero2;
} STREAM_VU_METER_REQ_INFO,* PSTREAM_VU_METER_REQ_INFO,
  FAR *LPSTREAM_VU_METER_REQ_INFO;

// Get stream vu meter response block is a RESP_HEADER_INFO structure
// followed by as STREAM_VU_METER_RESP_INFO structure than streams in
// svqStreamMask
//
typedef struct _STREAM_VU_METER_RESP_INFO {
    DWORD           svpVuMeter;
    DWORD           svpPeakMeter;
    BYTE            svpSaturation;
    WORD            svpAudioNum;
    BYTE            svpZero1;
} STREAM_VU_METER_RESP_INFO,* PSTREAM_VU_METER_RESP_INFO,
  FAR * LPSTREAM_VU_METER_RESP_INFO;

// Stream State command request block
//
typedef struct _STREAM_STATE_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  ssqOutPipeMask64;
    ULARGE_INTEGER  ssqInPipeMask64;
    DWORD           ssqStreamMask;
} STREAM_STATE_REQ_INFO,* PSTREAM_STATE_REQ_INFO,
  FAR *LPSTREAM_STATE_REQ_INFO;

// Get stream state response block is a RESP_HEADER_INFO structure
// followed by as STREAM_STATE_RESP_INFO structure than streams in
// ssqStreamMask
//
typedef struct _STREAM_STATE_RESP_INFO {
    BYTE            sspStart;
    BYTE            sspZero1[3];
    PCX_TIME        sspHour;
    DWORD           sspZero2;
} STREAM_STATE_RESP_INFO,* PSTREAM_STATE_RESP_INFO,
  FAR * LPSTREAM_STATE_RESP_INFO;

#define MAX_STREAM_STATE_RESP_SIZE \
                (  sizeof( RESP_HEADER_INFO ) \
                 + MAX_STREAM_PIPE * sizeof( STREAM_STATE_RESP_INFO ) )

// Stream Sample Count command request block
//
typedef struct _STREAM_SAMPLE_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  ssqOutPipeMask64;
    ULARGE_INTEGER  ssqInPipeMask64;
    DWORD           ssqStreamMask;
} STREAM_SAMPLE_REQ_INFO,* PSTREAM_SAMPLE_REQ_INFO,
  FAR *LPSTREAM_SAMPLE_REQ_INFO;

// Get stream sample count response block is a RESP_HEADER_INFO structure
// followed by as STREAM_SAMPLE_RESP_INFO structure than streams in
// ssqStreamMask
//
typedef struct _STREAM_SAMPLE_RESP_INFO {
    PCX_TIME        sspZero;
    PCX_TIME        sspHour;
} STREAM_SAMPLE_RESP_INFO,* PSTREAM_SAMPLE_RESP_INFO,
  FAR * LPSTREAM_SAMPLE_RESP_INFO;

#define MAX_STREAM_SAMPLE_RESP_SIZE \
                (  sizeof( RESP_HEADER_INFO ) \
                 + MAX_STREAM_PIPE * sizeof( STREAM_SAMPLE_RESP_INFO ) )

// Get Output Stream levels command request block
//
typedef struct _GET_OUT_STREAM_LEVELS_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  oslqOutPipeMask64;
    DWORD           oslqStreamMask;
} GET_OUT_STREAM_LEVELS_REQ_INFO,* PGET_OUT_STREAM_LEVELS_REQ_INFO,
  FAR *LPGET_OUT_STREAM_LEVELS_REQ_INFO;

// Get Output stream levels response block is a RESP_HEADER_INFO structure
// followed by as STREAM_SAMPLE_RESP_INFO structure than streams in
// oslqStreamMask
//
typedef struct _GET_OUT_STREAM_LEVELS_RESP_INFO {
    WORD            oslrLeftChannelToOutput1DigitalLevel ;
    WORD            oslrZero3;
    WORD            oslrLeftChannelToOutput2DigitalLevel ;
    WORD            oslrZero4;
    WORD            oslrRightChannelToOutput1DigitalLevel ;
    WORD            oslrZero5;
    WORD            oslrRightChannelToOutput2DigitalLevel ;
    WORD            oslrZero6;
    WORD            oslrDigitalLevel1 ;
    WORD            oslrZero7;
    WORD            oslrDigitalLevel2 ;
    WORD            oslrZero8;
    WORD            oslrMute1 ;
    WORD            oslrZero9;
    WORD            oslrMute2;
    WORD            oslrZero10;
} GET_OUT_STREAM_LEVELS_RESP_INFO,* PGET_OUT_STREAM_LEVELS_RESP_INFO,
  FAR * LPGET_OUT_STREAM_LEVELS_RESP_INFO;

#define MAX_GET_OUT_STREAM_LEVELS_RESP_SIZE \
                (  sizeof( RESP_HEADER_INFO ) \
                 + MAX_STREAM_PIPE * sizeof( STREAM_SAMPLE_RESP_INFO ) )


// Get output stream effects command request block
//
typedef struct _GET_OUT_STREAM_EFFECTS_REQ_INFO {
    BC_HEADER_INFO		Header;         // block header
    ULARGE_INTEGER		gseqOutPipeMask64;
    DWORD				gseqStreamMask;
    PCX_EFFECT_HANDLE	gseqEffectId;
    WORD				gseqZero1;
    DWORD				gseqZero2;
} GET_OUT_STREAM_EFFECTS_REQ_INFO,* PGET_OUT_STREAM_EFFECTS_REQ_INFO,
  FAR * LPGET_OUT_STREAM_EFFECTS_REQ_INFO;

// Get output stream effects response block
//
typedef struct _GET_OUT_STREAM_EFFECTS_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    DWORD           gserParam[STREAM_EFFECTS_MAX_PARAM];
    DWORD           gserZero1;
} GET_OUT_STREAM_EFFECTS_RESP_INFO, *PGET_OUT_STREAM_EFFECTS_RESP_INFO,
 FAR *LPGET_OUT_STREAM_EFFECTS_RESP_INFO;


//*****************************************************************************
//  types and constants for the asynchronous family commands.
//*****************************************************************************

// Constants definitions
// *********************

// Command number definitions for play-record family
#define PLAY_CMD                1
#define RECORD_CMD              2

// Command number definitions for asynchronous events family
#define WAIT_ERROR_CMD          1
#define WAIT_ENDOF_PLAY_CMD     2
#define WAIT_ENDOF_RECORD_CMD   3
#define WAIT_NOTIFICATION_CMD   4
#define WAIT_BOARD_PNP_CMD      5
#define WAIT_GPIO_EVENT_CMD     6

// Types Definitions
// *****************

typedef struct  _PLAY_RECORD_DRIVER_INFO {
    LPRESP_HEADER_INFO  dprAdrBlkResp;
    LPBC_HEADER_INFO    dprAdrNextBlk;
    HANDLE_BUFFER       dprHandleBuffer;
    LPBYTE              dprVirtualAddress;  // used by DirectSound/DRIVER_MACOSX
    DWORD               dprPhysicalAddress; // used by DirectSound/DRIVER_MACOSX
    DWORD               dprCurrentLength;
    LPVOID              dprParent;          // pointer to DirectSoundStream / pointer onto IRP under APINP
} PLAY_RECORD_DRIVER_INFO, *PPLAY_RECORD_DRIVER_INFO,
  FAR *LPPLAY_RECORD_DRIVER_INFO;

// Play command request block
// Be careful : the place of plqForDriver must be the same for Record
// Be careful : the place of plqBuffNum must be the same for Record
// command request block
//
typedef struct _PLAY_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    BRQ_SEP_TYPE    Sep;            // used by the driver
    ULARGE_INTEGER  plqOutPipeMask64;
    DWORD           plqStreamMask;
    // Be careful : the place of plqBuffNum must be the same for Record
    // command request block
    DWORD           plqBuffNum;
    WORD            plqZero1;
    WORD            plq9BitsTag;
    DWORD           plqDataLength;
    BYTE            plqPause;
    BYTE            plqZero2;
    BYTE            plqHint;
    BYTE            plqZero3;
    DWORD           plqMBlazeBufIdx;
    DWORD           plqMisc;
    DWORD           plqZeros[2];

    // Be careful : the place of plqForDriver must be the same for Record
    // command request block
    PLAY_RECORD_DRIVER_INFO plqForDriver;
} PLAY_REQ_INFO,* PPLAY_REQ_INFO,FAR *LPPLAY_REQ_INFO;

// The play command response block is only a RESP_HEADER_INFO structure

// Record command request block
// Be careful : the place of rcqForDriver must be the same for Play
// command request block
//
typedef struct _RECORD_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    BRQ_SEP_TYPE    Sep;            // Used by the driver
    ULARGE_INTEGER  rcqInPipeMask64;
    DWORD           rcqStreamMask;
    // Be careful : the place of rcqBuffNum must be the same for Play
    // command request block
    DWORD           rcqBuffNum;
    WORD            rcqZero1;
    WORD            rcq9BitsTag;
    DWORD           rcqDataLength;
    DWORD           rcqZero2;
    DWORD           rcqMBlazeBufIdx;
    DWORD           rcqMisc;
    DWORD           rcqZeros[2];

    // Be careful : the place of rcqForDriver must be the same for Play
    // command request block
    PLAY_RECORD_DRIVER_INFO rcqForDriver;
} RECORD_REQ_INFO, *PRECORD_REQ_INFO, FAR *LPRECORD_REQ_INFO;

// Record response block
//
typedef struct _RECORD_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    DWORD           rrpDataLength;
} RECORD_RESP_INFO,* PRECORD_RESP_INFO,FAR *LPRECORD_RESP_INFO;

typedef struct  _ERR_ENDPLAY_DRIVER_INFO {
    LPRESP_HEADER_INFO  deeAdrBlkResp;  // pointer to reply block
    PDWORD              deeIrp;         // pointer onto IRP under WindowsNT/95
} ERR_ENDPLAY_DRIVER_INFO, *PERR_ENDPLAY_DRIVER_INFO,
  FAR *LPERR_ENDPLAY_DRIVER_INFO;


// Wait error request block
//
typedef struct _WAIT_ERROR_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    BRQ_SEP_TYPE    Sep;            // Used by the driver
    DWORD           weqZero1[2];
    ERR_ENDPLAY_DRIVER_INFO weqForDriver;
} WAIT_ERROR_REQ_INFO,* PWAIT_ERROR_REQ_INFO,FAR *LPWAIT_ERROR_REQ_INFO;

// Wait error response block
//
typedef struct _WAIT_ERROR_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    WORD            wepError;
    BYTE            wepZero[2];
    ULARGE_INTEGER  wepOutPipeMask64;
    ULARGE_INTEGER  wepInPipeMask64;
    DWORD           wepStreamMask;
} WAIT_ERROR_RESP_INFO,* PWAIT_ERROR_RESP_INFO,FAR *LPWAIT_ERROR_RESP_INFO;

// Wait play ended command request block
//
typedef struct _WAIT_ENDOF_PLAY_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    BRQ_SEP_TYPE    Sep;            // Used by the driver
    ULARGE_INTEGER  wpqOutPipeMask64;
    DWORD           wpqZero1[2];
    ERR_ENDPLAY_DRIVER_INFO wpqForDriver;
} WAIT_ENDOF_PLAY_REQ_INFO,* PWAIT_ENDOF_PLAY_REQ_INFO,
  FAR *LPWAIT_ENDOF_PLAY_REQ_INFO;

// The Wait play ended response is only a RESP_HEADER_INFO structure

// Wait record ended command request block
//
typedef struct _WAIT_ENDOF_RECORD_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    BRQ_SEP_TYPE    Sep;            // Used by the driver
    ULARGE_INTEGER  wrqInPipeMask64;
    DWORD           wrqZero1[2];
    ERR_ENDPLAY_DRIVER_INFO wrqForDriver;
} WAIT_ENDOF_RECORD_REQ_INFO,* PWAIT_ENDOF_RECORD_REQ_INFO,
  FAR *LPWAIT_ENDOF_RECORD_REQ_INFO;

// The Wait record ended response is only a RESP_HEADER_INFO structure

// Wait for notification command request block
//
typedef struct _WAIT_NOTIFY_REQ_INFO {
    BC_HEADER_INFO  Header;         // Common block header
    BRQ_SEP_TYPE    Sep;            // Used by the driver
    ULARGE_INTEGER  wnrOutPipeMask64;
    ULARGE_INTEGER  wnrInPipeMask64;
    DWORD           wnrZero;            // free for future use
    ERR_ENDPLAY_DRIVER_INFO wnrForDriver;
} WAIT_NOTIFY_REQ_INFO, * PWAIT_NOTIFY_REQ_INFO,
  FAR * LPWAIT_NOTIFY_REQ_INFO ;

// The Wait for notification response is only a RESP_HEADER_INFO structure

// Wait for PCXPocket command request block
//
typedef struct _WAIT_BOARD_PNP_REQ_INFO {
    BC_HEADER_INFO  Header;         // Common block header
    BRQ_SEP_TYPE    Sep;            // Used by the driver
    DWORD           wpqZero[5];     // free for future use
    ERR_ENDPLAY_DRIVER_INFO wpqForDriver;
} WAIT_BOARD_PNP_REQ_INFO, * PWAIT_BOARD_PNP_REQ_INFO,
  FAR * LPWAIT_BOARD_PNP_REQ_INFO ;

// Wait for PCXPocket command response block
//
typedef struct _WAIT_BOARD_PNP_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    BYTE            wprEvent;       // see POCKET_EVENT_* defines
    BYTE            wprZero1[3];
    WORD            wprBoardMask;
    WORD            wprZero2;
    DWORD           wprZero3[3];
} WAIT_BOARD_PNP_RESP_INFO, * PWAIT_BOARD_PNP_RESP_INFO,
  FAR * LPWAIT_BOARD_PNP_RESP_INFO ;

// Wait for GPIO command request block
//
typedef struct _WAIT_GPIO_REQ_INFO {
    BC_HEADER_INFO  Header;         // Common block header
    BRQ_SEP_TYPE    Sep;            // Used by the driver
    DWORD           wpqZero[5];     // free for future use
    ERR_ENDPLAY_DRIVER_INFO wpqForDriver;
} WAIT_GPIO_REQ_INFO, * PWAIT_GPIO_REQ_INFO,
  FAR * LPWAIT_GPIO_REQ_INFO ;

// Wait for GPIO notify command response block
//
typedef struct _WAIT_GPIO_RESP_INFO {
    RESP_HEADER_INFO RespHeader;    // common response header
    WORD             wgrBoardMask;
    WORD             wgrZero0;
    DWORD            wgrZero1;
    DWORD            wgrZero2;
} WAIT_GPIO_RESP_INFO, * PWAIT_GPIO_RESP_INFO,
  FAR * LPWAIT_GPIO_RESP_INFO ;

//*****************************************************************************
//  types and constants for the synchronous asynchronous family commands.
//      each command of this family behaves synchronously from the application
//      point of view, but asynchronously from the driver point of view.
//*****************************************************************************

// Constants definitions
// *********************


// Types definitions
// *****************

// Sample clock command request block
//
typedef struct _SAMPLE_CLK_REQ_INFO {
    BC_HEADER_INFO  Header;         // block header
    ULARGE_INTEGER  scqOutputMask64;
    ULARGE_INTEGER  scqInputMask64;
    BYTE            scqDiffered;
    BYTE            scqZero1;
    WORD            scqClockBoardMask;
    PCX_TIME        scqHour;
    BYTE            scqSource;
    BYTE            scqClockFormat;
    BYTE            scqZero2[2];
    DWORD           scqClockBoardNum;
    DWORD           scqFrequency;
    DWORD           scqValidationMask;
    DWORD           scqSyncInputNum;
    DWORD           scqZero4[4];    // Reserved for further use
} SAMPLE_CLK_REQ_INFO,* PSAMPLE_CLK_REQ_INFO,FAR *LPSAMPLE_CLK_REQ_INFO;

// The sample clock response block is only a RESP_HEADER_INFO structure

//*****************************************************************************
//
//*****************************************************************************

// FS - 10/10/1996
// Max. size of a request block in DWORDs
//
typedef union _ANY_REQUEST_INFO {
    BC_HEADER_INFO                  arCommon;
    REG_REQ_INFO                    arRegister;
    SYSTEM_REQ_INFO                 arSystemFeature;
    BOARD_HARD_REQ_INFO             arBoardHardFeature;
    BOARD_SOFT_REQ_INFO             arBoardSoftFeature;
    APP_LIST_REQ_INFO               arGetAppli;
    PIPE_LIST_REQ_INFO              arGetPipe;
    SYNCED_PIPE_LIST_REQ_INFO       arSyncedPipes;
    DRIVER_PATH_REQ_INFO            arDriverPath;
    BYTE                            arDspUse[MAX_DSP_USE_REQ_SIZE];
    DSP_BUFF_REQ_INFO               arDspBuff;
    BYTE                            arPipeDef[MAX_PIPE_DEF_REQ_SIZE];
    PIPE_REM_REQ_INFO               arPipeDel;
    DSP_TRACE_REQ_INFO              arDspTrace;
    DRIVER_TRACE_REQ_INFO           arDriTrace;
    BYTE                            arEffectCtxt[MAX_EFFECT_CTXT_LOAD_REQ_SIZE];
    TIME_CODE_REQ_INFO              arTimeCode;
    SAMPLE_CLK_REQ_INFO             arSampleClock;

    PIPE_CMD_REQ_INFO               arPipeCmd;
    OUT_PIPE_SET_REQ_INFO           arOutPipeParams;
    OUT_PIPE_EFFECTS_REQ_INFO       arOutPipeEffects;
    IN_PIPE_SET_REQ_INFO            arInPipeParams;
    IN_AUDIO_EFFECT_REQ_INFO        arInAudioEffect;
    BYTE                            arOfflineLoops[MAX_OFFLINE_LOOPS_REQ_SIZE];
    BYTE                            arMonitChanges[MAX_MONIT_CHANGES_REQ_SIZE];
    OUT_AUDIO_SET_LEVELS_REQ_INFO   arOutSetLevels;
    IN_AUDIO_SET_LEVELS_REQ_INFO    arInSetLevels;

    STREAM_CMD_REQ_INFO             arStreamCmd;
    OUT_STREAM_SET_REQ_INFO         arOutStreamParams;
    OUT_STREAM_LEVELS_REQ_INFO      arOutStreamLevels;
    OUT_STREAM_LCURVE_REQ_INFO      arOutStreamLevelCurve;
    SET_OUT_STREAM_EFFECTS_REQ_INFO arSetOutStreamEffects;
    GET_OUT_STREAM_EFFECTS_REQ_INFO arGetOutStreamEffects;
    IN_STREAM_SETTINGS_REQ_INFO     arInStreamParams;
    PURGE_DCMDS_REQ_INFO            arPurgeDCmds;

    PIPE_STATUS_INFO                arPipeStatus;
    PIPE_NOTIFICATION_REQ_INFO      arPipeNotification;

    AUDIO_VUMETER_REQ_INFO          arAudioVuMeters;
    UER_REQ_INFO                    arUer;
    OUT_AUDIO_GET_LEVELS_REQ_INFO   arOutGetLevels;
    IN_AUDIO_GET_LEVELS_REQ_INFO    arInGetLevels;

    STREAM_VU_METER_REQ_INFO        arStreamVuMeters;
    STREAM_STATE_REQ_INFO           arStreamState;
    GET_OUT_STREAM_LEVELS_REQ_INFO  arStreamLevels;
} ANY_REQUEST_INFO;

// FS - 22/01/1997
// Max. size of an async. request block in DWORDs
//
typedef union _ANY_ASYNC_REQUEST_INFO {
    PLAY_REQ_INFO               aarPlayStream;
    RECORD_REQ_INFO             aarRecordStream;
    WAIT_ERROR_REQ_INFO         aarWaitError;
    WAIT_ENDOF_PLAY_REQ_INFO    aarWaitEndOfPlay;
    WAIT_ENDOF_RECORD_REQ_INFO  aarWaitEndOfRecord;
    WAIT_NOTIFY_REQ_INFO        aarWaitNotification;
    WAIT_BOARD_PNP_REQ_INFO     aarWaitBoardPnp;
    WAIT_GPIO_REQ_INFO          aarWaitGpio;
} ANY_ASYNC_REQUEST_INFO, *PANY_ASYNC_REQUEST_INFO, FAR *LPANY_ASYNC_REQUEST_INFO ;


//*****************************************************************************
//
//*****************************************************************************

typedef union _ANY_REPLY_INFO {
    RESP_HEADER_INFO            apCommon;
    REG_REP_INFO                apRegister;
    SYSTEM_RESP_INFO            apSystemFeatures;
    BOARD_HARD_RESP_INFO        apBoardHardFeatures;
    BYTE                        apBoardSoftFeatures[MAX_BOARD_SOFT_RESP_SIZE];
    BYTE                        apGetAppli[MAX_APP_LIST_RESP_SIZE];
    BYTE                        apGetPipe[MAX_PIPE_LIST_RESP_SIZE];
    BYTE                        apSyncedPipes[MAX_SYNCED_PIPE_LIST_RESP_SIZE];
    DRIVER_PATH_RESP_INFO       apDriverPath;
    BYTE                        apDspBuff[MAX_DSP_BUFF_RESP_SIZE];
    TIME_CODE_RESP_INFO         apTimeCode;
    BYTE                        apPipeDef[MAX_PIPE_DEF_RESP_SIZE];
    SAMPLE_COUNTING_RESP_INFO   apSampleCount;
    PIPE_STATE_RESP_INFO        apPipeState;
    PIPE_NOTIFICATION_RESP_INFO apPipeNotification;
    BYTE                        apOutLevels[MAX_OUT_LEVELS_RESP_SIZE];
    BYTE                        apInLevels[MAX_IN_LEVELS_RESP_SIZE];
    BYTE                        apVuMeters[MAX_VU_METER_RESP_SIZE];
    BYTE                        apUer[MAX_UER_RESP_SIZE];
    BYTE                        apStreamState[MAX_STREAM_STATE_RESP_SIZE];
    BYTE                        apStreamSampleCount[MAX_STREAM_SAMPLE_RESP_SIZE];
    BYTE                        apStreamLevels[MAX_GET_OUT_STREAM_LEVELS_RESP_SIZE];
    BYTE                        apDspTrace[MAX_DSP_TRACE_RESP_SIZE];
    DRIVER_TRACE_RESP_INFO      apDriTrace;
} ANY_REPLY_INFO;

// FS - 22/01/1997
// Max. size of an async. request block in DWORDs
//
typedef union _ANY_ASYNC_REPLY_INFO {
    RESP_HEADER_INFO            aapPlayStream;
    RECORD_RESP_INFO            aapRecordStream;
    WAIT_ERROR_RESP_INFO        aapWaitError;
    WAIT_BOARD_PNP_RESP_INFO    aapWaitBoardPnp;
    RESP_HEADER_INFO            aapWaitEndOfPlay;
    RESP_HEADER_INFO            aapWaitEndOfRecord;
    RESP_HEADER_INFO            aapWaitNotification;
    WAIT_GPIO_RESP_INFO         aapWaitGpio;
} ANY_ASYNC_REPLY_INFO, *PANY_ASYNC_REPLY_INFO, FAR *LPANY_ASYNC_REPLY_INFO ;



//*****************************************************************************
//
//*****************************************************************************

// FS - 16/12/1997
// Max. size of a request that requires unmapping
// buffers. This type will be useful for the driver
// under WindowsNT to write the unmapping requests
// after the union, and proceed to effective
// unmapping once PASSIVE_LEVEL is reached. Note
// that for all these requests the API must send
// a reply block of this size under WindowsNT
// ----------------------------------------------
typedef struct _ANY_UNMAPPING_REPLY_INFO {
    union _REQUEST_REPLY_INFO {
        PIPE_REM_RESP_INFO          rrReleasePipe;
        DSP_USE_RESP_INFO           rrDspUse;
        EFFECT_CTXT_LOAD_RESP_INFO  rrLoadEffectContext;
        REG_REP_INFO                rrUnregister;
    } u;
    ADD_DESC_INFO                   urAddrDescriptors[MAX_BUFFER];
} ANY_UNMAPPING_REPLY_INFO,
  *PANY_UNMAPPING_REPLY_INFO,
 FAR *LPANY_UNMAPPING_REPLY_INFO;

//*****************************************************************************
//
//*****************************************************************************

#define MAX_REQ_SIZE                sizeof(ANY_REQUEST_INFO)
#define MAX_RESP_SIZE               sizeof(ANY_REPLY_INFO)

#define MAX_ASYNC_REQ_SIZE          sizeof(ANY_ASYNC_REQUEST_INFO)
#define MAX_ASYNC_RESP_SIZE         sizeof(ANY_ASYNC_REPLY_INFO)

//}

#pragma pack()

#endif




