//********************************************************************
//
// COPYRIGHT 2005 DIGIGRAM. ALL RIGHTS RESERVED
//
//********************************************************************
//
//  ETHERSOUND.H
//
//  Project          : LXES
//  Description      : header file for Ethersound FPGA interface
//
//  Last Mod $Date: 1/06/06 13:22 $ by $Author: Mtr $
//
//************************************************************************
#ifndef __ETHERSOUND_H_
#define __ETHERSOUND_H_

#define	XES_BASEADDR		0x0007F800		// Ethersound fpga base address	
//
#define XES_RW_GRANULARITY	(XES_BASEADDR + 0x0000)	// adresse du registre EtherSound contenant la granularit
#define		XES_GRAN_MASK	0x00FFFF				// masque des bits significatifs dans le registre de granularite

//
#define XES_RW_FREQUENCY	(XES_BASEADDR + 0x0001)		// adresse du registre EtherSound contenant la frequence des trames
#define		XES_FREQ_FILTER			0x0000FFF0	// filtre pour notifier le changement de source / cadence.				
#define		XES_FREQ_MASK			0x0000FFFF	// condition bits and counter filter mask.
#define		XES_FREQ_IS_PM			0x00008000	// set if primary master
#define		XES_FREQ_NOT_WCK		0x00004000	// (significant if primary master) clear if wordclock, set if local.
#define		XES_FREQ_COUNT8_MASK	0x00001FFF	// compteur 25MHz entre 8 ech.
#define		XES_FREQ_COUNT8_44_MIN  0x00001288	// 25M / [ 44k - ( 44.1k + 48k ) / 2 ] * 8
#define		XES_FREQ_COUNT8_44_MAX	0x000010F0	// 25M / [ ( 44.1k + 48k ) / 2 ] * 8 
#define		XES_FREQ_COUNT8_48_MAX	0x00000F08	// 25M / [ 48k + ( 44.1k + 48k ) / 2 ] * 8

//
#define XES_RO_PEAKMETER_IN0	(XES_BASEADDR + 0x0200)
#define XES_RO_PEAKMETER_OUT0	(XES_BASEADDR + 0x0210)


// 16 bits pf a chaque fois
//
#define OFFSET_A	0		/**< channels 00 to 15.*/
#define OFFSET_B	1		/**< channels 16 to 31.*/
#define OFFSET_C	2		/**< channels 32 to 47.*/
#define OFFSET_D	3		/**< channels 48 to 63.*/
//
#define XES_W_MUTE_PLAY			(XES_BASEADDR + 0x0020)	// registre de  mute (1) ou dmute (0) des voies PLAY
#define XES_W_MUTE_RECORD		(XES_BASEADDR + 0x0030)	// registre de  mute (1) ou dmute (0) des voies RECORD
#define XES_W_ACTIVATE_PLAY		(XES_BASEADDR + 0x0040)	// registre d'activation (1) ou disable (0) des voies PLAY
#define XES_W_ACTIVATE_RECORD	(XES_BASEADDR + 0x0050) // registre d'activation (1) ou disable (0) des voies REC

#define XES_W_RAM_FIFO_BASE		(XES_BASEADDR + 0x0100)	// registre de  prog de l'addresse de base des fifo
#define XES_R_RAM_CUR_BANK		(XES_BASEADDR + 0x0101)	/**< current bank (bit 0).*/


#endif
