// *************************************************************************
//
//  COPYRIGHT 1996-2000 DIGIGRAM. ALL RIGHTS RESERVED.
//
//  DIGIGRAM
//
// **************************************************************************

#ifndef _BASICDEF_H_
#define _BASICDEF_H_

// Included files
// **************


// Constant definitions
// ********************

#undef TRUE
#define TRUE            1

#undef FALSE
#define FALSE           0


// Type definitions
// ****************

// Procedure parameter attributes
// ------------------------------

#ifndef IN
    #define  IN
#endif

#ifndef OUT
    #define OUT
#endif

#ifndef INOUT
    #define INOUT
#endif

#ifndef CONST
    #define CONST               const
#endif


// For static procedure and variable declarations
// ----------------------------------------------

#ifndef STATIC
    #define STATIC              static
#endif


// For extern procedure and variable declarations
// ----------------------------------------------

#ifndef EXTERN
    #define EXTERN          extern
#endif


// Basic types
// -----------

#if !defined(_WIN32)

#ifndef __MWERKS__
    #define FAR                 _far
#else
    #define FAR
#endif

    #ifndef VOID
      typedef void                VOID    ;
    #endif
    typedef VOID *              PVOID   ;
    typedef VOID FAR *          LPVOID  ;

// signed types (8, 16, 32 bits and non defined)
// CHAR is also for ASCII charcter
    typedef char                CHAR    ;
    typedef short               SHORT   ;
    typedef int                 INT     ;

// unsigned types (8, 16, 32 bits et non defined)
    typedef unsigned char       BYTE    ;
    typedef unsigned short      WORD    ;
    typedef unsigned long       DWORD   ;
    typedef unsigned int        UINT    ;

// unsigned ASCII character
    typedef unsigned char       UCHAR   ;

// floating point type
    typedef float               FLOAT;

// for this type, the number of bits is not defined
    typedef int                 BOOLEAN ;

    typedef BOOLEAN            *PBOOLEAN ;
    typedef BOOLEAN FAR        *LPBOOLEAN ;

// pointer types
    typedef CHAR    *PCHAR;
    typedef SHORT   *PSHORT;

    typedef UINT    *PUINT;

    typedef UCHAR   *PUCHAR;

    typedef FLOAT   *PFLOAT;

// far pointer type
    typedef CHAR FAR    *LPCHAR;
    typedef SHORT FAR   *LPSHORT;
    typedef INT FAR     *LPINT;


    typedef BYTE FAR    *LPBYTE;
    typedef WORD FAR    *LPWORD;
    typedef DWORD FAR   *LPDWORD;
    typedef UINT FAR    *LPUINT;

    typedef UCHAR FAR   *LPUCHAR;

    typedef FLOAT FAR   *LPFLOAT;

// Port address
// ------------
    typedef DWORD        PORT_ADDRESS_TYPE;

// Memory address for PCXNP board
// ------------------------------
//    typedef LPDWORD     MEM_ADDRESS_TYPE;


    #undef HANDLE
    #define HANDLE  LPVOID

    #ifndef _MAX_PATH
        #define _MAX_PATH 260
    #endif

#else

    #ifndef FAR
        #define FAR
    #endif

// Port address
// ------------
    typedef DWORD       PORT_ADDRESS_TYPE;

// Memory address for PCXNP board
// ------------------------------
    typedef DWORD       MEM_ADDRESS_TYPE;

// far pointer type
    typedef CHAR  FAR   *LPCHAR;
    typedef FLOAT FAR   *LPFLOAT;
    typedef SHORT FAR   *LPSHORT;

    typedef BOOLEAN FAR *LPBOOLEAN;

#endif // ifndef _WIN32

#endif

